/* $XConsortium: BoxCommand.c,v 1.79 94/04/17 20:11:58 kaleb Exp $ */

/***********************************************************

Copyright (c) 1987, 1988, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

Modifications of the Command widget class for use in the Box widget
hierarchy Copyright 1999 Todd Allen.

******************************************************************/

/*
 * BoxCommand.c - BoxCommand button widget
 */

#include <stdio.h>
#include <unistd.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Misc.h>
#include <X11/XawXpm/XawInit.h>
#include <X11/XawXpm/Xpm.h>
#include <X11/XawXpm/BoxCommandP.h>
#include <X11/Xmu/Converters.h>
#include <X11/extensions/shape.h>

#define DEFAULT_HIGHLIGHT_THICKNESS 0
#define DEFAULT_SHAPE_HIGHLIGHT 32767

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static char defaultTranslations[] =
    "<EnterWindow>:	highlight()		\n\
     <LeaveWindow>:	reset()			\n\
     <Btn1Down>:        set()       \n\
     <Btn1Up>:          notify() unset()";

#define offset(field) XtOffsetOf(BoxCommandRec, field)
static XtResource resources[] = { 
   {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer), 
      offset(boxCommand.callbacks), XtRCallback, (XtPointer)NULL},
   {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
      offset(boxCommand.foreground), XtRString, XtDefaultForeground},
   {XtNhighlightThickness, XtCThickness, XtRDimension, sizeof(Dimension),
      offset(boxCommand.highlight_thickness), XtRImmediate,
      (XtPointer) DEFAULT_SHAPE_HIGHLIGHT},
   {XtNshapeStyle, XtCShapeStyle, XtRShapeStyle, sizeof(int),
      offset(boxCommand.shape_style), 
      XtRImmediate, (XtPointer)XawShapeRectangle},
   {XtNcornerRoundPercent, XtCCornerRoundPercent, 
	XtRDimension, sizeof(Dimension),
	offset(boxCommand.corner_round), XtRImmediate, (XtPointer) 25},
   {XtNshadowWidth, XtCShadowWidth, XtRDimension, sizeof(Dimension),
      offset(compositeThreeD.shadow_width), XtRImmediate, (XtPointer) 2},
   {XtNborderWidth, XtCBorderWidth, XtRDimension, sizeof(Dimension),
      XtOffsetOf(RectObjRec, rectangle.border_width), XtRImmediate, (XtPointer)1},
   {XtNsetPixmap, XtCBGPixmap, XtRString, sizeof(String),
      offset(boxCommand.setpixmap), XtRString, None},
   {XtNhlPixmap, XtCBGPixmap, XtRString, sizeof(String),
      offset(boxCommand.hlpixmap), XtRString, None},
   {XtNnotifySound, XtCsound, XtRString, sizeof(String),
      offset(boxCommand.notifysound), XtRString, NULL},
   {XtNarmSound, XtCsound, XtRString, sizeof(String),
      offset(boxCommand.armsound), XtRString, NULL},
   {XtNhlSound, XtCsound, XtRString, sizeof(String),
      offset(boxCommand.hlsound), XtRString, NULL},

};
#undef offset

static Boolean SetValues();
static void Initialize(), Redisplay(), Set(), Reset(), Notify(), Unset();
static void Highlight(), Unhighlight(), Destroy(), PaintBoxCommandWidget();
static void ClassInitialize();
static Boolean ShapeButton();
static void Realize(), Resize();

static XtActionsRec actionsList[] = {
  {"set",		Set},
  {"notify",		Notify},
  {"highlight",		Highlight},
  {"reset",		Reset},
  {"unset",		Unset},
  {"unhighlight",	Unhighlight}
};

#define SuperClass ((BoxWidgetClass)&boxClassRec)

BoxCommandClassRec boxCommandClassRec = {
  {
    (WidgetClass) SuperClass,		/* superclass		  */	
    "BoxCommand",			/* class_name		  */
    sizeof(BoxCommandRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    actionsList,			/* actions		  */
    XtNumber(actionsList),		/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    Resize,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    defaultTranslations,		/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    XtInheritGeometryManager,           /* geometry_manager     */
    XtInheritChangeManaged,             /* change_managed       */
    XtInheritInsertChild,               /* insert_child         */
    XtInheritDeleteChild,               /* delete_child         */
    NULL,                               /* extension            */
  },  /* CompositeClass fields initialization */
  {
    XtInheritXaw3dShadowDraw,           /* shadowdraw           */
  },  /* CompositeThreeD Class fields initialization */
  {
    0,                                  /* field not used       */
  },  /* BoxClass fields initialization */
  {
    0,                                  /* field not used       */
  },  /* BoxCommandClass fields initialization */
};

  /* for public consumption */
WidgetClass boxCommandWidgetClass = (WidgetClass) &boxCommandClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static GC 
Get_GC(cbw, fg, bg)
BoxCommandWidget cbw;
Pixel fg;
Pixel bg;
{
  XGCValues	values;
  
  values.foreground = fg;
  values.background = bg;
  values.cap_style  = CapProjecting;
  
  if (cbw->boxCommand.highlight_thickness > 1 )
    values.line_width   = cbw->boxCommand.highlight_thickness;
  else 
    values.line_width   = 0;
  
  return XtAllocateGC((Widget)cbw, 0, 
                      (GCForeground|GCBackground|GCLineWidth|GCCapStyle),
                      &values, GCFont, 0 );
}


/* ARGSUSED */
static void 
Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;			/* unused */
Cardinal *num_args;		/* unused */
{
  BoxCommandWidget cbw = (BoxCommandWidget) new;
  int shape_event_base, shape_error_base;

  if (cbw->boxCommand.shape_style != XawShapeRectangle
      && !XShapeQueryExtension(XtDisplay(new), &shape_event_base, 
			       &shape_error_base))
      cbw->boxCommand.shape_style = XawShapeRectangle;
  if (cbw->boxCommand.highlight_thickness == DEFAULT_SHAPE_HIGHLIGHT) {
      if (cbw->boxCommand.shape_style != XawShapeRectangle)
	  cbw->boxCommand.highlight_thickness = 0;
      else
	  cbw->boxCommand.highlight_thickness = DEFAULT_HIGHLIGHT_THICKNESS;
  }
  if (cbw->boxCommand.shape_style != XawShapeRectangle) {
    cbw->compositeThreeD.shadow_width = 0;
    cbw->core.border_width = 1;
  }

  cbw->boxCommand.normal_GC = Get_GC(cbw, 
                                     cbw->boxCommand.foreground,
                                     cbw->core.background_pixel);
  cbw->boxCommand.inverse_GC = Get_GC(cbw, 
                                      cbw->core.background_pixel,
                                      cbw->boxCommand.foreground);
  cbw->boxCommand.set = FALSE;
  cbw->boxCommand.button_pressed = FALSE;
  cbw->boxCommand.highlighted = HighlightNone;
}

static Region 
HighlightRegion(cbw)
BoxCommandWidget cbw;
{
  static Region outerRegion = NULL, innerRegion, emptyRegion;
  XRectangle rect;

  if (cbw->boxCommand.highlight_thickness == 0 ||
      cbw->boxCommand.highlight_thickness >
      (Dimension) ((Dimension) Min(cbw->core.width, cbw->core.height)/2))
    return(NULL);

  if (outerRegion == NULL) {
    /* save time by allocating scratch regions only once. */
    outerRegion = XCreateRegion();
    innerRegion = XCreateRegion();
    emptyRegion = XCreateRegion();
  }

  rect.x = rect.y = 0;
  rect.width = cbw->core.width;
  rect.height = cbw->core.height;
  XUnionRectWithRegion( &rect, emptyRegion, outerRegion );
  rect.x = rect.y = cbw->boxCommand.highlight_thickness;
  rect.width -= cbw->boxCommand.highlight_thickness * 2;
  rect.height -= cbw->boxCommand.highlight_thickness * 2;
  XUnionRectWithRegion( &rect, emptyRegion, innerRegion );
  XSubtractRegion( outerRegion, innerRegion, outerRegion );
  return outerRegion;
}

static
void
offset_children(BoxCommandWidget  w,
                int               direction)
{
   int  offset;
   int  i;

   if (w->compositeThreeD.shadow_width == 1) {
      offset = 1;
   } else {
      offset = w->compositeThreeD.shadow_width/2;
   }
   offset *= direction;

   for (i = 0; i < w->composite.num_children; i++) {
      XtMoveWidget(w->composite.children[i],
                   w->composite.children[i]->core.x + offset,
                   w->composite.children[i]->core.y + offset);
   }
}

/***************************
*
*  Action Procedures
*
***************************/

/* ARGSUSED */
static void 
Set(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  BoxCommandWidget cbw = (BoxCommandWidget)w;
  Boolean press = FALSE;
  if (cbw->boxCommand.set)
    return;
  if (cbw->boxCommand.button_pressed)
    press = TRUE;
  cbw->boxCommand.set= TRUE;
  cbw->boxCommand.button_pressed = TRUE;
#ifdef SUN_AUDIO
  if(cbw->boxCommand.armsound != NULL)
	PlaySound(cbw->boxCommand.armsound);
#endif /* SUN_AUDIO */

  offset_children(cbw, +1);

  if (XtIsRealized(w))
  {
    if(press)
    	PaintBoxCommandWidget(w, event, (Region) NULL, FALSE);
    else
     PaintBoxCommandWidget(w, event, (Region) NULL, TRUE);
   }
}

/* ARGSUSED */
static void
Unset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;
{
  BoxCommandWidget cbw = (BoxCommandWidget)w;

  if (!cbw->boxCommand.set)
    return;

  cbw->boxCommand.set = FALSE;
  cbw->boxCommand.button_pressed = FALSE;
  offset_children(cbw, -1);
  if (XtIsRealized(w)) {
    XClearWindow(XtDisplay(w), XtWindow(w));
    PaintBoxCommandWidget(w, event, (Region) NULL, TRUE);
  }
}

/* ARGSUSED */
static void 
Reset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;   /* unused */
{
  BoxCommandWidget cbw = (BoxCommandWidget)w;

  if (cbw->boxCommand.set) {
    cbw->boxCommand.highlighted = HighlightNone;
  cbw->boxCommand.set = FALSE;
  offset_children(cbw, -1);
  if(event->type != LeaveNotify)
  	cbw->boxCommand.button_pressed = FALSE;
  if (XtIsRealized(w)) {
    XClearWindow(XtDisplay(w), XtWindow(w));
    PaintBoxCommandWidget(w, event, (Region) NULL, TRUE);
  }

  } else
    Unhighlight(w, event, params, num_params);
}

/* ARGSUSED */
static void 
Highlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		
Cardinal *num_params;	
{
  BoxCommandWidget cbw = (BoxCommandWidget)w;

  if(cbw->boxCommand.button_pressed) 
  {
  	Set(w, event, params, num_params);
  	return;
  }
  if ( *num_params == (Cardinal) 0) 
    cbw->boxCommand.highlighted = HighlightWhenUnset;
  else {
    if ( *num_params != (Cardinal) 1) 
      XtWarning("Too many parameters passed to highlight action table.");
    switch (params[0][0]) {
    case 'A':
    case 'a':
      cbw->boxCommand.highlighted = HighlightAlways;
      break;
    default:
      cbw->boxCommand.highlighted = HighlightWhenUnset;
      break;
    }
  }
  
 #ifdef SUN_AUDIO
  if(cbw->boxCommand.hlsound != NULL)
	PlaySound(cbw->boxCommand.hlsound);
#endif /* SUN_AUDIO */ 

  if (XtIsRealized(w))
    PaintBoxCommandWidget(w, event, HighlightRegion(cbw), TRUE);
}

/* ARGSUSED */
static void 
Unhighlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  BoxCommandWidget cbw = (BoxCommandWidget)w;

  cbw->boxCommand.highlighted = HighlightNone;
  if (XtIsRealized(w))
  {
    PaintBoxCommandWidget(w, event, HighlightRegion(cbw), TRUE);
  }
}

/* ARGSUSED */
static void 
Notify(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  BoxCommandWidget cbw = (BoxCommandWidget)w; 


  /* check to be sure state is still Set so that user can cancel
     the action (e.g. by moving outside the window, in the default
     bindings.
  */
  cbw->boxCommand.button_pressed = FALSE;
  if (cbw->boxCommand.set)
  {
#ifdef SUN_AUDIO
  if(cbw->boxCommand.notifysound != NULL)
	PlaySound(cbw->boxCommand.notifysound);
#endif /* SUN_AUDIO */
    XtCallCallbackList(w, cbw->boxCommand.callbacks, (XtPointer) NULL);
  }
}

/*
 * Repaint the widget window
 */

/************************
*
*  REDISPLAY (DRAW)
*
************************/

/* ARGSUSED */
static void 
Redisplay(w, event, region)
Widget w;
XEvent *event;
Region region;
{
  PaintBoxCommandWidget(w, event, region, FALSE);
}

/*	Function Name: PaintBoxCommandWidget
 *	Description: Paints the boxCommand widget.
 *	Arguments: w - the boxCommand widget.
 *                 region - region to paint (passed to the superclass).
 *                 change - did it change either set or highlight state?
 *	Returns: none
 */

static void 
PaintBoxCommandWidget(w, event, region, change)
Widget w;
XEvent *event;
Region region;
Boolean change;
{
  BoxCommandWidget cbw = (BoxCommandWidget) w;
  BoxCommandWidgetClass cwclass = (BoxCommandWidgetClass) XtClass (w);
  Boolean very_thick;
  GC norm_gc, rev_gc;
  Dimension	s = cbw->compositeThreeD.shadow_width;
   int x, y;
  unsigned int width, height, bw, depth;
  Window foo1;

  very_thick = cbw->boxCommand.highlight_thickness >
               (Dimension)((Dimension) Min(cbw->core.width, cbw->core.height)/2);
  if (cbw->boxCommand.set) {
     if(cbw->boxCommand.setpixmap == None){
        XFillRectangle(XtDisplay(w), XtWindow(w), cbw->compositeThreeD.arm_GC,
                       s, s, cbw->core.width - 2 * s, cbw->core.height - 2 * s);
        region = NULL;		/* Force box to repaint text. */
     } else {
   	XGetGeometry(XtDisplay(w), (Pixmap)*cbw->boxCommand.setpix,
                     &foo1, &x, &y, &width, &height, &bw, &depth);
        for(x=0;x<cbw->core.width;x+=width) {
           for(y=0;y<cbw->core.height;y+=height) {
              XCopyArea(XtDisplay(w), (Pixmap)*cbw->boxCommand.setpix,
	 		XtWindow(w),cbw->boxCommand.normal_GC, 0, 0,
	 		width, height, x, y);
           }	 
        }
     }
     
     region = NULL;
  }

   if(cbw->boxCommand.hlpixmap != None && (!(cbw->boxCommand.set)))
   {
   	if(cbw->boxCommand.highlighted != HighlightNone)
   	{
   	XGetGeometry(XtDisplay(w), (Pixmap)*cbw->boxCommand.hlpix,
			&foo1, &x, &y, &width, &height, &bw, &depth);
 	 for(x=0;x<cbw->core.width;x+=width)
 	 {
  		 for(y=0;y<cbw->core.height;y+=height)
 		 {
 	 	XCopyArea(XtDisplay(w), (Pixmap)*cbw->boxCommand.hlpix,
	 		XtWindow(w),cbw->boxCommand.normal_GC, 0, 0,
	 		width, height, x, y);
	 	}
	 }
	 } else XClearWindow(XtDisplay(cbw), XtWindow(cbw));
	 region = NULL;
   }


  if (cbw->boxCommand.highlight_thickness <= 0)
  {
    (*SuperClass->core_class.expose) (w, event, region);
    (*cwclass->compositeThreeD_class.shadowdraw) (w, event, region, !cbw->boxCommand.set);
    return;
  }

/*
 * If we are set then use the same colors as if we are not highlighted. 
 */

  if (cbw->boxCommand.set == (cbw->boxCommand.highlighted == HighlightNone)) {
    norm_gc = cbw->boxCommand.inverse_GC;
    rev_gc = cbw->boxCommand.normal_GC;
  }
  else {
    norm_gc = cbw->boxCommand.normal_GC;
    rev_gc = cbw->boxCommand.inverse_GC;
  }
  if ( !( (!change && (cbw->boxCommand.highlighted == HighlightNone)) ||
	  ((cbw->boxCommand.highlighted == HighlightWhenUnset) &&
	   (cbw->boxCommand.set))) ) {
    if (very_thick) {
      XFillRectangle(XtDisplay(w),XtWindow(w), rev_gc,
		     s, s, cbw->core.width - 2 * s, cbw->core.height - 2 * s);
    }
    else {
      /* wide lines are centered on the path, so indent it */
      int offset = cbw->boxCommand.highlight_thickness/2;
      XDrawRectangle(XtDisplay(w),XtWindow(w), rev_gc, s + offset, s + offset, 
		     cbw->core.width - cbw->boxCommand.highlight_thickness - 2 * s,
		     cbw->core.height - cbw->boxCommand.highlight_thickness - 2 * s);
    }
    
  }
  (*SuperClass->core_class.expose) (w, event, region);
  (*cwclass->compositeThreeD_class.shadowdraw) (w, event, region, !cbw->boxCommand.set);
}

static void 
Destroy(w)
Widget w;
{
  BoxCommandWidget cbw = (BoxCommandWidget) w;

  /* so Label can release it */
  XtReleaseGC( w, cbw->boxCommand.inverse_GC );
  XtReleaseGC( w, cbw->boxCommand.normal_GC );
}

/*
 * Set specified arguments into widget
 */

/* ARGSUSED */
static Boolean 
SetValues (current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
  BoxCommandWidget oldcbw = (BoxCommandWidget) current;
  BoxCommandWidget cbw = (BoxCommandWidget) new;
  Boolean redisplay = False;

  if ( oldcbw->core.sensitive != cbw->core.sensitive && !cbw->core.sensitive) {
    /* about to become insensitive */
    cbw->boxCommand.set = FALSE;
    offset_children(cbw, -1);
    cbw->boxCommand.highlighted = HighlightNone;
    redisplay = TRUE;
  }

  if (oldcbw->boxCommand.foreground != cbw->boxCommand.foreground
      || oldcbw->core.background_pixel != cbw->core.background_pixel
      || (oldcbw->boxCommand.highlight_thickness 
          != cbw->boxCommand.highlight_thickness)) {
    cbw->boxCommand.normal_GC = Get_GC(cbw, 
                                       cbw->boxCommand.foreground,
                                       cbw->core.background_pixel);
    cbw->boxCommand.inverse_GC = Get_GC(cbw,
                                        cbw->core.background_pixel,
                                        cbw->boxCommand.foreground);

    redisplay = True;
  }
  if ( XtIsRealized(new)
       && oldcbw->boxCommand.shape_style != cbw->boxCommand.shape_style
       && !ShapeButton(cbw, TRUE))
  {
      cbw->boxCommand.shape_style = oldcbw->boxCommand.shape_style;
  }
   if ( XtIsRealized(new))
   {
      if(oldcbw->boxCommand.setpixmap != cbw->boxCommand.setpixmap &&
      	cbw->boxCommand.setpixmap != None)
      {
       (BoxCommandWidget)cbw->boxCommand.setpix = 
       	InsertPixmap(cbw, ((BoxCommandWidget)cbw)->boxCommand.setpixmap, NULL);
      	 if  ((Pixmap)*cbw->boxCommand.setpix == (Pixmap)NULL)
       		cbw->boxCommand.setpixmap = None;
       redisplay = True;
       }
      if(oldcbw->boxCommand.hlpixmap != cbw->boxCommand.hlpixmap &&
      	cbw->boxCommand.hlpixmap != None)
      {
       (BoxCommandWidget)cbw->boxCommand.hlpix = 
   	InsertPixmap(cbw, ((BoxCommandWidget)cbw)->boxCommand.hlpixmap, NULL);
       	if  ((Pixmap)*cbw->boxCommand.hlpix == (Pixmap)NULL)
       		cbw->boxCommand.hlpixmap = None;
       	redisplay = True;
      }
   }
  return (redisplay);
}

static void ClassInitialize()
{
    XawInitializeWidgetSet();
    XtSetTypeConverter( XtRString, XtRShapeStyle, XmuCvtStringToShapeStyle,
		        (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL );
}


static Boolean
ShapeButton(cbw, checkRectangular)
BoxCommandWidget cbw;
Boolean checkRectangular;
{
    Dimension corner_size = 0;

    if ( (cbw->boxCommand.shape_style == XawShapeRoundedRectangle) ) {
	corner_size = (cbw->core.width < cbw->core.height) ? cbw->core.width 
	                                                   : cbw->core.height;
	corner_size = (int) (corner_size * cbw->boxCommand.corner_round) / 100;
    }

    if (checkRectangular || cbw->boxCommand.shape_style != XawShapeRectangle) {
	if (!XmuReshapeWidget((Widget) cbw, cbw->boxCommand.shape_style,
			      corner_size, corner_size)) {
	    cbw->boxCommand.shape_style = XawShapeRectangle;
	    return(False);
	}
    }
    return(TRUE);
}

static void Realize(w, valueMask, attributes)
    Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
	BoxCommandWidget cbw = (BoxCommandWidget) w;
    (*boxCommandWidgetClass->core_class.superclass->core_class.realize)
	(w, valueMask, attributes);
  
 
    if(cbw->boxCommand.setpixmap != None)
    {
       (Pixmap *)cbw->boxCommand.setpix = 
       (Pixmap *)InsertPixmap(w, cbw->boxCommand.setpixmap, NULL);

       if( (Pixmap) *cbw->boxCommand.setpix == (Pixmap)NULL)
       	cbw->boxCommand.setpixmap = None;
    }
    if(cbw->boxCommand.hlpixmap != None)
    {
       (Pixmap *)cbw->boxCommand.hlpix = 
       (Pixmap *)InsertPixmap(w, cbw->boxCommand.hlpixmap, NULL);

       if( (Pixmap) *cbw->boxCommand.hlpix == (Pixmap)NULL)
       	cbw->boxCommand.hlpixmap = None;
    }
    ShapeButton( (BoxCommandWidget) w, FALSE);
}

static void Resize(w)
    Widget w;
{
    if (XtIsRealized(w)) 
	ShapeButton( (BoxCommandWidget) w, FALSE);

    (*boxCommandWidgetClass->core_class.superclass->core_class.resize)(w);
}
