#define _USE_BSD
#include <ctype.h>
#include <config.h>
#include "pty.h"
#include "xwin.h"
#include "main.h"
#include "utmp_write.h"

RETSIGTYPE reaper(int);
RETSIGTYPE write_user_outof_utmp_and_quit(int);

extern char pty_name[12];
extern char *tty;
extern pid_t pid;

int main (int argc, char **argv)
    {
    int fd1, fd2;
    int filedes[2];
    /* node * standard_patterns; */

    fd1 = pty_master ();
    fd2 = pty_slave (fd1);

    signal_handle (SIGCHLD, reaper);

    if (pipe (filedes))
        {
        fprintf (stderr, "Pipe failed.\n");
        return (-1);
        }

    pid = fork ();
    if (pid == (pid_t) 0)
        {
        close (1);                         /* close stdout */
        dup (filedes[1]);                 /* make pipe stdout */
        close (filedes[1]);
        setuid (getuid ());                 /* give up privs */
        read_and_output (fd1);             /* this baby never returns */
        }
    else if (pid < (pid_t) 0)
        {
        /* The fork failed. */
        fprintf (stderr, "Fork failed.\n");
        return (-1);
        }
    else
        {
        /* :-) */
        signal_handle (SIGQUIT, write_user_outof_utmp_and_quit);
        signal_handle (SIGTERM, write_user_outof_utmp_and_quit);
		signal_handle(SIGSEGV, write_user_outof_utmp_and_quit); 
        signal_handle (SIGHUP, write_user_outof_utmp_and_quit);
        signal_handle (SIGINT, write_user_outof_utmp_and_quit);
        signal_handle (SIGPIPE, write_user_outof_utmp_and_quit);
        signal_handle (SIGINT, write_user_outof_utmp_and_quit);
        signal_handle (SIGALRM, SIG_IGN);
        /* wheee */

        close (filedes[1]);

        open_window (argc, argv, filedes[0], pid /* ,standard_patterns */ );
        }

    return (0);
    }
