/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifdef NOTDEF
#define HAVE_XPM
#define XPM_INCLUDE "../libXpm/include/xpm.h"
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "Xmg.h"
#include "XmgFancy.h"
#include "xipimg.h"
#ifdef HAVE_XPM
# include XPM_INCLUDE
#endif

/* generic callback for img support in fancy widget.
   Currently, it manages X bitmaps ans possibly X pixmaps if you uncomment
   things... you might find useful to use Xpm.
   Here is the algorithm used for image loading:
   First, it tries to find a pixmap which match the name in cache 
   possibly forcing depth (see XmgPixmapDictForceGet(3)). If not found,
   it loads a filename in using X or Xpm functions. If a specific depth
   is required it goes back to the first phase. 
   Note: XmgFancy widget also support XImages excepted for some features
   (e.g background pixmap) */
VOID_FUNC			XipFancyImg(w,closure,cbs)
Widget				w;
VOID_PTR			closure;
XmgFancyImgCallbackStruct	*cbs;
{
  t_hash_elt			*he;
  t_status			status;
  Pixmap			pixmap;
  int				retries;

  retries = 0;
retry:
  if (retries > 1)
    goto bad;
  if ((status = XmgPixmapDictForceGet(XtDisplay(w),
				      cbs->src,
				      cbs->depth,
				      &pixmap)) == 0)
    {
      cbs->type = FancyImgTypePixmap;
      cbs->ptr = (VOID_PTR)pixmap;
      return ;
    }
  else
    {
      Pixmap			pixmap;
      unsigned int		width;
      unsigned int		height;
      int			x;
      int			y;
      int			depth;

      if (strstr(cbs->src,"xbm"))
	{
	  if (XReadBitmapFile(XtDisplay(w),
			      DefaultRootWindow(XtDisplay(w)),
			      cbs->src,
			      &width,
			      &height,
			      &pixmap,
			      &x,
			      &y) != BitmapSuccess)
	    {
	      XmgWarning("XipFancyImg: bad xbm %s",cbs->src);
	      goto bad;
	    }
	  depth = 1;
	}
      else
	{
#ifdef HAVE_XPM
	  if (strstr(cbs->src,"xpm"))
	    {
	      XpmAttributes	xa;
              Pixmap		pixmask;    
	      
	      xa.valuemask = XpmReturnPixels;
	      pixmask = XtUnspecifiedPixmap;
	      if (XpmReadFileToPixmap(XtDisplay(w),
				      DefaultRootWindow(XtDisplay(w)),
				      cbs->src,
				      &pixmap,
				      &pixmask,
				      &xa) != 0)
		{
		  XmgWarning("XipFancyImg: bad xpm %s",cbs->src);
		  goto bad;
		}
	      depth = DefaultDepth(XtDisplay(w),
				   DefaultScreen(XtDisplay(w)));
	    }
	  else
#endif
	    {
	      XmgWarning("XipFancyImg: unrecognized %s",cbs->src);
	      goto bad;
	    }
	}
      if ((status = XmgPixmapDictAdd(cbs->src,
				     depth,
				     pixmap)) < 0)
	{
	  XmgWarning("XipFancyImg: %s",err_msg(-status));
	  goto bad;
	}
      if (cbs->depth != AnyDepth)
	{
	  retries++;
	  goto retry;
	}
      cbs->depth = depth;
      cbs->type = FancyImgTypePixmap;
      cbs->ptr = (VOID_PTR)pixmap;
      return ;
    }
bad:
  cbs->type = FancyImgTypeAny;
  return ;
}
