/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XIP_H
#define XIP_H	1

#include "a.h"

#ifdef DEBUG_MALLOC
# include "gdm.h"
# define XIP_ALLOC_ALGORITHM	gdm_alloc_algorithm
# define XIP_ALLOC_PROC		gdm_alloc
# define XIP_REALLOC_PROC	gdm_realloc
# define XIP_FREE_PROC		gdm_free
#else
# define XIP_ALLOC_ALGORITHM	alloc_algorithm_factor2
# define XIP_ALLOC_PROC		alloc_malloc
# define XIP_REALLOC_PROC	realloc_realloc
# define XIP_FREE_PROC		free_free
#endif

#define XIP_VEC_NEW(Base,StatusPtr)	vec_new((Base),\
						FALSE,\
						XIP_ALLOC_ALGORITHM,\
						XIP_ALLOC_PROC,\
						XIP_REALLOC_PROC,\
						XIP_FREE_PROC,\
						"xip_vec",\
						(StatusPtr))

#define XIP_DICT_NEW(HashBase,VecBase,StatusPtr)	dict_new((HashBase),\
								 (VecBase),\
						      dict_hash_code_public,\
							 XIP_ALLOC_ALGORITHM,\
							 XIP_ALLOC_PROC,\
							 XIP_REALLOC_PROC,\
							 XIP_FREE_PROC,\
								 "xip_dict",\
								 (StatusPtr))

#define XIP_ID_NEW(HashBase,VecBase,StatusPtr)		id_new((HashBase),\
								 (VecBase),\
							 XIP_ALLOC_ALGORITHM,\
							 XIP_ALLOC_PROC,\
							 XIP_REALLOC_PROC,\
							 XIP_FREE_PROC,\
							       "xip_id",\
								 (StatusPtr))

#endif
