/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <time.h>
#include "layer.h"
#include "typ_msg.h"
#include "typ_time.h"
#include "typ_32.h"

char			*ctime_without_nl(t)
time_t			*t;
{
  char			*result;

  result = ctime(t);
  result[strlen(result) - 1] = 0;
  return (result);
}

/* is a t_msg_proc.
   Manages unix time (32 bits). It uses the GNU get_date(3) 
   and ctime_without_nl(3) to resolve strings. */
t_status		typ_time_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  t_status		status;

  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("time");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u32		u32;
	t_status	status;
	time_t		t;
	
	if (ed->b.len < sizeof (t_u32))
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&u32,sizeof (t_u32));
#ifdef NOTDEF
	u32 = UNSAFE_NTOHL(u32);
#endif
	t = u32;
	return (str_cat_str(bs->str,
			    bs->max_len,
			    ctime_without_nl(&t)));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_u32		u32;
	t_status	status;	
	time_t		t;

	if (ed->b.len < sizeof (u32))
	  return (-ERR_TRUNC);
	if ((t = get_date(str,NULL)) < 0)
	  return (-ERR_MALFORMED);
	u32 = t;
#ifdef NOTDEF
	u32 = UNSAFE_HTONL(u32);
#endif
	FBCOPY(&u32,ed->b.buf,sizeof (u32));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
