/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "layer.h"
#include "typ_msg.h"
#include "typ_port.h"
#include "typ_16.h"

/* converts a string into a port number.
   It uses getservbyname(3) and reverts to atoi(3) if not found.
   Returns the port number */
int			port_from_str(str,proto,resolve)
char			*str;		/* A service name or a number */
char			*proto;		/* Protocol, e.g. "tcp" */
t_boolean		resolve;	/* If FALSE,bypasses getservbyname(3)*/
{
  if (resolve)
    {
      struct servent	*serventry;

      setservent(0);
      if (serventry = getservbyname(str,proto))
	{
	  int		port;
	  
	  port = serventry->s_port;

	  endservent();
	  return (port);
	}
      endservent();
    }
  return (atoi(str));
}

/* converts-and-catenates a port number to a bridled string.
   It uses getservbyport(3) and reverts to long_to_str(3) if not found.
   Returns 0 if OK, might return various errors */
t_status		port_to_str(port,proto,str,max_len,resolve)
int			port;		/* Port number */
char			*proto;		/* Protocol, e.g. "tcp" */
char			*str;		/* Valid string */
int			max_len;	/* Maximum length */
t_boolean		resolve;	/* If FALSE, bypasses getservyport(3)*/
{
  if (resolve)
    {
      struct servent	*serventry;

      setservent(0);
      if (serventry = getservbyport(UNSAFE_HTONS(port),proto))
	{
	  char		*name;
	  
	  name = serventry->s_name;
	  endservent();
	  return (str_cat_str(str,max_len,name));
	}
      endservent();
    }
  return (long_to_str((signed long)port,
		      layer_base,
		      str,
		      max_len));
}

/* is a t_msg_proc.
   Manages port number. Requires the protocol (e.g "udp" or "tcp") as
   ed->data. */
t_status		typ_port_resolved_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  t_status		status;

  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("port_resolved");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u16		u16;
	t_status	status;
	char		*proto;

	proto = (char *)(ed->data);
	assert(proto);
	if (ed->b.len < sizeof (t_u16))
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&u16,sizeof (t_u16));
	u16 = UNSAFE_NTOHS(u16);
	return (port_to_str(u16,
			    proto,
			    bs->str,
			    bs->max_len,
			    (t_boolean)layer_resolve));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_u16		u16;
	t_status	status;	
	int		port;
	char		*proto;

	proto = (char *)(ed->data);
	assert(proto);
	if (ed->b.len < sizeof (u16))
	  return (-ERR_TRUNC);
	if ((port = port_from_str(str,
				  proto,
				  TRUE)) < 0)
	  return (port);
	u16 = port;
#ifdef NOTDEF
	u16 = UNSAFE_HTONS(u16);
#endif
	FBCOPY(&u16,ed->b.buf,sizeof (u16));
	return (0);
      }
    case TYP_GET_CHOICES:
      {
	TYP_GET_CHOICES_ARGS(ed,vec_str);
	struct servent	*serventry;
	char		*proto;

	proto = (char *)(ed->data);
	setservent(0);
	while (serventry = getservent())
	  {
	    if (!strcmp(proto,serventry->s_proto))
	      if ((status = vec_str_add(vec_str,
					serventry->s_name)) < 0)
		return (status);
	  }
	endservent();
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
