/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "layer.h"
#include "typ_msg.h"

/* converts a string into a protocol number.
   It uses getprotobyname(3) and reverts to atoi(3) if not found.
   Returns the protocol number */
int			proto_from_str(str,resolve)
char			*str;		/* A protocol name or a number */
t_boolean		resolve;	/*If FALSE,bypasses getprotobyname(3)*/
{
  if (resolve)
    {
      struct protoent	*protoentry;

      setprotoent(0);
      if (protoentry = getprotobyname(str))
	{
	  int		proto;
	  
	  proto = protoentry->p_proto;
	  endprotoent();
	  return (proto);
	}
      endprotoent();
    }
  return (atoi(str));
}

/* converts-and-catenates a protocol number to a bridled string.
   It uses getprotobynumber(3) and reverts to long_to_str(3) if not found.
   Returns 0 if OK, might return various errors */
t_status		proto_to_str(proto,str,max_len,resolve)
int			proto;		/* Protocol number */
char			*str;		/* Valid string */
int			max_len;	/* Maximum-length */	
t_boolean		resolve;     /* If FALSE,bypasses getprotobynumber(3)*/
{
  if (resolve)
    {
      struct protoent	*protoentry;

      setprotoent(0);
      if (protoentry = getprotobynumber(proto))
	{
	  char		*name;
	  
	  name = protoentry->p_name;
	  endprotoent();
	  return (str_cat_str(str,max_len,name));
	}
      endprotoent();
    }
  return (long_to_str((signed long)proto,
		      layer_base,
		      str,
		      max_len));
}

/* is a t_msg_proc.
   Manages protocol numbers. */
t_status		typ_ipproto_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  t_status		status;
  
  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("ipproto");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u8		ipproto;

	if (ed->b.len < sizeof (ipproto))
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&ipproto,sizeof (ipproto));
	return (proto_to_str(ipproto,
			     bs->str,
			     bs->max_len,
			     (t_boolean)layer_resolve));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_u8		ipproto;

	if (ed->b.len < sizeof (ipproto))
	  return (-ERR_TRUNC);
	ipproto = proto_from_str(str,
				 TRUE);
	FBCOPY(&ipproto,ed->b.buf,sizeof (ipproto));
	return (0);
      }
    case TYP_GET_CHOICES:
      {
	TYP_GET_CHOICES_ARGS(ed,vec_str);
	struct protoent	*protoentry;

	setprotoent(0);
	while (protoentry = getprotoent())
	  {
	    if ((status = vec_str_add(vec_str,
				      protoentry->p_name)) < 0)
	      return (status);
	  }
	endprotoent();
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
