/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_rip.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_tracert.h"
#include "lay_data.h"
#include "typ_32.h"
#include "typ_16.h"
#include "typ_8.h"
#include "typ_time.h"

t_status		tracert_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_tracert		*rip;

  LAYER_TRACERT_CHECK(rip,buf,len);
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				tracert_fields[] = 
{
  {"seq",	OFFSET(t_tracert *,seq),	typ_u8_msg,	NULL},
  {"ttl",	OFFSET(t_tracert *,ttl),	typ_u8_msg,	NULL},
  {"tvsec",	OFFSET(t_tracert *,tv.tv_sec),	typ_nu32_msg,	NULL},
  {"Tvsec",	OFFSET(t_tracert *,tv.tv_sec),	typ_time_msg,	NULL},
  {"tvusec",	OFFSET(t_tracert *,tv.tv_usec),	typ_nu32_msg,	NULL},
  {"Tvusec",	OFFSET(t_tracert *,tv.tv_usec),	typ_time_msg,	NULL},
  NULL_FIELD
};

char				*tracert_itmpl = "\n\
<!--tracert_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%tracertColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tracert[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tracert[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tracert[%i%])\">[Paste]</a>\n\
 Van Jacobson's traceroute\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=25%%%%>\n\
<a href=\"setfield(tracert[%i%].seq)\">%%tracert[%i%].seq%%</a>\n\
</td>\n\
<td align=center width=25%%%%>\n\
<a href=\"setfield(tracert[%i%].ttl)\">%%tracert[%i%].ttl%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(tracert[%i%].Tvsec)\">%%tracert[%i%].Tvsec%%</a>\n\
(<a href=\"setfield(tracert[%i%].tvsec)\">%%tracert[%i%].tvsec%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(tracert[%i%].Tvusec)\">%%tracert[%i%].Tvusec%%</a>\n\
(<a href=\"setfield(tracert[%i%].tvusec)\">%%tracert[%i%].tvusec%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tracert_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tracert_msg,"tracert");
      LAY_GET_FIELD_GENERIC(tracert_fields);
      LAY_SET_FIELD_GENERIC(tracert_fields);
      LAY_GET_FIELDS_GENERIC(tracert_fields);
      LAY_GET_FIELD_TYP_GENERIC(tracert_fields);
      LAY_GET_ITMPL_GENERIC(&lay_tracert_msg,tracert_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = TRACERT_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (tracert_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
