/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_tftp.h"
#include "lay_tftpfname.h"
#include "lay_tftpmode.h"
#include "typ_sz.h"

t_field				tftpfname_fields[] = 
{
  {"name",	0,		typ_sz_msg,		NULL},
  NULL_FIELD
};

char				*tftpfname_itmpl = "\n\
<!--tftpfname_tmpl-->\n\
<table width=100%%%% bgcolor=\"%%tftpfnameColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tftpfname[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tftpfname[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tftpfname[%i%])\">[Paste]</a>\n\
 tftp file name\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(tftpfname[%i%].name)\">%%tftpfname[%i%].name%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tftpfname_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tftpfname_msg,"tftpfname");
      LAY_GET_FIELD_GENERIC(tftpfname_fields);
      LAY_SET_FIELD_GENERIC(tftpfname_fields);
      LAY_GET_FIELDS_GENERIC(tftpfname_fields);
      LAY_GET_FIELD_TYP_GENERIC(tftpfname_fields);
      LAY_GET_ITMPL_GENERIC(&lay_tftpfname_msg,tftpfname_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	t_extract_data		ed;

	ed.b.buf = b->buf;
	ed.b.len = b->len;
	return (typ_msg(typ_sz_msg,
			TYP_OFF,
			&ed,
			off));
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = lay_tftpmode_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
