/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_tftp.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_data.h"
#include "typ_16.h"
#include "typ_8.h"
#include "lay_tftpfname.h"
#include "lay_tftpbn.h"
#include "lay_tftperror.h"

t_assoc		tftpopcode_assocs[] = 
{
  {"rrq",	(VOID_PTR)TFTPOP_RRQ},
  {"wrq",	(VOID_PTR)TFTPOP_WRQ},
  {"data",	(VOID_PTR)TFTPOP_DATA},
  {"ack",	(VOID_PTR)TFTPOP_ACK},
  {"error",	(VOID_PTR)TFTPOP_ERROR},
  {NULL,	0},
};

int		tftp_get_opcode(tftp)
t_tftp		*tftp;
{
  return (safe_ntohs(&tftp->opcode));
}

t_status	tftp_sub(buf,len,sub_mp)
char		*buf;
int		len;
t_msg_proc	*sub_mp;
{
  t_tftp	*tftp;

  LAYER_TFTP_CHECK(tftp,buf,len);
  switch (tftp_get_opcode(tftp))
    {
    case TFTPOP_RRQ:
    case TFTPOP_WRQ:
      (*sub_mp) = lay_tftpfname_msg;
      return (0);
    case TFTPOP_DATA:
    case TFTPOP_ACK:
      (*sub_mp) = lay_tftpbn_msg;
      return (0);
    case TFTPOP_ERROR:
      (*sub_mp) = lay_tftperror_msg;
      return (0);
    }
  (*sub_mp) = lay_data_msg;
  return (0);
}

t_field				tftp_fields[] = 
{
  {"opcode",	0,		typ_nu16_msg,		NULL},
  {"Opcode",	0,		typ_nu16assoc_msg,	tftpopcode_assocs},
  NULL_FIELD
};

char				*tftp_itmpl = "\n\
<!--tftp_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%tftpColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tftp[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tftp[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tftp[%i%])\">[Paste]</a>\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(tftp[%i%].Opcode)\">%%tftp[%i%].Opcode%%</a>\n\
(<a href=\"setfield(tftp[%i%].opcode)\">%%tftp[%i%].opcode%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tftp_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tftp_msg,"tftp");
      LAY_GET_FIELD_GENERIC(tftp_fields);
      LAY_SET_FIELD_GENERIC(tftp_fields);
      LAY_GET_FIELDS_GENERIC(tftp_fields);
      LAY_GET_FIELD_TYP_GENERIC(tftp_fields);
      LAY_GET_ITMPL_GENERIC(&lay_tftp_msg,tftp_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = 2;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (tftp_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
