/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_pcap.h"
#include "lay_ether.h"
#include "lay_data.h"
#include "pkt.h"

char			*pcap_tmpl = "\n\
<!--pcap_tmpl-->\n\
<table width=100%%%%>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
Not implemented\n\
</tr>\n\
</table>\n\
";

#define NOTREALLYIMPLEMENTED(MsgProc,Name,Offset) \
t_status		MsgProc(msg,arg1,arg2)\
t_msg			msg;\
VOID_PTR		arg1;\
VOID_PTR		arg2;\
{\
  switch (msg)\
    {\
       LAY_CLASS_GENERIC;\
       LAY_NAME_GENERIC(Name);\
       LAY_GET_TMPL_GENERIC(pcap_tmpl);\
     case LAY_SUB:\
       {\
	 LAY_SUB_ARGS(b,mp);\
\
	 (*mp) = lay_data_msg;\
	 return (0);\
       }\
    case LAY_OFF:\
      {\
	LAY_OFF_ARGS(b,off);\
\
	(*off) = (Offset);\
	return (0);\
      }\
    }\
  return (-ERR_NOMETHOD);\
}

NOTREALLYIMPLEMENTED(lay_slip_msg,"slip",16)
NOTREALLYIMPLEMENTED(lay_ppp_msg,"ppp",4)
#if defined(WITH_PCAP) && defined(PCAP_FDDIPAD)
NOTREALLYIMPLEMENTED(lay_fddi_msg,"fddi",21 + PCAP_FDDIPAD)
#else
NOTREALLYIMPLEMENTED(lay_fddi_msg,"fddi",21)
#endif
NOTREALLYIMPLEMENTED(lay_atm_rfc1483_msg,"atm_rfc1483",8)
