/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include "lay_pad.h"
#include "lay_ether.h"
#include "typ_32.h"

t_u32				lay_pad_nbytes = 1;
t_msg_proc			lay_pad_sub_lay = &lay_ether_msg;

char				*pad_itmpl = "\n\
<!--pad_tmpl-->\n\
<table width=100%%%% bgcolor=\"%%padColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(pad[%i%])\">[Extract]</a>\n\
<a href=\"trunc(pad[%i%])\">[Trunc]</a>\n\
<a href=\"paste(pad[%i%])\">[Paste]</a>\n\
 pad\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
 pad of %lay_pad_nbytes% byte(s) to %lay_pad_sub_lay%\n\
</td>\n\
</table>\n\
";

t_status			pad_format_do(bs,var,i)
t_bridled_str			*bs;
char				*var;
int				i;
{
  int				varlen;
  long				signedvalue;
  t_status			status;

  varlen = strlen(var);
  if (varlen == 0)
    return (str_cat_char(bs->str,bs->max_len,'%'));
  else
    {
      if (!strcmp(var,"i"))
	{
	  return (long_to_str((signed long)i,
			      10,
			      bs->str,
			      bs->max_len));
	}
      if (!strcmp(var,"lay_pad_nbytes"))
	{
	  return (ulong_to_str((unsigned long)lay_pad_nbytes,
			       layer_base,
			       bs->str,
			       bs->max_len));
	}
      if (!strcmp(var,"lay_pad_sub_lay"))
	{
	  return (lay_to_str(lay_pad_sub_lay,
			     bs->str,
			     bs->max_len));
	}
    }
  return (0);
}

t_status			pad_format(i,tmpl_str,str,max_len)
int				i;
char				*tmpl_str;
char				*str;
int				max_len;
{
  return (tmpl_str_to_str(tmpl_str,
			  (t_tmpl_do_proc)pad_format_do,
			  (VOID_PTR)i,
			  str,
			  max_len));
}

t_status			lay_pad_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_pad_msg,"pad");
    case LAY_GET_TMPL:
      {
	LAY_GET_TMPL_ARGS(gtd,bs);
	t_hash_elt	*he;
	int		i;
	t_status	status;
	
	if (he = id_get(gtd->id,
			&lay_pad_msg))
	  i = (int)(he->value);
	else
	  i = 0;
	if ((status = pad_format(i,
				 pad_itmpl,
				 bs->str,
				 bs->max_len)) < 0)
	  return (status);
	if ((status = id_override(gtd->id,
				  &lay_pad_msg,
				  (VOID_PTR)(++i))) < 0)
	  return (status);
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = lay_pad_nbytes;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = lay_pad_sub_lay;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
