/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_ether.h"
#include "lay_ieee802.h"
#include "lay_ip.h"
#include "lay_arp.h"
#include "lay_data.h"
#include "typ_16.h"
#include "typ_8.h"
#include "typ_buf.h"

t_assoc			llcsap_assocs[] = 
{
  {"null",		(VOID_PTR)0},
  {"global",		(VOID_PTR)0xff},
  {"8021b_i",		(VOID_PTR)0x02},
  {"8021b_g",		(VOID_PTR)0x03},
  {"ip",		(VOID_PTR)0x06},
  {"prowaynm",		(VOID_PTR)0x02},
  {"8021d",		(VOID_PTR)0x42},
  {"rs511",		(VOID_PTR)0x4e},
  {"iso8208",		(VOID_PTR)0x7e},
  {"proway",		(VOID_PTR)0x8e},
  {"snap",		(VOID_PTR)LLCSAP_SNAP},
  {"isons",		(VOID_PTR)0xfe},
  {NULL,		NULL},	
};

t_assoc			llcui_assocs[] = 
{
  {"ui",		(VOID_PTR)LLC_UI},
  {"ua",		(VOID_PTR)0x63},
  {"disc",		(VOID_PTR)0x43},
  {"dm",		(VOID_PTR)0x0f},
  {"sabme",		(VOID_PTR)0x6f},
  {"test",		(VOID_PTR)0xe3},
  {"xid",		(VOID_PTR)0xaf},
  {"frmr",		(VOID_PTR)0x87},
  {NULL,		NULL},
};

t_status		llc_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_llc			*llc;
  int			type;

  LAYER_LLC_CHECK(llc,buf,len);
  if (llc->ssap == LLCSAP_SNAP && 
      llc->dsap == LLCSAP_SNAP &&
      llc->cntl == LLC_UI)
    {
      (*sub_mp) = &lay_snap_msg;
      return (0);
    }
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				llc_fields[] = 
{
  {"dsap",	OFFSET(t_llc *,dsap),	typ_u8_msg,		NULL},
  {"Dsap",	OFFSET(t_llc *,dsap),	typ_u8assoc_msg,llcsap_assocs},
  {"ssap",	OFFSET(t_llc *,ssap),	typ_u8_msg,		NULL},
  {"Ssap",	OFFSET(t_llc *,ssap),	typ_u8assoc_msg,llcsap_assocs},
  {"cntl",	OFFSET(t_llc *,cntl),	typ_u8_msg,		NULL},
  {"Cntl",	OFFSET(t_llc *,cntl),	typ_u8assoc_msg,llcui_assocs},
  NULL_FIELD
};

char				*llc_itmpl = "\n\
<!--llc_itmpl-->\n\
<table width=100%%%% cellpadding=3 bgcolor=\"%%llcColor%%\">\n\
<tr>\n\
<td width=100%%%% colspan=3>\n\
<small>\n\
<a href=\"extract(llc[%i%])\">[Extract]</a>\n\
<a href=\"trunc(llc[%i%])\">[Trunc]</a>\n\
<a href=\"paste(llc[%i%])\">[Paste]</a>\n\
 llc\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=33%%%%>\n\
<a href=\"setfield(llc[%i%].Dsap)\">%%llc[%i%].Dsap%%</a>\n\
(<a href=\"setfield(llc[%i%].dsap)\">%%llc[%i%].dsap%%</a>)\n\
</td>\n\
<td align=center width=33%%%%>\n\
<a href=\"setfield(llc[%i%].Ssap)\">%%llc[%i%].Ssap%%</a>\n\
(<a href=\"setfield(llc[%i%].ssap)\">%%llc[%i%].ssap%%</a>)\n\
</td>\n\
<td align=center width=33%%%%>\n\
<a href=\"setfield(llc[%i%].Cntl)\">%%llc[%i%].Cntl%%</a>\n\
(<a href=\"setfield(llc[%i%].cntl)\">%%llc[%i%].cntl%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_llc_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_llc_msg,"llc");
      LAY_GET_FIELD_GENERIC(llc_fields);
      LAY_SET_FIELD_GENERIC(llc_fields);
      LAY_GET_FIELDS_GENERIC(llc_fields);
      LAY_GET_FIELD_TYP_GENERIC(llc_fields);
      LAY_GET_ITMPL_GENERIC(&lay_llc_msg,llc_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = LLC_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (llc_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}

int			snap_get_type(snap)
t_snap			*snap;
{
  return (safe_ntohs(&snap->type));
}

t_status		snap_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_snap		*snap;
  int			type;
  
  LAYER_SNAP_CHECK(snap,buf,len);
  type = snap_get_type(snap);
  switch (type)
    {
    case ETHERTYPE_IP:
      (*sub_mp) = &lay_ip_msg;
      return (0);
    case ETHERTYPE_ARP:
      (*sub_mp) = &lay_arp_msg;
      return (0);
    }
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				snap_fields[] = 
{
  {"orgcode",	OFFSET(t_snap *,orgcode),	typ_buf_msg,	(VOID_PTR)3},
  {"type",	OFFSET(t_snap *,type),	typ_nu16_msg,		NULL},
  {"Type",	OFFSET(t_snap *,type),typ_nu16assoc_msg,ethertype_assocs},
  NULL_FIELD
};

char				*snap_itmpl = "\n\
<!--snap_itmpl-->\n\
<table width=100%%%% cellpadding=3 bgcolor=\"%%snapColor%%\">\n\
<tr>\n\
<td width=100%%%% colspan=3>\n\
<small>\n\
<a href=\"extract(snap[%i%])\">[Extract]</a>\n\
<a href=\"trunc(snap[%i%])\">[Trunc]</a>\n\
<a href=\"paste(snap[%i%])\">[Paste]</a>\n\
 snap\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=60%%%%>\n\
<a href=\"setfield(snap[%i%].orgcode)\">%%snap[%i%].orgcode%%</a>\n\
</td>\n\
<td align=center width=40%%%%>\n\
<a href=\"setfield(snap[%i%].Type)\">%%snap[%i%].Type%%</a>\n\
(<a href=\"setfield(snap[%i%].type)\">%%snap[%i%].type%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_snap_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_snap_msg,"snap");
      LAY_GET_FIELD_GENERIC(snap_fields);
      LAY_SET_FIELD_GENERIC(snap_fields);
      LAY_GET_FIELDS_GENERIC(snap_fields);
      LAY_GET_FIELD_TYP_GENERIC(snap_fields);
      LAY_GET_ITMPL_GENERIC(&lay_snap_msg,snap_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = SNAP_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (snap_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
