/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_dns.h"
#include "lay_dnsrttl.h"
#include "lay_dnsrdata.h"
#include "typ_32.h"

char				*dnsrttl_itmpl = "\n\
<!--dnsrttl_itmpl-->\n\
<table bgcolor=\"%%dnsrttlColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(dnsrdata[%i%])\">[E]</a>\n\
<a href=\"trunc(dnsrdata[%i%])\">[T]</a>\n\
<a href=\"paste(dnsrdata[%i%])\">[P]</a>\n\
</small>\n\
</td>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(dnsrttl[%i%].ttl)\">%%dnsrttl[%i%].ttl%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_field				dnsrttl_fields[] = 
{
  {"ttl",	0,	typ_nu32_msg,			NULL},
  NULL_FIELD
};

t_status			lay_dnsrttl_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dnsrttl_msg,"dnsrttl");
      LAY_GET_FIELD_GENERIC(dnsrttl_fields);
      LAY_SET_FIELD_GENERIC(dnsrttl_fields);
      LAY_GET_FIELDS_GENERIC(dnsrttl_fields);
      LAY_GET_FIELD_TYP_GENERIC(dnsrttl_fields);
      LAY_GET_ITMPL_GENERIC(&lay_dnsrttl_msg,dnsrttl_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = sizeof (t_u32);
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = &lay_dnsrdata_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
