/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_dnsqname.h"
#include "lay_dnsqtype.h"
#include "lay_dnsrdata.h"
#include "typ_dnsrdata.h"

char				*dnsrdata_itmpl = "\n\
<!--dnsrdata_itmpl-->\n\
<table bgcolor=\"%%dnsrdataColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(dnsrdata[%i%])\">[E]</a>\n\
<a href=\"trunc(dnsrdata[%i%])\">[T]</a>\n\
<a href=\"paste(dnsrdata[%i%])\">[P]</a>\n\
</small>\n\
</td>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(dnsrdata[%i%].data)\">%%dnsrdata[%i%].data%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_field				dnsrdata_fields[] = 
{
  {"data",	0,	typ_dnsrdata_msg,		NULL},
  NULL_FIELD
};

t_status			lay_dnsrdata_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dnsrdata_msg,"dnsrdata");
      LAY_GET_FIELD_GENERIC(dnsrdata_fields);
      LAY_SET_FIELD_GENERIC(dnsrdata_fields);
      LAY_GET_FIELDS_GENERIC(dnsrdata_fields);
      LAY_GET_FIELD_TYP_GENERIC(dnsrdata_fields);
      LAY_GET_ITMPL_GENERIC(&lay_dnsrdata_msg,dnsrdata_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	t_extract_data		ed;
	
	ed.b.buf = b->buf;
	ed.b.len = b->len;
	ed.data = NULL;
	return (typ_msg(typ_dnsrdata_msg,
			TYP_OFF,
			&ed,
			off));
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);

	(*mp) = lay_dnsqname_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
