/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_dns.h"
#include "lay_dnsqtype.h"
#include "lay_dnsqname.h"
#include "lay_dnsrttl.h"
#include "typ_16.h"

char				*dnsqtype_itmpl = "\n\
<!--dnsqtype_itmpl-->\n\
<table bgcolor=\"%%dnsqtypeColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(dnsqtype[%i%])\">[E]</a>\n\
<a href=\"trunc(dnsqtype[%i%])\">[T]</a>\n\
<a href=\"paste(dnsqtype[%i%])\">[P]</a>\n\
</small>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(dnsqtype[%i%].Type)\">%%dnsqtype[%i%].Type%%</a>(<a href=\"setfield(dnsqtype[%i%].type)\">%%dnsqtype[%i%].type%%</a>)\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(dnsqtype[%i%].class)\">%%dnsqtype[%i%].class%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_assoc				dnsqtype_assocs[] = 
{
  {"a",				(VOID_PTR)1},
  {"ns",			(VOID_PTR)2},
  {"cname",			(VOID_PTR)5},
  {"ptr",			(VOID_PTR)12},
  {"hinfo",			(VOID_PTR)13},
  {"mx",			(VOID_PTR)15},
  {"axfr",			(VOID_PTR)252},
  {"any",			(VOID_PTR)255},
  {NULL,			NULL},
};

t_field				dnsqtype_fields[] = 
{
  {"type",	0,	typ_nu16_msg,			NULL},
  {"Type",	0,	typ_nu16assoc_msg,		dnsqtype_assocs},
  {"class",	2,	typ_nu16_msg,			NULL},
  NULL_FIELD
};

t_status			lay_dnsqtype_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dnsqtype_msg,"dnsqtype");
      LAY_GET_FIELD_GENERIC(dnsqtype_fields);
      LAY_SET_FIELD_GENERIC(dnsqtype_fields);
      LAY_GET_FIELDS_GENERIC(dnsqtype_fields);
      LAY_GET_FIELD_TYP_GENERIC(dnsqtype_fields);
      LAY_GET_ITMPL_GENERIC(&lay_dnsqtype_msg,dnsqtype_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = sizeof (t_u32);
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = &lay_dnsqname_msg;
	return (0);
      }
    case LAY_SUB_ID:
      {
	LAY_SUB_ID_ARGS(sid,mp);
	t_hash_elt	*he;

	if (he = id_get(sid->id,
			&dns_nquestions_chan))
	  {
	    int		nquestions;
	    t_boolean	again;

	    nquestions = (int)(he->value);
	    if (nquestions == 0)
	      again = FALSE;
	    else
	      {
		again = TRUE;
		nquestions--;
		if ((status = id_override(sid->id,
					  &dns_nquestions_chan,
					  (VOID_PTR)nquestions)) < 0)
		  return (status);
	      }
	    if (again)
	      (*mp) = &lay_dnsqname_msg;
	    else
	      (*mp) = &lay_dnsrttl_msg;
	  }
	else
	  (*mp) = &lay_dnsqname_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
