/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_dns.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_data.h"
#include "typ_16.h"
#include "typ_8.h"
#include "lay_dnsqname.h"

t_bit_field	dns_qr_bit_field =
{
  0,0
};

t_assoc		dns_qr_assocs[] =
{
  {"-",		(VOID_PTR)0},
  {"QR",	(VOID_PTR)1},
  {NULL,	NULL},
};

t_bit_field_assocs_data	dns_qr_bfad =
{
  &dns_qr_bit_field,
  dns_qr_assocs
};

t_bit_field	dns_opcode_bit_field = 
{
  1,4
};

t_assoc		dns_opcode_assocs[] =
{
  {"query",		(VOID_PTR)0},
  {"inverse_query",	(VOID_PTR)1},
  {"server_status_request",(VOID_PTR)2},
  {NULL,		NULL},	
};

t_bit_field_assocs_data	dns_opcode_bfad =
{
  &dns_opcode_bit_field,
  dns_opcode_assocs
};

t_bit_field	dns_aa_bit_field = 
{
  5,5
};

t_assoc		dns_aa_assocs[] =
{
  {"-",		(VOID_PTR)0},
  {"AA",	(VOID_PTR)1},
  {NULL,	NULL},
};

t_bit_field_assocs_data	dns_aa_bfad =
{
  &dns_aa_bit_field,
  dns_aa_assocs
};

t_bit_field	dns_tc_bit_field = 
{
  6,6
};

t_assoc		dns_tc_assocs[] =
{
  {"-",		(VOID_PTR)0},
  {"TC",	(VOID_PTR)1},
  {NULL,	NULL},
};

t_bit_field_assocs_data	dns_tc_bfad =
{
  &dns_tc_bit_field,
  dns_tc_assocs
};

t_bit_field	dns_rd_bit_field = 
{
  7,7
};

t_assoc		dns_rd_assocs[] =
{
  {"-",		(VOID_PTR)0},
  {"RD",	(VOID_PTR)1},
  {NULL,	NULL},
};

t_bit_field_assocs_data	dns_rd_bfad =
{
  &dns_rd_bit_field,
  dns_rd_assocs
};

t_bit_field	dns_ra_bit_field = 
{
  8,8
};

t_assoc		dns_ra_assocs[] =
{
  {"-",		(VOID_PTR)0},
  {"RA",	(VOID_PTR)1},
  {NULL,	NULL},
};

t_bit_field_assocs_data	dns_ra_bfad =
{
  &dns_ra_bit_field,
  dns_ra_assocs
};

t_bit_field	dns_zero_bit_field = 
{
  9,11
};

t_bit_field	dns_rcode_bit_field = 
{
  11,15
};

t_assoc		dns_rcode_assocs[] =
{
  {"no_error",	(VOID_PTR)0},
  {"name_error",(VOID_PTR)3},
  {NULL,	NULL},
};

t_bit_field_assocs_data	dns_rcode_bfad =
{
  &dns_rcode_bit_field,
  dns_rcode_assocs
};

t_status	dns_sub(buf,len,sub_mp)
char		*buf;
int		len;
t_msg_proc	*sub_mp;
{
  t_dns		*dns;

  LAYER_DNS_CHECK(dns,buf,len);
  (*sub_mp) = &lay_dnsqname_msg;
  return (0);
}

t_field				dns_fields[] = 
{
  {"id",	OFFSET(t_dns *,id),	
   typ_nu16_msg,		NULL},
  {"qr",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_qr_bit_field)},
  {"Qr",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_qr_bfad)},
  {"opcode",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_opcode_bit_field)},
  {"Opcode",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_opcode_bfad)},
  {"aa",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_aa_bit_field)},
  {"Aa",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_aa_bfad)},
  {"tc",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_tc_bit_field)},
  {"Tc",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_tc_bfad)},
  {"rd",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_rd_bit_field)},
  {"Rd",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_rd_bfad)},
  {"ra",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_ra_bit_field)},
  {"Ra",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_ra_bfad)},
  {"zero",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_zero_bit_field)},
  {"rcode",	OFFSET(t_dns *,flags),
   typ_nu16bitfield_msg,	(VOID_PTR)(&dns_rcode_bit_field)},
  {"Rcode",	OFFSET(t_dns *,flags),
   typ_nu16bitfieldassoc_msg,	(VOID_PTR)(&dns_rcode_bfad)},
  {"nquestions",OFFSET(t_dns *,nquestions),
   typ_nu16_msg,		NULL},
  {"nanswers",	OFFSET(t_dns *,nanswers),
   typ_nu16_msg,		NULL},
  {"nauths",	OFFSET(t_dns *,nauths),
   typ_nu16_msg,		NULL},
  {"nadds",	OFFSET(t_dns *,nadds),
   typ_nu16_msg,		NULL},
  NULL_FIELD
};

char				*dns_itmpl = "\n\
<!--dns_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%dnsColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(dns[%i%])\">[Extract]</a>\n\
<a href=\"trunc(dns[%i%])\">[Trunc]</a>\n\
<a href=\"paste(dns[%i%])\">[Paste]</a>\n\
 dns\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%><a href=\"setfield(dns[%i%].id)\">%%dns[%i%].id%%</a></td>\n\
<td align=center width=3%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Qr)\">%%dns[%i%].Qr%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=12%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Opcode)\">%%dns[%i%].Opcode%%</a>(<a href=\"setfield(dns[%i%].opcode)\">%%dns[%i%].opcode%%</a>)\n\
</_tiny>\n\
</td>\n\
<td align=center width=3%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Aa)\">%%dns[%i%].Aa%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=3%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Tc)\">%%dns[%i%].Tc%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=3%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Rd)\">%%dns[%i%].Rd%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=3%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Ra)\">%%dns[%i%].Ra%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=9%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].zero)\">%%dns[%i%].zero%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=12%%%%>\n\
<_tiny>\n\
<a href=\"setfield(dns[%i%].Rcode)\">%%dns[%i%].Rcode%%</a>(<a href=\"setfield(dns[%i%].rcode)\">%%dns[%i%].rcode%%</a>)\n\
</_tiny>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%><a href=\"setfield(dns[%i%].nquestions)\">%%dns[%i%].nquestions%%</a></td>\n\
<td align=center width=50%%%%><a href=\"setfield(dns[%i%].nanswers)\">%%dns[%i%].nanswers%%</a></td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%><a href=\"setfield(dns[%i%].nauths)\">%%dns[%i%].nauths%%</a></td>\n\
<td align=center width=50%%%%><a href=\"setfield(dns[%i%].nadds)\">%%dns[%i%].nadds%%</a></td>\n\
</tr>\n\
</table>\n\
";

int				dns_nquestions_chan;

t_status			lay_dns_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dns_msg,"dns");
      LAY_GET_FIELD_GENERIC(dns_fields);
      LAY_SET_FIELD_GENERIC(dns_fields);
      LAY_GET_FIELDS_GENERIC(dns_fields);
      LAY_GET_FIELD_TYP_GENERIC(dns_fields);
      LAY_GET_ITMPL_GENERIC(&lay_dns_msg,dns_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = DNS_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (dns_sub(b->buf,b->len,mp));
      }
    case LAY_SUB_ID:
      {
	LAY_SUB_ID_ARGS(sid,mp);
	t_status		status;	
	t_dns			*dns;
	t_hash_elt		*he;
	t_buf			b;

	if (he = id_get(sid->id,
			&dns_nquestions_chan))
	  return (-ERR_CHANINUSE);
	if (sid->b.len < DNS_HLEN)
	  return (-ERR_TRUNC);
	dns = (t_dns *)(sid->b.buf);
	if ((status = id_add(sid->id,
			     &dns_nquestions_chan,
			     (VOID_PTR)(safe_ntohs(&dns->nquestions)))) < 0)
	  return (status);
	b.buf = sid->b.buf;
	b.len = sid->b.len;
	return (lay_msg(lay_dns_msg,
			LAY_SUB,
			&b,
			mp));
      }
    }
  return (-ERR_NOMETHOD);
}
