/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "layer.h"

t_vec				*lay_data_ascii_vec = NULL;
t_vec				*lay_data_ascii_vec_for_html = NULL;
t_vec				*lay_data_ebcdic_vec_for_html = NULL;
t_u32				lay_data_bytes_per_line = 8;

/* NOTE: IT'S NEARLY INCOMPLETE AND STANDS FOR PRINTABLE CHARS */
unsigned char		ebcdic_to_ascii[256] = 
{
  0,	1,	2,	3,	0,	9,	0,	127,
  0,	0,	0,	11,	12,	13,	14,	14,
  16,	17,	18,	19,	0,	10,	8,	0,
  24,	25,	0,	0,	0,	0,	0,	0,
  0,	0,	28,	0,	0,	10,	23,	27,
  0,	0,	0,	0,	0,	5,	6,	7,
  0,	0,	22,	0,	0,	0,	0,	4,
  0,	0,	0,	0,	20,	21,	0,	26,
  32,	0,	0,	0,	0,	0,	0,	0,
  0,	0,	'c',	'.',	'<',	'(',	'+',	'|',
  '&',	0,	0,	0,	0,	0,	0,	0,	
  0,	0,	'!',	'$',	'*',	')',	';',	0,
  '-',	'/',	0,	0,	0,	0,	0,	0,	
  0,	0,	'|',	',',	'%',	'_',	'>',	'?',
  0,	0,	0,	0,	0,	0,	0,	0,	
  0,	'`',	':',	'#',	'@',	'\'',	'=',	'"',
  0,	'a',	'b',	'c',	'd',	'e',	'f',	'g',
  'h',	'i',	0,	0,	0,	0,	0,	0,	
  0,	'j',	'k',	'l',	'm',	'n',	'o',	'p',
  'q',	'r',	0,	0,	0,	0,	0,	0,	
  0,	0,	's',	't',	'u',	'v',	'w',	'x',
  'y',	'z',	0,	0,	0,	0,	0,	0,	
  0,	0,	0,	0,	0,	0,	0,	0,	
  0,	0,	0,	0,	0,	0,	0,	0,	
  '{',	'A',	'B',	'C',	'D',	'E',	'F',	'G',
  'H',	'I',	0,	0,	0,	0,	0,	0,	
  '}',	'J',	'K',	'L',	'M',	'N',	'O',	'P',
  'Q',	'R',	0,	0,	0,	0,	0,	0,	
  '\\',	0,	'S',	'T',	'U',	'V',	'W',	'X',
  'Y',	'Z',	0,	0,	0,	0,	0,	0,	
  '0',	'1',	'2',	'3',	'4',	'5',	'6',	'7',
  '8',	'9',	0,	0,	0,	0,	0,	0,	
};

t_status	ebcdic_buf_to_cooked_str_i(off,
					   b,
					   l,
					   br,
					   br_str,
					   spc_str,
					   big_spc_str,
					   nonprint_str,
					   ascii_vec,
					   str,
					   max_len)
int		off;
unsigned char	*b;
int		l;
int		br;
char		*br_str;
char		*spc_str;
char		*big_spc_str;
char		*nonprint_str;
t_vec		*ascii_vec;
char		*str;
int		max_len;
{
   int		i;
   t_status	status;

   if ((status = str_cat_fmt_va_unlimited(str,
					  max_len,
					  "%08x%s",
					  off - l,
					  big_spc_str)) < 0)
     return (status);
   i = 0;
   while (i < br)
     {
       if (i < l)
	 {
	   if ((status = str_cat_fmt_va_unlimited(str,
						  max_len,
						  "%02x",
						  b[i])) < 0)
	     return (status);
	 }
       else
	 {
	   if ((status = str_cat_str(str,
				     max_len,
				     spc_str)) < 0)
	     return (status);
	   if ((status = str_cat_str(str,
				     max_len,
				     spc_str)) < 0)
	     return (status);
	 }
       if ((status = str_cat_str(str,
				 max_len,
				 spc_str)) < 0)
	 return (status);
       i++;
     }
   if ((status = str_cat_str(str,
			     max_len,
			     big_spc_str)) < 0)
     return (status);
   i = 0;
   while (i < l)
     {
       if (isprint(ebcdic_to_ascii[b[i]]))
	 {
	   if (ascii_vec)
	     {
	       if ((status = str_cat_str(str,
					 max_len,
					 (char *)(VEC_AT(ascii_vec,
							 (int)(b[i]))))) < 0)
		 return (status);
	     }
	   else
	     {
	       if ((status = str_cat_char(str,
					  max_len,
					  b[i])) < 0)
		 return (status);
	     }
	 }
       else
	 {
	   if ((status = str_cat_str(str,
				     max_len,
				     nonprint_str)) < 0)
	     return (status);
	 }
       i++;
     }
   if ((status = str_cat_str(str,
			     max_len,
			     br_str)) < 0)
     return (status);
   return (0);
}

t_status	ebcdic_buf_to_cooked_str(buf,
					 len,
					 br,
					 br_str,
					 spc_str,
					 big_spc_str,
					 nonprint_str,
					 ascii_vec,
					 str,
					 max_len)
char		*buf;
int		len;
int		br;
char		*br_str;
char		*spc_str;
char		*big_spc_str;
char		*nonprint_str;
t_vec		*ascii_vec;
char		*str;
int		max_len;
{
  unsigned char	b[BUFSIZ];
  int		i;
  int		l;
  t_status	status;

  if (br >= BUFSIZ)
    return (-ERR_INVAL);
  if (ascii_vec)
    if (VEC_COUNT(ascii_vec) != 256)
      return (-ERR_BADVEC);
  l = 0;
  i = 0;
  while (i < len)
    {
      if (l < br)
	b[l++] = buf[i];
      else
	{
	  if ((status = ebcdic_buf_to_cooked_str_i(i,
						   b,
						   br,
						   br,
						   br_str,
						   spc_str,
						   big_spc_str,
						   nonprint_str,
						   ascii_vec,
						   str,
						   max_len)) < 0)
	    return (status);
	  l = 0;
	  b[l++] = buf[i];
	}
      i++;
    }
  if (l > 0)
    if ((status = ebcdic_buf_to_cooked_str_i(i,
					     b,
					     l,
					     br,
					     br_str,
					     spc_str,
					     big_spc_str,
					     nonprint_str,
					     ascii_vec,
					     str,
					     max_len)) < 0)
      return (status);
  return (0);
}




VOID_FUNC			lay_data_destroy(VOID_DECL)
{
  vec_str_delete(lay_data_ascii_vec);
  vec_str_delete(lay_data_ascii_vec_for_html);
  vec_str_delete(lay_data_ebcdic_vec_for_html);
}

t_status	ascii_vec_default(vec)
t_vec		*vec;
{
  t_status	status;
  int		i;

  i = 0;
  while (i < 256)
    {
      char	str[2];

      str[0] = (char)i;
      str[1] = 0;
      if ((status = vec_str_add(vec,str)) < 0)
	return (status);
      i++;
    }
  return (0);
}

t_status	ebcdic_to_ascii_vec_default(vec)
t_vec		*vec;
{
  t_status	status;
  int		i;

  i = 0;
  while (i < 256)
    {
      char	str[2];

      str[0] = ebcdic_to_ascii[i];
      str[1] = 0;
      if ((status = vec_str_add(vec,str)) < 0)
	return (status);
      i++;
    }
  return (0);
}

t_status			lay_data_init(VOID_DECL)
{
  t_status			status;

  lay_data_ascii_vec = NULL;
  lay_data_ascii_vec_for_html = NULL;
  lay_data_ebcdic_vec_for_html = NULL;
  if ((lay_data_ascii_vec = vec_new(256,
				    TRUE,
				    LAYER_ALLOC_ALGORITHM,
				    LAYER_ALLOC_PROC,
				    LAYER_REALLOC_PROC,
				    LAYER_FREE_PROC,
				    "lay_data_ascii_vec",
				    &status)) == NULL)
    goto bad;
  if ((status = ascii_vec_default(lay_data_ascii_vec)) < 0)
    goto bad;
  if ((lay_data_ascii_vec_for_html = vec_new(256,
					     TRUE,
					     LAYER_ALLOC_ALGORITHM,
					     LAYER_ALLOC_PROC,
					     LAYER_REALLOC_PROC,
					     LAYER_FREE_PROC,
					     "lay_data_ascii_vec_for_html",
					     &status)) == NULL)
    goto bad;
  if ((status = ascii_vec_default(lay_data_ascii_vec_for_html)) < 0)
    goto bad;
  if ((lay_data_ebcdic_vec_for_html = vec_new(256,
					      TRUE,
					      LAYER_ALLOC_ALGORITHM,
					      LAYER_ALLOC_PROC,
					      LAYER_REALLOC_PROC,
					      LAYER_FREE_PROC,
					      "lay_data_ebcdic_vec_for_html",
					      &status)) == NULL)
    goto bad;
  if ((status = ebcdic_to_ascii_vec_default(lay_data_ebcdic_vec_for_html)) < 0)
    goto bad;
  return (0);
bad:
  if (lay_data_ascii_vec)
    vec_str_delete(lay_data_ascii_vec);
  if (lay_data_ascii_vec_for_html)
    vec_str_delete(lay_data_ascii_vec_for_html);
  if (lay_data_ebcdic_vec_for_html)
    vec_str_delete(lay_data_ebcdic_vec_for_html);
  return (status);
}

char				*data_itmpl = "\n\
<!--data_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%dataColor%%\">\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(data[%i%])\">[Extract]</a>\n\
<a href=\"paste(data[%i%])\">[Paste]</a>\n\
 data %%data[%i%].len%% byte(s)\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td width=100%%%%>\n\
<code>\n\
%%data[%i%].cookedhtmlbuf%%\n\
</code>\n\
</tr>\n\
</table>\n\
";

t_status			lay_data_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_data_msg,"data");
      LAY_GET_ITMPL_GENERIC(&lay_data_msg,data_itmpl);
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;

	if (!strcmp(gfd->field,"len"))
	  return (long_to_str((signed long)(gfd->b.len),
			      layer_base,
			      bs->str,
			      bs->max_len));
	if (!strcmp(gfd->field,"buf"))
	  return (str_cat_buf(bs->str,
			      bs->max_len,
			      gfd->b.buf,
			      gfd->b.len));
	if (!strcmp(gfd->field,"xbuf"))
	  return (buf_to_xdata_str(gfd->b.buf,
				   gfd->b.len,
				   lay_data_bytes_per_line,
				   "\n",
				   " ",
				   bs->str,
				   bs->max_len));
	if (!strcmp(gfd->field,"xhtmlbuf"))
	  return (buf_to_xdata_str(gfd->b.buf,
				   gfd->b.len,
				   lay_data_bytes_per_line,
				   "\n",
				   " ",
				   bs->str,
				   bs->max_len));
	if (!strcmp(gfd->field,"printablehtmlbuf"))
	  return (buf_to_printable_str(gfd->b.buf,
				       gfd->b.len,
				       lay_data_bytes_per_line,
				       "\n",
				       " ",
				       ".",
				       lay_data_ascii_vec_for_html,
				       bs->str,
				       bs->max_len));
	if (!strcmp(gfd->field,"cookedhtmlbuf"))
	  return (buf_to_cooked_str(gfd->b.buf,
				    gfd->b.len,
				    lay_data_bytes_per_line,
				    "\n",
				    " ",
				    "  ",
				    ".",
				    lay_data_ascii_vec_for_html,
				    bs->str,
				    bs->max_len));
	return (-ERR_NOENT);
      }
    case LAY_GET_FIELDS:
      {
	LAY_GET_FIELDS_ARGS(b,vec);

	if ((status = vec_str_add(vec,"len")) < 0)
	  return (status);
	if ((status = vec_str_add(vec,"xbuf")) < 0)
	  return (status);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}

char				*dataebcdic_itmpl = "\n\
<!--dataebcdic_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%dataebcdicColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(dataebcdic[%i%])\">[Extract]</a>\n\
<a href=\"paste(dataebcdic[%i%])\">[Paste]</a>\n\
 dataebcdic %%dataebcdic[%i%].len%% byte(s)\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td width=100%%%%>\n\
<code>\n\
%%dataebcdic[%i%].cookedhtmlbuf%%\n\
</code>\n\
</tr>\n\
</table>\n\
";

t_status			lay_dataebcdic_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dataebcdic_msg,"dataebcdic");
      LAY_GET_ITMPL_GENERIC(&lay_dataebcdic_msg,dataebcdic_itmpl);
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;

	if (!strcmp(gfd->field,"len"))
	  return (long_to_str((signed long)(gfd->b.len),
			      layer_base,
			      bs->str,
			      bs->max_len));
	if (!strcmp(gfd->field,"buf"))
	  return (str_cat_buf(bs->str,
			      bs->max_len,
			      gfd->b.buf,
			      gfd->b.len));
	if (!strcmp(gfd->field,"cookedhtmlbuf"))
	  return (ebcdic_buf_to_cooked_str(gfd->b.buf,
					   gfd->b.len,
					   lay_data_bytes_per_line,
					   "\n",
					   " ",
					   "  ",
					   ".",
					   lay_data_ebcdic_vec_for_html,
					   bs->str,
					   bs->max_len));
	return (-ERR_NOENT);
      }
    case LAY_GET_FIELDS:
      {
	LAY_GET_FIELDS_ARGS(b,vec);

	if ((status = vec_str_add(vec,"len")) < 0)
	  return (status);
	if ((status = vec_str_add(vec,"xbuf")) < 0)
	  return (status);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
