/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef PKT_H
#define PKT_H	1

#include <sys/time.h>
#include "layer.h"

typedef struct			s_pkt
{
  t_msg_proc			mp;
  char				*buf;
  t_32				len;		/* the "captured" len	*/
  t_32				netlen;		/* the "real" len	*/
  struct timeval		ts;
} t_pkt;

typedef t_status		(*t_pkt_proc) P((t_pkt *pkt));

/* SHALLOW COPY */
#define PKT_COPY(src,dst) bcopy((char *)(src),(char *)dst,sizeof (t_pkt))

typedef t_status	(*t_pkt_get_field_to_str_proc) P((t_pkt *pkt,
							  char *field,
							  char *str,
							  int max_len));

typedef struct			s_pkt_format_do_data
{
  t_pkt				*pkt;
  t_vec				*vec_prefixes;		/* MIGHT BE NULL */
  t_dict			*extra_vars;		/* MIGHT BE NULL */
  t_tmpl_do_proc		tmpl_do_proc;
  char				*htmlize_str;
  int				htmlize_max_len;
  t_pkt_get_field_to_str_proc	get_field_to_str_proc;
} t_pkt_format_do_data;

extern int			thiszone;

/* PROTO pkt.c */
/* pkt.c */
t_pkt *pkt_new P((int len, t_msg_proc mp, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
t_status pkt_sub P((t_pkt *pkt, t_pkt *sub_pkt));
t_status pkt_subn P((t_pkt *pkt, t_pkt *subn_pkt, t_msg_proc desired_mp));
t_status pkt_sum P((t_pkt *pkt, t_pkt *up_pkt));
t_pkt *pkt_dup P((t_pkt *pkt, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
void pkt_delete P((t_pkt *pkt, t_free_proc free_proc));
t_status pkt_full_name_to_str P((t_pkt *pkt, char *str, int max_len));
t_status pkt_save_raw P((t_pkt *pkt, char *fname));
t_status pkt_load_raw P((t_pkt *pkt, char *fname, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_extract P((t_pkt *pkt, t_msg_proc mp, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_trunc P((t_pkt *pkt, t_msg_proc mp, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_adapt_len P((t_pkt *pkt));
void pkt_show P((t_pkt *pkt));
t_status pkt_sub_id P((t_pkt *pkt, t_pkt *sub_pkt, t_id *id));
t_status pkt_subn_from_name_i P((t_pkt *pkt, t_pkt *subn_pkt, char *desired_name, t_id *id));
t_status pkt_subn_from_name P((t_pkt *pkt, t_pkt *subn_pkt, char *desired_name));
t_status pkt_get_field_to_str_i P((t_pkt *pkt, char *fq_field, char *str, int max_len, t_id *id));
t_status pkt_get_field_to_str P((t_pkt *pkt, char *field, char *str, int max_len));
t_status pkt_get_field_to_str_no_id P((t_pkt *pkt, char *field, char *str, int max_len));
t_status pkt_set_field_from_str_i P((t_pkt *pkt, char *fq_field, char *str, t_id *id));
t_status pkt_set_field_from_str P((t_pkt *pkt, char *field, char *str));
t_status pkt_get_tmpl_to_str_i P((t_pkt *pkt, char *str, int max_len, t_id *id));
t_status pkt_get_tmpl_to_str P((t_pkt *pkt, char *str, int max_len));
void timeval_from_str P((char *str, struct timeval *tv));
t_status timeval_to_str P((struct timeval *tv, char *str, int max_len, t_boolean resolve));
t_status timeval_to_str_init P((void));
t_status local_to_str P((t_pkt *pkt, t_vec *vec_prefixes, char *str, int max_len, t_boolean remote, t_boolean resolve, t_pkt_get_field_to_str_proc get_field_to_str_proc));
t_status pkt_format_do P((t_bridled_str *bs, char *var, t_pkt_format_do_data *pfdd));
t_status pkt_format_permissive_do P((t_bridled_str *bs, char *var, t_pkt_format_do_data *pfdd));
t_status pkt_format_htmlize_do P((t_bridled_str *bs, char *var, t_pkt_format_do_data *pfdd));
t_status pkt_format_simple P((t_pkt *pkt, char *tmpl_str, t_vec *vec_prefixes, t_dict *extra_vars, char *str, int max_len));
t_status pkt_format_simple_permissive P((t_pkt *pkt, char *tmpl_str, t_vec *vec_prefixes, t_dict *extra_vars, char *str, int max_len));
t_status pkt_format_html P((t_pkt *pkt, char *tmpl_str, t_vec *vec_prefixes, t_dict *extra_vars, char *str, int max_len, char *htmlize_str, int htmlize_max_len));
t_status pkt_format_html_permissive P((t_pkt *pkt, char *tmpl_str, t_vec *vec_prefixes, t_dict *extra_vars, char *str, int max_len, char *htmlize_str, int htmlize_max_len));
t_status pkt_get_choices_i P((t_pkt *pkt, char *fq_field, t_vec *vec_str, t_id *id));
t_status pkt_get_choices P((t_pkt *pkt, char *field, t_vec *vec_str));
t_status pkt_trunc_from_name P((t_pkt *pkt, char *name, t_alloc_proc alloc_proc, t_free_proc free_proc));
t_status pkt_extract_from_name P((t_pkt *pkt, char *name, t_alloc_proc alloc_proc, t_free_proc free_proc));
#endif
