/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_TFTP_H
#define LAY_TFTP_H	1

#include "layer.h"

typedef struct		s_tftp
{
  t_u16			opcode;
} t_tftp;

#define TFTP_HLEN	(sizeof (t_tftp))

#define TFTP_PORT	69

#define LAYER_TFTP_CHECK(tftppar,bufpar,lenpar) \
	if ((lenpar) < TFTP_HLEN)\
		return (-ERR_TRUNC);\
	(tftppar) = (t_tftp *)(bufpar);

#define TFTPOP_RRQ	1
#define TFTPOP_WRQ	2
#define TFTPOP_DATA	3
#define TFTPOP_ACK	4
#define TFTPOP_ERROR	5

extern t_assoc		tftpopcode_assocs[];

/* PROTO lay_tftp.c */
/* lay_tftp.c */
int tftp_get_opcode P((t_tftp *tftp));
t_status tftp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_tftp_msg P((t_msg msg, void *arg1, void *arg2));
#endif
