/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_RPC_H
#define LAY_RPC_H	1

#include "layer.h"

typedef struct			s_rpc
{
  t_u32				xid;
  t_u32				direction;
} t_rpc;

#define RPC_HLEN		(sizeof (t_rpc))

#define LAYER_RPC_CHECK(rpcpar,bufpar,lenpar) \
	if ((lenpar) < RPC_HLEN)\
		return (-ERR_TRUNC);\
	(rpcpar) = (t_rpc *)(bufpar);

#define RPC_PORT		111

#define RPCDIRECTION_CALL	0
#define RPCDIRECTION_REPLY	1

/* PROTO lay_rpc.c */
/* lay_rpc.c */
t_status rpc_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_rpc_msg P((t_msg msg, void *arg1, void *arg2));
#endif
