/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ARPETHIP_H
#define LAY_ARPETHIP_H	1

#include "layer.h"
#include "lay_ether.h"
#include "lay_ip.h"

typedef struct			s_arpethip
{
  t_u8				sha[6];
  t_u8				spa[4];
  t_u8				tha[6];
  t_u8				tpa[4];
} t_arpethip;

#define ARPETHIP_HLEN		(sizeof (t_arpethip))

#define LAYER_ARPETHIP_CHECK(aeipar,bufpar,lenpar) \
    if ((lenpar) < ARPETHIP_HLEN)\
	return (-ERR_TRUNC);\
    (aeipar) = (t_arpethip *)(bufpar);

/* PROTO lay_arpethip.c */
/* lay_arpethip.c */
void arpethip_set_sha P((t_arpethip *aei, t_ether_addr *mba_sha));
void arpethip_get_sha P((t_arpethip *aei, t_ether_addr *mba_sha));
void arpethip_set_tha P((t_arpethip *aei, t_ether_addr *mba_tha));
void arpethip_get_tha P((t_arpethip *aei, t_ether_addr *mba_tha));
void arpethip_set_tpa P((t_arpethip *aei, t_in_addr *mba_tpa));
void arpethip_get_tpa P((t_arpethip *aei, t_in_addr *mba_tpa));
void arpethip_set_spa P((t_arpethip *aei, t_in_addr *mba_spa));
void arpethip_get_spa P((t_arpethip *aei, t_in_addr *mba_spa));
t_status lay_arpethip_msg P((t_msg msg, void *arg1, void *arg2));
#endif
