/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/* 
 *
 */ 

#ifndef A_UNITS_H
#define A_UNITS_H	1

/* L = Length */

#define UNIT_L_METER	1
#define UNIT_L_INCH	39.37
#define UNIT_L_FOOT	3.281
#define UNIT_L_YARD	1.094
#define UNIT_L_MILE	6.214E-4
#define UNIT_L_PICA	(UNIT_L_INCH/72)

#define INCH_TO_PICA(n)	((n)*72)	
#define PICA_TO_MM(n)	((n)*UNIT_L_PICA*1E-3)
#define INCH_TO_MM(n)	((n)*UNIT_L_INCH*1E-3)

#endif
