/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_MISC_H
#define A_MISC_H	1

#include "a.h"

#define MY_ABS(X)	(((X) < 0)?-(X):(X))
#define MY_MIN(X,Y)	(((X) < (Y))?(X):(Y))
#define MY_MAX(X,Y)	(((X) > (Y))?(X):(Y))

#define PTR_XY(Ptr,Width,PosX,PosY)	((Ptr)[(PosY) * (Width) + (PosX)])

#define RAND(Num)	(rand() % (Num))

/* PROTO a_misc.c */
/* a_misc.c */
t_boolean atobooleanfalse P((char *str));
t_boolean atobooleantrue P((char *str));
void *pool_alloc P((t_vec *pool, t_alloc_proc alloc_proc, size_t size, char *comment, t_free_proc free_proc, t_status *status));
char *strdup_alloc P((char *str, t_alloc_proc alloc_proc, char *comment1, char *comment2, t_status *status));
char *str_skip P((char *str, char *chars));
char *str_find P((char *str, char *chars));
char *bindex P((char *buf, int len, int c));
int indexcount P((char *str, int c));
void str_lower P((char *str));
void a_debug_init P((void));
void bff P((char *buf, int len));
#endif
