/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XMGFANCYP_H
#define XMGFANCYP_H	1

#include <X11/CompositeP.h>
#include <XmgFancy.h>

#define PARSE_BUFSIZ			4096 

typedef VOID_FUNC		(*t_state_proc) P((Widget w,
						   int c));
typedef struct 
{
  /* methods */
  /* class variables */
  int dummy;
} XmgFancyClassPart;

typedef struct				_XmgFancyClassRec 
{
  CoreClassPart				core_class;
  CompositeClassPart			composite_class;
  XmgFancyClassPart			xmgFancy_class;
} XmgFancyClassRec;

typedef struct 
{
  /* resources */
  int			margin;		/* Top/Left margin		*/
  int			subEltVecBase;	/* Allocation base for sub_elts */
  int			argsVecBase;	/* Allocation base for tags args */
  int			varsHashBase;	/* Hashsize for form variables	*/
  int			varsVecBase;	/* Allocation base for hashlists*/
  XtCallbackList	formCallback;	/* Activated on "submits"	*/
  XtCallbackList	linkCallback;	/* Activated on link clicks	*/
  XtCallbackList	titleCallback;	/* Activated when title is found*/
  XtCallbackList	imgCallback;	/* Activated when img is found	*/
  Boolean		badHTMLWarnings;/* I.e. /TD is missing, etc.	*/
  Boolean		doCutAndPaste;	/* Allow highlight and selection*/
  Boolean		debugKeepSource;/* Keep source for Alt<Key>v	*/
  Boolean		debugDrawRowBorders;/* Draw row borders		*/
  Boolean		debugShowCmds;	/* Show just parsed cmds	*/
  Boolean		debugShowComments;/* Show just parsed comments	*/
  Dimension		forceBorder;	/* Force table borders, or zero	*/
  Dimension		debugCellSpacing;/* Force cell spacings, or zero*/
  Boolean		debugDrawImgBorders;/* Draw img borders		*/
  XtPointer		userData;	/* Apps. can store value here	*/
  Pixmap		brokenPixmap;	/* Used if imgCallback has failed*/
  XFontStruct		*brokenXFS;	/* Used if get_xfs() has failed	*/
  Pixel			brokenPixel;	/* Used if get_pixel() has failed*/
  char			*normalFontName;/* No comment!			*/
  char			*smallFontName;	/* No comment!			*/
  char			*_tinyFontName;	/* No comment!			*/
  char			*italicFontName;/* No comment!			*/
  char			*boldFontName;	/* No comment!			*/
  char			*header1FontName;/* No comment!			*/
  char			*header2FontName;/* No comment!			*/
  char			*fixedFontName;	/* No comment!			*/
  char			*linkColorName;	/* No comment!			*/
  char			*vLinkColorName;/* Visited link			*/
  char			*textColorName;	/* No comment			*/
  char			*fgColorName;	/* No comment			*/
  char			*bgColorName;	/* No comment			*/
  /* private state */
  GC			black_gc;	/* Conv. gc for HR and borders	*/
  GC			white_gc;	/* Conv. gc for HR and borders	*/
  t_state_proc		state_proc;	/* Current state of parsing	*/
  char			buf[PARSE_BUFSIZ];/* Parse buffer		*/
  int			lineno;		/* Current line parsed		*/
  t_vec			*args;		/* Infinite args vector		*/
  t_vec			*table_stack;	/* Table stack			*/
  t_vec			*source_vec;	/* Vec_buf of HTML source	*/
  struct s_elt		*current_table;	/* No comment!			*/
  struct s_elt		*current_form;	/* No comment!			*/
  struct s_elt		*current_select;/* No comment!			*/
  struct s_elt		*root_elt;	/* Top of the html structure	*/
  struct s_elt		*current_link;	/* Used to checkLink()		*/
  Boolean		quote;		/* Parsing state variable	*/
  Boolean		next_str_is_a_link;/* True if next str is a link*/
  Boolean		next_str_is_a_title;/* True if next str is a title*/
  Boolean		in_layout;	/* Auto-lock for do_layout()	*/
  Boolean		do_br_on_nl;	/* True before the keyword <HTML>*/
  char			*base_href;	/* Storage of base href		*/
  char			*href;		/* Used with next_str_is_a_link */
  char			*normal_font_name;	/* No comment!		*/
  char			*small_font_name;	/* No comment!		*/
  char			*_tiny_font_name;	/* No comment!		*/
  char			*italic_font_name;	/* No comment!		*/
  char			*bold_font_name;	/* No comment!		*/
  char			*header1_font_name;	/* No comment!		*/
  char			*header2_font_name;	/* No comment!		*/
  char			*fixed_font_name;	/* No comment!		*/
  char			*link_color_name;	/* No comment!		*/
  char			*v_link_color_name;	/* No comment!		*/
  char			*text_color_name;	/* No comment!		*/
  char			*fg_color_name;		/* No comment!		*/
  char			*bg_color_name;		/* No comment!		*/
  Position		highlight_x;	/* Starting point of selection	*/
  Position		highlight_y;	/* Starting point of selection	*/
  int			highlight_time;	/* Time of selection		*/
  t_vec			*selection_vec;	/* Vec_str of highlighted items */
  char			*selection;	/* Final selection text		*/
} XmgFancyPart;

typedef struct				_XmgFancyRec
{
  CorePart				core;
  CompositePart				composite;
  XmgFancyPart				xmgFancy;
} XmgFancyRec;

externalref XmgFancyClassRec		xmgFancyClassRec;

#define CORE				(((XmgFancyWidget)(self))->core)
#define COMPOSITE			(((XmgFancyWidget)(self))->composite)
#define FANCY				(((XmgFancyWidget)(self))->xmgFancy)
#define FANCY_I(Inst)			(((XmgFancyWidget)(Inst))->xmgFancy)

#endif
