/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
* $XConsortium: BoxP.h,v 1.16 89/11/06 10:51:28 swick Exp $
*/


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* 
 * XmgBoxP.h - Private definitions for Box widget
 * 
 */

#ifndef XMGBOXP_H
#define XMGBOXP_H

/***********************************************************************
 *
 * Box Widget Private Data
 *
 ***********************************************************************/

#include "XmgBox.h"
#include <X11/CompositeP.h>
#ifdef NOTDEF
#include <X11/Xmu/Converters.h>
#endif

/* New fields for the Box widget class record */
typedef struct {int empty;} XmgBoxClassPart;

/* Full class record declaration */
typedef struct _XmgBoxClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    XmgBoxClassPart	box_class;
} XmgBoxClassRec;

extern XmgBoxClassRec xmgBoxClassRec;

/* New fields for the Box widget record */
typedef struct {
    /* resources */
    Dimension   h_space, v_space;
    XmgOrientation orientation;

    /* private state */
    Dimension	preferred_width, preferred_height;
    Dimension	last_query_width, last_query_height;
    XtGeometryMask last_query_mode;
} XmgBoxPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _XmgBoxRec {
    CorePart	    core;
    CompositePart   composite;
  XmgBoxPart 	    box;
} XmgBoxRec;

#define Max(x, y)       (((x) > (y)) ? (x) : (y))
#define Min(x, y)       (((x) < (y)) ? (x) : (y))
#define AssignMax(x, y) {if ((y) > (x)) x = (y);}
#define AssignMin(x, y) {if ((y) < (x)) x = (y);}

#endif

