/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * Copyright 1991, 1993 The University of Newcastle upon Tyne
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of The University of Newcastle upon Tyne not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. The University of
 * Newcastle upon Tyne makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF NEWCASTLE UPON TYNE DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF
 * NEWCASTLE UPON TYNE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author:  Jim Wight (j.k.wight@newcastle.ac.uk)
 *          Department of Computing Science
 *          University of Newcastle upon Tyne, UK
 */

#ifndef FileNominator_h
#define FileNominator_h

#ifndef XtNinitialDirectory
#define XtNinitialDirectory "initialDirectory"
#endif
#ifndef XtNselectCallback
#define XtNselectCallback "selectCallback"
#endif
#ifndef XtNpathList
#define XtNpathList "pathList"
#endif
#ifndef XtNcancelCallback
#define XtNcancelCallback "cancelCallback"
#endif
#ifndef XtNmargin
#define XtNmargin "margin"
#endif
#ifndef XtNnumberRows
#define XtNnumberRows "numberRows"
#endif
#ifndef XtNshowDotFiles
#define XtNshowDotFiles "showDotFiles"
#endif
#ifndef XtNbellLevel
#define XtNbellLevel "bellLevel"
#endif
#ifndef XtNfilter
#define XtNfilter "filter"
#endif
#ifndef XtNfilterDirectoryNames
#define XtNfilterDirectoryNames "filterDirectoryNames"
#endif
#ifndef XtNuserData
#define XtNuserData "userData"
#endif

#ifndef XtCInitialDirectory
#define XtCInitialDirectory "InitialDirectory"
#endif
#ifndef XtCPathList
#define XtCPathList "PathList"
#endif
#ifndef XtCShowDotFiles
#define XtCShowDotFiles "ShowDotFiles"
#endif
#ifndef XtCBellLevel
#define XtCBellLevel "BellLevel"
#endif
#ifndef XtCFilter
#define XtCFilter "Filter"
#endif
#ifndef XtCFilterDirectoryNames
#define XtCFilterDirectoryNames "FilterDirectoryNames"
#endif
#ifndef XtCUserData
#define XtCUserData "UserData"
#endif

extern WidgetClass fileNominatorWidgetClass;

typedef struct _FileNominatorRec *FileNominatorWidget;
typedef struct {
    String  directoryPart;
    int     directoryStatus;
    String  filenamePart;
    int     filenameStatus;
} FileNominatorStruct;

#define FileNominatorNonexistent 8
#define FileNominatorReadable    4
#define FileNominatorWritable    2
#define FileNominatorExecutable  1

String FileNominatorGetDirectory();
void   FileNominatorSetDirectory();
void   FileNominatorClearName();
Widget FileNominatorViewportWidget();
Widget FileNominatorListWidget();

#endif /* FileNominator_h */
