.TH XFSM 1 X11
.SH NAME
xfsm \- monitor your file systems' status
.SH DESCRIPTION
xfsm stands for X File System Monitor and runs under MIT's X11
window system on several flavors of UNIX. It is a tool designed
to make monitoring your file systems' status easy by displaying
a simple bar graph for each file system greater than size 0. It
updates the file systems' statistics at regular, user definable
intervals.
.SH COMMAND LINE PARAMETERS
.PP
xfsm accepts the following command line options:

.nf
        +rv                     reverse video (use to override xrdb entry)
        +synchronous            syncronous mode(use to override xrdb entry)
        -?                      help
	-A			show available space in MBs
        -a                      absolute display mode
        -background <arg>       backgound color
        -b                      black bars (disable gray fill)
        -bg <arg>               same as -background
        -bordercolor <arg>      border color
        -borderwidth <arg>      border width
        -detailgeometry <arg>   Geometry of detail window. Only X and Y are
                                        honoured
        -display                display
        -e                      extend warning to ring bell when file 
					system is above warning level
	-f                      show free space rather than space used
        -fg <arg>               same as -forground
        -font <arg>             font
        -foreground <arg>       forground color(also file system bar color)
	-fsb                    draw file system bars without a border
        -geometry <arg>         geometry (will override extreme window 
					sizes to apply reasonable settings)
        -help                   help
        -i <arg>                interval at which stats are updated 
						(default=60s)
        -iconic                 iconic
	-it <arg1 ... argn>     ignore file systems of this type
        -m                      minimize window size
        -mb                     draw menu borders
        -mnl                    minimize window size so that the longest 
					file system name fits
        -name <arg>             run xfsm under this name
	-ot <arg>               show only file systems of this type
        -p                      don't display percentages
	-pu			popup alarm
        -r                      display space with respect to root
	-rs <arg>               specify the amount of space reserved for root
					default=10%
        -rv                     reverse video
	-s			select only these file systems
	-S			select only file systems matching these patterns
        -synchronous            synchronous mode
	-title			title to show in main window
        -v                      verbose
        -w <arg>                display warning when usage reaches <arg> %
	-wl0c			color for file systems below 1st warning level
        -wl1 <arg>              threshold for first warning level
        -wl1c <arg>             color for first warning level
        -wl2 <arg>              threshold for second warning level
        -wl2c <arg>             color for second warning level
        -wl3 <arg>              threshold for third warning level
        -wl3c <arg>             color for third warning level
        -xrm                    set an entry in the resource database for 
						this execution only
        help                    help
.fi

.SH RESOURCES
.PP
xfsm can be controlled via the following resources:

.nf
        absolute                absolute display mode
	available		show available space in MBs
        background              universal backgound color
        <filesystem>.background background color for a file system
        bell                    extend warning to ring bell when any
                                        file system is above warning level
        borderColor             border color
        borderWidth             border width
        detailWin.geometry      Geometry of detail window. Only X and Y are
                                        honored
        detailWin.share         have detail window share file system color
        display                 display
        font                    font
        foreground              universal foreground color
        <filesystem>.foreground foreground color for a file system
	fs_border		do we draw borders around file systems?
        gray                    black bars
        help                    show help
        mainWin.geometry        main window geometry
        iconic                  start program in iconic mode
        minimize                minimize window size
        menuborder              draw menu borders
        name                    run xfsm under this name
        percent                 don't display percentages
        root                    display space with respect to root
        reverseVideo            reverse video
        synchronous             syncronous mode
        updInterval             interval at which stats are updated
        used                    show space free rather than space available
        verbose                 verbose mode
        warnval                 display warning pixmap when usage reaches 
						<arg>%
        warn1val                threshold for first warning level
        warn1col                color for first warning level
        warn2val                threshold for second warning leve
        warn2col                color for second warning level
        warn3val                threshold for third warning level
        warn3col                color for third warning level
.fi

.PP
.SH BRIEF USER'S GUIDE
The following abbreviations are used:
.nf

	LB      - left mouse button
	MB      - middle mouse button
	RB      - right mouse button
.fi
.PP
Once you have started xfsm you will get a window containing 
at least 1 bar graph (xfsm removes all file systems of size 0) 
and 2 menus. The Menus are:

.nf
	Update Now - updates all files systems' statistics now
	Quit       - exits xfsm
.fi
.PP
If you click on the graph of a file system (LB, MB) you get a
window displaying the detailed statistics for the file system.
Clicking on the file system again (LB, MB) or clicking in the
detail window (LB, MB), closes the detail window while clicking
on another file system (LB, MB) while the detail window is open,
displays this file system's statistics in the detail window. (Check
the 5th item in the Troubleshooting section in the documentation to 
see the limitations of the default mode of xfsm with regard to 
calculating percentages.)
.PP
The right mouse button is used to toggle the display mode. The
default startup mode graphs all file systems relative to their
size. By clicking with the right mouse button in any of the
windows, the graphs are drawn in absolute size. Clicking (RB)
again, reverts back to the original mode.
.PP
If you have specified the -w flag with a valid parameter, xfsm
will display an exclamation mark after the file system's percent
display when the file system's useage exceeds the specified
threshold. If you also specified the -e option, xfsm will sound
the bell when the above condition is true for at least 1 file
system when the file systems statistics are updated. You can
use the -wl1, -wl1c, -wl2, -wl2c, -wl3, -wl3c options to set
additional warning levels and associate them with colors. A
word about colors: If you use them (ie. specify forground and
background colors) you probably want to use the -b flag to
disable the grey fill. If you don't do this, the color of
the file system bars will be filled using the gray tile, which
IMHO looks rather horrible.
.PP
Xfsm will recognize automount file systems. If file systems are
added or removed after startup, they will be caught at update
time. Xfsm will then resize the main window to enable it properly
display a status bar for each file system. If you specify file systems 
to be ignored (via the -d or -D option) xfsm will remember these 
file systems even if they are not present at startup time. This 
enables you to have xfsm ignore file systems which are not mounted 
at startup time. 
.PP
The following keys can be used to control xfsm:

.nf
	q - quit xfsm
	u - update now
	t - toggle display mode
	c - close the detail window
.fi
.PP
The Detail Window can display the following statistics. Depending
on the system you are on, you may not get all these statistics:

.nf
	Device Name             The actual device name
	Total Size              The file system size in MB
	Space Free              Free space in MB
	Sapce Available         Space Available to non-root in MB
	Mount Type		Type of Mount
	Mount Option		Mount Options
	Block Size              The size of a block in Bytes
	Blocks                  The number of blocks
	Blocks Free             The number of free blocks
	Blocks Available        Blocks available to non-root
	File Inodes             The number of Inodes
	Free Inodes             The number of free Inodes
	Inodes Availible        Inodes available to non-root user
.fi
.PP
If a device name is too long to be dispayed in the detail window,
the detail window will resize to accomodate the name. This resizing
will take place every time a file system name is too long to fit
into the default width of the detail window. You can resize the
main window but xfsm will not let you make the main window
smaller beyond a certain point. This is to ensure that the output
remains neat and legible. When the main window is not wide
enough to display the entire name of a file system, the name
will be truncated so that it does not overwrite the percentages.
.SH AUTHOR
xfsm was written by Robert Gasch (Robert_Gasch@peoplesoft.com) and is 
copyright by the author. Xfsm is distributed under the GNU General Public 
Licence. 
.SH CREDITS
The strstr() used for DYNIX ports is a slightly modified version
of the GNU source.

Many thanks to the following people who all contributed a
great deal to evolving xfsm to new levels of sophistication:

.nf
	Bruno (bp@chorus.fr)
	Jim (etljmme@etlxd20.ericsson.se)
	Joost (jhelberg@nl.oracle.com)
	Malcolm (malcolmp@hydra.maths.unsw.edu.au)
	Jose (josem@ender.tid.es)
	R.K. (R.K.Lloyd@compsci.liverpool.ac.uk)
.fi

Lastly, my apologies for not giving credit to all the people
who helped me out with this, offered their suggestions and
supplied platform exceptions for various UNIX falvors - the
list would simple become too big.

