.. @(#)xbench.man	1.3 89/03/23
.TH XBENCH 1
.UC 4
.SH NAME
xbench \- get a feeling of X server performance
.SH SYNOPSIS
.B xbench
[-option ...]
.SH DESCRIPTION
\fIXbench\fP tries to give you a feeling of your X-server's
performance by outputting a number of graphic-commands and
measuring the time it takes to put this onto the screen.
.br
It is a useful tool for comparing different server
implementations and for measuring server tuning effects.
.SH "TIMING"
Care has been taken to remove the effects of queueing and/or
buffering in the server.
Every test outputs its commands until a given time period elapses
(usually 10 seconds). Then
.I xbench
waits until the server has processed the commands by doing an
.I XSync.
Since the server may communicate with a
graphic-controller using
a command fifo/pipe/buffer in between,
.I Xbench
finally reads back part of the screen.
This read-back makes sure that every pixel is definitely on the
screen and not in some server-controller command-queue.
.br
[only 1 pixel is read back so the additional (misinterpreted) delay
is minimal].
.sp
Every test is run 3 times and the
.B best
rating is taken - not the average. This is done to remove (or at least
minimize) the effects of daemons or other background processes.
.SH TESTS
The benchmark tests the most common operations,
they include:
.IP lines
.br
horizontal, vertical and diagonal lines are drawn
solid, dashed and wide solid.
.IP rectangles
.br
unfilled, filled, tile-filled and stipple-filled.
.IP arcs
.br
unfilled and filled.
.IP bit-blt's
.br
screen to screen copy, ,
bitmap to screen (XCopyPlane) and invert.
.IP "character output"
.br
draws strings in a common font.
.IP "complex test"
.br
to test overall performance.
.PP
Every test in
.I xbench
has associated with it a level-number, currently 1 to 3.
If you start
.I xbench
without any arguments all level 1 benches are run.
If you need more information, specify the level in the command line
to get all tests with levels less or equal the specified level.
The higher level benches are variations of the lower-level ones
with changed parameters. In general level 1 information is all you need.
.br
Most tests are run more than once with different parameters.
Server tuners may find it useful, to compare the numbers given -
for example short vector performance is likely to be limited by the
interprocess/server overhead while long vector performance is usually
limited by the speed of the graphics-controller/ddx code.
.PP
.SH OPTIONS
.I Xbench
accepts the folloing options:
.TP 8
\fB\-display \fIname\fP
.br
as usual
.TP 8
.B \-foo
.br
prints usage message.
.TP 8
.B \-help
.br
output a list of available tests.
.TP 8
\fB\-level \fInumber\fP
.br
run all tests with level number less or equal
.I level.
Without this option all level 1 tests are run.
.TP 8
\fB\-timegoal \fIseconds\fP
.br
changes runtime per test. (default = 10 seconds).
Remember, that every test is run 3 times so that a
.I timegoal
of 20 seconds gives a total run time of 1 minute per test.
.TP 8
\fB\-nruns \fInumber\fP
.br
runs each test
.I number
times.
With a timegoal of 10 seconds this gives a total run time of 10 sec's per test.
(default = 3)
.TP 8
.B \-sync
.br
if you are testing a slow server with a big buffer, many commands
may be buffered in some internal server queues. [I have seen servers
running for half an hour processing arc commands sent during the
10 seconds]. This option removes long delays for commands
that are known to be slow - but keep in mind, that
.I xbench
may give you incorrect benchmark data if this option is used.
[but if your server is really slow, it doesn't count anyway :-)]
.TP 8
\fB\-only \fIname-of-test\fP
.br
run only the named test. This option may be repeated so that:
.sp
.nf
      xbench -only hline100 -only vline100
.fi
.sp
runs only the
.I hline100
and
.I vline100
tests.
.TP 8
\fB\-not \fIname-of-test\fP
.br
excludes the named test from the benchmark.
[If any test crashes your server ....]
This option may also be repeated to exclude more.
.TP 8
.B \-ask
.br
turns on interactive mode. For every test 
you have to enter "y" if you want the test to be run.
If you enter "s" runs this test with the "-sync" option on.
Entering "n" skips this test.
.PP
.SH COPYRIGHT
Copyright 1988, Siemens Munich.
.br
free to copy/distribute - but not for money -
provided that the above copyright notice appears
in all copies.
.PP
.SH AUTHOR
.PP
Claus Gittinger (..!decvax!unido!sinix!claus) 
