static char SCCSID[] = "@(#)bitmapcpy.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"
#include "bitmap1.bit"

static GC myGC;
static Pixmap thePixmap;

/*
 * bitmap->screen copy plane
 *
 * used for drawing pictures, icons and in some textsystems which
 * use their own fonts in bitmaps.
 */

bitmapcopy_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int depth;
	Pixmap      pattern;
	GC tmpGC;

	depth = DefaultDepth(dpy, screen);
	myGC = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC) return 1;
	XSetForeground(dpy, myGC, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC, BlackPixel(dpy, screen));
        XSetGraphicsExposures(dpy, myGC, False);
	
	pattern = XCreateBitmapFromData(dpy, win, bitmap1_bits,
						  bitmap1_width,
						  bitmap1_height);
	if (!pattern) return 1;

	/*
	 * create a bitmap and fill it with the pattern
	 */
	tmpGC = XCreateGC(dpy, pattern, 0L, NULL);
	if (! tmpGC) return 1;
	XSetForeground(dpy, tmpGC, 1);
	XSetBackground(dpy, tmpGC, 0);

	thePixmap = XCreatePixmap(dpy, win, len, len, 1);
	if (! thePixmap) return 1;

	XSetStipple(dpy, tmpGC, pattern);
	XSetFillStyle(dpy, tmpGC, FillOpaqueStippled);
	XFillRectangle(dpy, thePixmap, tmpGC, 0, 0, len, len);

	XFreeGC(dpy, tmpGC);
	XFreePixmap(dpy, pattern);
	return 0;
}

bitmapcopy_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, myGC);
	XFreePixmap(dpy, thePixmap);
}

bitmapcopy_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int ncopy;
	int x = 0, y = 0;

	ncopy= 0;
	while (benchRunning) {
	    XCopyPlane(dpy, thePixmap, win, myGC, 0, 0, len, len, x, y, 1);
	    x = (x + 1) & 0x0F;
	    y = (y + 1) & 0x0F;
	    if (sync) XSync(dpy, 0);
	    ncopy += 1;
	}
	return ncopy;
}

bitmapcopy_msg(deltaT, ncopy, len, rate)
double rate;
{
	printf("COPYPLANE (BITMAP->SCREEN)\n");
	printf("\n");
	printf("%d copies with %d pixel sides in %d secs\n",
				ncopy, len, deltaT);
	printf("rate = %8.2f copies/sec (%d Pixels/sec)\n",
				rate, (ncopy*len*len)/deltaT);
}
