static char SCCSID[] = "@(#)pixmapcpy.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"
#include "bitmap1.bit"

static GC myGC;
static Pixmap thePixmap;

/*
 * pixmap->screen copy area
 *
 * questionable, whether this benchmark tells us much
 * (since most applications draw pictures using XCopyPlane)
 * its valid for colour pictures and for backing store / save under
 * performance.
 */
pixmapcopy_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int depth;
	Pixmap      pattern;

	depth = DefaultDepth(dpy, screen);
	myGC = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC) return 1;
	XSetForeground(dpy, myGC, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC, BlackPixel(dpy, screen));

	pattern = XCreateBitmapFromData(dpy, win, bitmap1_bits,
						  bitmap1_width,
						  bitmap1_height);
	if (!pattern) return 1;

	/*
	 * create a pixmap and fill it with the pattern
	 */
	thePixmap = XCreatePixmap(dpy, win, len, len, depth);
	if (! thePixmap) return 1;

	XSetStipple(dpy, myGC, pattern);
	XSetFillStyle(dpy, myGC, FillOpaqueStippled);
	XFillRectangle(dpy, thePixmap, myGC, 0, 0, len, len);

	XSetFillStyle(dpy, myGC, FillSolid);
	XFreePixmap(dpy, pattern);
	return 0;
}

pixmapcopy_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, myGC);
	XFreePixmap(dpy, thePixmap);
}

pixmapcopy_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int ncopy;
	int x = 0, y = 0;

	ncopy= 0;
	while (benchRunning) {
	    XCopyArea(dpy, thePixmap, win, myGC, 0, 0, len, len, x, y);
	    x = (x + 1) & 0x0F;
	    y = (y + 1) & 0x0F;
	    if (sync) XSync(dpy, 0);
	    ncopy++;
	}
	return ncopy;
}

pixmapcopy_msg(deltaT, ncopy, len, rate)
double rate;
{
	printf("COPYAREA (PIXMAP->SCREEN)\n");
	printf("\n");
	printf("%d copies with %d pixel sides in %d secs\n",
				ncopy, len, deltaT);
	printf("rate = %8.2f copies/sec (%d Pixels/sec)\n",
				rate, (ncopy*len*len)/deltaT);
}
