/*
 * alert.c : Alert popup
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <X11/Intrinsic.h>
#include "popups.h"

/*
 * Functions defined here:
 */
void alert0(),alert1(),alert2();
static void alertCallback();

/*
 * Data defined here:
 */
static Widget alertShell;

/*	-	-	-	-	-	-	-	-	*/

void
alert0(str)
char *str;
{
    if (alertShell == NULL)
	alertShell = createPopup("alert",1,alertCallback);
    setPopupLabel(alertShell,"alert",str);
    popupMainLoop(alertShell);
}
 
void
alert1(fmt,arg)
char *fmt,*arg;
{
    char buf[256];

    sprintf(buf,fmt,arg);
    alert0(buf);
}

void
alert2(fmt,arg1,arg2)
char *fmt,*arg1,*arg2;
{
    char buf[256];

    sprintf(buf,fmt,arg1,arg2);
    alert0(buf);
}

/*ARGSUSED*/
static void
alertCallback(w,client_data,call_data)
Widget w;
XtPointer client_data;		/* button number */
XtPointer call_data;
{
    popupDone();
}
