/* ----------------------------------------------------------------------------
 * Copyright (C) 1995-1999 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

#include <string.h>





/* ----------------------------------------------------------------------------
 * StrCmp - my own 'strcmp' to handle NULL pointers
 * --------------------------------------------------------------------------*/

int StrCmp(char *s1, char *s2)
{
	if (s1 == NULL || s2 == NULL)
	   return(-1);
	else
	   return(strcmp(s1, s2));
}





/* ----------------------------------------------------------------------------
 * StrNCpy - my own 'strncpy' to work around a strange bug of Solaris 2.4x86
 * --------------------------------------------------------------------------*/
 
void StrNCpy(char *s1, char *s2, int n)
{
	char	*p1, *p2;

	p1 = s1;
	p2 = s2;

	while (p2 != NULL && n > 0) {
	      *p1 = *p2;
	      p1++;
	      p2++;
	      n--;
	}

	*p1 = '\0';	/* terminate copied string properly */
}
