/* ----------------------------------------------------------------------------
 * Copyright (C) 1997-1999 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define SUCCESS         0
#define FAIL            -1





/* ----------------------------------------------------------------------------
 * getHostEnt - get hostent structure of host name
 * ------------------------------------------------------------------------- */

struct hostent *getHostEnt(char *hAddr)
{
	return(gethostbyname(hAddr));
}




 
/* ----------------------------------------------------------------------------
 * substAddr - substitute internet address for host name
 * ------------------------------------------------------------------------- */

int substAddr(char **hAddr)
{
	int		status = FAIL;                /* substitution status */
	char		*iAddr;                       /* internet address    */
	struct hostent	*hPtr;                        /* host entry pointer  */

	if ((hPtr = gethostbyname(*hAddr)) != NULL) {
	   if (hPtr->h_addrtype == AF_INET && *(hPtr->h_addr_list) != NULL) {
	      iAddr = inet_ntoa(*((struct in_addr *) *(hPtr->h_addr_list)));
	      *hAddr = (char *) realloc(*hAddr,
	                                sizeof(char) * (strlen(iAddr)+1));
	      (void) strcpy(*hAddr, iAddr);
	      status = SUCCESS;
	   }
	}
	
	return(status);
}




 
/* ----------------------------------------------------------------------------
 * getRHostName - get remote host name for internet address
 * ------------------------------------------------------------------------- */

char *getRHostName(char *iAddr)
{
	struct hostent	*hPtr;			/* host entry pointer    */
	unsigned long	addr;			/* host internet address */
	char		*name;			/* official host name    */

	name = NULL;
	addr = inet_addr(iAddr);

	/* -------------------------------------------- resolve host address */

	if (addr != -1) {
	   if ((hPtr = gethostbyaddr((char *) &addr, sizeof(addr), AF_INET))
	       != NULL) {
	      if (hPtr->h_name != NULL) {
	         name = (char *) malloc(sizeof(char)*(strlen(hPtr->h_name)+1));
	         (void) strcpy(name, hPtr->h_name);
	      }
	   }
	}

	/* ------------------------------------- cannot resolve host address */

	if (name == NULL) {
	   name = (char *) malloc(sizeof(char)*6);
	   (void) strcpy(name, "- ? -");
	}
	
	return(name);
}




 
/* ----------------------------------------------------------------------------
 * getLHostName - get name of local host
 * ------------------------------------------------------------------------- */

char *getLHostName(char *hName)
{
	struct utsname	*u_name;

	u_name = (struct utsname *) malloc(sizeof(struct utsname));

	if (uname(u_name) != -1) {

	   /* found hostname */

	   hName = (char *) realloc(hName, sizeof(char) * 
	           (strlen(u_name->nodename) + 1));
	   (void) strcpy(hName, u_name->nodename);
	} else {

	   /* use default hostname */

	   hName = (char *) realloc(hName, sizeof(char) * 10);
	   (void) strcpy(hName, "127.0.0.1");
	}

	free(u_name);

	return(hName);
}
