/* ----------------------------------------------------------------------------
 * Copyright (C) 1995-1999 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

#define NUMHELP		11		/* number of help menu entries */

static char *HelpTitle[NUMHELP] = {
    "Version",
    "Introduction",
    "Host Table",
    "Host Address",
    "Terminal Emulators",
    "Sessions",
    "Server Access",
    "Connection Report",
    "Configuration",
    "Log Files",
    "Synchronization"
};

static char *HelpText[NUMHELP] = {
"xLogin Version 1.6\n\
\n\
Copyright (C) 1995-1999 by Karim Kaschani\n\
\n\
Permission is hereby granted, free of charge, to any person obtaining a\n\
copy of this software and associated documentation files (the 'Software'),\n\
to deal in the Software without restriction, including without limitation\n\
to rights to use, copy, modify, merge, publish, distribute, sublicense,\n\
and/or sell copies of the Software, and to permit persons to whom the\n\
Software is furnished to do so, subject to the following conditions:\n\
\n\
The above copyright notice and this permission notice shall be included in\n\
all copies or substantial portions of the Software.\n\
\n\
THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n\
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n\
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL\n\
THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER\n\
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\n\
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.",

"xLogin is a simple Motif based tool to run multiple different sessions on\n\
various remote hosts, while controlling the access of the local X server,\n\
too.\n\
\n\
In this way xLogin relieves the user of a remote session from\n\
\n\
1. starting a terminal emulator,\n\
2. adding the remote host to the list allowed to make connections to the\n\
   local X server,\n\
3. starting the remote session,\n\
4. setting the environment variable $DISPLAY at the remote host\n\
   appropriately,\n\
5. removing the remote host from the list allowed to make connections to\n\
   the local X server after finishing the remote session and\n\
6. finally terminating the terminal emulator.\n\
\n\
xLogin keeps track of every session by forking an independent xLogin\n\
process for any session, which will monitor its session until it is\n\
finally terminated.",

"The 'Host Table' lists all hosts that are specified in xLogin's resource\n\
file.\n\
\n\
Clicking on an item will select the respective host along with its 'Host\n\
Address' and its last specified 'Server Access' for further operation. In\n\
case additional options are given in the resource file, both 'Terminal'\n\
and 'Session' menu will be set accordingly.\n\
\n\
A double click as well as pushing the 'Connect...' button or entering\n\
'return' will immediately connect the specified host according to the\n\
given options and settings below.",

"The field 'Host Address' displays the internet address of any selected\n\
host. By overriding this address with an address or host name, that is not\n\
included with the 'Host Table', even any host can be contacted. In this\n\
case, however, any options attached to the hosts listed in the 'Host\n\
Table' are ignored.\n\
\n\
If the respective host name cannot be resolved, xLogin assumes this item\n\
to be the name of an application, which should be run on the local host.\n\
Therefore even local applications, that need to connect to the local X\n\
server can be managed.", 

"By pushing the 'Terminal' menu button different terminal emulators can be\n\
chosen for the session to run.\n\
\n\
Apart from 'xterm', which is the default terminal, the items of this menu\n\
are taken from the terminal settings in xLogin's resource file. Therefore\n\
this menu can be configured to even include items, that are no terminal\n\
emulators at all.",

"By pushing the 'Session' menu button different sessions like 'telnet',\n\
'rlogin', 'ftp' or others can be specified.\n\
\n\
Apart from 'telnet', which is the default session, the items of this menu\n\
are taken from the session settings in xLogin's resource file. Therefore\n\
this menu can be configured to even include items, that are no sessions at\n\
all.",

"The radio buttons called 'Server Access' are used to enable or disable\n\
the respective host to make connections to the local X server and to\n\
indicate the current server access mode.\n\
\n\
Automatic  In 'Automatic' mode, which is the default, xLogin controls the\n\
           server access automatically. In this way connections to the\n\
           local X server are allowed as long as corresponding sessions\n\
           are active. As soon as the last session with a remote host is\n\
           terminated, this remote host is refused to make connection to\n\
           the local X server.\n\
\n\
The 'Server Access' settings, however, can be manually overridden if\n\
necessary.\n\
\n\
Enable     By toggling 'Enable' the selected host is allowed to make\n\
           connections to the local X server regardless of any session.\n\
\n\
Disable    In contrast, by toggling 'Disable' the selected host is refused\n\
           to make connections to the local X server even if corresponding\n\
           sessions are running.\n\
\n\
PLEASE NOTE, THAT IN CONTRAST TO OTHER RADIO BUTTONS TOGGLING ONE OF THESE\n\
BUTTONS WILL TAKE EFFECT IMMEDIATELY!",

"Selecting the item 'Report' of the 'File' menu will display a connection\n\
report of all current sessions. This report covers the remote host's\n\
address and name as well as the number of connections, the respective\n\
server access mode and the synchronization status.\n\
\n\
Recognized server access modes are (cf. 'Server Access'):\n\
\n\
        automatic = automatic server access (default)\n\
          enabled = server access enabled\n\
         disabled = server access disabled\n\
\n\
Recognized synchronization status are (cf. 'Synchronization'):\n\
\n\
      synchronous = log files and xhost table synchronized (default)\n\
     asynchronous = log files and xhost table not synchronized\n\
        unmanaged = xhost entry without corresponding log file\n\
\n\
In case an asynchronous or unmanaged status is reported, it is recommended\n\
to synchronize the xhost table (cf. 'Synchronization') in order to make\n\
sure, that any connection is managed and tracked correctly by xLogin.",

"xLogin's resource file 'xLoginrc' resides in '~/.xLogin'. The 'Host\n\
Table', 'Terminal' and 'Session' menu of xLogin can be configured by\n\
editing this resource file.\n\
\n\
Valid entries must have the following syntax:\n\
\n\
   <host address> <host alias> \\\n\
   [S{<session program> [<X server access> [<session options>]]}] \\\n\
   [T{<terminal emulator> [<terminal options>]}]\n\
\n\
Please note:\n\
\n\
   Lines beginning with '#' will be ignored by xLogin.\n\
\n\
   Escaping a newline by means of '\\' as shown above is NOT allowed.\n\
\n\
   <X server access> has to be set 'ON', if the respective session might\n\
   need to make connection to the local X server (like e.g. 'telnet'), and\n\
   has to be set 'OFF', if generally it does not need to make connection\n\
   to the local X server (like e.g. 'ftp').\n\
\n\
   Compound strings including blanks and tabs have to be enclosed in\n\
   double quotes '\"'.\n\
\n\
   '%D' will be substituted by the local hostname:display struct.\n\
\n\
   '%H' will be substituted by the name of the local host.\n\
\n\
   '%U' when encountered among the session options, will cause an\n\
        interactive username dialog to pop up, whenever the respective host\n\
        is connected. '%U' afterwards will be substituted by the entered\n\
        username.\n\
\n\
   When specifying any terminal options, make sure the last option is the\n\
   one for running the session program. Almost always this option is '-e'.\n\
\n\
Valid 'xLoginrc' entries are e.g.:\n\
\n\
   maximilian       max\n\
   123.45.67.89     school    T{xterm -fg red -bg black -e}\n\
   %H               login...  S{rlogin ON -l %U}\n\
   prep.ai.mit.edu  Software  S{ftp OFF}  T{xterm -T \"G N U\" -e}\n\
\n\
A sample resource file called 'xLoginrc.ex' is installed in '~/.xLogin' by\n\
xLogin. However, in order to get a new sample resource file installed\n\
after updating xLogin, make sure to remove the old one before running\n\
xLogin.\n\
\n\
In case no resource file can be found, xLogin is reading '/etc/hosts' as\n\
default resource file, instead.\n\
\n\
In case no valid host entry is found neither in 'xLoginrc' nor in\n\
'/etc/hosts', the entry 'localhost' is used as default entry.",

"X Server Management\n\
\n\
The X server management is accomplished by different log files called\n\
'.<host address>@<local host>', which are created in '~/.xLogin'. Since the\n\
server access control of xLogin crucially depends on these files, they\n\
should NOT be modified.\n\
\n\
\n\
Logging\n\
\n\
As long as xLogin is running any comments, warnings or errors are written\n\
to '~/.xLogin/log'. All those messages will be kept until xLogin is started\n\
the next time. Selecting the item 'Log' of the 'File' menu will display the\n\
contents of this file.",

"Despite keeping log files for any connection, the X server management of\n\
xLogin may still be confused, e.g.\n\
\n\
- by killing the window manager before proper termination of xLogin, which\n\
  will prevent xLogin from updating its log files before being terminated\n\
- by manually adding/removing hosts to/from the X server's access control\n\
  list via 'xhost'.\n\
\n\
To avoid asynchronous X server management, the current state of xLogin's\n\
log files and the xhost table can be synchronized by means of the 'Sync'\n\
menu.\n\
\n\
... log files\n\
\n\
updates xLogin's log files to reflect the current state of the X server's\n\
access control list (xhost table). This is automatically done each time\n\
xLogin is started to prevent from misleading log files that may have\n\
remained when finishing the last X session by termination of the window\n\
manager prior to terminating xLogin.\n\
\n\
... xhost table\n\
\n\
updates the X server's access control list to reflect the current state of\n\
xLogin's log files, i.e. its connections. This may be necessary to undo\n\
modifications of the X server's access control list that have been manually\n\
carried out by means of 'xhost'.\n\
\n\
Furthermore, both synchronization commands, will enable the use of the X\n\
server's access control list, to let xLogin fully control the X server's\n\
access."
};

static char *xLoginrcText = { "\
# ------------------------------------------------------------------------\n\
# xLoginrc - sample resource file for xLogin\n\
#\n\
# Valid entries MUST have the following syntax:\n\
# \n\
#    <host address> <host alias> \\\n\
#    [S{<session program> [<X server access> [<session options>]]}] \\\n\
#    [T{<terminal emulator> [<terminal options>]}]\n\
# \n\
# Please note:\n\
# \n\
#    Lines beginning with '#' will be ignored by xLogin.\n\
# \n\
#    Escaping a newline by means of '\\' as shown above is NOT allowed.\n\
# \n\
#    <X server access> has to be set 'ON', if the respective session might\n\
#    need to make connection to the local X server (like e.g. 'telnet'),\n\
#    and has to be set 'OFF', if generally it does not need to make\n\
#    connection to the local X server (like e.g. 'ftp').\n\
# \n\
#    Compound strings including blanks and tabs have to be enclosed in\n\
#    double quotes '\"'.\n\
# \n\
#    '%D' will be substituted by the local hostname:display struct.\n\
# \n\
#    '%H' will be substituted by the name of the local host.\n\
# \n\
#    '%U', when encountered among the session options, will cause an\n\
#    interactive username dialog to pop up, whenever the respective host\n\
#    is connected. '%U' afterwards will be substituted by the entered\n\
#    username.\n\
# \n\
#    When specifying any terminal options, make sure the last option is\n\
#    the one for running the session program. Almost always this option is\n\
#    '-e'.\n\
# \n\
# Valid 'xLoginrc' entries are e.g.:\n\
# \n\
#    maximilian       max\n\
#    123.45.67.89     school    T{xterm -fg red -bg black -e}\n\
#    %H               login...  S{rlogin ON -l %U}\n\
#    prep.ai.mit.edu  Software  S{ftp OFF} T{xterm -T \"G N U\" -e}\n\
# ------------------------------------------------------------------------\n\
" };
