/* xc_builtins.h - header file for xc_builtins.c */

/*  Copyright 1993 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)xc_builtins.h	1.1 22/12/93 (UKC) */

libfunc_addr_t *cx_get_libfuncs PROTO((size_t count));
char **cx_get_libvars PROTO((size_t count));
void cx_set_environ PROTO((char **envp));

/* ----------------------------------------------------------------------------
 * 'C' interpreter built-in function groups
 *	BUILTIN_X11		- include (some) X11 functions
 *	BUILTIN_NONPOSIX	- include common non-Posix functions
 *	BUILTIN_BSDSOCKET	- BSD socket-based networking functions
 *	BUILTIN_NETLOOKUP	- 'gethostbyname()' etc. functions
 *	BUILTIN_BSDTIME		- 'adjtime()' etc. functions
 *	BUILTIN_INTERNAL	- 'C' library implementation specific
 *				  (undef it if you get odd link problems)
 *
 * Undefining _BSDSOCKET and _NETLOOKUP really means that we are not linked
 * with the appropriate libraries.
 * ----------------------------------------------------------------------------
 */
#define BUILTIN_X11		1
#define BUILTIN_NONPOSIX	1
#define BUILTIN_INTERNAL	1
#define BUILTIN_VPRINTF		1
#if defined(OS_BSD)
#define BUILTIN_BSDSOCKET	1
#define BUILTIN_NETLOOKUP	1
#define BUILTIN_BSDTIME		1
#endif


/*
 * 'C' interpreter built-in specific functions and variables
 */
#define BUILTIN_GETS		1
#if defined(OS_BSD)
#define BUILTIN_FLOCK		1
#endif
#define BUILTIN_ERRNO		errno
#define BUILTIN_ERRLIST		1
/*
 * The following are used only if BUILTIN_INTERNAL is defined.
 */
#define BUILTIN_IOB		_iob
#define BUILTIN_CTYPE		_ctype_
#define BUILTIN_FLSBUF		_flsbuf
#define BUILTIN_FILBUF		_filbuf


/*
 * What needs changing...
 */
#if defined(OS_SUNOS_5) && defined(__STDC__)
#undef  BUILTIN_IOB
#undef  BUILTIN_CTYPE
#undef  BUILTIN_FLSBUF
#undef  BUILTIN_FILBUF
#define BUILTIN_IOB		__iob
#define BUILTIN_CTYPE		__ctype
#define BUILTIN_FLSBUF		__flsbuf
#define BUILTIN_FILBUF		__filbuf
extern char *sys_errlist[];
extern int sys_nerr;
#endif

#if defined(OS_SUNOS_5) && !defined(__STDC__) && defined (__CLCC__)
#undef  BUILTIN_CTYPE
#endif

#if defined(OS_SUNOS_4)
#undef  BUILTIN_BSDTIME
#undef  BUILTIN_VPRINTF
#endif

#if defined(OS_SVR4)
#undef  BUILTIN_BSDSOCKET
#undef  BUILTIN_NETLOOKUP
#undef  BUILTIN_FLOCK
#endif

#if (OS_FREEBSD >= 2)
#undef  BUILTIN_INTERNAL
#endif
#if (OS_FREEBSD >= 3)
#undef  BUILTIN_ERRNO
#endif

#if defined(OS_LINUX)
#undef  BUILTIN_INTERNAL
#undef  BUILTIN_ERRNO
#undef  BUILTIN_GETS
#endif

#if defined(OS_ULTRIX)
#undef  BUILTIN_CTYPE
#define BUILTIN_CTYPE		_ctype__
#endif

