/* ci_libfuncs.h - C interpreter builtin functions */

/*  Copyright 1992 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)cx_libfuncs.h	1.6 09 Apr 1995 (UKC) */

#ifdef _POSIX_C_SOURCE
#define POSIX
#endif

#define WANT_X11	1	/* builtins for X */

#ifdef WANT_ADDRS
#	define F(func)		(libfunc_addr_t)func
#	define F2(func, name)	(libfunc_addr_t)func
#endif

#ifdef WANT_NAMES
#	ifdef __STDC__
#		define F(func)		#func
#		define F2(func, name)	#name
#	else
#		define F(func)		"func"
#		define F2(func, name)	"name"
#	endif
#endif

	/* B1.1 File operations */
	F2(builtin_fopen, fopen),
	F2(builtin_freopen, freopen),
	F(fflush),
	F2(builtin_fclose, fclose),
#ifdef NOTYET
	F(remove),
#endif
	F(rename),
#ifdef NOTYET
	F(tmpfile),
#endif
	F(tmpnam),
#ifdef NOTYET
	F(setvbuf),
#endif
	F(setbuf),

	/* B1.2 Formatted output */
	F(fprintf),
	F(printf),
	F(sprintf),
	F(vfprintf),
	F(vsprintf),

	/* B1.3 Formatted input */
	F(fscanf),
	F(scanf),
	F(sscanf),

	/* B1.4 Character input and output functions */
	F(fgetc),
	F(fgets),
	F(fputc),
	F(fputs),
#ifndef OS_LINUX
	F(gets),
#endif
	F(puts),
	F(ungetc),

	/* These two are used by most stdio getc/putc macro implementations */
#ifdef WANT_NONPOSIX
	F(_flsbuf),
	F(_filbuf),
#endif

	/* B1.5 Direct input and output functions */
	F(fread),
	F(fwrite),

	/* B1.6 File positioning functions */
	F(fseek),
	F(ftell),
	F(rewind),
#ifdef NOTYET
	F(fgetpos),
	F(fsetpos),
#endif

	/* B1.7 Error functions */
	F(perror),

	F2(builtin_pclose, pclose),
	F2(builtin_popen, popen),

	/* B2 Character class tests */
	F(toupper),
	F(tolower),

	/* B3 - String and memory functions */
	F(strcpy),
	F(strncpy),
	F(strcat),
	F(strncat),
	F(strcmp),
	F(strncmp),
	F(strchr),
	F(strrchr),
#ifdef NOTYET
	F(strspn),
	F(strcspn),
	F(strpbrk),
	F(strstr),
#endif
	F(strlen),
#ifdef NOTYET
	F(strerror),
#endif
	F(strtok),
	F(memcpy),
#ifdef NOTYET
	F(memmove),
#endif
	F(memcmp),
	F(memchr),
	F(memset),

	/* B9 Signals */
	F2(builtin_signal, signal),
	F(alarm),
	F(sleep),

	/* B5 Utility functions */
	F(atof),
	F(atoi),
	F(atol),
	F(strtod),
	F(strtol),
#ifdef NOTYET
	F(strtoul),
#endif
#ifdef WANT_NONPOSIX
	F(srandom),
	F(random),
#endif
	F(rand),
	F(srand),
	F2(builtin_calloc, calloc),
	F2(builtin_malloc, malloc),
	F2(builtin_realloc, realloc),
	F2(builtin_free, free),
	F(abort),
	F2(builtin_exit, exit),
#ifdef NOTYET
	F(atexit),
#endif
	F(system),
	F(getenv),
#ifdef NOTYET
	F(bsearch),
#endif
	F2(builtin_qsort, qsort),
#ifdef NOTYET
	F(labs),
#endif
#ifdef STRUCTRET
	F(div),
	F(ldiv),
#endif

	/* Directory routines */
	F(opendir),
	F(readdir),
	F(closedir),
#ifndef POSIX
	F(seekdir),
	F(telldir),
#endif

	/* Old (non-ANSI) library routines */
#ifndef OS_UMIPS
#ifdef WANT_NONPOSIX
	F(setlinebuf),
	F(utimes),
#endif
#endif
	F(mktemp),
	F(time),
#ifdef WANT_NONPOSIX
	F(getwd),
#endif
	F(getcwd),
	F(ctime),
	F(abs),
	F(fdopen),

	/* Authorisation system calls */
	F(getuid),
	F(geteuid),
	F(getgid),
	F(getegid),
#ifndef OS_UMIPS
#ifdef WANT_NONPOSIX
	F(setreuid),
	F(setregid),
	F(setgroups),
#endif
#endif
	F(getgroups),
#ifndef POSIX
	F(setgrent),
#endif
	F(getgrgid),
#ifndef POSIX
	F(setpwent),
	F(getpwent),
#endif
	F(getpwnam),
	F(getpwuid),

	/* Pathname and file descriptor type system calls */
	F2(builtin_read, read),
	F2(builtin_write, write),
	F2(builtin_pipe, pipe),
	F2(builtin_lseek, lseek),
	F2(builtin_fcntl, fcntl),
	F2(builtin_close, close),
	F2(builtin_dup, dup),
	F2(builtin_dup2, dup2),
#ifdef WANT_NONPOSIX
	F(getdtablesize),
#endif
	F2(builtin_fchown, fchown),
	F2(builtin_fchmod, fchmod),
#ifndef OS_UMIPS
#ifdef WANT_NONPOSIX
	F2(builtin_flock, flock),
#endif
	F2(builtin_fsync, fsync),
#endif
	F2(builtin_ftruncate, ftruncate),
	F2(builtin_ioctl, ioctl),
#ifndef POSIX
	F(select),
#endif
	F2(builtin_open, open),
	F2(builtin_creat, creat),
	F(link),
	F(rename),
#ifndef POSIX
	F(symlink),
	F(readlink),
	F(chroot),
	F(truncate),
	F(sync),
	F(lstat),
#endif
	F(unlink),
	F(chown),
	F(chmod),
	F(mkdir),
	F(rmdir),
	F(access),
	F(chdir),
	F(umask),
	F(stat),
	F2(builtin_fstat, fstat),

	/* Process handling system calls */
	F(getpid),
	F(getpgrp),
#ifndef POSIX
	F(setpgrp),
#endif
	F(fork),
#ifndef OS_UMIPS
	F2(fork, vfork),
#ifdef WANT_NONPOSIX
	F(wait3),
	F(killpg),
	F(getrusage),
#endif
#endif
	F(execve),
	F(wait),
	F(kill),
	F2(builtin__exit, _exit),
	F(execl),
	F(execv),
	F(execle),
	F(execlp),
	F(execvp),

	/* Socket system calls */
#ifdef WANT_NONPOSIX
	F(send),
	F(sendto),
	F(sendmsg),
	F(recv),
	F(recvfrom),
	F(recvmsg),
	F(socket),
#ifndef OS_UMIPS
	F(socketpair),
#endif
	F(shutdown),
	F(getsockopt),
	F(setsockopt),
	F(getsockname),
	F(bind),
	F(connect),
	F(listen),
	F(accept),
	F(getpeername),
#endif

	/* Time system calls */
#ifdef WANT_NONPOSIX
	F(gettimeofday),
#endif
#ifndef OS_UMIPS
#ifdef WANT_NONPOSIX
	F(settimeofday),
	F(adjtime),
#endif
#endif
	F(localtime),
	
	/* Miscellaneous library functions */
	F(isatty),
#ifdef WANT_NONPOSIX
	F(ptrace),
	F(putenv),
#endif

	/* BSD signals */
	F(sigaddset),
	F(sigemptyset),
	F(sigprocmask),

	/* netdb.h stuff */
#ifdef WANT_NONPOSIX
	F(gethostbyname),
	F(gethostbyaddr),
	F(getservbyname),
	F(getservbyport),
#endif

#if WANT_X11
	F(XUngrabServer),
	F(XUnmapWindow),
	F(XGrabServer),
	F(XMoveResizeWindow),
	F(XDestroyWindow),
	F(XrmGetResource),
	F(XGetDefault),
	F(XrmGetFileDatabase),
	F(XStoreColor),
	F(XAllocColor),
	F2(builtin_XCloseDisplay, XCloseDisplay),
	F(XSynchronize),
	F2(builtin_XOpenDisplay, XOpenDisplay),
	F(XCreateGC),
	F(XGetWindowAttributes),
	F(XSetStandardProperties),
	F(XCreateSimpleWindow),
	F(XSetClassHint),
	F(XSetWMHints),
	F(XParseGeometry),
	F(XMapWindow),
	F(XChangeWindowAttributes),
	F(XBell),
	F(XStoreBytes),
	F(XSetSelectionOwner),
	F(XGetWindowProperty),
	F(XFetchBytes),
	F(XPending),
	F(XConvertSelection),
	F(XSendEvent),
	F(XChangeProperty),
	F(XGetImage),
	F(XPutImage),
	F(XSetFillStyle),
	F(XSetTile),
	F(XCreatePixmap),
	F(XCopyArea),
	F(XSetGraphicsExposures),
	F(XDrawLine),
	F(XFillRectangle),
	F(XLookupKeysym),
	F(XLookupString),
	F(XPeekEvent),
	F(XRaiseWindow),
	F(XNextEvent),
	F2(builtin_XIfEvent, XIfEvent),
	F(XCheckWindowEvent),
	F(XWarpPointer),
	F(XSync),
	F(XFlush),
	F(XSelectInput),
	F(XLoadQueryFont),
	F(XListFonts),
	F(XFreeFontNames),
	F(XUnloadFont),
	F(XDrawImageString),
	F(XDrawString),
	F(XSetFont),
	F(XSetState),
	F(XCreateBitmapFromData),
	F(XFreePixmap),
	F(XCreatePixmapCursor),
	F(XFreeCursor),
	F(XDefineCursor),
	F(XFreeColors),
	F(XAllocColorCells),
	F(XQueryColor),
	F(XParseColor),
	F(XStoreColors),
	F(XSetBackground),
	F(XSetForeground),
	F(XDisplayName),
	F(XFree),
	F(XSetWMProperties),
	F(XAllocClassHint),
	F(XAllocWMHints),
	F(XStringListToTextProperty),
	F(XAllocSizeHints),
	F(XClearWindow),
	F(XDrawRectangle),
	F(XTextWidth),
	F(XCheckTypedEvent),
	F(XClearArea),
#endif
