/* ci_libvars.h - C interpreter builtin variables */

/*  Copyright 1992 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)cx_libvars.h	1.4 21 Apr 1994 (UKC) */

#define WANT_X11	1	/* builtins for X */

#ifdef WANT_ADDRS
#	define V(var)		(char *)&var
#	define V2(var, name)	(char *)&var
#	define VA(var)		(char *)var
#endif

#ifdef WANT_NAMES
#	ifdef __STDC__
#		define V(var)		#var
#		define V2(var, name)	#name
#		define VA(var)		#var
#	else
#		define V(var)		"var"
#		define V2(var, name)	"name"
#		define VA(var)		"var"
#	endif
#endif

#ifndef OS_LINUX
	V(errno),
#endif
	V(sys_nerr),
	V(optind),
	V(optarg),
#ifdef WANT_NONPOSIX
	VA(_iob),
#endif
	VA(sys_errlist),
	V2(Builtin_environ, environ),
#ifdef OS_ULTRIX
	VA(_ctype__),
	V(_pctype),
#else
#ifdef OS_UMIPS
	VA(_ctype),
#else
#ifdef WANT_NONPOSIX
	VA(_ctype_),
#endif
#endif /* !OS_UMIPS */
#endif /* !OS_ULTRIX */

#if WANT_X11
	V(_Xdebug)
#endif
