%{ 
/* xwalld.y: the parser for xwalld 1.1
 * tian
 *         than@lucent.com
 *         tian@aluxpo.mirco.lucent.com
 */

#ifdef IDENT
#ident  "@(#)xwalld.y    1.1 xwalld Sat Jan 27 18:48:44 EST 1997"
#endif

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xatom.h>

#include "xwalld.h"

static XWallDP instr = NULL;

static void fork_popup();
static void dismissCallback();
static void popup();
%}

%union
{
   char*     sval;
}

%token  <sval>  TIME
%token  <sval>  SENDER
%token  <sval>  HOST
%token  <sval>  RECEIVER
%token  <sval>  SUBJECT
%token  <sval>  MESSAGE
%token  <sval>  END
%token  <sval>  WORDS

%%
/* Rules */
input_stream : data END
                  { fork_popup(); }
             | input_stream data END
                  { fork_popup(); }
             | error END
                  {
                      /* fprintf(stderr, "we caught the error.\n"); */
                      /* if there is an error, restart after the next WORDS */
                      yyerrok; yyclearin;
                  } 
             | error WORDS
                  { 
                      /* fprintf(stderr, "we caught the error.\n"); */
                      /* if there is an error, restart after the next WORDS */
                      yyerrok; yyclearin; /* return 0; */
                  } 
             ;

data  : unit
      | data unit
      ;

unit : TIME string 
                 {
                       instr->Date = $<sval>2;
                 } 
     | SENDER string 
                 { 
                       instr->Sender = $<sval>2;
                 }
     | HOST string 
                 { 
                       instr->Host = $<sval>2;
                 }
     | RECEIVER string 
                 { 
                       instr->Receiver = $<sval>2;
                 }
     | SUBJECT string 
                    {
                       instr->Subject = $<sval>2;
                    }
     | MESSAGE string 
                    {
                       instr->Message = $<sval>2;
                    }
     ; 

string : WORDS
            {
                char *p1=$<sval>1, *p2=$<sval>1;
                int  i, len = strlen($<sval>1);
         
                /* fprintf(stderr, "we get a string.\n"); */

                /* allocate memory for 'instr' */
                if( !instr ) {
                    if( (instr=(XWallDP)malloc(sizeof(XWallDS))) == NULL) {
                        perror("(XWallDP)malloc(sizeof(XWallDS))");
                        fflush(yyin);
                        return 1;
                    }
                } 
                 
                /* stripe off the escape char '\\' for '"' and the ending double quote */
                for(i=0; i<len-1; i++) {
                       if( *p1=='\\' && *(p1+1)=='"')  {  p1++; }
                       else                            { *p2=*p1; p2++; p1++; }
                }
                *p2 = '\0';
          
                /* stripe off the heading double quote and return. */
                $<sval>$ = $<sval>1 + 1;
             }                                
        ;


/*end of Rules */
%%

void yyerror(char *s)
{
    /* fprintf(stderr, "%s\n", s); */ /* don't bother */
    return; 
}

void fork_popup()
{
   pid_t child;

   /* one of the subject and message must not be null */
   if( ! ( (instr->Subject && strlen(instr->Subject)) 
                  || (instr->Message && strlen(instr->Message)) ) ) {
           return; 
   }

   /* 3rd fork to make a pop-up message window */ 
   if( (child=fork()) == (pid_t)-1 ) {
           perror("fork()");
           exit(1);
   } else if( child == (pid_t)0 ) {
           /*child*/
           XWallDP copy=instr;
           fclose(yyin);
           instr=NULL; /* renew instr */
           (void) popup(copy); 
   } else return; /*parent*/
}   



static Atom wm_delete_window;

/* ARGSUSED */
static void
my_exit_action(w, event, params, num_params)
    Widget w;                 /* unused */
    XEvent *event;
    String *params;           /* unused */
    Cardinal *num_params;     /* unused */
{
    if(event->type == ClientMessage
       && event->xclient.data.l[0] != wm_delete_window)
        return;

    if (*num_params == 1) exit(0);
}

static XtActionsRec actions_list[] = {
    "my_exit", my_exit_action,
};

static String top_trans =
                     "<ClientMessage>WM_PROTOCOLS: my_exit(1)\n";

void popup(XWallDP data)
{
    XtAppContext app_con;
    int zero=0;
    Widget top, form, label, button;
    Dimension height;
    char labeltext[DATA_MAXLEN+256];

    labeltext[0]='\0';
    if(data->Date) { 
          strcat(labeltext, "Date:    "); 
          strcat(labeltext, data->Date); 
          strcat(labeltext,"\n"); 
    }
    if(data->Sender) { 
          strcat(labeltext, "From:    "); 
          strcat(labeltext, data->Sender); 
          strcat(labeltext,"\n"); 
    }
    if(data->Host) { 
          strcat(labeltext, "Host:    "); 
          strcat(labeltext, data->Host); 
          strcat(labeltext,"\n"); 
    }
    if(data->Receiver) { 
          strcat(labeltext, "To:      "); 
          strcat(labeltext, data->Receiver); 
          strcat(labeltext,"\n"); 
    }
    if(data->Subject)  { 
          strcat(labeltext, "Subject: "); 
          strcat(labeltext, data->Subject); 
          strcat(labeltext,"\n"); 
    }
    strcat(labeltext,"\n"); 
    if(data->Message)  { 
          strcat(labeltext, data->Message); 
          strcat(labeltext,"\n"); 
    }

    free(data);

    top = XtAppInitialize (&app_con, "XWallD", NULL, 0,
                           &zero, NULL, NULL, NULL, 0);

    form = XtVaCreateManagedWidget ("form", formWidgetClass, top,
                                    NULL);

    label = XtVaCreateManagedWidget("label", labelWidgetClass, form,
                                     XtNlabel,   labeltext,
                                     XtNx,       0,
                                     XtNy,       0,
                                     XtNleft,    XtChainLeft,
                                     XtNright,   XtChainRight,
                                     XtNtop,     XtChainTop,
                                     XtNbottom,  XtChainBottom,
                                     NULL);
    XtVaGetValues(label, XtNheight, &height, NULL);

    button = XtVaCreateManagedWidget ("button", commandWidgetClass, form,
                                       XtNlabel,        "Dismiss", 
                                       XtNleft,         XtChainLeft,
                                       XtNright,        XtChainLeft,
                                       XtNtop,          XtChainBottom,
                                       XtNbottom,       XtChainBottom,
                                       XtNfromVert,     label,
                                       XtNvertDistance, 5,
                                       XtNfromHoriz,    NULL,
                                       XtNshapeStyle,   XawShapeOval,
                                       NULL);
    XtAddCallback ( button, XtNcallback, dismissCallback, NULL);

    XtRealizeWidget(top);

    XChangeProperty(XtDisplay(top),    XtWindow(top),
                    XA_WM_NAME,        XA_STRING,
                    8,                 PropModeReplace,
                    (unsigned char *)"XWall",
                    strlen("XWall") );

    XtAppAddActions(app_con, actions_list, XtNumber(actions_list));
    XtOverrideTranslations(top, XtParseTranslationTable(top_trans));

    wm_delete_window = XInternAtom (XtDisplay(top), "WM_DELETE_WINDOW", False);
    (void) XSetWMProtocols (XtDisplay(top), XtWindow(top), &wm_delete_window, 1);

    XBell(XtDisplay(top), 100);

    XtAppMainLoop(app_con);
  
    exit(0);

}

void dismissCallback ( Widget w, XtPointer clientData, XtPointer callData)
{
    exit(0);
}
