%{
/* xwalld.l: lexical analyer source code of xwalld 1.1.
 * tian
 *       than@lucent.com
 *       tian@aluxpo.micro.lucent.com
 */

#ifdef IDENT
#ident  "@(#)xwalld.l    1.1 xwalld Sat Jan 25 18:48:44 EST 1997"
#endif

#include <string.h>
#include "y.tab.h"
%}

%%

date      { /* ECHO; */ return TIME; }
sender    { /* ECHO; */ return SENDER; }
host      { /* ECHO; */ return HOST; }
receiver  { /* ECHO; */ return RECEIVER; }
subject   { /* ECHO; */ return SUBJECT; }
message   { /* ECHO; */ return MESSAGE; }
quit      { /* ECHO; */ return END; }


\"[^"]*\"   {
              if (yytext[yyleng - 2] == '\\') {
                        /* printf("get %s long %d\n", yytext, yyleng); */
                        yyless(yyleng - 1);
                        /* printf("get %s long %d\n", yytext, yyleng); */
                        yymore();
              }
              else {
                        /* printf("get %s long %d\n", yytext, yyleng); */
                        yylval.sval = (char*)strdup(yytext);
                        return WORDS;
              }
          }

\n|.  ; /* { ECHO; printf(" unexpected\n"); return yytext[0]; } */

%%
int yywrap() { return 1;}
