.\" tian's man page.
.TH XWALL 1 "Jan 25 1997" "Lucent Technologies "
.SH NAME
xwall xwalld \- client/server of xwall(5) protocol implementation 
.SH SYNOPSIS
.B xwall
[-s \fIsubject\fP]
[-r \fIraw_data\fP]
[-v]
.br
.B xwalld
-f \fIfifo_name\fP
.SH DESCRIPTION
.PP
\fIXwall\fP is the X'ed wall(1). \fIXwall\fP and \fIxwalld\fP communicate
through an FIFO (i.e. named pipe or unix domain socket), 
usually /dev/xdm/[0-9]*. They follow \fIxwall\fP(5) protocol (version 1.1).
\fIXwalld\fP is 
on the server side trying to read from the FIFO. It works as a 
daemon and can be started once user login through xdm(1), xdm also makes 
the FIFO. \fIXwalld\fP will exit automatically when the 
FIFO is removed. 
.PP
\fIXwall\fP is on the client side. It writes data to the FIFO.
The directory path of the FIFO has compiled inside \fIxwall\fP,
so it will find them by its own. This is a set-gid excutable file
in order to broadcast message and get authentic user identity and date. 
.PP
Why do we use FIFO (unix domain socket) instead of tcp port (internet 
domain socket)? -- because FIFO costs less and easy to make; ( how
to dynamically assign each user a tcp port and then tell \fIxwall\fP(1)
is painful); also we don't have to worry about the MIT-MAGIC-COOKIIE 
and the DISPLAY environment variable; the authentication of the message 
is easily integrated in the file system's security.

.PP
\fIXwall\fP and \fIxwalld\fP are independent in the sense that you
can write your own \fIxwall\fP to communicate this \fIxwalld\fP.
For example, make a shell script. Both \fIXwalld\fP version 1.0 and
version 1.1 can communicate either of the \fIxwall\fP version 1.0 and
version 1.1. 
.PP
\fIXwalld\fP supports multiple messages in a single stream. While
the \fIxwall\fP here now only can send one message once. Again,
you can make your own \fIxwall\fP to send multiple messages once
and even to choose specific receivers instead of broadcast. 
.SH "OPTIONS OF XWALLD"
.IP "\fB-f\fP \fIfifo_name\fP"
This specifies which FIFO \fIxwalld\fP should listen to,
usually /dev/xdm/[0-9]*.

.SH "OPTIONS OF XWALL"
.IP "\fB-s\fP \fIsubject\fP"
This gives the subject of xwall message. See xwall(5).
If \fIsubject\fP is longer than one word, then it needs quoting.
morefile as a virtual tty for \fIxdm\fP(1)
.IP "\fB-r\fP \fIraw_data\fP"
This gives one or more xwall(5) protocol units. 
.IP "\fB-v\fP 
This make \fIxwall\fP print some debugging information.
.SH USAGES
\fIXwall\fP is a supplimentary tool for wall(1) in X environment.
This is because when a user login through xdm(1), there may be
no tty associated with his session and hence wall(1) won't work
for this case.  but note: \fIxwall\fP is not supposed to be a 
replacement for wall(1). Wall(1) and \fIxwall\fP can be easily
integrated by using a shell script so that you don't have to
type the same message twice.
.PP
To make the FIFO for \fIxwalld\fP, i did this in the Xstartup file

        mkfifo -m 620 /dev/xdm/<this_xdm_pid> 
        chown $USER:nobody /dev/xdm/<this_xdm_pid>

Then in the Xreset file to remove it after user exit X session.

        /bin/rm -f /dev/xdm/<this_xdm_pid>

To start \fIxwalld\fP, i did this in the Xsession file

        ..../xwalld -f /dev/xdm/<this_xdm_pid>

I set-gid on \fIxwall\fP,

.nf
        % chown nobody:nobody xwall
        % chmod 2711 xwall
        % ls -l xwall
          -rwx--s--x 1 nobody nobody 10072 Jan 25 19:18 xwall
.fi

so that it can write to all those FIFO's.
To \fIxwall\fP the xdm users, simply type \fIxwall\fP and 
then message like wall(1).

        % xwall
        the system will be rebooted in 5 minuts.
        please save your work to avoid risking lose.
        (Control-D)

If you want to include a subject, you could

        % xwall -s "system rebooted in 5 minuts."
        please save your work to avoid risking lose.
        (Control-D)

The above is equivallent to 

        % xwall -r "subject\\"system rebooted in 5 minuts.\\""
        please save your work to avoid risking lose. 
        (Control-D)
.SH "SEE ALSO"
xwall(5), wall(1), X(1), xdm(1), mkfifo(1)
.SH AUTHOR
Version 1.1 and 1.0 by Tianhua Han, Lucent Technology, \fIthan@lucent.com\fP
