/* xwall.c: client implementation of xwall protocol 1.1.
 * tian
 *       than@lucent.com
 *       tian@aluxpo.micro.lucent.com
 */
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <sys/utsname.h>

#include "xwalld.h"

static void usage (char *program_name)
{
#ifdef DEBUG
      fprintf(stderr, "usage: %s [-s subject] [-r raw_data] [-d xdm_lines_dir] [-v]\n", program_name);
#else
      fprintf(stderr, "usage: %s [-s subject] [-r raw_data] [-v]\n", program_name);
#endif
      fprintf(stderr, "  -s  subject   if more than one word, please quote them.\n");
      fprintf(stderr, "  -r  raw_data  a double quoted string with multi-purpose, for example: \"receiver\\\"all\\\"subject\\\"reboot\\\"\".\n");
      fprintf(stderr, "  -v             make verbose output for debugging\n"); 
#ifdef DEBUG
      fprintf(stderr, "  -d  subject    dir for xdm virtual lines. /dev/xdm be default.\n");
#endif
      exit (1);
}

void main(int argc, char **argv)
{

    int    i, fd, verbose=0;
    char   c, data[DATA_MAXLEN],
           fifo_name[256],
           *xdm_lines_dir=XDM_LINES_DIR;
    FILE   *outfile;
    time_t t=time(NULL);
    struct passwd  *pwd = getpwuid(getuid());
    struct stat    statv;
    struct dirent  *dp;
    struct utsname host;
    DIR            *dir_fdesc;

#ifndef REDUNDENT
    uid_t          eff_uid;  
    gid_t          eff_gid;  


    /* For security reasons, we reset gid before necessary. 
     * use setegid() instead of setgid() to set the process's effective gid. 
     * because the caller only need a special effective gid.
     */
    eff_gid = getegid();
    if( setegid(getgid()) ) {
       perror("setgid(getgid())"); 
       exit(1);
    }
#endif

#ifdef DEBUG
    printf("xdm_lines_dir=%s.\n", XDM_LINES_DIR);
#endif

    if(argc == 999 ) {
       /* this message is for strings(1). */
       printf("Here!!!.\n");
       printf("the source is in tian's pub/src. tian@aluxpo.micro.lucent.com, x7668. \n");
    }

    /* initialize the data string */
    data[0] = '\0';

    for(i=1; i<argc; i++) {
        char *arg = argv[i];
        if(arg[0] == '-') {
              switch (arg[1]) {
#ifdef DEBUG
                 case 'd': if(++i >= argc) usage(argv[0]);
                           xdm_lines_dir=argv[i]; 
                           continue;
#endif
                 case 's': if(++i >= argc) usage(argv[0]);
                           strcat(data, "subject\"");
                           strcat(data, argv[i]);
                           strcat(data, "\"");
#ifdef DEBUG
                           strcat(data, "\n");
#endif
                           continue;
                 case 'r': if(++i >= argc) usage(argv[0]);
                           strcat(data, argv[i]);
#ifdef DEBUG
                           strcat(data, "\n");
#endif
                           continue;
                 case 'v': verbose=1;
                           continue;
                 default : usage(argv[0]);
              }
        }
        else usage(argv[0]);
    }

    /* get the valid sender name. we don't trust $LOGNAME or $USER */
    if(!pwd) {
       fprintf(stderr, "cannot get your user name. please contact SA.\n", argv[0]);
       exit(1);
    }
    strcat(data, "sender\""); 
    strcat(data, pwd->pw_name);
    strcat(data, "\"");
#ifdef DEBUG
    strcat(data, "\n");
#endif

    /*get the date*/
    strcat(data, "date\"");
    strcat(data, asctime(localtime(&t)));
    /* remove the return char '\n' at the end of the time string. */
    if(data[strlen(data)-1]=='\n')  data[strlen(data)-1] = '\0';
    strcat(data, "\"");
#ifdef DEBUG
    strcat(data, "\n");
#endif

    /* get the host name, we don't trust $HOSTNAME */
    if ( uname(&host) == -1 )  {
        perror("uname");
        exit(1);
    }
    strcat(data, "host\"");
    strcat(data,  host.nodename); 
    strcat(data, "\"");
#ifdef DEBUG
    strcat(data, "\n");
#endif
  

    /* get message from standard input */
    strcat(data, "message\"");
    i=strlen(data);
    while( !feof(stdin) && i< sizeof(data)-strlen("quit")-10 /*give a little redudence*/) {
         if( (c=getchar()) == '"' ) {
            data[i]='\\';
            i++;
         } 
         data[i]=c;
         i++;
    }
    fflush(stdin);

    /* to stripe off the ending EOF */
    i=( i>=2 ? i-2 : 0 );
    /* add the closing double quote */
    data[i]='"'; 
    i++;
#ifdef DEBUG
    /* add a redundent return in order get a better debug output */
    data[i]='\n';
    i++;
#endif
    /* end the string with a null char */
    data[i]='\0';

    /* close the data string with "quit" */
    if(strlen(data)+strlen("quit")+5 >= sizeof(data)) {
         fprintf(stderr, "%s: message too long", argv[0]);
         exit(1);
    }
    strcat(data, "quit");
#ifdef DEBUG
    strcat(data, "\n");
    printf("input:\n%s\nlength=%d\n", data, strlen(data));
#endif

#ifndef REDUNDENT
    /* now we really need the setegid */
    if(setegid(eff_gid)) {
        perror("setegid(eff_gid)");
        exit(1);
    }
#endif

#ifdef DEBUG
    fflush(stdin);
    printf("hit return to continue.\n");
    getchar();
#endif

    /* now open the dir and try to broadcast */
    if( ! (dir_fdesc=opendir(xdm_lines_dir)) ) {
           perror("opendir(xdm_lines_dir)");
#ifndef REDUNDENT
           /* for security, reset the uid and gid before leaving */
           setgid(getgid());
           exit(1);
#endif
    }

    while(dp=readdir(dir_fdesc)) {
        if( strcmp(dp->d_name, ".") && strcmp(dp->d_name, "..")) {
            fifo_name[0]='\0';
            strcat(fifo_name, xdm_lines_dir);
            strcat(fifo_name, "/");
            strcat(fifo_name, dp->d_name);
          
            if(verbose)
                   fprintf(stderr, "begin operating %s.\n", fifo_name);

            /* make sure we will open an FIFO, and it's writable. */
            if( stat(fifo_name, &statv) ) {
                  if(verbose) {
                     perror("stat()");
                     fprintf(stderr, 
                             "%s: %s is not a valid path name.\n", 
                             argv[0], fifo_name);
                  }
                  continue;
            }
            if( ! (statv.st_mode & S_IFIFO) ) {
                  if(verbose) {
                     fprintf(stderr, 
                             "%s: %s is not an FIFO.\n", 
                             argv[0], fifo_name);
                  }
                  continue;
            }

            /****************************************************** 
             *since access() use the real process gid, the following
             * shouldn't be included.
            if( access(fifo_name, W_OK) == -1 ) {
                  fprintf(stderr, 
                          "%s: %s is not writable.\n", 
                          argv[0], fifo_name);
                  continue;
            }
            *******************************************************/
         
            /*open to the fifo*/
            if((fd=open(fifo_name, O_WRONLY|O_NDELAY|O_NONBLOCK)) == -1 ) {
                 if(verbose) {
                      perror("open");
                      fprintf(stderr, 
                              "%s: open(\"%s\", O_WRONLY|O_NDELAY|O_NONBLOCK) failed.\n", 
                               argv[0], fifo_name);
                 }
                 continue;
            }
            if( (outfile=fdopen(fd, "wb")) == NULL ) {
                 if(verbose) {
                      fprintf(stderr, "%s: outfile=fdopen(fd, \"wb\") failed.\n", argv[0]);
                      close(fd);
                 }
                 continue;
            }

            /* now write */
            fprintf(outfile, "%s\n", data);

            fclose(outfile);
        }
    }
    closedir(dir_fdesc);

#ifdef DEBUG
    fflush(stdin);
    printf("hit return key to continue.\n");
    getchar();
#endif
    
#ifndef REDUNDENT
    /* for security, reset gid before leaving */
    setegid(getgid());
#endif

    exit(0);
}
