.\" $Id: ddd.man.in,v 1.314 1998/11/30 09:55:26 zeller Exp $ -*-nroff-*-
.\" DDD manual page
.\" Generated automatically from ddd.man.in by configure.
.\"
.\" Copyright (C) 1995-1998 Technische Universitaet Braunschweig, Germany.
.\" Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
.\" 
.\" This file is part of DDD.
.\" 
.\" DDD is free software; you can redistribute it and/or modify it under
.\" the terms of the GNU General Public License as published by the Free
.\" Software Foundation; either version 2 of the License, or (at your
.\" option) any later version.
.\" 
.\" DDD is distributed in the hope that it will be useful, but WITHOUT ANY
.\" WARRANTY; without even the implied warranty of MERCHANTABILITY or
.\" FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
.\" for more details. 
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with DDD -- see the file COPYING.  If not, write to the Free
.\" Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
.\" MA 02111-1307, USA.
.\" 
.\" DDD is the data display debugger.
.\" For details, see the DDD World-Wide-Web page, 
.\" `http://www.cs.tu-bs.de/softech/ddd/',
.\" or send a mail to the DDD developers <ddd@ips.cs.tu-bs.de>.
.\"
.TH ddd 1 "1998\-12\-01" "DDD 3.1"
.SH "NAME"
ddd, xddd - the data display debugger
.SH ""
.PSPIC ./PICS/dddsplash.ps 10cm
.\"
.\" ---------------
.SH "SYNOPSIS"
.\" ---------------
.na
.TP
.B ddd
.RB "[\|" \-\-gdb "\|]"
.RB "[\|" \-\-dbx "\|]"
.RB "[\|" \-\-xdb "\|]"
.RB "[\|" \-\-jdb "\|]"
.RB "[\|" \-\-pydb "\|]"
.RB "[\|" \-\-perl "\|]"
.RB "[\|" \-\-debugger
.I name\c
\&\|]
.RB "[\|" \-\- "[" r "]" host " ["\c
.I username\c
.B @\c
\&]\c
.I hostname\c
\&\|]\|]
.RB "[\|" \-\-help "\|]"
.RB "[\|" \-\-trace "\|]"
.RB "[\|" \-\-version "\|]"
.RB "[\|" \-\-configuration "\|]"
.RB "[\|"\c
.I options...\c
\&\|]
.RB "[\|" \c
.I program
.RB "[\|" \c
.I core \c
\&\||\|
.I process-id\c
\&\|]\|]
.ad b
.TP
but usually just
.TP
.B ddd
.I program
.ad b
.\"
.\" ---------------
.SH "DESCRIPTION"
.\" ---------------
.\"
The purpose of a debugger such as \s-1DDD\s+1 is to allow you to see
what is going on \*(lqinside\*(rq another program while it
executes\(em\&or what another program was doing at the moment it
crashed.
.PP
\s-1DDD\s+1 can do four main kinds of things (plus other things in support of
these) to help you catch bugs in the act:
.IP \(bu 2
Start your program, specifying anything that might affect its
behavior.
.br
.IP \(bu 2
Make your program stop on specified conditions.
.br
.IP \(bu 2
Examine what has happened, when your program has stopped.
.br
.IP \(bu 2
Change things in your program, so you can experiment with correcting the
effects of one bug and go on to learn about another.
.PP
.\"
\*(lqClassical\*(rq \s-1UNIX\s+1 debuggers such as the \s-1GNU\s+1
debugger (\s-1GDB\s+1) provide a command-line interface and a
multitude of commands for these and other debugging purposes.
\s-1DDD\s+1 is a comfortable \fIgraphical user interface\fR around
an inferior \s-1GDB\s+1, \s-1DBX\s+1, \s-1XDB\s+1, \s-1JDB\s+1, Python
debugger, or Perl debugger.
.\"
.\"
.\" ---------------
.SH "INVOKING DDD"
.\" ---------------
.\"
You can run \s-1DDD\s+1 with no arguments or options.  However, the
most usual way to start \s-1DDD\s+1 is with one argument or two,
specifying an executable program as the argument:
.sp
.br
  \fBddd\ program\fR
.br
.sp
.\"
You can also start with both an executable program and a core file specified:
.sp
.br
  \fBddd\ program\ core\fR
.br
.sp
.\"
You can, instead, specify a process ID as a second argument, if you want
to debug a running process:
.sp
.br
  \fBddd\ program\ 1234\fR
.br
.sp
.\"
would attach \s-1DDD\s+1 to process \c
.B 1234\c
\& (unless you also have a file
named `\|\c
.B 1234\c
\&\|'; \s-1DDD\s+1 does check for a core file first).
.\"
.PP
By default, \s-1DDD\s+1 determines the inferior debugger
automatically.  Use
.sp
.br
  \fBddd\ \-\-gdb \fIprogram\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-dbx \fIprogram\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-xdb \fIprogram\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-jdb \fIclass\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-pydb \fImodule\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-perl \fIprogramfile\fR
.br
.sp
.\"
to run \s-1GDB\s+1, \s-1DBX\s+1, \s-1XDB\s+1, \s-1JDB\s+1,
\s-1PYDB\s+1 or Perl as inferior debugger.
.PP
To learn more about \s-1DDD\s+1 options, run
.sp
.br
  \fBddd\ \-\-help\fR
.br
.sp
to get a list of frequently used options, or see the `\fBOPTIONS\fR'
section, below.
.\"
.\" ---------------
.SH "THE DDD WINDOWS"
.\" ---------------
.\"
.SS "The DDD Main Windows"
.\"
.PSPIC ./PICS/ddd-all.ps 15.3cm
\s-1DDD\s+1 is composed of three main windows:
.br
.IP \(bu 2
The \fIData Window\fR shows the current data of the debugged program.
.br
.IP \(bu 2
The \fISource Window\fR shows the current source code of the debugged
program.
.br
.IP \(bu 2
The \fIDebugger Console\fR accepts debugger commands and shows
debugger messages.
.PP
By default, \s-1DDD\s+1 places these main windows stacked into one
single top-level window, but \s-1DDD\s+1 can also be configured to
treat each one separately.
.PP
.PSPIC ./PICS/ddd-separate.ps 15.3cm
.PP
Besides these main windows, there are some other optional windows:
.br
.IP \(bu 2
The \fICommand Tool\fR offers buttons for frequently used commands.
It is usually placed on the source window.
.br
.IP \(bu 2
The \fIMachine Code Window\fR shows the current machine code.  It is
usually placed beneath the current source.
.br
.IP \(bu 2
The \fIExecution Window\fR shows the input and output of the debugged
program.
.PP
\s-1DDD\s+1 also has several temporary \fIdialogs\fR for showing and
entering additional information.
.\"
.\"
.SS "Using the Command Tool"
.\"
The command tool is a small window containing frequently used
\s-1DDD\s+1 commands.  It can be moved around on top of the
\s-1DDD\s+1 windows, but it can also be placed besides them.
Whenever you save \s-1DDD\s+1 state, \s-1DDD\s+1 also saves the
distance between command tool and source window, such that you can
select your own individual command tool placement.  To move the
command tool to its saved position, use `\fBView\(->Command Tool\fR'.
.PP
By default, the command tool \fIsticks\fR to the \s-1DDD\s+1 source
window: Whenever you move the \s-1DDD\s+1 source window, the command
tool follows such that the distance between source window and command
tool remains the same.  By default, the command tool is also
\fIauto-raised\fR, such that it stays on top of other \s-1DDD\s+1
windows.
.PP
The command tool can be configured to appear as a command tool bar
above the source window; see `\fBEdit\(->Preferences\(->Source\(->Tool
Buttons Location\fR' for details.
.PP
.PSPIC ./PICS/ddd-tool.ps 15.3cm
.\"
.\"
.SS "Using the Tool Bar"
.\"
Some \s-1DDD\s+1 commands require an \fIargument\fR.  This argument
is specified in the \fIargument field\fR, labeled `\fB():\fR'.
Basically, there are four ways to set arguments:
.IP \(bu 2
You can \fIkey in\fR the argument manually.
.IP \(bu 2
You can \fIpaste\fR the current selection into the argument field
(typically using \fImouse button 2\fR).  To clear old contents
beforehand, click on the `\fB():\fR' label.
.IP \(bu 2
You can \fIselect an item\fR from the source and data windows.  This
will automatically copy the item to the argument field.
.IP \(bu 2
You can select a \fIpreviously used argument\fR from the drop-down
menu at the right of the argument field.
.PP
Using \s-1GDB\s+1 and Perl, the argument field provides a completion
mechanism.  You can enter the first few characters of an item an press
the \s-1\fBTAB\fR\s+1 key to complete it.  Pressing \s-1\fBTAB\fR\s+1
again shows alternative completions.
.PP
After having entered an argument, you can select one of the buttons on
the right.  Most of these buttons also have menus associated with
them; this is indicated by a small arrow in the upper right corner.
Pressing and holding \fImouse button 1\fR on such a button will pop up
a menu with further operations.
.PP
.PSPIC ./PICS/ddd-toolbar.ps 15.3cm
.\"
.\"
.\" ---------------
.SH "GETTING HELP"
.\" ---------------
.\"
\s-1DDD\s+1 has an extensive on-line help system.  Here's how to get 
help while working with \s-1DDD\s+1.
.\"
.\"
.SS "Button Tips"
.\"
You can get a short help text on most \s-1DDD\s+1 buttons by simply
moving the mouse pointer on it and leave it there.  After a second, a
small window (called \fIbutton tip\fR) pops up, giving a hint on the
button's meaning.  The button tip disappears as soon as you move the
mouse pointer to another item.
.\"
.\"
.SS "The Status Line"
.\"
The status line also displays information about the currently selected
item.  By clicking on the status line, you can redisplay the most
recent messages.
.\"
.\"
.SS "Context-Sensitive Help"
.\"
You can get detailed help on any visible \s-1DDD\s+1 item.  Just
point on the item you want help and press the `\fBF1\fR' key.  This
pops up a detailed help text.
.PP
The \s-1DDD\s+1 dialogs all contain `\fBHelp\fR' buttons that give
detailed information about the dialog.
.\"
.\"
.SS "Help on Debugger Commands"
.\"
You can get help on debugger commands by entering `\fBhelp\fR' at the
debugger prompt.
.PP
See `\fBEntering Commands\fR', below, for details on entering commands.
.\"
.\"
.SS "Are You Stuck?"
.\"
If you are stuck, try `\fBHelp\(->What Now?\fR' (the `\fBWhat Now\fR'
item in the `\fBHelp\fR' menu) or press \fBCtrl+F1\fR.  Depending on
the current state, \s-1DDD\s+1 will give you some hints on what you
can do next.
.\"
.\"
.SS "Undoing Commands"
.\"
And if, after all, you made a mistake, don't worry.  Almost every
\s-1DDD\s+1 command can be undone, using `\fBEdit\(->Undo\fR' or the
`\fBUndo\fR' button on the command tool.  Likewise,
`\fBEdit\(->Redo\fR' repeats the command most recently undone.
.\"
.\"
.\"
.\" ---------------
.SH "OPENING FILES"
.\" ---------------
.\"
If you did not invoke \s-1DDD\s+1 specifying a program to be debugged,
you can use the `\fBFile\fR' menu to open programs, core dumps and
sources.
.PP
.PSPIC ./PICS/ddd-open.ps 15.3cm
.PP
To open a program to be debugged, select `\fBFile\(->Open Program\fR'.
.PP
In \s-1JDB\s+1, select `\fBFile\(->Open Class\fR' instead.  This gives
you a list of available classes to choose from.
.PP
To re-open a recently debugged program or class, select
`\fBFile\(->Open Recent\fR' and choose a program or class from the
list.
.PP
Note: With \s-1XDB\s+1 and some \s-1DBX\s+1 versions, the debugged
program must be specified upon invocation and cannot be changed at run
time.
.PP
To open a core dump for the program, select `\fBFile\(->Open Core
Dump\fR'.  Before `\fBOpen Core Dump\fR', you should first use
`\fBFile\(->Open Program\fR' to specify the program that generated the
core dump and to load its symbol table.
.PP
To open a source file of the debugged program, select `\fBFile\(->Open
Source\fR'.
.IP \(bu 2
Using \s-1GDB\s+1, this gives you a list of the sources used for
compiling your program.
.IP \(bu 2
Using other inferior debuggers, this gives you a list of accessible
source files, which may or may not be related to your program.
.\"
.\"
.\" ---------------
.SH "LOOKING UP ITEMS"
.\" ---------------
.\"
As soon as the source of the debugged program is available, the
\fIsource window\fR displays its current source text.  (If a source
text cannot be found, use `\fBEdit\(->GDB Settings\fR' to specify
source text directories.)
.PP
In the source window, you can lookup and examine function and variable
definitions as well as search for arbitrary occurrences in the source
text.
.\"
.\"
.SS "Looking up Definitions"
.\"
If you wish to lookup a specific function or variable definition whose
name is visible in the source text, click with \fImouse button 1\fR on
the function or variable name.  The name is copied to the argument
field.  Alter the name if desired and click on the `\fBLookup ()\fR'
button to find its definition.
.PP
.PSPIC ./PICS/ddd-source-popup.ps 15.3cm
.PP
As a faster alternative, you can simply press \fImouse button 3\fR on the
function name and select the `\fBLookup\fR' item from the source popup
menu.
.PP
As an even faster alternative, you can also double-click on a function 
call (an identifier followed by a `\fB(\fR' character) to lookup the
function definition.
.\"
.\"
.SS "Textual Search"
.\"
If the item you wish to search is visible in the source text, click
with \fImouse button 1\fR on it.  The identifier is copied to the argument
field.  Click on the `\fBFind\s-2>>\s+2 ()\fR' button to find
following occurrences and on the `\fBFind\s-2<<\s+2 ()\fR' button to
find previous occurrences.
.PP
As an alternative, you can enter the item in the argument field and
click on one of the `\fBFind\fR' buttons.
.PP
By default, \s-1DDD\s+1 finds only complete words.  To search for
arbitrary substrings, change the value of the `\fBSource\(->Find Words
Only\fR' option.
.\"
.\"
.SS "Looking up Previous Locations"
.\"
After looking up a location, use `\fBEdit\(->Undo\fR' (or the
`\fBUndo\fR' button on the command tool) to go back to the original
locations.  `\fBEdit\(->Redo\fR' brings you back again to the location
you looked for.
.PP
.PSPIC ./PICS/ddd-source.ps 15.3cm
.\"
.\"
.\"
.\"
.\" ---------------
.SH "BREAKPOINTS"
.\" ---------------
.\"
You can make the program stop at certain \fIbreakpoints\fR and trace
its execution.
.\"
.\"
.SS "Setting Breakpoints by Location"
.\"
If the source line is visible, click with \fImouse button 1\fR
on the left of the source line and then on the `\fBBreak at ()\fR'
button.
.PP
As a faster alternative, you can simply press \fImouse button 3\fR on
the left of the source line and select the `\fBSet Breakpoint\fR' item
from the line popup menu.
.PP
.PSPIC ./PICS/ddd-line-popup.ps 15.3cm
.PP
As an even faster alternative, you can simply double-click on the left
of the source line to set a breakpoint.
.PP
As yet another alternative, you can select `\fBSource\(->Edit
Breakpoints\fR'.  Click on the `\fBBreak\fR' button and enter the
location.
.PP
(If you find this number of alternatives confusing, be aware that
\s-1DDD\s+1 users fall into three categories, which must all be
supported.  \fINovice users\fR explore \s-1DDD\s+1 and may prefer to
use one single mouse button.  \fIAdvanced users\fR know how to use
shortcuts and prefer popup menus.  \fIExperienced users\fR prefer the
command line interface.)
.PP
Breakpoints are indicated by a plain stop sign, or as
`\fB#\fIn\fB#\fR', where \fIn\fR is the breakpoint number.  A greyed
out stop sign (or `\fB_\fIn\fB_\fR') indicates a disabled breakpoint.
A stop sign with a question mark (or `\fB?\fIn\fB?\fR') indicates a
conditional breakpoint or a breakpoint with an ignore count set.
.PP
If you set a breakpoint by mistake, use `\fBEdit\(->Undo\fR' to delete
it again.
.PP
Note: We have received reports that some Motif versions fail to
display stop signs correctly.  If this happens, try writing in your
`\fB$HOME/.ddd/init\fR' file:
.br
.sp
  \fBDdd*cacheGlyphImages: off\fR
.sp
.br
and restart \s-1DDD\s+1.  See also the `\fBcacheGlyphImages\fR'
resource in the `\fBRESOURCES\fR' section, below.
.\"
.\"
.SS "Setting Breakpoints by Name"
.\"
If the function name is visible, click with \fImouse button 1\fR on the
function name.  The function name is copied to the argument field.
Click on the `\fBBreak at ()\fR' button to set a breakpoint there.
.PP
As a shorter alternative, you can simply press \fImouse button 3\fR on the
function name and select the `\fBbreak\fR' item from the popup menu.
.PP
As yet another alternative, you can click on `\fBNew\fR' from the
Breakpoint editor (invoked through `\fBSource\(->Edit Breakpoints\fR')
and enter the function name.
.\"
.\"
.SS "Setting Regexp Breakpoints"
.\"
Using \s-1GDB\s+1, you can also set a breakpoint on all functions that
match a given string.  `\fBBreak at ()\(->Set Breakpoints at Regexp
()\fR' sets a breakpoint on all functions whose name matches the
\fIregular expression\fR given in `\fB()\fR'.  Here are some examples:
.IP \(bu 2
To set a breakpoint on every function that starts with `\fBXm\fR', set
`\fB()\fR' to `\fB^Xm\fR'.
.IP \(bu 2
To set a breakpoint on every member of class `\fBDate\fR', set
`\fB()\fR' to `\fB^Date::\fR'.
.IP \(bu 2
To set a breakpoint on every function whose name contains
`\fB_fun\fR', set `\fB()\fR' to `\fB_fun\fR'.
.IP \(bu 2
To set a breakpoint on every function that ends in `\fB_test\fR', 
set `\fB()\fR' to `\fB_test$\fR'.
.PP
Once these multiple breakpoints are set, they are treated just like
the breakpoints set with the `\fBBreak at ()\fR' button.  You can
delete them, disable them, or make them conditional the same way as
any other breakpoint.  Use `\fBSource\(->Edit Breakpoints\fR' to view
and edit the list of breakpoints.
.\"
.\"
.SS "Disabling Breakpoints"
.\"
To temporarily disable a breakpoint, press \fImouse button 3\fR on the
breakpoint symbol and select the `\fBDisable Breakpoint\fR' item from
the breakpoint popup menu.  To enable it again, select `\fBEnable
Breakpoint\fR'.
.PP
.PSPIC ./PICS/ddd-bp-popup.ps 15.3cm
.PP
As an alternative, you can select the breakpoint and click on
`\fBDisable\fR' or `\fBEnable\fR' in the Breakpoint editor (invoked
through `\fBSource\(->Edit Breakpoints\fR'.
.PP
Disabled breakpoints are indicated by a grey stop sign, or 
`\fB_\fIn\fB_\fR', where \fIn\fR is the breakpoint number.
.PP
The `\fBDisable Breakpoint\fR' item is also accessible via the
`\fBClear at ()\fR' button.  Just press and hold \fImouse button 1\fR
on the button to get a popup menu.
.PP
Note: \s-1JDB\s+1 does not support breakpoint disabling.
.\"
.\"
.SS "Temporary Breakpoints"
.\"
A \fItemporary breakpoint\fR is immediately deleted as soon as it is
reached.  To set a temporary breakpoint, press \fImouse button 3\fR on the
left of the source line and select the `\fBSet Temporary
Breakpoint\fR' item from the popup menu.
.PP
As a faster alternative, you can simply double-click on the left of
the source line while holding \fBCtrl\fR.
.PP
Temporary breakpoints are convenient to make the program continue up
to a specific location: just set the temporary breakpoint at this
location and continue execution.
.PP
The `\fBContinue Until Here\fR' item from the popup menu sets a
temporary breakpoint on the left of the source line and immediately
continues execution.  Execution stops when the temporary breakpoint is
reached.
.PP
The `\fBSet Temporary Breakpoint\fR' and `\fBContinue Until Here\fR'
items are also accessible via the `\fBBreak at ()\fR' button.  Just
press and hold \fImouse button 1\fR on the button to get a popup menu.
.PP
Note: \s-1JDB\s+1 does not support temporary breakpoints.
.\"
.\"
.SS "Deleting Breakpoints"
.\"
If the breakpoint is visible, click with \fImouse button 1\fR on the
breakpoint.  The breakpoint location is copied to the argument field.
Click on the `\fBClear at ()\fR' button to delete all breakpoints
there.
.PP
If the function name is visible, click with \fImouse button 1\fR on the
function name.  The function name is copied to the argument field.
Click on the `\fBClear at ()\fR' button to set a breakpoint there.
.PP
As a faster alternative, you can simply press \fImouse button 3\fR on the
breakpoint and select the `\fBDelete Breakpoint\fR' item from the
popup menu.
.PP
As yet another alternative, you can select the breakpoint and click on
`\fBDelete\fR' in the Breakpoint editor (invoked through
`\fBSource\(->Edit Breakpoints\fR').
.PP
As an even faster alternative, you can simply double-click on the
breakpoint while holding \fBCtrl\fR.
.\"
.\"
.SS "Editing Breakpoint Properties"
.\"
You can change all properties of a breakpoint by pressing \fImouse
button 3\fR on the breakpoint symbol and select `\fBProperties\fR'
from the breakpoint popup menu.  This will pop up a dialog showing the 
current properties of the selected breakpoint.
.PP
As an even faster alternative, you can simply double-click on the
breakpoint.
.PP
.PSPIC ./PICS/ddd-bp-properties.ps 15.3cm
.PP
.IP \(bu 2
Click on `\fBLookup\fR' to move the cursor to the breakpoint's
location.
.IP \(bu 2
Click on `\fBEnable\fR' to enable the breakpoint.
.IP \(bu 2
Click on `\fBDisable\fR' to disable the breakpoint.
.IP \(bu 2
Click on `\fBTemp\fR' to make the breakpoint temporary.  Note:
\s-1GDB\s+1 has no way to make a temporary breakpoint non-temporary
again.
.IP \(bu 2
Click on `\fBDelete\fR' to delete the breakpoint.
.PP
.\"
.\"
.SS "Breakpoint Conditions"
.\"
In the field `\fBCondition\fR' of the `\fBBreakpoint Properties\fR'
panel, you can specify a \fIbreakpoint condition\fR.  If a breakpoint
condition is set, the breakpoint stops the program only if the
associated condition is met\(em\&that is, if the condition expression
evaluates to a non-zero value.
.PP
Note: \s-1JDB\s+1 does not support breakpoint conditions.
.\"
.\"
.SS "Breakpoint Ignore Counts"
.\"
In the field `\fBIgnore Count\fR' of the `\fBBreakpoint Properties\fR'
panel, you can specify a \fIbreakpoint ignore count\fR.  If the ignore
count is set to some value \fIN\fR, the next \fIN\fR crossings of the
breakpoint will be ignored: Each crossing of the breakpoint decrements
the ignore count; the program stops only if the ignore count is zero.
.PP
Note: \s-1JDB\s+1, Perl and some \s-1DBX\s+1 variants do not support
breakpoint ignore counts.
.\"
.SS "Breakpoint Commands"
.\"
Note: Breakpoint commands are currently available on \s-1GDB\s+1 only.
.PP
Using the `\fBCommands\fR' buttons of the `\fBBreakpoint
Properties\fR' panel, you can record and edit commands to be executed
when the breakpoint is hit.
.PP
To record a command sequence, follow these steps:
.IP \(bu 2
Click on `\fBRecord\fR' to begin the recording of the breakpoint commands.
.IP \(bu 2
Now interact with \s-1DDD\s+1.  While recording, \s-1DDD\s+1 does not
execute commands, but simply records them to be executed when the
breakpoint is hit.  The recorded debugger commands are shown in the
debugger console.
.IP \(bu 2
To stop the recording, click on `\fBEnd\fR' or enter `\fBend\fR' at
the \s-1GDB\s+1 prompt.  To \fIcancel\fR the recording, click on
`\fBInterrupt\fR' or press \s-1\fBESC\fR\s+1.
.IP \(bu 2
Click on `\fBEdit \s-2>>\s+2\fR' to edit the recorded commands.
When done with editing, click on `\fBEdit \s-2<<\s+2\fR' to close the
commands editor.
.PP
.\"
.\"
.SS "Moving and Copying Breakpoints"
.\"
To move a breakpoint to a different location, press \fImouse button 1\fR on
the stop sign and drag it to the desired location.  This is equivalent
to deleting the breakpoint at the old location and setting a
breakpoint at the new location.  The new breakpoint inherits all
properties of the old breakpoint, except the breakpoint number.
.PP
To copy a breakpoint to a new location, press the \fBShift\fR key
while dragging.
.PP
Note: Dragging breakpoints is not possible when glyphs are disabled.
Delete and set breakpoints instead.
.\"
.\"
.SS "Looking up Breakpoints"
.\"
If you wish to lookup a specific breakpoint, select `\fBSource\(->Edit
Breakpoints\(->Lookup\fR'.  After selecting a breakpoint from the list
and clicking the `\fBLookup\fR' button, the breakpoint location is
displayed.
.PP
As an alternative, you can enter `\fB#\fIn\fR' in the argument field,
where \fIn\fR is the breakpoint number and click on the `\fBLookup ()\fR'
button to find its definition.
.\"
.\"
.SS "Editing all Breakpoints"
.\"
To view and edit all breakpoints at once, select `\fBSource\(->Edit
Breakpoints\fR'.  This will popup the \fIBreakpoint Editor\fR which
displays the state of all breakpoints.
.PP
.PSPIC ./PICS/ddd-edit-breakpoints.ps 15.3cm
.PP
In the breakpoint editor, you can select individual breakpoints by
clicking on them.  Pressing \fBCtrl\fR while clicking toggles the
selection.  To edit the properties of all selected breakpoints, click
on `\fBProps\fR'.
.\"
.\"
.SS "More Breakpoint Features"
.\"
Using \s-1GDB\s+1, a few more commands related to breakpoints can be
invoked through the debugger console:
.TP 10
.B "hbreak \fIposition\fR"
Sets a hardware-assisted breakpoint at \fIposition\fR.  This command
requires hardware support and some target hardware may not have this
support.  The main purpose of this is EPROM/ROM code debugging, so you
can set a breakpoint at an instruction without changing the
instruction.
.TP 10
.B "thbreak \fIpos\fR"
Set a temporary hardware-assisted breakpoint at \fIpos\fR.
.PP
See the \s-1GDB\s+1 documentation for details on these commands.
.\"
.\"
.\" ---------------
.SH "WATCHPOINTS"
.\" ---------------
.\"
You can make the program stop as soon as some variable value changes,
or when some variable is read or written.  This is called `setting a
\fIwatchpoint\fR on a variable'.
.PP
Watchpoints have much in common with breakpoints: in particular, you
can enable and disable them.  You can also set conditions, ignore
counts, and commands to be executed when a watched variable changes
its value.
.PP
Please note: on architectures without special watchpoint support,
watchpoints currently make the program execute two orders of magnitude
more slowly.  This is so because the inferior debugger must interrupt
the program after each machine instruction in order to examine whether
the watched value has changed.  However, this delay can be well worth
it to catch errors when you have no clue what part of your program is
the culprit.
.PP
Note: Watchpoints are available in \s-1GDB\s+1 and some \s-1DBX\s+1
variants only.  In \s-1XDB\s+1, a similar feature is available via
\s-1XDB\s+1 \fIassertions\fR; see the \s-1XDB\s+1 documentation for
details.
.\"
.\"
.SS "Setting Watchpoints"
.\"
If the variable name is visible, click with \fImouse button 1\fR on
the variable name.  The variable name is copied to the argument field.
Otherwise, enter the variable name in the argument field.  Click on
the `\fBWatch ()\fR' button to set a watchpoint there.
.PP
Using \s-1GDB\s+1, you can set different types of watchpoints.  Click
and hold \fImouse button 1\fR on the `\fBWatch ()\fR' button to get a
menu.
.\"
.\"
.SS "Editing Watchpoint Properties"
.\"
To change the properties of a watchpoint, enter the name of the
watched variable in the argument field.  Click and hold \fImouse
button 1\fR on the `\fBWatch ()\fR' button and select `\fBWatchpoint
Properties\fR'.
.PP
The \fBWatchpoint Properties\fR panel has the same functionality as
the \fBBreakpoint Properties\fR panel; see `\fBEditing Breakpoint
Properties\fR', above, for details.  As an additional feature, you can 
click on `\fBPrint ()\fR' to see the current value of a watched
variable.
.\"
.\"
.SS "Editing all Watchpoints"
.\"
To view and edit all watchpoints at once, select `\fBData\(->Edit
Watchpoints\fR'.  This will popup the \fIWatchpoint Editor\fR which
displays the state of all watchpoints.
.PP
The \fIWatchpoint Editor\fR has the same functionality as the
\fIBreakpoint Editor\fR; see `\fBEditing All Breakpoints\fR', above,
for details.  As an additional feature, you can click on `\fBPrint
()\fR' to see the current value of a watched variable.
.\"
.\"
.SS "Deleting Watchpoints"
.\"
To delete a watchpoint, enter the name of the watched variable in the
argument field and click the `\fBUnwatch ()\fR' button.
.\"
.\"
.\" ---------------
.SH "RUNNING THE PROGRAM"
.\" ---------------
.\"
.SS "Starting Program Execution"
.\"
To start execution of the debugged program, select
`\fBProgram\(->Run\fR'.  You will then be prompted for the arguments
to pass to your program.  You can either select from a list of
previously used arguments or enter own arguments in the text field.
Afterwards, press the `\fBRun\fR' button to start execution with the
selected arguments.
.PP
To run your program again, with the same arguments, select
`\fBProgram\(->Run Again\fR' or press the `\fBRun\fR' button on the
command tool.  You may also enter `\fBrun\fR', followed by arguments
at the debugger prompt instead.
.PP
.PSPIC ./PICS/ddd-arguments.ps 15.3cm
.\"
.\"
.SS "Using the Execution Window"
.PP
By default, input and output of your program go to the debugger
console.  As an alternative, \s-1DDD\s+1 can also invoke an
\fIexecution window\fR, where the program terminal input and output is
shown.  To activate the execution window, select `\fBProgram\(->Run in
Execution Window\fR'.
.PP
While the execution window is active, \s-1DDD\s+1 invokes your
program such that its standard input, output, and error streams are
redirected to the execution window.  Note that the device
`\fB/dev/tty\fR' still refers to the debugger console, \fInot\fR the
execution window.
.PP
You can override the \s-1DDD\s+1 stream redirection by giving
alternate redirection operations as arguments.  For instance, to have
your program read from a file, but to write to the execution window,
invoke your program with `\fB< \fIfile\fR' as argument.  Likewise, to
redirect the standard error output to the debugger console, use `\fB2>
/dev/tty\fR' (assuming the inferior debugger and/or your \s-1UNIX\s+1
shell support standard error redirection).
.PP
The execution window is not available in \s-1JDB\s+1 and \s-1Perl\s+1.
.\"
.\"
.SS "Attaching to a Running Process"
.\"
If the debugged program is already running in some process, you can
\fIattach\fR to this process (instead of starting a new one with
`\fBRun\fR').  Select `\fBFile\(->Attach to Process\fR' to choose from
a list of processes.  Afterwards, press the `\fBAttach\fR' button to
attach to the specified process.
.PP
The first thing \s-1DDD\s+1 does after arranging to debug the
specified process is to stop it. You can examine and modify an
attached process with all the \s-1DDD\s+1 commands that are
ordinarily available when you start processes with `\fBRun\fR'. You
can insert breakpoints; you can step and continue; you can modify
storage. If you would rather the process continue running, you may use
`\fBContinue\fR' after attaching \s-1DDD\s+1 to the process.
.PP
When using `\fBAttach to Process\fR', you should first use `\fBOpen
Program\fR' to specify the program running in the process and load its
symbol table.
.PP
When you have finished debugging the attached process, you can use the
`\fBFile\(->Detach Process\fR' to release it from \s-1DDD\s+1
control.  Detaching the process continues its execution.  After
`\fBDetach Process\fR', that process and \s-1DDD\s+1 become
completely independent once more, and you are ready to attach another
process or start one with `\fBRun\fR'.
.PP
.PSPIC ./PICS/ddd-attach.ps 15.3cm
.PP
You can customize the list of processes shown by defining an alternate
command to list processes.  See
`\fBEdit\(->Preferences\(->Helpers\(->List Processes\fR'.
.PP
Note: \s-1JDB\s+1, \s-1PYDB\s+1, and Perl do not support attaching the 
debugger to running processes.
.\"
.\"
.SS "Stopping the Program"
.\"
The program stops as soon as a breakpoint is reached.  The current
execution position is highlighted by an arrow.
.PP
You can interrupt a running program any time by clicking the
`\fBInterrupt\fR' button or typing \s-1\fBESC\fR\s+1 in a \s-1DDD\s+1
window.
.\"
.\"
.SS "Resuming Execution"
.\"
To resume execution, at the address where your program last stopped,
click on the `\fBContinue\fR` button.  Any breakpoints set at that
address are bypassed.
.PP
To execute just one source line, click on the `\fBStep\fR' button.
The program is executed until control reaches a different source line,
which may be in a different function.
.PP
To continue to the next line in the current function, click on the
`\fBNext\fR' button.  This is similar to `\fBStep\fR', but any
function calls appearing within the line of code are executed without
stopping.
.PP
To continue until a greater line in the current function is reached,
click on the `\fBUntil\fR' button.  This is useful to avoid
single stepping through a loop more than once.
.PP
To continue running until the current function returns, use the
`\fBFinish\fR' button.  The returned value (if any) is printed.
.PP
To continue running until a line after the current source line is
reached, use the `\fBContinue Until Here\fR' facility from the line
popup menu.  See the `\fBTemporary Breakpoints\fR' section, above, for
a discussion.
.\"
.\"
.\"
.SS "Altering the Execution Position"
.\"
To resume execution at a different location, press \fImouse button 1\fR on
the arrow and drag it to a different location.  The most common
occasion to use this feature is to back up\(em\&perhaps with more
breakpoints set-over a portion of a program that has already executed,
in order to examine its execution in more detail.
.PP
Moving the execution position does not change the current stack frame,
or the stack pointer, or the contents of any memory location or any
register other than the program counter.
.PP
Some inferior debuggers (notably \s-1GDB\s+1) allow you to set the new
execution position into a different function from the one currently
executing.  This may lead to bizarre results if the two functions
expect different patterns of arguments or of local variables.  For
this reason, moving the execution position requests confirmation if
the specified line is not in the function currently executing.
.PP
After moving the execution position, click on the `\fBContinue\fR'
button to resume execution.
.PP
.PSPIC ./PICS/ddd-drag.ps 15.3cm
.PP
Note: Dragging the execution position is not possible when glyphs are
disabled.  Use `\fBSet Execution Position\fR' from the breakpoint
popup menu instead to set the execution position to the current
location.  This item is also accessible by pressing and holding the
`\fBBreak at ()\fR/\fBClear at ()\fR' button.
.PP
Note: \s-1JDB\s+1 does not support altering the execution position.
.\"
.\"
.SS "Examining the Stack"
.\"
When your program has stopped, the first thing you need to know is
where it stopped and how it got there.
.PP
\s-1DDD\s+1 provides a \fIbacktrace window\fR showing a summary of 
how your program got where it is.  To enable the backtrace window,
select `\fBStatus\(->Backtrace\fR'.
.PP
.PSPIC ./PICS/ddd-backtrace.ps 15.3cm
.PP
The `\fBUp\fR' button selects the function that called the current
one.
.PP
The `\fBDown\fR' button selects the function that was called by
the current one.
.PP
You can also directly type the `\fBup\fR' and `\fBdown\fR' commands at
the debugger prompt.  Typing \fBCtrl+Up\fR and \fBCtrl+Down\fR,
respectively, will also move you through the stack.
.PP
`\fBUp\fR' and `\fBDown\fR' actions can be undone via
`\fBEdit\(->Undo\fR'.
.\"
.\"
.\"
.SS "\*(lqUndoing\*(rq Program Execution"
.\"
If you take a look at the `\fBEdit\(->Undo\fR' menu item after an
execution command, you'll find that \s-1DDD\s+1 offers you to undo
execution commands just as other commands.  Does this mean that
\s-1DDD\s+1 allows you to go backwards in time, undoing program
execution as well as undoing any side-effects of your program?
.PP
Sorry\(em\&we must disappoint you.  \s-1DDD\s+1 cannot undo what your
program did.  (After a little bit of thought, you'll find that this
would be impossible in general.) However, DDD can do something
different: it can show \fIpreviously recorded states\fR of your
program.
.PP
After \*(lqundoing\*(rq an execution command (via
`\fBEdit\(->Undo\fR', or the `\fBUndo\fR' button), the execution
position moves back to the earlier position and displayed variables
take their earlier values.  Your program state is in fact unchanged,
but DDD gives you a \fIview\fR on the earlier state as recorded by
DDD.
.PP
In this so-called \fIhistoric mode\fR, most normal \s-1DDD\s+1
commands that would query further information from the program are
disabled, since the debugger cannot be queried for the earlier state.
However, you can examine the current execution position, or the
displayed variables.  Using `\fBUndo\fR' and `\fBRedo\fR', you can
move back and forward in time to examine how your program got into the
present state.
.PP
To let you know that you are operating in historic mode, the execution
arrow gets a dashed-line appearance (indicating a past position);
variable displays also come with dashed lines.  Furthermore, the
status line informs you that you are seeing an earlier program state.
.PP
Here's how historic mode works: each time your program stops,
\s-1DDD\s+1 collects the current execution position and the values of
displayed variables.  Backtrace, thread, and register information is
also collected if the corresponding dialogs are open.  When
\*(lqundoing\*(rq an execution command, \s-1DDD\s+1 updates its view
from this collected state instead of querying the program.
.PP
If you want to collect this information without interrupting your
program\(em\&within a loop, for instance\(em\&you can place a
breakpoint with an associated `\fBcont\fR' command; see `\fBBreakpoint
Commands\fR', above, for details.  When the breakpoint is hit,
\s-1DDD\s+1 will stop, collect the data, and execute the `\fBcont\fR'
command, resuming execution.  Using a later `\fBUndo\fR', you can step
back and look at every single loop iteration.
.PP
To leave historic mode, you can use `\fBRedo\fR' until you are back in
the current program state.  However, any \s-1DDD\s+1 command that
refers to program state will also leave historic mode immediately by
applying to the current program state instead.  For instance,
`\fBUp\fR' leaves historic mode immediately and selects an alternate
frame in the restored current program state.
.PP
If you want to see the history of a specific variable, as recorded
during program stops, you can enter the \s-1DDD\s+1 command
.sp
.br
  \fBgraph history \fIname\fR
.sp
.br
This returns a list of all previously recorded values of the variable
\fIname\fR, using array syntax.  Note that \fIname\fR must have been
displayed at earlier program stops in order to record values.
.\"
.\"
.\"
.SS "Examining Threads"
.\"
Note: Thread support is available with \s-1GDB\s+1 and \s-1JDB\s+1 only.
.PP
In some operating systems, a single program may have more than one
\fIthread\fR of execution.  The precise semantics of threads differ
from one operating system to another, but in general the threads of a
single program are akin to multiple processes\(em\&except that they
share one address space (that is, they can all examine and modify the
same variables).  On the other hand, each thread has its own registers
and execution stack, and perhaps private memory.
.PP
For debugging purposes, \s-1DDD\s+1 lets you display the list of
threads currently active in your program and lets you select the
\fIcurrent thread\fR\(em\&the thread which is the focus of debugging.
\s-1DDD\s+1 shows all program information from the perspective of
the current thread.
.PP
.PSPIC ./PICS/ddd-threads.ps 15.3cm
.PP
To view all currently active threads in your program, select
`\fBStatus\(->Threads\fR'.  The current thread is highlighted.  Select
any thread to make it the current thread.
.PP
Using \s-1JDB\s+1, additional functionality is available:
.IP \(bu 2
Select a \fIthread group\fR to switch between viewing all threads and
the threads of the selected thread group;
.IP \(bu 2
Click on `\fBSuspend\fR' to suspend execution of the selected threads;
.IP \(bu 2
Click on `\fBResume\fR' to resume execution of the selected threads.
.PP
For more information on threads, see the \s-1JDB\s+1 and \s-1GDB\s+1
documentation.
.\"
.\"
.SS "Handling Signals"
.\"
Note: Signal support is available with \s-1GDB\s+1 only.
.PP
A signal is an asynchronous event that can happen in a program.  The
operating system defines the possible kinds of signals, and gives each
kind a name and a number.  For example, in Unix \fBSIGINT\fR is the
signal a program gets when you type an interrupt; \fBSIGSEGV\fR is the
signal a program gets from referencing a place in memory far away from
all the areas in use; \fBSIGALRM\fR occurs when the alarm clock timer
goes off (which happens only if your program has requested an alarm).
.PP
Some signals, including \fBSIGALRM\fR, are a normal part of the
functioning of your program.  Others, such as \fBSIGSEGV\fR, indicate
errors; these signals are \fIfatal\fR (kill your program immediately)
if the program has not specified in advance some other way to handle
the signal.  \fBSIGINT\fR does not indicate an error in your program,
but it is normally fatal so it can carry out the purpose of the
interrupt: to kill the program.
.PP
\s-1GDB\s+1 has the ability to detect any occurrence of a signal in
your program.  You can tell \s-1GDB\s+1 in advance what to do for each
kind of signal.
.PP
Normally, \s-1DDD\s+1 is set up to ignore non-erroneous signals like
\fBSIGALRM\fR (so as not to interfere with their role in the
functioning of your program) but to stop your program immediately
whenever an error signal happens.  In \s-1DDD\s+1, you can change
these settings via `\fBStatus\(->Signals\fR'.
.PP
`\fBStatus\(->Signals\fR' pops up a panel showing all the kinds of
signals and how \s-1GDB\s+1 has been told to handle each one.  The
settings available for each signal are:
.TP 10
.B "Stop"
If set, \s-1GDB\s+1 should stop your program when this signal happens.
This also implies `\fBPrint\fR' being set.
.br
If unset, \s-1GDB\s+1 should not stop your program when this signal
happens.  It may still print a message telling you that the signal has
come in.
.TP 10
.B "Print"
If set, \s-1GDB\s+1 should print a message when this signal happens.
.br
If unset, \s-1GDB\s+1 should not mention the occurrence of the signal
at all.  This also implies `\fBStop\fR' being unset.
.TP 10
.B "Pass"
If set, \s-1GDB\s+1 should allow your program to see this signal; your
program can handle the signal, or else it may terminate if the signal
is fatal and not handled.
.br
If unset, \s-1GDB\s+1 should not allow your program to see this
signal.
.PP
.PSPIC ./PICS/ddd-signals.ps 15.3cm
.PP
The entry `\fBAll Signals\fR' is special.  Changing a setting here
affects \fIall signals at once\fR\(em\&except those used by the
debugger, typically SIGTRAP and SIGINT.
.PP
To undo any changes, use `\fBEdit\(->Undo\fR'.  The `\fBReset\fR'
button restores the saved settings.
.PP
When a signal stops your program, the signal is not visible until you
continue.  Your program sees the signal then, if `\fBPass\fR' is in
effect for the signal in question \fIat that time\fR.  In other words,
after \s-1GDB\s+1 reports a signal, you can change the `\fBPass\fR'
setting in `\fBStatus\(->Signals\fR' to control whether your program
sees that signal when you continue.
.PP
You can also cause your program to see a signal it normally would not
see, or to give it any signal at any time.  The `\fBSend\fR' button
will resume execution where your program stopped, but immediately give
it the signal shown.
.PP
On the other hand, you can also prevent your program from seeing a
signal.  For example, if your program stopped due to some sort of
memory reference error, you might store correct values into the
erroneous variables and continue, hoping to see more execution; but
your program would probably terminate immediately as a result of the
fatal signal once it saw the signal.  To prevent this, you can
resume execution using `\fBCommands\(->Continue Without Signal\fR'.
.PP
`\fBEdit\(->Save Options\fR' does not save changed signal settings,
since changed signal settings are normally useful within specific
projects only.  Instead, signal settings are saved with the current
session, using `\fBFile\(->Save Session As\fR'.
.\"
.\"
.\" ---------------
.SH "EXAMINING DATA"
.\" ---------------
.TP
\s-1DDD\s+1 provides several means to examine data.
.TP 10
.B "Value Hints"
The quickest way to examine variables is to move the pointer on an
occurrence in the source text.  The value is displayed in the source
line; after a second, a popup window shows the variable value.  This
is useful for quick examination of several simple variables.
.TP 10
.B "Printing Values"
If you want to reuse variable values at a later time, you can print
the value in the debugger console.  This allows for displaying and
examining larger data structures.
.TP 10
.B "Displaying Values"
If you want to examine complex data structures, you can display them
graphically in the data display.  Displays remain effective until you
delete them; they are updated each time the program stops.  This is
useful for large dynamic structures.
.TP 10
.B "Plotting Values"
If you want to examine arrays of numeric values, you can plot them
graphically in a separate plot window.  The plot is updated each time
the program stops.  This is useful for large numeric arrays.
.TP 10
.B "Memory Dumps"
This feature, available using \s-1GDB\s+1 only, allows you to dump
memory contents in any of several formats, independently of your
program's data types.  This is described under `\fBMACHINE-LEVEL
DEBUGGING\fR', below.
.PP
.\"
.\"
.SS "Showing Simple Values using Value Hints"
.\"
To display the value of a simple variable, move the mouse pointer on
its name.  After a second, a small window (called \fIvalue tip\fR)
pops up showing the value of the variable pointed at.  The window
disappears as soon as you move the mouse pointer away from the
variable.  The value is also shown in the status line.
.PP
.PSPIC ./PICS/ddd-value-tip.ps 15.3cm
.\"
.\"
.SS "Printing Simple Values in the Debugger Console"
.\"
The variable value can also be printed in the debugger console, making
it available for further operations.  To print a variable value,
select the desired variable by clicking \fImouse button 1\fR on its
name.  The variable name is copied to the argument field.  By clicking
the `\fBPrint ()\fR' button, the value is printed in the debugger
console.  Note that the value is also shown in the status line.
.PP
As a shorter alternative, you can simply press \fImouse button 3\fR on
the variable name and select the `\fBPrint\fR' item from the popup
menu.
.PP
.PSPIC ./PICS/ddd-print-popup.ps 15.3cm
.\"
.\"
.SS "Displaying Complex Values in the Data Window"
.\"
To explore complex data structures, you can use the \fIgraphical data
display\fR in the \fIdata window\fR.  The data window holds
\fIdisplays\fR showing names and the values of variables.  The display
is updated each time the program stops.
.PP
To create a new display, select the desired variable by clicking
\fImouse button 1\fR on its name.  The variable name is copied to the
argument field.  By clicking the `\fBDisplay ()\fR' button, a new
display is created in the data window.  The data window opens
automatically as soon as you create a display.
.PP
.PSPIC ./PICS/ddd-display.ps 15.3cm
.PP
As a shorter alternative, you can simply press \fImouse button 3\fR on the
variable name and select the `\fBDisplay\fR' item from the popup menu.
.PP
As an even faster alternative, you can also double-click on the
variable name.
.PP
As another alternative, you may also enter the expression to be
displayed in the argument field and press the `\fBDisplay ()\fR'
button.
.PP
Finally, you may also enter
.sp
.br
  \fBgraph display \fIexpr\fR [\|\fBclustered\fR\|] 
[\|\fBat (\fIx, y\fB)\fR\|] [\|\fBdependent on \fIdisplay\fR\|] 
[\|[\|\fBnow or\fR\|]\|\fBwhen in \fIscope\fR\|]
.sp
.br
\&at the debugger prompt.  The options have the following meaning:
.br
.IP \(bu 2
If the suffix `\fBclustered\fR' is specified, the new data display is
created in a cluster.  See `\fBClustering Displays\fR', below, for a
discussion.
.br
.IP \(bu 2
If the suffix `\fBat \fB(\fIx, y\fB)\fR' is specified, the new data
display is created at the position (\fIx\fR, \fIy\fR).  Otherwise, a
default position is assigned.
.br
.IP \(bu 2
If the suffix `\fBdependent on \fIdisplay\fR' is given, an edge from
the display numbered or named \fIdisplay\fR to the new display is
created.  Otherwise, no edge is created.
.br
.IP \(bu 2
If the suffix `\fBwhen in \fIscope\fR' is given, display creation is
\fIdeferred\fR until execution reaches the given \fIscope\fR (a
function name, as in the backtrace output).
.br
.IP \(bu 2
If the suffix `\fBnow or when in \fIscope\fR' is given, \s-1DDD\s+1
attempts to create the display immediately.  If display creation fails,
it is \fIdeferred\fR until execution reaches the given \fIscope\fR (a
function name, as in the backtrace output).
.br
.IP \(bu 2
If no `\fBwhen in\fR' suffix or `\fBnow or when in\fR' suffix is
given, the display is created immediately.
.br
.PP
If you created a display by mistake, use `\fBEdit\(->Undo\fR' to
undisplay it.
.\"
.\"
.SS "Selecting Displays"
.\"
Each display in the data window has a \fItitle bar\fR containing the
\fIdisplay number\fR and the displayed expression (the \fIdisplay
name\fR).  Below the title, the \fIdisplay value\fR is shown.
.PP
You can select individual displays by clicking on them with
\fImouse button 1\fR.  The resulting expression is shown in the \fIargument
field\fR, below.
.PP
You can \fIextend\fR an existing selection by pressing the \fBShift\fR
key while selecting.  You can also \fItoggle\fR an existing selection
by pressing the \fBShift\fR key while selecting already selected
displays.
.PP
Single displays may also be selected by using the arrow keys.
.\"
.\"
.SS "Selecting Multiple Displays"
.\"
Multiple displays are selected by pressing and holding \fImouse button 1\fR
somewhere on the window background.  By moving the pointer while
holding the button, a selection rectangle is shown; all displays
fitting in the rectangle are selected when mouse button 1 is released.
.PP
If the \fBShift\fR key is pressed while selecting, the existing
selection is \fIextended\fR.
.PP
By double-clicking on a display title, the display itself and all
connected displays are automatically selected.
.PP
.PSPIC ./PICS/ddd-select-display.ps 15.3cm
.\"
.\"
.SS "Showing and Hiding Values"
.\"
Aggregate values (i.e. records, structs, classes, and arrays) can be
shown \fIexpanded\fR, that is, displaying all details, or
\fIhidden\fR, that is, displayed as `\fB{...}\fR'.
.PP
To show details about an aggregate, select the aggregate by clicking
\fImouse button 1\fR on its name or value and click on the `\fBShow ()\fR'
button.  Details are shown for the aggregate itself as well as for all
contained sub-aggregates.
.PP
To hide details about an aggregate, select the aggregate by clicking
\fImouse button 1\fR on its name or value and click on the `\fBHide ()\fR'
button.
.PP
.PSPIC ./PICS/ddd-hide-display.ps 15.3cm
.PP
When pressing and holding \fImouse button 1\fR on the `\fBShow
()\fR/\fBHide ()\fR' button, a menu pops up with even more
alternatives:
.TP
.B "Show More ()"
Shows details of all aggregates currently hidden, but not of their
sub-aggregates.  You can invoke this item several times in a row to
reveal more and more details of the selected aggregate.
.TP
.B "Show Just ()"
Shows details of the selected aggregate, but hides all sub-aggregates.
.TP
.B "Show All ()"
Shows all details of the selected aggregate and of its sub-aggregates.
This item is equivalent to the `\fBShow ()\fR' button.
.TP
.B "Hide ()"
Hide all details of the selected aggregate.  This item is equivalent
to the `\fBHide ()\fR' button.
.PP
As a faster alternative, you can also press \fImouse button 3\fR on the
aggregate and select the appropriate menu item.
.PP
As an even faster alternative, you can also double-click \fImouse
button 1\fR on a value.  If some part of the value is hidden, more
details will be shown; if the entire value is shown, double-clicking
will \fIhide\fR the value instead.  This way, you can double-click on
a value until you get the right amount of details.
.PP
If \fIall\fR details of a display are hidden, the display is called
\fIdisabled\fR; this is indicated by the string `\fI(Disabled)\fR'.
Displays can also be disabled or enabled via the \s-1DDD\s+1
commands
.sp
.br
  \fBgraph disable display \fIdisplays...\fR
.sp
.br
and
.sp
.br
  \fBgraph enable display \fIdisplays...\fR
.sp
.br
at the debugger prompt.  \fIdisplays...\fR is either
.br
.IP \(bu 2
a space-separated list of display numbers to disable or enable, or
.br
.IP \(bu 2
a single display name.  If you specify a display by name, all displays 
with this name will be affected.
.br
.PP
Use `\fBEdit\(->Undo\fR' to undo disabling or enabling displays.
.\"
.\"
.SS "Rotating Arrays"
.\"
Arrays can be aligned horizontally or vertically.  To change the
alignment of an array, select it and then click on the `\fBRotate
()\fR' button.
.PP
As a faster alternative, you can also press \fImouse button 3\fR on the array
and select the `\fBRotate\fR' menu item.
.PP
.PSPIC ./PICS/ddd-rotate-display.ps 15.3cm
.PP
.\"
.\"
.SS "Displaying Dependent Values"
.\"
Dependent displays are created from an existing display.  The
dependency is indicated by arrows leading from the originating display
to the dependent display.
.PP
To create a dependent display, select the originating display or
display part and enter the dependent expression in the `\fB():\fR'
argument field.  Then click on the `\fBDisplay\fR' button.
.PP
Using dependent displays, you can investigate the data structure of a
\*(lqtree\*(rq for example and lay it out according to your intuitive
image of the \*(lqtree\*(rq data structure.
.PP
By default, \s-1DDD\s+1 does not recognize shared data structures
(i.e. a data object referenced by multiple other data objects).  See
`\fBExamining Shared Data Structures\fR', below, for details on how to
examine such structures.
.\"
.\"
.SS "Display Shortcuts"
.\"
\s-1DDD\s+1 maintains a \fIshortcut menu\fR of frequently used
display expressions.  This menu is activated
.br
.IP \(bu 2
by pressing and holding the `\fBDisplay\fR' button, or
.br
.IP \(bu 2
by pressing \fImouse button 3\fR on some display and selecting `\fBNew
Display\fR', or
.br
.IP \(bu 2
by pressing \fBShift\fR and \fImouse button 3\fR on some display.
.br
.PP
By default, the shortcut menu contains frequently used base
conversions.
.PP
The `\fBOther\fR' entry in the shortcut menu lets you create a new
display that \fIextends\fR the shortcut menu.  As an example, assume
you have selected a display named `\fBdate_ptr\fR'.  Selecting
`\fBDisplay\(->Other\fR' pops up a dialog that allows you to enter a
new expression to be displayed -- for instance, you can cast the
display `\fBdate_ptr\fR' to a new display `\fB(char *)date_ptr\fR'.
If the `\fBInclude in `\fBNew Display\fR' Menu\fR' toggle was
activated, the shortcut menu will then contain a new entry `\fBDisplay
(char *)()\fR' that will cast \fIany\fR selected display \fIdisplay\fR
to `\fB(char *)\fIdisplay\fR'.  Such shortcuts can save you a lot of
time when examining complex data structures.
.PP
.PSPIC ./PICS/ddd-shortcuts.ps 15.3cm
.PP
You can edit the contents of the `\fBNew Display\fR' menu by selecting its
`\fBEdit Menu\fR' item.  This pops up the \fIShortcut Editor\fR
containing all shortcut expressions, which you can edit at leisure.
Each line contains the expression for exactly one menu item.  Clicking
on `\fBApply\fR' re-creates the `\fBNew Display\fR' menu from the text.  If
the text is empty, the `\fBNew Display\fR' menu will be empty, too.
.PP
.PSPIC ./PICS/ddd-shortcut-editor.ps 15.3cm
.PP
\s-1DDD\s+1 also allows you to specify individual labels for
user-defined buttons.  You can write such a label after the
expression, separated by `\fB//\fR'.  This feature is used in the
default contents of the \s-1GDB\s+1 `\fBNew Display\fR' menu, where
each of the base conversions has a label:
.br
.sp
    \fB/t ()	// Convert to Bin
    /d ()	// Convert to Dec
    /x ()	// Convert to Hex
    /o ()	// Convert to Oct\fR
.sp
.br
Feel free to add other conversions here.  \s-1DDD\s+1 supports up to 
20 `\fBNew Display\fR' menu items.
.\"
.\"
.SS "Dereferencing Pointers"
.\"
There are special shortcuts for creating dependent displays showing
the value of a dereferenced pointer.  This allows for rapid
examination of pointer-based data structures.
.PP
To dereference a pointer, select the originating pointer value or name
and click on the `\fBDisplay *()\fR' button.  A new display showing
the dereferenced pointer value is created.
.PP
As a faster alternative, you can also press \fImouse button 3\fR on
the originating pointer value or name and select the `\fBDisplay *\fR'
menu item.
.PP
As an even faster alternative, you can also double-click \fImouse
button 1\fR on the originating pointer value or name.  If you press
\fBCtrl\fR while double-clicking, the display will be dereferenced
\fIin place\fR--that is, it will be replaced by the dereferenced
display.
.PP
The `\fBDisplay *()\fR' function is also accessible by pressing and
holding the `\fBDisplay ()\fR' button.
.\"
.\"
.SS "Displaying Local Variables"
.\"
You can display all local variables at once by choosing
`\fBData\(->Display Local Variables\fR'.  When using \s-1DBX\s+1,
\s-1XDB\s+1, \s-1JDB\s+1, or Perl, this displays all local variables,
including the arguments of the current function.  When using
\s-1GDB\s+1 or \s-1PYDB\s+1, function arguments are contained in a
separate display, activated by `\fBDisplay Arguments\fR'.
.PP
The display showing the local variables can be manipulated just like
any other data display.  Individual variables can be selected and
dereferenced.
.PP
.PSPIC ./PICS/ddd-locals.ps 15.3cm
.PP
.\"
.\"
.SS "Displaying Program Status"
.\"
You can create a display from the output of an arbitrary debugger
command.  By entering
.sp
.br
  \fBgraph display `\fIcommand\fB`\fR
.sp
.br
the output of \fIcommand\fR is turned into a \fIstatus display\fR
updated each time the program stops.  For instance,
.sp
.br
  \fBgraph display `where`\fR
.sp
.br
creates a status display named `\fBWhere\fR' that shows the current
backtrace.
.PP
If you are using \s-1GDB\s+1, \s-1DDD\s+1 provides a panel from
which you can choose useful status displays.  Select
`\fBData\(->More Status Displays\fR' and pick your choice from the list.
.PP
.PSPIC ./PICS/ddd-status-displays.ps 15.3cm
.PP
Status displays consume time; you should delete them as soon as you
don't need them any more.
.\"
.\"
.SS "Displaying Multiple Array Values"
.\"
When debugging C or C++ programs, one often has to deal with pointers
to arrays of dynamically determined size.  Both \s-1DDD\s+1 and
\s-1GDB\s+1 provide special support for such dynamic arrays.
.PP
To display several successive objects of the same type (a section of
an array, or an array of dynamically determined size), use the
notation \fB[\fIFROM\fB..\fITO\fB]\fR in display expressions.
\fIFROM\fR and \fITO\fR denote the first and last array position to
display.  Thus,
.sp
.br
  \fBgraph display argv[0..9]\fR
.sp
.br
creates ten new display nodes for `\fBargv[0]\fR',
`\fBargv[1]\fR', ..., `\fBargv[9]\fR'.
.PP
Using \s-1GDB\s+1 as inferior debugger, you can use \fIartificial arrays\fR.
Typing
.sp
.br
  \fBgraph display argv[0] @ 10\fR
.sp
.br
creates a single array display node containing `\fBargv[0]\fR' up to
`\fBargv[9]\fR'.  Generally, by using the `\fB@\fR' operator, you
can specify the number of array elements to be displayed.
.PP
For more details on artificial arrays, see the \s-1GDB\s+1 documentation.
.\"
.\"
.SS "Repeated Array Values"
.\"
Using \s-1GDB\s+1, an array value that is repeated 10 or more times is
displayed only once.  The value is shown with a `\fB<\fIN\fB\(mu>\fR'
postfix added, where \fIN\fR is the number of times the value is
repeated.  Thus, the display `\fB0x0 <30\(mu>\fR' stands for 30 array
elements, each with the value \fB0x0\fR.  This saves a lot of display
space, especially with homogeneous arrays.
.PP
.PSPIC ./PICS/ddd-repeats.ps 15.3cm
.PP
The default \s-1GDB\s+1 threshold for repeated array values is 10.
You can change it via `\fBEdit\(->GDB Settings\(->Threshold for
repeated print elements\fR'.  Setting the threshold to \fB0\fR will
cause \s-1GDB\s+1 (and \s-1DDD\s+1) to display each array element
individually.  Be sure to refresh the data window via
`\fBData\(->Refresh Displays\fR' after a change in \s-1GDB\s+1
settings.
.PP
You can also configure \s-1DDD\s+1 to display each array element
individually, regardless of \s-1GDB\s+1 settings; see the
`\fBexpandRepeatedValues\fR' resource for details.
.\"
.\"
.SS "Altering Variable Values"
.\"
Using the `\fBSet ()\fR' button or the `\fBSet Value\fR' menu item in
the data popup menu, you can alter the value of the selected variable,
to resume execution with the changed value.  In a dialog, you can
modify the variable value at will; clicking the `\fBOK\fR' or
`\fBApply\fR' button commits your change.
.PP
.PSPIC ./PICS/ddd-set.ps 15.3cm
.PP
If you made a mistake, you can use `\fBEdit\(->Undo\fR' to re-set the
variable to its previous value.
.PP
Note: Altering variable values is not supported in \s-1JDB\s+1.
.\"
.\"
.SS "Refreshing the Data Window"
.\"
The data window refreshes itself automatically each time the program
stops.  Values that have changed are highlighted.
.PP
However, there may be situations where you should refresh the data
window explicitly.  This is especially the case whenever you changed
debugger settings that could affect the data format, and want the data 
window to reflect these settings.
.PP
You can refresh the data window by selecting `\fBData\(->Refresh
Displays\fR'.
.PP
As an alternative, you can press \fImouse button 3\fR on the background of
the data window and select the `\fBRefresh Display\fR' item.
.PP
Typing
.sp
.br
  \fBgraph refresh\fR
.sp
.br
at the debugger prompt has the same effect.
.\"
.\"
.SS "Deleting Displays"
.\"
To delete a single display, select it and click on the `\fBDelete
()\fR' button.  As an alternative, you can also press \fImouse button 3\fR on
the display and select the `\fBDelete Display\fR' item.
.PP
When a display is deleted, its immediate ancestors and descendants are
automatically selected, so that you can easily delete entire graphs.
.PP
To delete several displays at once, select the `\fBDelete\fR' item in
the Display Editor (invoked via `\fBData\(->Edit Displays\fR').  Select
any number of display items in the usual way and delete them by
pressing `\fBDelete\fR'.
.PP
As an alternative, you can also type
.sp
.br
  \fBgraph undisplay \fIdisplays...\fR
.sp
.br
at the debugger prompt.  \fIdisplays...\fR is either
.br
.IP \(bu 2
a space-separated list of display numbers to delete, or
.br
.IP \(bu 2
a single display name.  If you specify a display by name, all displays
with this name will be deleted.
.br
.PP
If you are using stacked windows, deleting the last display from the
data window also automatically closes the data window.  (You can
change this via `\fBEdit\(->Preferences\(->Data\(->Close data window
when deleting last display\fR'.)
.PP
If you deleted a display by mistake, use `\fBEdit\(->Undo\fR' to
re-create it.
.\"
.\"
.SS "Examining Shared Data Structures"
.\"
By default, \s-1DDD\s+1 does not recognize shared data
structures\(em\&that is, a data object referenced by multiple other
data objects.  For instance, if two pointers \fBp1\fR and \fBp2\fR
point at the same data object \fBd\fR, the data displays \fBd\fR,
\fB*p1\fR, and \fB*p2\fR will be separate, although they denote the
same object.
.PP
\s-1DDD\s+1 provides a special mode which makes it detect these
situations.  \s-1DDD\s+1 recognizes if two or more data displays are
stored at the same physical address, and if this is so, merges all
these \fIaliases\fR into one single data display, the \fIoriginal data
display\fR.  This mode is called \fIAlias Detection\fR; it is enabled
via the `\fBData\(->Detect Aliases\fR'.
.PP
When alias detection is enabled, \s-1DDD\s+1 inquires the memory
location (the \fIaddress\fR) of each data display after each program
step.  If two displays have the same address, they are merged into
one.  More specifically, only the one which has least recently changed
remains (the \fIoriginal data display\fR); all other aliases are
\fIsuppressed\fR, i.e. completely hidden.  The edges leading to the
aliases are replaced by edges leading to the original data display.
.PP
An edge created by alias detection is somewhat special: rather than
connecting two displays directly, it goes through an \fIedge hint\fR,
describing an arc connecting the two displays and the edge hint.
.PP
Each edge hint is a placeholder for a suppressed alias; selecting an
edge hint is equivalent to selecting the alias.  This way, you can
easily delete display aliases by simply selecting the edge hint and
clicking on `\fBUndisplay ()\fR'.
.PP
.PSPIC ./PICS/ddd-aliases.ps 15.3cm
.PP
To access suppressed display aliases, you can also use the Display
Editor.  Suppressed displays are listed in the Display Editor as
\fIaliases\fR of the original data display.  Via the Display Editor,
you can select, change, and delete suppressed displays.
.PP
Suppressed displays become visible again as soon as
.br
.IP \(bu 2
alias detection is disabled, 
.br
.IP \(bu 2
their address changes such that they are no more aliases, or
.br
.IP \(bu 2
the original data display is deleted, such that the least recently
changed alias becomes the new original data display.
.PP
Please note the following \fIcaveats\fR with alias detection:
.br
.IP \(bu 2
Alias detection requires that the current programming language
provides a means to determine the address of an arbitrary data
object.  Currently, only C and C++ are supported.
.br
.IP \(bu 2
Some inferior debuggers (for instance, SunOS \s-1DBX\s+1) produce
incorrect output for address expressions.  Given a pointer \fIp\fR,
you may verify the correct function of your inferior debugger by
comparing the values of \fIp\fR and \fB&\fIp\fR (unless \fIp\fR
actually points to itself).  You can also examine the data display
addresses, as shown in the Display Editor.
.br
.IP \(bu 2
Alias detection slows down \s-1DDD\s+1 slightly, which is why it is
disabled by default.  You may consider to enable it only at
need\(em\&for instance, while examining some complex data
structure\(em\&and disable it while examining control flow (i.e.,
stepping through your program).  \s-1DDD\s+1 will automatically
restore edges and data displays when switching modes.
.PP
.PSPIC ./PICS/ddd-edit-displays.ps 15.3cm
.\"
.\"
.SS "Clustering Displays"
.\"
If you examine several variables at once, having a separate display
for each of them uses a lot of screen space.  This is why
\s-1DDD\s+1 supports \fIclusters\fR.  A cluster merges several
logical data displays into one physical display, saving screen space.
.PP
There are two ways to create clusters:
.br
.IP \(bu 2
You can create clusters \fImanually\fR.  This is done by selecting the
displays to be clustered and choosing `\fBUndisp\(->Cluster ()\fR'.
This creates a new cluster from all selected displays.  If an already
existing cluster is selected, too, the selected displays will be
clustered into the selected cluster.
.br
.IP \(bu 2
You can create a cluster \fIautomatically\fR for all independent data
displays, such that all new data displays will automatically be
clustered, too.  This is achieved by enabling
`\fBEdit\(->Preferences\(->Data\(->Cluster Data Displays\fR'.
.br
.PP
.PSPIC ./PICS/ddd-clusters.ps 15.3cm
.PP
Displays in a cluster can be selected and manipulated like parts of an
ordinary display; in particular, you can show and hide details, or
dereference pointers.  However, edges leading to clustered displays
can not be shown, and you must either select one or all clustered
displays.
.PP
Disabling a cluster is called \fIunclustering\fR, and again, there
are two ways of doing it:
.br
.IP \(bu 2
You can uncluster displays \fImanually\fR, by selecting the cluster
and choosing `\fBUndisp\(->Uncluster ()\fR'.
.br
.IP \(bu 2
You can uncluster all current and future displays by disabling
`\fBEdit\(->Preferences\(->Data\(->Cluster Data Displays\fR'.
.br
.PP
.\"
.SS "Moving Displays Around"
.\"
From time to time, you may wish to move displays at another place in
the data window.  You can move a single display by pressing and
holding \fImouse button 1\fR on the display title.  Moving the pointer while
holding the button causes all selected displays to move along with the
pointer.
.PP
If the data window becomes too small to hold all displays, scroll bars
are created.  If your \s-1DDD\s+1 is set up to use \fIpanners\fR
instead, a panner is created in the lower right edge.  When the panner
is moved around, the window view follows the position of the panner.
See `\fBCUSTOMIZING DDD\fR', below, for details on how to set up
scroll bars or panners.
.PP
For fine-grain movements, selected displays may also be moved using
the arrow keys.  Pressing \fBShift\fR and an arrow key moves displays
by single pixels.  Pressing \fBCtrl\fR and arrow keys moves displays
by grid positions.
.PP
Edge hints can be selected and moved around like other displays.  If
an arc goes through the edge hint, you can change the shape of the arc
by moving the edge hint around.
.\"
.\"
.SS "Aligning Displays"
.\"
You can align all displays on the nearest grid position by selecting
`\fBData\(->Align on Grid\fR'.  This is useful for keeping edges
horizontal or vertical.
.PP
You can enforce alignment by selecting
`\fBEdit\(->Preferences\(->Data\(->Auto-align displays on nearest grid
point\fR'.  If this feature is enabled, displays can be moved on grid
positions only.
.\"
.\"
.SS "Layouting the Display Graph"
.\"
You can layout the entire graph as a tree by selecting
`\fBData\(->Layout Graph\fR'.
.PP
Layouting the graph may introduce \fIedge hints\fR; that is, edges are
no more straight lines, but lead to an edge hint and from there to
their destination.  Edge hints can be moved around like arbitrary
displays.
.PP
To enable a more compact layout, you can set the
`\fBEdit\(->Preferences\(->Data\(->Compact layout\fR' option.
This realizes an alternate layout algorithm, where successors are
placed next to their parents.  This algorithm is suitable for
homogeneous data structures only.
.PP
You can enforce layout by setting `\fBEdit\(->Preferences\(->Data\(->
Automatic Layout\fR'.  If automatic layout is enabled, the graph is
layouted after each change.
.PP
.PSPIC ./PICS/ddd-layout.ps 15.3cm
.\"
.\"
.SS "Rotating the Display Graph"
.\"
You can rotate the entire graph clockwise by 90 degrees by selecting
`\fBData\(->Rotate Graph\fR'.
.PP
If the graph was previously layouted, you may need to layout it again.
Subsequent layouts will respect the direction of the last rotation.
.\"
.\"
.SS "Printing the Display Graph"
.\"
\s-1DDD\s+1 allows for printing the graph picture on PostScript
printers or into files.  This is useful for documenting program states.
.PP
.PSPIC ./PICS/ddd-print-graph.ps 15.3cm
.PP
To print the graph on a PostScript printer, select `\fBFile\(->Print
Graph\fR'.  Enter the printing command in the `\fBPrint Command\fR'
field.  Click on the `\fBOK\fR' or the `\fBApply\fR' button to start
printing.
.PP
As an alternative, you may also print the graph in a file.  Click on
the `\fBFile\fR' button and enter the file name in the `\fBFile
Name\fR' field.  Click on the `\fBPrint\fR' button to create the file.
.PP
When the graph is printed in a file, two formats are available:
.br
.IP \(bu 2
\fBPostScript\fR\(em\&suitable for enclosing the graph in another document;
.br
.IP \(bu 2
\fB\s-1FIG\s+1\fR\(em\&suitable for post-processing, using the
\s-1XFIG\s+1 graphic editor, or for conversion into other formats
(among others \s-1IBMGL\s+1, \s-1L\s-1A\s+1T\dE\uX\s+1, \s-1PIC\s+1),
using the \s-1TRANSFIG\s+1 or \s-1FIG2DEV\s+1 package.
.PP
.PSPIC ./PICS/ddd-print-output.ps 15.3cm
.PP
Please note the following \fIcaveats\fR related to printing graphs:
.IP \(bu 2
If any displays were selected when invoking the `\fBPrint\fR' dialog,
the option `\fBSelected Only\fR' is set.  This makes \s-1DDD\s+1
print only the selected displays.
.IP \(bu 2
The `\fBColor\fR', `\fBOrientation\fR', and `\fBPaper Size\fR' options 
are meaningful for PostScript only.
.PP
.\"
.\" ---------------
.SH "PLOTTING DATA"
.\" ---------------
.\"
If you have huge amounts of numerical data to examine, a picture often
says more than a thousand numbers.  Therefore, \s-1DDD\s+1 allows
you to draw numerical values in nice 2-D and 3-D plots.
.\"
.\"
.SS "Plotting Arrays"
.\"
Basically, \s-1DDD\s+1 can plot two types of numerical values:
.\"
.IP \(bu 2
One-dimensional arrays.  These are drawn in a 2-D \fIX\fR/\fIY\fR
space, where \fIX\fR denotes the array index, and \fIY\fR the element
value.
.IP \(bu 2
Two-dimensional arrays.  These are drawn in a 3-D
\fIX\fR/\fIY\fR/\fIZ\fR space, where \fIX\fR and \fIY\fR denote the
array indexes, and \fIZ\fR the element value.
.PP
To plot an array, select it by clicking \fImouse button 1\fR on an
occurrence.  The array name is copied to the argument field.  By
clicking the `\fBPlot\fR' button, a new display is created in the data
window, followed by a new top-level window containing the value plot.
.PP
Each time the value changes during program execution, the plot is
updated to reflect the current values.  The plot window remains active
until you close it (via `\fBFile\(->Close\fR') or until the associated
display is deleted.
.\"
.\"
.SS "Changing the Plot Appearance"
.\"
The actual drawing is not done by \s-1DDD\s+1 itself.  Instead,
\s-1DDD\s+1 relies on an external Gnuplot program to create the
drawing.  \s-1DDD\s+1 adds a menu bar to the Gnuplot plot window
that lets you influence the appearance of the plot:
.IP \(bu 2
The `\fBView\fR' menu toggles optional parts of the plot, such as
border lines or a background grid.
.br
.IP \(bu 2
The `\fBPlot\fR' menu changes the plotting style.  The `\fB3-D
Lines\fR' option is useful for plotting two-dimensional arrays.
.br
.IP \(bu 2
The `\fBScale\fR' menu allows you to enable logarithmic scaling and to 
enable or disable the scale tics.
.br
.IP \(bu 2
The `\fBContour\fR' menu adds contour lines to 3-D plots.
.PP
You can also resize the plot window as desired.
.PP
In a 3-D plot, you can use the scroll bars to change your view
position.  The horizontal scroll bar rotates the plot around the
\fIZ\fR axis, that is, to the left and right.  The vertical scroll bar
rotates the plot around the \fIY\fR axis, that is, up and down.
.PP
.PSPIC ./PICS/ddd-plots.ps 15.3cm
.\"
.\"
.SS "Plotting Scalars and Composites"
.\"
Besides plotting arrays, \s-1DDD\s+1 also allows you to plot scalars
(simple numerical values).  This works just like plotting
arrays\(em\&you select the numerical variable, click on `\fBPlot\fR',
and here comes the plot.  However, plotting a scalar is not very
exciting.  A plot that contains nothing but a scalar simply draws the
scalar's value as a \fIY\fR constant\(em\&that is, a horizontal line.
.PP
So why care about scalars at all?  \s-1DDD\s+1 allows you to combine
multiple values into one plot.  The basic idea is: if you want to plot
something that is neither an array nor a scalar, \s-1DDD\s+1 takes
all numerical sub-values it can find and plots them all together in one
window.  For instance, you can plot all local variables by selecting
`\fBData\(->Display Local Variables\fR', followed by `\fBPlot\fR'.
This will create a plot containing all numerical values as found in
the current local variables.  Likewise, you can plot all numeric
members contained in a structure by selecting it, followed by
`\fBPlot\fR'.
.PP
If you want more control about what to include in a plot and what not,
you can use display clusters.  (See `\fBClustering Displays\fR',
above, for details on clusters.)  A common scenario is to plot a
one-dimensional array together with the current index position.
This is done in three steps:
.IP \(bu 2
Display the array and the index, using `\fBDisplay ()\fR'.
.br
.IP \(bu 2
Cluster both displays: select them and choose `\fBUndisp\(->Cluster
()\fR'.
.br
.IP \(bu 2
Plot the cluster by pressing `\fBPlot\fR'.
.PP
Scalars that are displayed together with arrays can be displayed
either as vertical lines or horizontal lines.  By default, scalars are
plotted as horizontal lines.  However, if a scalar is a valid index
for an array that was previously plotted, it is shown as a vertical
line.  You can change this initial alignment by selecting the scalar
display, followed by `\fBRotate ()\fR'.
.\"
.\"
.SS "Plotting Display Histories"
.\"
At each program stop, \s-1DDD\s+1 records the values of all
displayed variables.  These \fIdisplay histories\fR can be plotted,
too.  The menu item `\fBPlot\(->Plot history of ()\fR' creates a plot
that shows all previously recorded values of the selected display.
.\"
.\"
.SS "Printing Plots"
.\"
If you want to print the plot, select `\fBFile\(->Print Plot\fR'.
This pops up the \s-1DDD\s+1 printing dialog, set up for printing
plots.  Just as when printing graphs, you have the choice between
printing to a printer or a file and setting up appropriate options.
.PP
The actual printing is also performed by Gnuplot, using the
appropriate driver.  Please note the following caveats related to
printing:
.IP \(bu 2
Creating \fB\s-1FIG\s+1\fR files requires an appropriate driver built
into Gnuplot.  Your Gnuplot program may not contain such a driver.  In
this case, you will have to recompile Gnuplot, including the line
`\fB#define FIG\fR' in the Gnuplot `\fBterm.h\fR' file.
.br
.IP \(bu 2
The `\fBPortrait\fR' option generates an \fBEPS\fR file useful for
inclusion in other documents.  The `\fBLandscape\fR' option makes
\s-1DDD\s+1 print the plot in the size specified in the `\fBPaper
Size\fR' option; this is useful for printing on a printer.  In
`\fBPortrait\fR' mode, the `\fBPaper Size\fR' option is ignored.
.br
.IP \(bu 2
The PostScript and X11 drivers each have their own set of colors, such
that the printed colors may differ from the displayed colors.
.br
.IP \(bu 2
The `\fBSelected Only\fR' option is set by default, such that only the
currently selected plot is printed.  (If you select multiple plots to
be printed, the respective outputs will all be concatenated, which may
not be what you desire.)
.PP
.\"
.\"
.SS "Entering Plotting Commands"
.\"
Via `\fBFile\(->Command\fR', you can enter Gnuplot commands directly.
Each command entered at the `\fBgnuplot>\fR' prompt is passed to
Gnuplot, followed by a Gnuplot `\fBreplot\fR' command to update the
view.  This is useful for advanced Gnuplot tasks.
.PP
Here's a simple example.  The Gnuplot command `\fBset xrange
[\fIxmin\fB:\fIxmax\fB]\fR' sets the horizontal range that will be
displayed to \fIxmin\fR...\fIxmax\fR.  To plot only the elements
10 to 20, enter:
.br
.sp
  gnuplot>\fBset xrange [10:20]\fR
.sp
.br
After each command entered, DDD adds a `\fBreplot\fR' command, such
that the plot is updated automatically.
.PP
Here's a more complex example.  The following sequence of Gnuplot
commands saves the plot in \s-1L\s-1A\s+1T\dE\uX\s+1 format:
.br
.sp
  gnuplot>\fBset output "plot.tex"\fR # Set the output filename
  gnuplot>\fBset term latex\fR        # Set the output format
  gnuplot>\fBset term x11\fR          # Show original picture again
.sp
.br
Due to the implicit `\fBreplot\fR' command, the output is
automatically written to `\fBplot.tex\fR' after the `\fBset term
latex\fR' command.
.PP
The dialog keeps track of the commands entered; use the arrow keys to
restore previous commands.  Gnuplot error messages (if any) are also
shown in the history area.
.PP
The interaction between \s-1DDD\s+1 and Gnuplot is logged in the
file `\fB$HOME/.ddd/log\fR'.  The \s-1DDD\s+1 `\fB\-\-trace\fR'
option logs this interaction on standard output.
.\"
.\"
.SS "Exporting Plot Data"
.\"
If you want some external program to process the plot data (a
stand-alone Gnuplot program or the \fBxmgr\fR program, for instance),
you can save the plot data in a file, using `\fBFile\(->Save Data
As\fR'.  This pops up a dialog that lets you choose a data file to
save the plotted data in.
.PP
The generated file starts with a few comment lines.  The actual data
follows in X/Y or X/Y/Z format.  It is the same file as processed by
Gnuplot.
.\" .PP
.\" Exporting plot data is only available if your plot includes exactly
.\" one array.
.\"
.\"
.SS "Animating Plots"
.\"
If you want to see how your data evolves in time, you can set a
breakpoint whose command sequence ends in a `\fBcont\fR' command.
Each time this \(lqcontinue\(rq breakpoint is reached, the program
stops and \s-1DDD\s+1 updates the displayed values, including the
plots.  Then, \s-1DDD\s+1 executes the breakpoint command sequence,
resuming execution.
.PP
This way, you can set a \(lqcontinue\(rq breakpoint at some decisive
point within an array-processing algorithm and have \s-1DDD\s+1
display the progress graphically.  When your program has topped for
good, you can use `\fBUndo\fR' and `\fRRedo\fR' to redisplay and
examine previous program states.
.\"
.\"
.\"
.\"
.\" ---------------
.SH "MACHINE-LEVEL DEBUGGING"
.\" ---------------
.\"
Note: Machine-level support is available with \s-1GDB\s+1 only.
.PP
Sometimes, it is desirable to examine a program not only at the
source level, but also at the machine level.  \s-1DDD\s+1 provides
special machine code and register windows for this task.
.\"
.\"
.SS "Examining Machine Code"
.\"
To enable machine-level support, select `\fBSource\(->Display Machine
Code\fR'.  With machine code enabled, an additional \fImachine
code window\fR shows up, displaying the machine code of the current
function.  By moving the sash at the right of the separating line
between source and machine code, you can resize the source and machine
code windows.
.PP
.PSPIC ./PICS/ddd-code.ps 15.3cm
.PP
The machine code window works very much like the source window.  You
can set, clear, and change breakpoints by selecting the address and
pressing a `\fBBreak at ()\fR' or `\fBClear at ()\fR' button; the
usual popup menus are also available.  Breakpoints and the current
execution position are displayed simultaneously in both source and
machine code.
.PP
The `\fBLookup ()\fR' button can be used to look up the machine code
for a specific function\(em\&or the function for a specific address.
Just click on the location in one window and press `\fBLookup ()\fR'
to see the corresponding code in the other window.
.PP
The `\fBmaxDisassemble\fR' resource controls how much is to be
disassembled.  If `\fBmaxDisassemble\fR' is set to 256 (default) and
the current function is larger than 256 bytes, \s-1DDD\s+1 only
disassembles the first 256 bytes below the current location.  You can
set the `\fBmaxDisassemble\fR' resource to a larger value if you
prefer to have a larger machine code view.
.PP
If source code is not available, only the machine code window is
updated.
.\"
.\"
.SS "Execution"
.\"
All execution facilities available in the source code window are
available in the machine code window as well.  Two special facilities
are convenient for machine-level debugging:
.PP
To execute just one machine instruction, click on the `\fBStepi\fR' button.
.PP
To continue to the next instruction in the current function, click on
the `\fBNexti\fR' button.  This is similar to `\fBStepi\fR', but any
subroutine calls are executed without stopping.
.\"
.\"
.SS "Registers"
.\"
\s-1DDD\s+1 provides a \fIregister window\fR showing the machine
register values after each program stop.  To enable the register
window, select `\fBStatus\(->Registers\fR'.
.PP
By selecting one of the registers, its name is copied to the argument
field.  You can use it as value for `\fBDisplay ()\fR', for instance,
to have its value displayed in the data window.
.PP
.PSPIC ./PICS/ddd-registers.ps 15.3cm
.\"
.\"
.SS "Examining Memory"
.\"
Using \s-1GDB\s+1 or \s-1DBX\s+1, you can examine memory in any of
several formats, independently of your program's data types.  The item
`\fBData\(->Examine Memory\fR' pops up a panel where you can choose
the format to be shown.
.PP
You can enter
.IP \(bu 2
a \fIrepeat count\fR, a decimal integer that specifies how much memory
(counting by units) to display
.IP \(bu 2
a \fIdisplay format\fR\(em\&one of
.RS
.TP 10
.B octal
Print as integer in octal
.TP 10
.B hex
Regard the bits of the value as an integer, and print the integer 
in hexadecimal.
.TP 10
.B decimal
Print as integer in signed decimal.
.TP 10
.B unsigned
Print as integer in unsigned decimal.
.TP 10
.B binary
Print as integer in binary.
.TP 10
.B float
Regard the bits of the value as a floating point number and print
using typical floating point syntax.
.TP 10
.B address
Print as an address, both absolute in hexadecimal and as an offset
from the nearest preceding symbol.
.TP 10
.B instruction
Print as machine instructions.  The \fIunit size\fR is ignored for
this display format.
.TP 10
.B char
Regard as an integer and print it as a character constant.
.TP 10
.B string
Print as null-terminated string.  The \fIunit size\fR is ignored for
this display format.
.RE
.IP \(bu 2
a \fIunit size\fR\(em\&one of
.RS
.TP 10
.B bytes
Bytes.
.TP 10
.B halfwords
Halfwords (two bytes).
.TP 10
.B words
Words (four bytes).
.TP 10
.B giants
Giant words (eight bytes).
.RE
.IP \(bu 2
an \fIaddress\fR\(em\&the starting display address.  The expression
need not have a pointer value (though it may); it is always
interpreted as an integer address of a byte of memory.
.PP
There are two ways to examine the values:
.IP \(bu 2
You can dump the memory in the debugger console (using `\fBPrint\fR').
If you repeat the resulting `\fBx\fR' command by pressing
\s-1\fBRETURN\fR\s+1, the following area of memory is shown.
.IP \(bu 2
You can also display the memory dump in the data window (using
`\fBDisplay\fR').  If you choose to display the values, the values
will be updated automatically each time the program stop.
.PP
.PSPIC ./PICS/ddd-examine.ps 15.3cm
.PP
.\"
.\"
.\" ---------------------
.SH "EDITING SOURCE CODE"
.\" ---------------------
.\"
In \s-1DDD\s+1 itself, you cannot change the source file currently
displayed.  Instead, \s-1DDD\s+1 allows you to invoke a \fItext
editor\fR.  To invoke a text editor for the current source file,
select the `\fBEdit\fR' button or `\fBSource\(->Edit Source\fR'.
.PP
By default, \s-1DDD\s+1 tries a number of common editors.  You can
customize \s-1DDD\s+1 to use your favourite editor via
`\fBEdit\(->Preferences\(->Helpers\(->Edit Sources\fR'.
.PP
After the editor has exited, the source code shown is automatically
updated.
.PP
If you have \s-1DDD\s+1 and an editor running in parallel, you can
also update the source code manually via `\fBSource\(->Reload
Source\fR'.  This reloads the source code shown from the source file.
Since \s-1DDD\s+1 automatically reloads the source code if the debugged
program has been recompiled, this should seldom be necessary.
.\"
.\"
.\"
.\" ---------------
.SH "ENTERING COMMANDS"
.\" ---------------
.\"
In the \fIdebugger console\fR, you can interact with the command
interface of the inferior debugger.  Enter commands at the \fIdebugger
prompt\fR\(em\&that is, `\fB(gdb)\fR' for \s-1GDB\s+1, `\fB(dbx)\fR'
for \s-1DBX\s+1, `\fB>\fR' for \s-1XDB\s+1, `\fB>\fR' and
`\fIthread\fB[\fIdepth\fB]\fR' for \s-1JDB\s+1, or `\fB(Pydb)\fR' for
\s-1PYDB\s+1, or `\fBDB<>\fR' for Perl.  You can use arbitrary
debugger commands; use the \s-1\fBRETURN\fR\s+1 key to enter them.
.PP
.PSPIC ./PICS/ddd-console.ps 15.3cm
.PP
You can \fIrepeat\fR previous and next commands by pressing the
`\fBUp\fR' and `\fBDown\fR' arrow keys, respectively.  If you enter an
empty line, the last command is repeated as well.
`\fBCommands\(->Command History\fR' shows the command history.
.PP
.PSPIC ./PICS/ddd-history.ps 15.3cm
.PP
You can \fIsearch\fR for previous commands by pressing \fBCtrl+B\fR.
This invokes \fIincremental search mode,\fR where you can enter a
string to be searched in previous commands.  Press \fBCtrl+B\fR again
to repeat the search, or \fBCtrl+F\fR to search in the reverse
direction.  To return to normal mode, press \s-1\fBESC\fR\s+1, or use
any cursor command.
.PP
Using \s-1GDB\s+1 and Perl, you can also \fIcomplete\fR commands and
arguments by pressing the \s-1\fBTAB\fR\s+1 key; pressing the
\s-1\fBTAB\fR\s+1 key multiple times shows one possible expansion
after the other.
.\"
.\"
.\" ---------------
.SH "CUSTOMIZING DDD"
.\" ---------------
.\"
You can set up your personal \s-1DDD\s+1 preferences by using the
`\fBEdit\(->Preferences\fR' menu from the menu bar.  These preferences
affect your running \s-1DDD\s+1 process only, unless you save these
preferences for a later \s-1DDD\s+1 invocation.  Frequently used
preferences can also be found in the individual menus.
.\"
.SS "Frequently Used Preferences"
If you want to run your debugged process in a separate terminal
emulator window, set `\fBProgram\(->Run in Execution Window\fR'.
This is useful for programs that have special terminal requirements
not provided by the debugger window, as raw keyboard processing or
terminal control sequences.
.PP
By default, \s-1DDD\s+1 finds only complete words.  This is
convenient for clicking on an identifier in the source text and search
for exactly this identifier.  If you want to find all occurrences,
including word parts, unset `\fBSource\(->Find Words Only\fR'.
.PP
By default, \s-1DDD\s+1 find is case-sensitive.  This is convenient
for case-sensitive programming languages.  If you want to find all
occurrences, regardless of case, unset `\fBSource\(->Find Case
Sensitive\fR'.
.PP
If you wish to display machine code of selected functions, set
`\fBSource\(->Display Machine Code\fR'.  This makes \s-1DDD\s+1 run
a little slower, so it is disabled by default.
.PP
Through `\fBEdit\(->Preferences\fR', you can set up more \s-1DDD\s+1
preferences, which are discussed here.
.\"
.\"
.SS "General Preferences"
.PP
By default, when you move the pointer over a button, \s-1DDD\s+1
gives a hint on the button's meaning in a small window.  This feature
is known as \fIbutton tips\fR (also known as \fItool tips\fR or
\fIballoon help\fR).  Experienced users may find these hints
disturbing; this is why you can disable them by unsetting the
`\fBAutomatic display of button hints as popup tips\fR' option.
.PP
.PSPIC ./PICS/ddd-general-prefs.ps 15.3cm
.PP
The button hints are also displayed in the status line.  Disabling
hints in status line (by unsetting the `\fBAutomatic display of button
hints in the status line\fR' option) and disabling button tips as well
makes \s-1DDD\s+1 run slightly faster.
.PP
By default, when you move the pointer over a variable in the source
code, \s-1DDD\s+1 displays the variable value in a small window.
Users may find these \fIvalue tips\fR disturbing; this is why you can
disable them by unsetting the `\fBAutomatic display of variable
values as popup tips\fR' option.
.PP
The variable values are also displayed in the status line.  Disabling
variable values in status line (by unsetting the `\fBAutomatic display
of variable values in the status line\fR' option) and disabling value
tips as well will make \s-1DDD\s+1 run slightly faster.
.PP
If you want to use \s-1\fBTAB\fR\s+1 key completion in all text
windows, set the `\s-1\fBTAB\fR\s+1 \fBkey completes in all windows\fR'
option.  This is useful if you have pointer-driven keyboard focus (see
below) and no special usage for the \s-1\fBTAB\fR\s+1 key.  Otherwise,
the \s-1\fBTAB\fR\s+1 key completes in the debugger console only.
.PP
If you frequently switch between \s-1DDD\s+1 and other multi-window
applications, you may like to set the `\fBIconify all windows at
once\fR' option.  This way, all \s-1DDD\s+1 windows are iconified
and deiconified as a group.
.PP
If you want to keep \s-1DDD\s+1 off your desktop during a longer
computation, you may like to set the `\fBUniconify when ready\fR'
option.  This way, you can iconify \s-1DDD\s+1 while it is busy on a
command (e.g. running a program); \s-1DDD\s+1 will automatically pop
up again after becoming ready (e.g. after the debugged program has
stopped at a breakpoint).
.PP
If you are bothered by X warnings, you can suppress them by setting
the `\fBSuppress X warnings\fR' option.
.PP
If you want to be warned about multiple \s-1DDD\s+1 invocations
sharing the same preferences and history files, enable
`\fBWarn if Multiple DDD Instances are Running\fR'.
.PP
When debugging a modal X application, \s-1DDD\s+1 may interrupt it
while it has grabbed the pointer, making further interaction
impossible.  If the `\fBContinue automatically when mouse pointer is
frozen\fR' option is set, \s-1DDD\s+1 will check after each
interaction whether the pointer is grabbed.  If this is so,
\s-1DDD\s+1 will continue the debugged program such that you can
continue to use your display.
.PP
The \fIUndo Buffer\fR is the area where \s-1DDD\s+1 stores old
program states and commands in order to undo operations.  When you are
displaying lots of data, the undo buffer can quickly grow.  In
`\fBUndo Buffer Size\fR', you can limit the size of the undo buffer.
Setting this limit to \fB0\fR disables undo altogether.  A negative
value means to place no limit.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Source Preferences"
.PP
In the source text, the current execution position and breakpoints are
indicated by symbols (\*(lqglyphs\*(rq).  As an alternative,
\s-1DDD\s+1 can also indicate these positions using text characters.
If you wish to disable glyphs, set the `\fBAs Text Characters\fR'
option.  This also makes \s-1DDD\s+1 run slightly faster, especially
when scrolling.
.PP
.PSPIC ./PICS/ddd-source-prefs.ps 15.3cm
.PP
\s-1DDD\s+1 can locate the tool buttons in the command tool
(`\fBCommand Tool\fR') or in a \fIcommand tool bar\fR above the
program source (`\fBSource Window\fR').  Pick your choice.
.PP
Some \s-1DBX\s+1 and \s-1XDB\s+1 variants do not properly handle paths
in source file specifications.  If you want the inferior debugger to
refer to source locations by source base names only, unset the `\fBRefer
to sources by full path name\fR' option.
.PP
By default, \s-1DDD\s+1 finds only complete words.  This is
convenient for clicking on an identifier in the source text and search
for exactly this identifier.  If you want to find all occurrences,
including word parts, unset `\fBFind words only\fR'.
.PP
By default, \s-1DDD\s+1 find is case-sensitive.  This is convenient
for case-sensitive programming languages.  If you want to find all
occurrences, regardless of case, unset `\fBFind case sensitive\fR'.
.PP
By default, \s-1DDD\s+1 caches source files in memory.  This is
convenient for remote debugging, since remote file access may be slow.
If you want to reduce memory usage, unset the `\fBCache source
files\fR' option.
.PP
By default, \s-1DDD\s+1 caches machine code in memory.  This is bad
for memory usage, but convenient for speed, since disassembling a
function each time it is reached may take time.  If you want to reduce
memory usage, unset the `\fBCache machine code\fR' option.
.PP
If your source code uses a tab width different from \fB8\fR (the
default), you can set an alternate width using the `\fBTab width\fR'
slider.
.PP
You can instruct \s-1DDD\s+1 to indent the source code, leaving more
room for breakpoints and execution glyphs.  This is done using the
`\fBSource indentation\fR' slider.  The default value is \fB0\fR for
no indentation at all.  If the source indentation is \fB5\fR or
higher, \s-1DDD\s+1 will also show line numbers.
.PP
Finally, you can instruct \s-1DDD\s+1 to indent the machine code,
leaving room for breakpoints and execution glyphs.  This is done using
the `\fBMachine code indentation\fR' slider.  The default value is
\fB4\fR.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Data Preferences"
.PP
You can control whether edge hints and edge annotations are
displayed.  Set or unset the `\fBShow Edge Hints\fR' and `\fBShow Edge 
Annotations\fR' option, respectively.
.PP
By default, \s-1DDD\s+1 disables the title of a dependent display if
the name can be deduced from edge annotations.  If you want all
dependent displays to have a title, set `\fBShow Titles of Dependent
Displays\fR'.
.PP
.PSPIC ./PICS/ddd-data-prefs.ps 15.3cm
.PP
To enable a more compact layout, you can set the `\fBCompact
Layout\fR' option.  This realizes an alternate layout algorithm, where
successors are placed next to their parents.  This algorithm is
suitable for homogeneous data structures only.
.PP
To enforce layout, you can set the `\fBRe-layout graph
automatically\fR' option.  If automatic layout is enabled, the graph
is layouted after each change.
.PP
If you want \s-1DDD\s+1 to detect aliases, set the `\fBDetect
Aliases\fR' option.  Note that alias detection makes \s-1DDD\s+1 run
slower.  See `\fBExamining Shared Data Structures\fR', above, for
details on alias detection.
.PP
By default, \s-1DDD\s+1 displays two-dimensional arrays as tables,
aligning the array elements in rows and columns.  If you prefer
viewing two-dimensional arrays as nested one-dimensional arrays, you
can disable the `\fBDisplay two-dimensional arrays as tables\fR'
option.
.PP
To facilitate alignment of data displays, you can set the
`\fBAuto-align displays\fR' option.  If auto-alignment is enabled,
displays can be moved on grid positions only.
.PP
By default, the stacked data window is automatically closed when you
delete the last data display.  You can keep the data window open by
unsetting `\fBClose data window when deleting last display\fR'.
.PP
In the `\fBGrid Size\fR' scale, you can change the spacing of grid points.
A spacing of 0 disables the grid.  Default is 16.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Startup Preferences"
.PP
If you change one of the resources in this panel, the change will not
take effect immediately.  Instead, you can
.IP \(bu 2
save options (using `\fBEdit\(->Save Options\fR') to make the change
effective for future \s-1DDD\s+1 sessions,
.IP \(bu 2
or restart \s-1DDD\s+1 (using `\fBFile\(->Restart \s-1DDD\s+1\fR')
to make it effective for the restarted \s-1DDD\s+1 session.
.PP
After having made changes in the panel, \s-1DDD\s+1 will
automatically offer you to restart itself, such that you can see the
changes taking effect.  Note that even after restarting, you still
must save options to make the changes permanent.
.PP
.PSPIC ./PICS/ddd-startup-prefs.ps 15.3cm
.PP
By default, \s-1DDD\s+1 stacks commands, source, and data in one
single top-level window.  To have separate top-level windows for
source, data, and debugger console, set the `\fBWindow Layout\fR'
option to `\fBSeparate Windows\fR'.  See also the
`\fB\-\-attach-windows\fR' and `\fB\-\-separate-windows\fR' options,
below.
.PP
The \fBCtrl+C\fR key can be bound to different actions, each in
accordance with a specific style guide.
.TP
.B "Copy"
This setting binds \fBCtrl+C\fR to the Copy operation, as specified by
the \s-1KDE\s+1 style guide.  In this setting, use \s-1\fBESC\fR\s+1
to interrupt the debuggee.
.TP
.B "Interrupt"
This (default) setting binds \fBCtrl+C\fR to the Interrupt operation,
as used in several \s-1UNIX\s+1 command-line programs.  In this
setting, use \s-1\fBCtrl+Ins\fR\s+1 to copy text to the clipboard.
.PP
The \fBCtrl+A\fR key can be bound to different actions, too.
.TP
.B "Select All"
This (default) setting binds \fBCtrl+A\fR to the Select All operation,
as specified by the \s-1KDE\s+1 style guide.  In this setting, use
\s-1\fBHOME\fR\s+1 tp move the cursor to the beginning of a line.
.TP
.B "Beginning of Line"
This setting binds \fBCtrl+A\fR to the Beginning of Line operation, as
used in several \s-1UNIX\s+1 text-editing programs.  In this setting,
use \s-1\fBCtrl+Shift+A\fR\s+1 to select all text.
.PP
The \s-1DDD\s+1 tool bar buttons can appear in a variety of styles:
.TP
.B "Images"
This lets each tool bar button show an image illustrating the action.
.TP
.B "Captions"
This shows the action name below the image.
.PP
The default is to have images as well as captions, but you can choose
to have only images (saving space) or only captions.
.PP
.PSPIC ./PICS/ddd-toolbars.ps 15.3cm
.PP
If you choose to have neither images nor captions, tool bar buttons
are labeled like other buttons, as in \s-1DDD\s+1 2.x.  Note that
this implies that in the stacked window configuration, the common tool
bar cannot be displayed; it is replaced by two separate tool bars, as
in \s-1DDD\s+1 2.x.
.PP
If you enable `\fBFlat\fR' buttons (default), the border of tool bar
buttons will appear only if the mouse pointer is over them.  This
latest-and-greatest \s-1GUI\s+1 invention can be disabled, such that
the button border is always shown.
.PP
If you enable `\fBColor\fR' buttons, tool bar images will be colored
when entered.  If \s-1DDD\s+1 was built using Motif 2.0 and later,
you can also choose a third setting, where buttons appear in color all
the time.
.PP
By default, the \s-1DDD\s+1 tool bars are located on top of the
window.  If you prefer the tool bar being located at the bottom, as in
\s-1DDD\s+1 2.x and earlier, enable the `\fBBottom\fR' toggle.  The
bottom setting is only supported for separate tool bars\(em\&that is,
you must either choose separate windows or configure the tool bar to
have neither images nor captions.
.PP
By default, \s-1DDD\s+1 directs keyboard input to the item your
mouse pointer points at.  If you prefer a click-to-type keyboard focus
(that is, click on an item to make it accept keyboard input), set the
`\fBKeyboard Focus\fR' option on `\fBClick to Type\fR'.
.PP
By default, \s-1DDD\s+1 uses Motif scroll bars to scroll the data
window.  Many people find this inconvenient, since you can scroll in
the horizontal or vertical direction only.  As an alternative,
\s-1DDD\s+1 provides a panner (a kind of two-dimensional scroll bar).
This is much more comfortable, but may be incompatible with your Motif
toolkit.  To set up \s-1DDD\s+1 such that it uses panners by
default, set the `\fBData Scrolling\fR' option to `\fBPanner\fR'.
See also the `\fB\-\-panned-graph-editor\fR' and
`\fB\-\-scrolled-graph-editor\fR' options, below.
.PP
By default, \s-1DDD\s+1 determines the inferior debugger
automatically.  To change this default, unset `\fBDetermine
Automatically\fR' and set the `\fBDebugger Type\fR' option to a
specific debugger.  See also the `\fB\-\-gdb\fR', `\fB\-\-dbx\fR',
`\fB\-\-xdb\fR', `\fB\-\-jdb\fR', `\fB\-\-pydb\fR', and
`\fB\-\-perl\fR' options, below.
.PP
If you want the \s-1DDD\s+1 splash screen shown upon startup, enable 
`\fBDDD Splash Screen\fR'.
.PP
If you want the \s-1DDD\s+1 tips of the day displayed upon startup,
enable `\fBTip of the Day\fR'.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Fonts"
.\"
You can configure the basic \s-1DDD\s+1 fonts at run-time.  Each
font is specified using two members:
.IP \(bu 2
The \fIfont family\fR is an X font specifications, where the initial
'\fIFoundry\fB-\fR' specification may be omitted, as well as any
specification after `\fIFamily\fR'.  Thus, a pair
`\fIfamily\fB\-\fIweight\fR' usually suffices.
.IP \(bu 2
The \fIfont size\fR is given as (resolution-independent) 1\(f/10 points.
.PP
The `\fBBrowse\fR' button opens a font selection program, where you
can select fonts and attributes interactively.  Clicking `\fBquit\fR'
or `\fBselect\fR' in the font selector causes all non-default values
to be transferred to the \s-1DDD\s+1 font preferences panel.
.PP
.PSPIC ./PICS/ddd-font-prefs.ps 15.3cm
.PP
The following fonts can be set using the preferences panel:
.TP
.B "Default Font"
The default \s-1DDD\s+1 font to use for labels, menus, and buttons.
Default is `\fBhelvetica-bold\fR'.
.TP
.B "Variable Width"
The variable width \s-1DDD\s+1 font to use for help texts and messages.
Default is `\fBhelvetica-medium\fR'.
.TP
.B "Fixed Width"
The fixed width \s-1DDD\s+1 font to use for source code, the
debugger console, text fields, data displays, and the execution
window.  Default is `\fBlucidatypewriter-medium\fR'.
.PP
Just like startup preferences, changes in this panel will not take
effect immediately.  Instead, you can
.IP \(bu 2
save options (using `\fBEdit\(->Save Options\fR') to make the change
effective for future \s-1DDD\s+1 sessions,
.IP \(bu 2
or restart \s-1DDD\s+1 (using `\fBFile\(->Restart \s-1DDD\s+1\fR')
to make it effective for the restarted \s-1DDD\s+1 session.
.PP
After having made changes in the panel, \s-1DDD\s+1 will
automatically offer you to restart itself, such that you can see the
changes taking effect.  Note that even after restarting, you still
must save options to make the changes permanent.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\" 
.SS "Helpers"
.\"
\s-1DDD\s+1 relies on some external applications (called
\fIhelpers\fR) for specific tasks.  Through the `\fBHelpers\fR' panel,
you can choose and customize these applications.
.PP
In `\fBEdit Sources\fR', you can select an X editor to be invoked via
the \s-1DDD\s+1 `\fBEdit\fR' button.  `\fB@FILE@\fR' is replaced by
the current file name; `\fB@LINE@\fR' is replaced by the current line.
Typical values include `\fBxedit @FILE@\fR' or `\fBgnuclient +@LINE@
@FILE@\fR'.  See also the `\fBeditCommand\fR' resource, below.
.PP
In `\fBGet Core File\fR', you can enter a command to get a core file
from a running process.  `\fB@FILE@\fR' is replaced by the name of the
target core file; `\fB@PID@\fR' is replaced by the process ID.  A
typical value is `\fBgcore -o @FILE@ @PID@\fR'.  If you don't have an
appropriate command, leave this value empty: \s-1DDD\s+1 will then
kill the debuggee in order to get a core file.  See also the
`\fBgetCoreCommand\fR' resource, below.
.PP
`\fBList Processes\fR' is a command to get a list of processes, like
`\fBps\fR'.  The output of this command is shown in the
`\fBFile\(->Attach to Process\fR' dialog.  See also the
`\fBpsCommand\fR' resource, below.
.PP
.PSPIC ./PICS/ddd-helpers.ps 15.3cm
.PP
In `\fBExecution Window\fR', you can enter a command to start a 
terminal emulator.  To this command, \s-1DDD\s+1 appends Bourne
shell commands to be executed within the execution window.  A simple
value is `\fBxterm \-e /bin/sh \-c\fR'.  See also the `\fBtermCommand\fR'
resource, below.
.PP
`\fBUncompress\fR' is the uncompression command used by \s-1DDD\s+1
to uncompress the \s-1DDD\s+1 license and manual pages.  The
uncompression command should be invoked such that it reads from
standard input and writes to standard output.  A typical value is
`\fBgunzip \-c\fR'.  See also the `\fBuncompressCommand\fR' resource,
below.
.PP
`\fBWeb Browser\fR' is the command to invoke a \s-1WWW\s+1 browser for
the \s-1DDD\s+1 \s-1WWW\s+1 page.  `\fB@URL@\fR' is replaced by the
\s-1URL\s+1 (web page) to be shown.  A simple value is `\fBnetscape
@URL@\fR'.  See also the `\fBwwwCommand\fR' resource, below.
.PP
`\fBPlot\fR' is the name of a Gnuplot program to invoke.
\s-1DDD\s+1 can run Gnuplot in two ways:
.IP \(bu 2
\s-1DDD\s+1 can use an \fBExternal Plot Window\fR, i.e. the plot
window as supplied by Gnuplot.  \s-1DDD\s+1 \(lqswallows\(rq the
Gnuplot output window into its own user interface.  Unfortunately,
some window managers, notably \s-1MWM\s+1, have trouble with
swallowing techniques.
.IP \(bu 2
\s-1DDD\s+1 can supply a \fBBuiltin Plot Window\fR instead.  This
works with all window managers, but plots are less customizable
(Gnuplot resources are not understood).
.PP
Pick your choice from the menu.  See also the `\fBplotCommand\fR' and
`\fBplotTermType\fR' resources, below.
.\"
.\"
.SS "Saving Options"
.\"
You can save the current option settings by selecting `\fBEdit\(->Save
Options\fR'.  Options are saved in a file named `\fB.ddd/init\fR' in
your home directory.  If a session \fIsession\fR is active, options 
will be saved in `\fB$HOME/.ddd/sessions/\fIsession\fB/init\fR' instead.
.\"
.SS "Other Customizations"
.\"
Other personal \s-1DDD\s+1 resources can also be set in your
`\fB.ddd/init\fR' file.  See the `\fBRESOURCES\fR' section, below.
.PP
The inferior debugger can be customized via `\fBEdit\(->Settings\fR'.
See the `\fBDEBUGGER SETTINGS\fR' section, below.
.\"
.\"
.\"
.\" ---------------
.SH "DEBUGGER SETTINGS"
.\" ---------------
.\"
For most inferior debuggers, you can change its settings using
`\fBEdit\(->Settings\fR'.  Using the settings editor, you can
determine whether C++ names are to be demangled, how many array
elements are to print, and so on.
.PP
.PSPIC ./PICS/ddd-settings.ps 15.3cm
.PP
The capabilities of the settings editor depend on the capabilities of
your inferior debugger.  Clicking on `\fB?\fR' gives an an explanation
on the specific item; the \s-1GDB\s+1 documentation gives more
details.
.PP
Use `\fBEdit\(->Undo\fR' to undo changes.  Clicking on `\fBReset\fR'
restores the most recently saved settings.
.PP
Some debugger settings are insensitive and cannot be changed, because
doing so would endanger \s-1DDD\s+1 operation.  See the
`\fBgdbInitCommands\fR' and `\fBdbxInitCommands\fR' resources for
details.
.PP
All debugger settings (except source and object paths) 
are saved with \s-1DDD\s+1 options.
.\"
.\"
.\" ---------------
.SH "USER-DEFINED ACTIONS"
.\" ---------------
.\"
.SS "Defining Buttons"
.\"
To facilitate interaction, you can add own command buttons to
\s-1DDD\s+1.  These buttons can be added below the debugger console
(`\fBConsole Buttons\fR'), the source window (`\fBSource Buttons\fR'),
or the data window (`\fBData Buttons\fR').
.PP
To define individual buttons, use the \fIButton Editor\fR, invoked via
`\fBCommands\(->Edit Buttons\fR'.  The button editor displays a text,
where each line contains the command for exactly one button.  Clicking
on `\fBOK\fR' creates the appropriate buttons from the text.  If the
text is empty (the default), no button is created.
.PP
As a simple example, assume you want to create a `\fBprint i\fR'
button.  Invoke `\fBCommands\(->Edit Buttons\fR' and enter a line
saying `\fBprint i\fR' in the button editor.  Then click on
`\fBOK\fR'.  A button named `\fBPrint i\fR' will now appear below the
debugger console\(em\&try it!  To remove the button, reopen the button
editor, clear the `\fBprint i\fR' line and press `\fBOK\fR' again.
.PP
If a button command contains `\fB()\fR', the string `\fB()\fR' will
automatically be replaced by the contents of the argument field.  For
instance, a button named `\fBreturn ()\fR' will execute the
\s-1GDB\s+1 `\fBreturn\fR' command with the current content of the
argument field as argument.
.PP
By default, \s-1DDD\s+1 disables buttons whose commands are not
supported by the inferior debugger.  To enable such buttons, unset the
`\fBEnable supported buttons only\fR' toggle in the button editor.
.PP
.PSPIC ./PICS/ddd-button-editor.ps 15.3cm
.PP
\s-1DDD\s+1 also allows you to specify control sequences and special
labels for user-defined buttons.  See the examples in `\fBUser-defined
Buttons\fR' in the `\fBRESOURCES\fR' section, below.
.\"
.\"
.SS "Defining Simple Commands using GDB"
.\"
Aside from breakpoint commands (see `\fBBreakpoint commands\fR',
above), \s-1DDD\s+1 also allows you to store sequences of commands
as a user-defined \s-1GDB\s+1 command.  A \fIuser-defined command\fR
is a sequence of \s-1GDB\s+1 commands to which you assign a new name
as a command.  Using \s-1DDD\s+1, this is done via the \fICommand
Editor\fR, invoked via `\fBCommands\(->Define Command\fR'.
.PP
A \s-1GDB\s+1 command is created in five steps:
.IP \(bu 2
Enter the name of the command in the `\fBCommand\fR' field.  Use the
drop-down list on the right to select from already defined commands.
.IP \(bu 2
Click on `\fBRecord\fR' to begin the recording of the command sequence.
.IP \(bu 2
Now interact with \s-1DDD\s+1.  While recording, \s-1DDD\s+1 does not
execute commands, but simply records them to be executed when the
breakpoint is hit.  The recorded debugger commands are shown in the
debugger console.
.IP \(bu 2
To stop the recording, click on `\fBEnd\fR' or enter `\fBend\fR' at
the \s-1GDB\s+1 prompt.  To \fIcancel\fR the recording, click on
`\fBInterrupt\fR' or press \s-1\fBESC\fR\s+1.
.IP \(bu 2
Click on `\fBEdit \s-2>>\s+2\fR' to edit the recorded commands.
When done with editing, click on `\fBEdit \s-2<<\s+2\fR' to close the
commands editor.
.PP
After the command is defined, you can enter it at the \s-1GDB\s+1
prompt.  You may also click on `\fBApply\fR' to apply the given
user-defined command.
.PP
For convenience, you can assign a button to the defined command.
Enabling one of the `\fBButton\fR' locations will add a button with
the given command to the specified location.  If you want to edit the
button, select `\fBCommands\(->Edit Buttons\fR'; see also `\fBDefining
Buttons\fR', above.
.PP
.PSPIC ./PICS/ddd-define-command.ps 15.3cm
.PP
When user-defined \s-1GDB\s+1 commands are executed, the commands of
the definition are not printed.  An error in any command stops
execution of the user-defined command.
.PP
If used interactively, commands that would ask for confirmation
proceed without asking when used inside a user-defined command.  Many
\s-1GDB\s+1 commands that normally print messages to say what they are
doing omit the messages when used in a user-defined command.
.PP
To save all command definitions, use `\fBEdit\(->Save Options\fR'.
.\" .PP
.\" \s-1DDD\s+1 commands that are part of \s-1GDB\s+1 command
.\" definitions are realized transparently as \fIauto-commands\fR; see 
.\" \fBDefining Commands using Other Debuggers\fR, below, for a discussion.
.\"
.\"
.SS "Defining Argument Commands using GDB"
.\"
If you want to pass arguments to user-defined commands, you can enable 
the `\fB()\fR' toggle button in the Command Editor.  Enabling
`\fB()\fR' has two effects:
.IP \(bu 2
While recording commands, all references to the argument field are
taken \fIsymbolically\fR instead of literally.  The argument field
value is frozen to `\fB$arg0\fR', which is how \s-1GDB\s+1 denotes the
argument of a user-defined command.  When \s-1GDB\s+1 executes the
command, it will replace `\fB$arg0\fR' by the current command argument.
.IP \(bu 2
When assigning a button to the command, the command will be suffixed
by the current contents of the argument field.
.PP
While defining a command, you can toggle the `\fB()\fR' button as you
wish to switch between using the argument field symbolically and
literally.
.PP
As an example, let us define a command `\fBcontuntil\fR' that will set
a breakpoint in the given argument and continue execution.
.IP \(bu 2
Enter `\fBcontuntil\fR' in the `\fBDefinition\fR' field.
.IP \(bu 2
Enable the `\fB()\fR' toggle button.
.IP \(bu 2
Now click on `\fBRecord\fR' to start recording.  Note that the
contents of the argument field change to `\fB$arg0\fR'.
.IP \(bu 2
Click on `\fBBreak at ()\fR' to create a breakpoint.  Note that the
recorded breakpoint command refers to `\fB$arg0\fR'.
.IP \(bu 2
Click on `\fBCont\fR' to continue execution.
.IP \(bu 2
Click on `\fBEnd\fR' to end recording.  Note that the argument field
is restored to its original value.
.IP \(bu 2
Finally, click on one of the `\fBButton\fR' locations.  This creates a 
`\fBContuntil ()\fR' button where `\fB()\fR' will be replaced by the
current contents of the argument field\(em\&and thus passed to the
`\fBcontuntil\fR' command.
.IP \(bu 2
You can now either use the `\fBContuntil ()\fR' button or enter a
`\fBcontuntil\fR' command at the \s-1GDB\s+1 prompt.  (If you plan to
use the command frequently, you may wish to define a `\fBcu\fR'
command, which again calls `\fBcontuntil\fR' with its argument.  This
is a nice exercise.)
.PP
There is a little drawback with argument commands: a user-defined
command in \s-1GDB\s+1 has no means to access the argument list as a
whole; only the first argument (up to whitespace) is processed.  This
may change in future \s-1GDB\s+1 releases.
.\"
.\"
.SS "Defining Commands using Other Debuggers"
.\"
If your inferior debugger allows you to define own command sequences,
you can also use these user-defined commands within \s-1DDD\s+1;
just enter them at the debugger prompt.
.PP
However, you may encounter some problems:
.IP \(bu 2
In contrast to the well-documented commands of the inferior debugger,
\s-1DDD\s+1 does not know what a user-defined command does.  This
may lead to inconsistencies between \s-1DDD\s+1 and the inferior
debugger.  For instance, if your the user-defined command `\fBbp\fR'
sets a breakpoint, \s-1DDD\s+1 may not display it immediately,
because \s-1DDD\s+1 does not know that `\fBbp\fR' changes the
breakpoint state.
.IP \(bu 2
You cannot use \s-1DDD\s+1 \fBgraph\fR commands within user-defined
commands.  This is only natural, because user-defined commands are
interpreted by the inferior debugger, which does not know about
\s-1DDD\s+1 commands.
.PP
As a solution, \s-1DDD\s+1 provides a simple facility called
\fIauto-commands\fR.  If \s-1DDD\s+1 receives any output from the
inferior debugger in the form `\fIprefix\fR \fIcommand\fR', it will
interpret \fIcommand\fR as if it had been entered at the debugger
prompt.  \fIprefix\fR is a user-defined string, for example `\fBddd:
\fR'.
.PP
Suppose you want to define a command `\fBgd\fR' that serves as
abbreviation for `\fBgraph display\fR'.  All the command \fBgd\fR has
to do is to issue a string
.br
.sp
  \fBddd: graph display \fIargument\fR
.sp
.br
where \fIargument\fR is the argument given to `\fBgd\fR'.  Using
\s-1GDB\s+1, this can be achieved using the \fBecho\fR command.  In
your \fB$HOME/.gdbinit\fR file, insert the lines
.br
.sp
  \fBdefine gd
    echo ddd: graph display $arg0\\n
  end\fR
.sp
.br
To complete the setting, you must also set the
`\fBautoCommandPrefix\fR' resource to the `\fBddd: \fR' prefix you
gave in your command.  In `\fB$HOME/.ddd/init\fR', write:
.br
.sp
  \fBDdd*autoCommandPrefix: ddd:\\ \fR
.sp
.br
(Be sure to leave a space after the trailing backslash.)
.PP
Entering `\fBgd foo\fR' will now have the same effect as entering
`\fBgraph display foo\fR' at the debugger prompt.
.PP
Please note: In your commands, you should choose some other prefix
than `\fBddd: \fR'.  This is because auto-commands raise a security
problem, since arbitrary commands can be executed.  Just imagine some
malicious program issuing a string like `\fIprefix\fB shell rm -fr
$HOME\fR' when being debugged!  As a consequence, be sure to choose
your own \fIprefix\fR; it must be at least three characters long.
.\"
.\"
.\"
.\"
.\" ---------------
.SH "QUITTING DDD"
.\" ---------------
.\"
To exit \s-1DDD\s+1, select `\fBFile\(->Exit\fR'.  You may also type
the `\fBquit\fR' command at the debugger prompt or press \fBCtrl+Q\fR.
\s-1GDB\s+1 and \s-1XDB\s+1 also accept the `\fBq\fR' command or an
end-of-file character (usually \fBCtrl+D\fR).  Closing the last
\s-1DDD\s+1 window will also exit \s-1DDD\s+1.
.PP
An interrupt (\s-1\fBESC\fR\s+1 or \fBInterrupt\fR) does not exit from
\s-1DDD\s+1, but rather terminates the action of any debugger
command that is in progress and returns to the debugger command level.
It is safe to type the interrupt character at any time because the
debugger does not allow it to take effect until a time when it is
safe.
.PP
In case an ordinary interrupt does not succeed, you can also use an
abort (\fBCtrl+\\\fR or \fBAbort\fR), which sends a \s-1QUIT\s+1
signal to the inferior debugger.  Use this in emergencies only; the
inferior debugger may be left inconsistent or even exit after a
\s-1QUIT\s+1 signal.
.PP
As a last resort\(em\&if \s-1DDD\s+1 hangs, for example\(em\&, you
may also interrupt \s-1DDD\s+1 itself using an interrupt signal
(\s-1SIGINT\s+1).  This can be done by typing the interrupt character
(usually \fBCtrl+C\fR) in the shell \s-1DDD\s+1 was started from, or
by using the \s-1UNIX\s+1 `\fBkill\fR' command.  An interrupt signal
interrupts any \s-1DDD\s+1 action; the inferior debugger is
interrupted as well.  Since this interrupt signal can result in
internal inconsistencies, use this as a last resort in emergencies
only; save your work as soon as possible and restart \s-1DDD\s+1.
.\"
.\"
.\" ---------------
.SH "PERSISTENT SESSIONS"
.\" ---------------
.\"
Note: Persistent sessions are supported with \s-1GDB\s+1 running on
the local machine only.  Support for other \s-1DBX\s+1, \s-1XDB\s+1,
and \s-1JDB\s+1 is partially implemented; your mileage may vary.
.PP
If you want to interrupt your current \s-1DDD\s+1 session, you can
save its entire \s-1DDD\s+1 state in a file and restore it later.
.\"
.SS "Saving Sessions"
To save a session, select `\fBFile\(->Save Session As\fR'.  You will 
be asked for
.br
.IP \(bu 2 
a symbolic session name \fIsession\fR and
.br
.IP \(bu 2 
whether to include a core dump of the debugged program.
Including a core dump is necessary for restoring memory contents and
the current execution position.
.PP
After clicking on `\fBSave\fR', the session is saved in 
`\fB$HOME/.ddd/sessions/\fIsession\fR'.
.PP
After saving the current state as a session, the session becomes
\fIactive\fR.  This means that \s-1DDD\s+1 state will be saved 
as session defaults:
.br
.IP \(bu 2
User options will be saved in
`\fB$HOME/.ddd/sessions/\fIsession\fB/init\fR' instead of
`\fB$HOME/.ddd/init\fR'; see `\fBSaving Options\fR', below, for details.
.IP \(bu 2
The \s-1DDD\s+1 command history will be saved in
`\fB$HOME/.ddd/sessions/\fIsession\fB/history\fR' instead of
`\fB$HOME/.ddd/history\fR'; see `\fBEntering Commands\fR', above, for
details.
.PP
To make the current session inactive, open the \fIdefault session\fR
named `\fB[None]\fR'; see below for details on opening sessions.
.PP
If your program is running, or if you have opened a core file,
\s-1DDD\s+1 can include a core file in the session such that the
debuggee data will be restored when re-opening it.  To get a core
file, \s-1DDD\s+1 typically must kill the debuggee.  This means that
you cannot resume program execution after saving a session.  Depending
on your architecture, other options for getting a core file may also
be available.
.PP
.PSPIC ./PICS/ddd-save-session.ps 15.3cm
.PP
If a core file is \fInot\fR to be included in the session, \s-1DDD\s+1
data displays are saved as \fIdeferred\fR; that is, they will be
restored as soon as program execution reaches the scope in which they
were created.
.\"
.\"
.SS "Opening Sessions"
.\"
To resume a previously saved session, select `\fBFile\(->Open
Session\fR' and choose a session name from the list.  After clicking
on `\fBOpen\fR', the entire \s-1DDD\s+1 state will be restored from
the given session.
.PP
The session named `\fB[None]\fR' is the \fIdefault session\fR which is
active when starting \s-1DDD\s+1.  To save options for default
sessions, open the default session and save options; see `\fBSaving
Options\fR' below for details.
.PP
.PSPIC ./PICS/ddd-open-session.ps 15.3cm
.PP
If a the restored session includes a core dump, the program being
debugged will be in the same state at the time the session was saved;
in particular, you can examine the program data.  However, you will
not be able to resume program execution since the environment (open
files, resources, etc.) will be lost.  However, you can restart the
program, re-using the restored breakpoints and data displays.
.PP
Opening sessions also restores command definitions, buttons, display
shortcuts and the source tab width.  This way, you can maintain a
different set of definitions for each session.
.\"
.\"
.SS "Deleting Sessions"
.\"
To delete sessions that are no longer needed, select `\fBFile\(->Open
Session\fR' or `\fBFile\(->Save Session\fR'.  Select the sessions you
want to delete and click on `\fBDelete\fR'.
.PP
The default session cannot be deleted.
.\"
.\"
.SS "Starting DDD with a Session"
.\"
To start-up \s-1DDD\s+1 with a given session named \fIsession\fR
instead of the default session, use
.sp
.br
  \fBddd\ \-\-session\ \fIsession\fR
.br
.sp
There is also a shortcut that opens the session \fIsession\fR and also
invokes the inferior debugger on an executable named \fIsession\fR (in
case \fIsession\fR cannot be opened):
.sp
.br
  \fBddd\ =\fIsession\fR
.br
.sp
There is no need to give further command-line options when restarting
a session, as they will be overridden by the options saved in the
session.
.\"
.\"
.\" ---------------
.SH "INTEGRATING DDD"
.\" ---------------
.\"
You can run \s-1DDD\s+1 as an inferior debugger in other debugger
front-ends, combining their special abilities with those of
\s-1DDD\s+1.
.\"
.\"
.SS "General Information"
.\"
To have \s-1DDD\s+1 run as an inferior debugger in other front-ends,
set up your debugger front-end such that `\fBddd \-\-tty\fR' is
invoked instead of the inferior debugger.  When \s-1DDD\s+1 is
invoked using the `\fB\-\-tty\fR' option, it enables its
\fI\s-1TTY\s+1 interface\fR, taking additional debugger commands from
standard input and forwarding debugger output to standard output, just
as if the inferior debugger had been invoked directly.  All remaining
\s-1DDD\s+1 functionality stays unchanged.
.PP
In case your debugger front-end uses the \s-1GDB\s+1
`\fB\-fullname\fR' option to have \s-1GDB\s+1 report source code
positions, the `\fB\-\-tty\fR' option is not required.  \s-1DDD\s+1
recognizes the `\fB\-fullname\fR' option, finds that it has been
invoked from a debugger front-end and automatically enables
the \s-1TTY\s+1 interface.
.PP
You may also invoke `\fBddd \-\-tty\fR' directly, entering
\s-1DDD\s+1 commands from your \s-1TTY\s+1, or use \s-1DDD\s+1 as
the end of a pipe, controlled by a remote program.  Be aware, however,
that the \s-1TTY\s+1 interface does not support line editing and
command completion and that \s-1DDD\s+1 exits as soon as it detects
an \s-1EOF\s+1 condition on its standard input.  Also, do not try to
run \s-1DDD\s+1 with \s-1DDD\s+1 as inferior debugger.
.PP
Using \s-1DDD\s+1 in \s-1TTY\s+1 mode automatically disables some
\s-1DDD\s+1 windows, because it is assumed that their facilities are 
provided by the remote program:
.IP \(bu 2 
If \s-1DDD\s+1 is invoked with the `\fB\-\-tty\fR' option, the
debugger console is initially disabled, as its facilities are supposed
to be provided by the integrating front-end.
.IP \(bu 2
If \s-1DDD\s+1 is invoked with the `\fB\-fullname\fR' option, the
debugger console and the source window are initially disabled, as their
facilities are supposed to be provided by the integrating front-end.
.PP
In case of need, you can use the `\fBView\fR' menu to re-enable these
windows.
.\"
.\"
.SS "Using DDD with GNU Emacs"
.\"
Use `\fBM-x gdb\fR' or `\fBM-x dbx\fR' to start a debugging session.
At the prompt, enter `\fBddd \-\-tty\fR', followed by
`\fB\-\-dbx\fR' or `\fB\-\-gdb\fR', if required, and the name of the
program to be debugged.  Proceed as usual.
.\"
.\"
.SS "Using DDD with XEmacs"
.\"
Set the variable \fBgdb-command-name\fR to \fB"ddd"\fR, by inserting
the following line in your \fB$HOME/.emacs\fR file or evaluating it by
pressing \s-1\fBESC\fR\s+1 \s-1\fB:\fR\s+1\fR (\s-1\fBESC\fR\s+1
\s-1\fBESC\fR\s+1 for XEmacs 19.13 and earlier):
.br
.sp
  \fB(setq gdb-command-name "ddd")\fR
.sp
.br
Use `\fBM-x gdb\fR' or `\fBM-x gdbsrc\fR' 
to start a debugging session.  Proceed as usual.
.\"
.SS "Using DDD with XXGDB"
.\"
Invoke \fBxxgdb\fR as
.br
.sp
  \fBxxgdb \-db_name ddd \-db_prompt '(gdb) '
.sp
.br
.\"
.\"
.\" ---------------
.SH "USING DDD WITH LESSTIF"
.\" ---------------
.\"
\s-1DDD\s+1 2.1.1 and later include a number of hacks that make
\s-1DDD\s+1 run with \fILessTif,\fR a free Motif clone, without loss
of functionality.  Since a \s-1DDD\s+1 binary may be dynamically
bound and used with either an OSF/Motif or LessTif library, these
\fIlesstif hacks\fR can be enabled and disabled at run time.
.PP
Whether the \fIlesstif hacks\fR are included at run-time depends on
the setting of the `\fBlessTifVersion\fR' resource.
`\fBlessTifVersion\fR' indicates the LessTif version against which
\s-1DDD\s+1 is linked.  For LessTif version \fIx.y\fR, its value is
\fIx\fR multiplied by 1000 plus \fIy\fR\(em\&for instance, the value
\fB95\fR stands for LessTif 0.95 and the value \fB1000\fR stands for
LessTif 1.0.  To specify the version number of the LessTif library at
\s-1DDD\s+1 invocation, you can also use the option
`\fB\-\-lesstif-version\fR \fIversion\fR'.
.PP
The default value of the `\fBlessTifVersion\fR' resource is derived
from the LessTif library \s-1DDD\s+1 was compiled against (or
\fB1000\fR when compiled against OSF/Motif).  Hence, you normally
don't need to worry about the value of this resource.  However, if you
use a dynamically linked \s-1DDD\s+1 binary with a library other
than the one \s-1DDD\s+1 was compiled against, you must specify the
version number of the library using this resource.  (Unfortunately,
\s-1DDD\s+1 cannot detect this at run-time.)
.PP
Here are a few scenarios to illustrate this scheme:
.IP \(bu 2
Your \s-1DDD\s+1 binary was compiled against OSF/Motif, but you use
a LessTif 0.85 dynamic library instead.  Invoke \s-1DDD\s+1 with
`\fB\-\-lesstif-version 85\fR'.
.IP \(bu 2
Your \s-1DDD\s+1 binary was compiled against LessTif, but you use
a OSF/Motif dynamic library instead.    Invoke \s-1DDD\s+1 with
`\fB\-\-lesstif-version 1000\fR'.
.IP \(bu 2
Your \s-1DDD\s+1 binary was compiled against LessTif 0.85, and you
have upgraded to LessTif 0.90.  Invoke \s-1DDD\s+1 with
`\fB\-\-lesstif-version 90\fR'.
.PP
To find out the LessTif or OSF/Motif version \s-1DDD\s+1 was
compiled against, invoke \s-1DDD\s+1 with the
`\fB\-\-configuration\fR' option.
.PP
In the \s-1DDD\s+1 source, LessTif-specific hacks are controlled by
the string `\fBlesstif_version\fR'.
.\"
.\"
.\" ---------------
.SH "REMOTE DEBUGGING"
.\" ---------------
.\"
It is possible to have the inferior debugger run on a remote
\s-1UNIX\s+1 host.  This is useful when the remote host has a slow
network connection or when \s-1DDD\s+1 is available on the local
host only.
.PP
Furthermore, the inferior debugger may support debugging a program on
a remote host.  This is useful when the inferior debugger is not
available on the remote host\(em\&for instance, because the remote
system does not have a general purpose operating system powerful
enough to run a full-featured debugger.
.\"
.\"
.SS "Using DDD with a Remote Debugger"
.\"
In order to run the inferior debugger on a remote host, you need
`\fBremsh\fR' (called `\fBrsh\fR' on \s-1BSD\s+1 systems) access on
the remote host.
.PP
To run the debugger on a remote host \fIhostname\fR, invoke \s-1DDD\s+1 as
.sp
.br
  \fBddd\ \-\-host \fIhostname\fB \fIremote-program\fR
.br
.sp
If your remote  \fIusername\fR differs from the local username, use
.sp
.br
  \fBddd\ \-\-host \fIhostname\fB\ \-\-login \fIusername\fB\c
 \fIremote-program\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-host \fIusername\fB@\fIhostname\fB\ \fIremote-program\fR
.br
.sp
instead.
.PP
There are a few \fIcaveats\fR in remote mode:
.IP \(bu 2
The remote debugger is started in your remote home directory.  Hence,
you must specify an absolute path name for \fIremote-program\fR (or a
path name relative to your remote home directory).  Same applies to
remote core files.  Also, be sure to specify a remote process id when
debugging a running program.
.br
.IP \(bu 2
The remote debugger is started non-interactively.  Some \s-1DBX\s+1
versions have trouble with this.  If you don't get a prompt from the
remote debugger, use the `\fB\-\-rhost\fR' option instead of
`\fB\-\-host\fR'.  This will invoke the remote debugger via an
interactive shell on the remote host, which may lead to better
results.
.br
Note: using `\fB\-\-rhost\fR', \s-1DDD\s+1 invokes the inferior
debugger as soon as a shell prompt appears.  The first output on the
remote host ending in a space character or `\fB>\fR' and not followed
by a newline is assumed to be a shell prompt.  If necessary, adjust
your shell prompt on the remote host.
.br
.IP \(bu 2
To run the remote program, \s-1DDD\s+1 invokes an `\fBxterm\fR' terminal
emulator on the remote host, giving your current `\fBDISPLAY\fR'
environment variable as address.  If the remote host cannot invoke
`\fBxterm\fR', or does not have access to your X display, start
\s-1DDD\s+1 with the `\fB\-\-no-exec-window\fR' option.  The program
input/output will then go through the \s-1DDD\s+1 debugger console.
.br
.IP \(bu 2
In remote mode, all sources are loaded from the remote host; file
dialogs scan remote directories.  This may result in somewhat slower
operation than normal.
.br
.IP \(bu 2
To help you find problems due to remote execution, run \s-1DDD\s+1
with the `\fB\-\-trace\fR' option.  This prints the shell commands
issued by \s-1DDD\s+1 on standard error.
.br
.IP \(bu 2
See also the `\fBrshCommand\fR' resource, below.
.\"
.\"
.SS "Using DDD with a Remote Program"
.\"
The \s-1GDB\s+1 debugger allows you to run the \fIdebugged program\fR
on a remote machine (called \fIremote target\fR), while \s-1GDB\s+1
runs on the local machine.
.PP
The section `\fBRemote debugging\fR' in the \s-1GDB\s+1 documentation
contains all the details.  Basically, the following steps are required:
.IP \(bu 2
Transfer the executable to the remote target.
.IP \(bu 2
Start `\fBgdbserver\fR' on the remote target.
.IP \(bu 2
Start \s-1DDD\s+1 using \s-1GDB\s+1 on the local machine, and load the same
executable using the '\fBfile\fR' command.
.IP \(bu 2
Attach to the remote `\fBgdbserver\fR' using the '\fBtarget remote\fR'
command.
.PP
The local `\fB.gdbinit\fR' file is useful for setting up directory
search paths, etc.
.PP
Of course, you can also combine \s-1DDD\s+1 remote mode and
\s-1GDB\s+1 remote mode, running \s-1DDD\s+1, \s-1GDB\s+1, and the
debugged program each on a different machine.
.\"
.\"
.\" ---------------
.SH "ROOT DEBUGGING"
.\" ---------------
.\"
Sometimes, you may require to debug programs with root privileges, but
without actually logging in as root.  This is usually done by
installing the debugger \fIsetuid root\fR, that is, having the
debugger run with root privileges.  For security reasons, you cannot
install \s-1DDD\s+1 as a setuid program; \s-1DDD\s+1 invokes shell
commands and even shell scripts, such that all known problems of
setuid shell scripts apply.  Instead, you should invoke \s-1DDD\s+1
such that a \fIsetuid\fR copy of the inferior debugger is used.
.PP
Here is an example.  Have a \fIsetuid root\fR copy of \s-1GDB\s+1
installed as `\fBrootgdb\fR'.  Then invoke
.sp
.br
  \fBddd\ \-\-debugger rootgdb\fR
.br
.sp
to debug programs with root privileges.
.PP
Since a program like `\fBrootgdb\fR' grants root privileges to any
invoking user, you should give it very limited access.
.\"
.\"
.\"
.\" ---------------
.SH "RESOURCES"
.\" ---------------
.\"
\s-1DDD\s+1 understands all of the core X Toolkit resource names and
classes.  The following resources are specific to \s-1DDD\s+1.
.\"
.\"
.SS "Setting DDD Fonts"
.\"
\s-1DDD\s+1 uses the following resources to set up its fonts:
.TP
.B "defaultFont (\fPclass\fR Font)"
The default \s-1DDD\s+1 font to use for labels, menus, buttons, etc.
The font is specified as an X font spec, where the initial
'\fIFoundry\fB-\fR' specification may be omitted, as well as any
specification after `\fIFamily\fR'.
Default value is `\fBhelvetica-bold\fR'.
.sp
.br
To set the default \s-1DDD\s+1 font to, say,
\fBhelvetica medium\fR, insert a line
.sp
.br
  \fBDdd*defaultFont: helvetica-medium\fR
.br
.sp
in your `\fB$HOME/.ddd/init\fR' file.
.TP
.B "defaultFontSize  (\fPclass\fR FontSize)"
The size of the default \s-1DDD\s+1 font, in 1\(f/10 points.  This
resource overrides any font size specification in the
`\fBdefaultFont\fR' resource (see above).  The default value is
\fB120\fR for a 12.0 point font.
.TP
.B "variableWidthFont (\fPclass\fR Font)"
The variable width \s-1DDD\s+1 font to use for help texts and messages.
The font is specified as an X font spec, where the initial
'\fIFoundry\fB-\fR' specification may be omitted, as well as any
specification after `\fIFamily\fR'.
Defaults to `\fBhelvetica-medium-r\fR'.
.sp
.br
To set the variable width \s-1DDD\s+1 font family to, say,
\fBtimes\fR, insert a line
.sp
.br
  \fBDdd*fixedWidthFont: times-medium\fR
.br
.sp
in your `\fB$HOME/.ddd/init\fR' file.
.TP
.B "variableWidthFontSize  (\fPclass\fR FontSize)"
The size of the variable width \s-1DDD\s+1 font, in 1\(f/10 points.
This resource overrides any font size specification in the
`\fBvariableWidthFont\fR' resource (see above).  The default value is
\fB120\fR for a 12.0 point font.
.TP
.B "fixedWidthFont (\fPclass\fR Font)"
The fixed width \s-1DDD\s+1 font to use for source code, the
debugger console, text fields, data displays, and the execution
window.
The font is specified as an X font spec, where the initial
'\fIFoundry\fB-\fR' specification may be omitted, as well as any
specification after `\fIFamily\fR'.
Defaults to `\fBlucidatypewriter-medium\fR'.
.sp
.br
To set the fixed width \s-1DDD\s+1 font family to, say,
\fBcourier\fR, insert a line
.sp
.br
  \fBDdd*fixedWidthFont: courier-medium\fR
.br
.sp
in your `\fB$HOME/.ddd/init\fR' file.
.TP
.B "fixedWidthFontSize  (\fPclass\fR FontSize)"
The size of the fixed width \s-1DDD\s+1 font, in 1\(f/10 points.
This resource overrides any font size specification in the
`\fBfixedWidthFont\fR' resource (see above).  The default value is
\fB120\fR for a 12.0 point font.
.PP
As all font size resources have the same class (and by default the
same value), you can easily change the default \s-1DDD\s+1 font size
to, say, 9.0 points by inserting a line
.sp
.br
  \fBDdd*FontSize: 90\fR
.br
.sp
in your `\fB$HOME/.ddd/init\fR' file.
.PP
To find out your favorite font size, try `\fB\-\-fontsize\fR
\fISIZE\fR'.  This also sets all font sizes to \fISIZE\fR.
.PP
If you want to set the fonts of specific items, see the `\fBDdd\fR'
application defaults file for instructions.
.\"
.\"
.\"
.SS "Setting DDD Colors"
.\"
.PP
These are the most important color resources used in \s-1DDD\s+1:
.TP 30
.B Ddd*foreground:
.B black
.TP 30
.B Ddd*background:
.B grey
.TP 30
.B Ddd*XmText.background:
.B grey96
.TP 30 
.B Ddd*XmTextField.background:
.B grey96
.TP 30 
.B Ddd*GraphEdit.background:
.B grey96
.TP 30 
.B Ddd*XmList.background:
.B grey96
.TP 30 
.B Ddd*graph_edit.nodeColor:
.B black
.TP 30 
.B Ddd*graph_edit.edgeColor:
.B blue4
.TP 30 
.B Ddd*graph_edit.selectColor:
.B black
.TP 30 
.B Ddd*graph_edit.gridColor:
.B black
.TP 30 
.B Ddd*graph_edit.frameColor:
.B grey50
.TP 30 
.B Ddd*graph_edit.outlineColor:
.B grey50
.PP
You can copy and modify the appropriate resources to your
`\fB$HOME/.ddd/init\fR' file.  For colors within the data display,
things are slightly more complicated\(emsee the `\fBvslDefs\fR'
resource, below.
.\"
.\"
.\"
.SS "General Preferences"
.\"
The following resources determine \s-1DDD\s+1 general behavior.
.TP
.B "buttonTips (\fPclass\fB Tips)"
Whether button tips are enabled (`\fBon\fR', default) or
not (`\fBoff\fR').  Button tips are helpful for novices, but
may be distracting for experienced users.
.TP
.B "buttonDocs (\fPclass\fB Docs)"
Whether the display of button hints in the status line is enabled
(`\fBon\fR', default) or not (`\fBoff\fR').
.TP
.B "checkGrabs (\fPclass\fB CheckGrabs)"
When debugging a modal X application, \s-1DDD\s+1 may interrupt it
while it has grabbed the pointer, making further interaction
impossible.  If this is `\fBon\fR' (default), \s-1DDD\s+1 will check
after each interaction whether the pointer is grabbed.  If this is so,
\s-1DDD\s+1 will automatically continue execution of debugged
program.
.TP
.B "checkGrabDelay (\fPclass\fB CheckGrabDelay)"
The time to wait (in ms) after a debugger command before checking for
a grabbed pointer.  If \s-1DDD\s+1 sees some pointer event within
this delay, the pointer cannot be grabbed and an explicit check for a
grabbed pointer is unnecessary.  Default is \fB5000\fR, or 5 seconds.
.TP
.B "checkOptions (\fPclass\fB CheckOptions)"
Every \fIN\fR seconds, where \fIN\fR is the value of this resource,
\s-1DDD\s+1 checks whether the options file has changed.  Default is
\fB30\fR, which means that every 30 seconds, \s-1DDD\s+1 checks for
the options file.  Setting this resource to \fB0\fR disables checking
for changed option files.
.TP
.B "cutCopyPasteBindings (\fPclass\fB BindingStyle)"
Controls the key bindings for cut, copy, and paste operations.
.br
.RS
.IP \(bu 2
If this is `\fBMotif\fR' (default), Cut/Copy/Paste is on
\fBShift+Del\fR/\fBCtrl+Ins\fR/\fBShift+Ins\fR.  This is conformant to
the Motif style guide.
.IP \(bu 2
If this is `\fBKDE\fR', Cut/Copy/Paste is on
\fBCtrl+X\fR/\fBCtrl+C\fR/\fBCtrl+V\fR.  This is conformant to the
\s-1KDE\s+1 style guide.  Note that this means that \fBCtrl+C\fR no
longer interrupts the debuggee; use \s-1\fBESC\fR\s+1 instead.
.RE
.TP
.B "filterFiles (\fPclass\fB FilterFiles)"
If this is `\fBon\fR' (default), \s-1DDD\s+1 filters files when
opening execution files, core dumps, or source files, such that the
selection shows only suitable files.  This requires that \s-1DDD\s+1
opens each file, which may take time.  If this is `\fBoff\fR',
\s-1DDD\s+1 always presents all available files.
.TP
.B "globalTabCompletion (\fPclass\fB GlobalTabCompletion)"
If this is `\fBon\fR' (default), the \s-1\fBTAB\fR\s+1 key completes
arguments in all windows.  If this is `\fBoff\fR', the
\s-1\fBTAB\fR\s+1 key completes arguments in the debugger console
only.
.TP
.B "grabAction (\fPclass\fB grabAction)"
The action to take after having detected a grabbed mouse pointer.
This is a list of newline-separated commands.  Default is
`\fBcont\fR', meaning to continue the debuggee.  Other possible
choices include `\fBkill\fR' (killing the debuggee) or `\fBquit\fR'
(exiting \s-1DDD\s+1).
.TP
.B "grabActionDelay (\fPclass\fB grabActionDelay)"
The time to wait (in ms) before taking an action due to having
detected a grabbed pointer.  During this delay, a working dialog pops
up telling the user about imminent execution of the grab action (see
the `\fBgrabAction\fR' resource, above).  If the pointer grab is
released within this delay, the working dialog pops down and no action 
is taken.  This is done to exclude pointer grabs from sources other
than the debugged program (including \s-1DDD\s+1).  Default is
\fB10000\fR, or 10 seconds.
.TP
.B "groupIconify (\fPclass\fB GroupIconify)"
If this is `\fBon\fR', (un)iconifying any \s-1DDD\s+1 window
causes all other \s-1DDD\s+1 windows to (un)iconify as well.
Default is `\fBoff\fR', meaning that each \s-1DDD\s+1 window can
be iconified on its own.
.TP
.B "saveHistoryOnExit (\fPclass\fB SaveHistoryOnExit)"
If `\fBon\fR' (default), the command history is automatically saved
when \s-1DDD\s+1 exits.
.TP
.B "selectAllBindings (\fPclass\fB BindingStyle)"
Controls the key bindings for the select all operation.
.br
.RS
.IP \(bu 2
If this is `\fBMotif\fR', Select All on \fBShift+Ctrl+A\fR.
.IP \(bu 2
If this is `\fBKDE\fR' (default), Select All is on \fBCtrl+A\fR.  This
is conformant to the \s-1KDE\s+1 style guide.  Note that this means
that \fBCtrl+A\fR no longer moves the cursor to the beginning of a
line; use the \s-1\fBHOME\fR\s+1 key instead.
.RE
.TP
.B "splashScreen (\fPclass\fB SplashScreen)"
If `\fBon\fR' (default), show a \s-1DDD\s+1 splash screen upon
start-up.
.TP
.B "splashScreenColorKey (\fPclass\fB ColorKey)"
The color key to use for the \s-1DDD\s+1 splash screen.  Possible
values include:
.RS
.br
.IP \(bu 2
`\fBc\fR' (default) for a color visual, 
.IP \(bu 2
`\fBg\fR' for a multi-level greyscale visual,
.IP \(bu 2
`\fBg4\fR' for a 4-level greyscale visual, and
.IP \(bu 2
`\fBm\fR' for a dithered monochrome visual.
.IP \(bu 2
`\fBbest\fR' chooses the best visual available for your display.
.br
.PP
Note: if \s-1DDD\s+1 runs on a monochrome display, or if
\s-1DDD\s+1 was compiled without the \s-1XPM\s+1 library, only the
monochrome version (`\fBm\fR') can be shown.
.RE
.TP
.B "startupTips (\fPclass\fB StartupTips)"
Whether a tip of the day is to be shown at startup (`\fBon\fR',
default) or not (`\fBoff\fR').
.TP
.B "startupTipCount (\fPclass\fB StartupTipCount)"
The number \fIn\fR of the tip of the day to be shown at startup.  See
also the `\fBtip\fIn\fR' resources.
.TP
.B "suppressWarnings (\fPclass\fB SuppressWarnings)"
If `\fBon\fR', X warnings are suppressed.  This is
sometimes useful for executables that were built on a machine with a
different X or Motif configuration.  By default, this is
`\fBoff\fR'.
.TP
.B "tip\fIn\fR (\fPclass\fB Tip)"
The tip of the day numbered \fIn\fR (a string).
.TP
.B "maxUndoDepth (\fPclass\fB MaxUndoDepth)"
The maximum number of entries in the undo buffer.  This limits the
number of actions that can be undone, and the number of states that
can be shown in historic mode.  Useful for limiting \s-1DDD\s+1
memory usage.  A negative value (default) means to place no limit.
.TP
.B "maxUndoSize (\fPclass\fB MaxUndoSize)"
The maximum memory usage (in bytes) of the undo buffer.  Useful for
limiting \s-1DDD\s+1 memory usage.  A negative value means to place
no limit.  Default is \fB2000000\fR.
.TP
.B "uniconifyWhenReady (\fPclass\fB UniconifyWhenReady)"
If this is `\fBon\fR' (default), the \s-1DDD\s+1 windows are
uniconified automatically whenever \s-1GDB\s+1 becomes ready.  This
way, you can iconify \s-1DDD\s+1 during some longer operation and
have it uniconify itself as soon as the program stops.  Setting this
to `\fBoff\fR' leaves the \s-1DDD\s+1 windows iconified.
.TP
.B "valueTips (\fPclass\fB Tips)"
Whether value tips are enabled (`\fBon\fR', default) or not
(`\fBoff\fR').  Value tips affect \s-1DDD\s+1 performance and may
be distracting for some experienced users.
.TP
.B "valueDocs (\fPclass\fB Docs)"
Whether the display of variable values in the status line is enabled
(`\fBon\fR', default) or not (`\fBoff\fR').
.TP
.B "warnIfLocked (\fPclass\fB WarnIfLocked)"
Whether to warn if multiple \s-1DDD\s+1 instances are running
(`\fBon\fR') or not (`\fBoff\fR', default).
.\"
.\"
.SS "Source Window"
.\"
The following resources determine the \s-1DDD\s+1 source window.
.TP
.B "cacheGlyphImages (\fPclass\fB CacheMachineCode)"
Whether to cache (share) glyph images (`\fBon\fR') or not
(`\fBoff\fR').  Caching glyph images requires less X resources, but
has been reported to fail with Motif 2.1 on XFree86 servers.  Default
is `\fBoff\fR' for Motif 2.1 or later on Linux machines, and
`\fBon\fR' otherwise.
.TP
.B "cacheMachineCode (\fPclass\fB CacheMachineCode)"
Whether to cache disassembled machine code (`\fBon\fR', default) or
not (`\fBoff\fR').  Caching machine code requires more memory, but
makes \s-1DDD\s+1 run faster.
.TP
.B "cacheSourceFiles (\fPclass\fB CacheSourceFiles)"
Whether to cache source files (`\fBon\fR', default) or not
(`\fBoff\fR').  Caching source files requires more memory, but makes
\s-1DDD\s+1 run faster.
.TP
.B "disassemble (\fPclass\fB Disassemble)"
If this is `\fBon\fR', the source code is automatically
disassembled.  The default is `\fBoff\fR'.  See also the
`\fB\-\-disassemble\fR' and `\fB\-\-no-disassemble\fR' options,
below.
.TP
.B "displayGlyphs (\fPclass\fB DisplayGlyphs)"
If this is `\fBon\fR', the current execution position and breakpoints
are displayed as glyphs; otherwise, they are shown through characters
in the text.  The default is `\fBon\fR'.  See also the
`\fB\-\-glyphs\fR' and `\fB\-\-no-glyphs\fR' options, below.
.TP
.B "displayLineNumbers (\fPclass\fB DisplayLineNumbers)"
If this is `\fBon\fR', lines in the source text are prefixed with
their respective line number.  The default is `\fBoff\fR'.
.TP
.B "findCaseSensitive (\fPclass\fB FindCaseSensitive)"
If this is `\fBon\fR' (default), the `\fBFind\fR' commands are
case-sensitive.  Otherwise, occurrences are found regardless of case.
.TP
.B "findWordsOnly (\fPclass\fB FindWordsOnly)"
If this is `\fBon\fR' (default), the `\fBFind\fR' commands find
complete words only.  Otherwise, arbitrary occurrences are found.
.TP
.B "glyphUpdateDelay (\fPclass\fB GlyphUpdateDelay)"
A delay (in ms) that says how much time to wait before updating glyphs
while scrolling the source text.  A small value results in glyphs
being scrolled with the text, a large value disables glyphs while
scrolling and makes scrolling faster.  Default: \fB10\fR.
.TP
.B "indentCode (\fPclass\fB Indent)"
The number of columns to indent the machine code, such that there is
enough place to display breakpoint locations.  Default: \fB4\fR.
.TP
.B "indentSource (\fPclass\fB Indent)"
The number of columns to indent the source code, such that there is
enough place to display breakpoint locations.  Default: \fB0\fR.
.TP
.B "indentScript (\fPclass\fB Indent)"
The minimum indentation for script languages, such as Perl and Python.
Default: \fB4\fR.
.TP
.B "lineNumberWidth (\fPclass\fB LineNumberWidth)"
The number of columns to use for line numbers (if displaying line
numbers is enabled).  Line numbers wider than this value extend into
the breakpoint space.  Default: \fB4\fR.
.TP
.B "linesAboveCursor (\fPclass\fB LinesAboveCursor)"
The minimum number of lines to show before the current location.
Default is \fB2\fR.
.TP
.B "linesBelowCursor (\fPclass\fB LinesBelowCursor)"
The minimum number of lines to show after the current location.
Default is \fB3\fR.
.TP
.B "maxDisassemble (\fPclass\fB MaxDisassemble)"
Maximum number of bytes to disassemble (default: \fB256\fR).  If this
is zero, the entire current function is disassembled.
.TP
.B "maxGlyphs (\fPclass\fB MaxGlyphs)"
The maximum number of glyphs to be displayed (default: \fB10\fR).
Raising this value causes more glyphs to be allocated, possibly
wasting resources that are never needed.
.TP
.B "sourceEditing (\fPclass\fB SourceEditing)"
If this is `\fBon\fR', the displayed source code becomes editable.
This is an experimental feature and may become obsolete in future
\s-1DDD\s+1 releases.  Default if `\fBoff\fR'.
.TP
.B "tabWidth (\fPclass\fB TabWidth)"
The tab width used in the source window (default: \fB8\fR)
.TP
.B "useSourcePath (\fPclass\fB UseSourcePath)"
If this is `\fBoff\fR' (default), the inferior debugger refers to
source code locations only by their base names.  If this is
`\fBon\fR' (default), \s-1DDD\s+1 uses the full source code paths.
.\"
.\"
.SS "Window Creation and Layout"
.\"
The following resources determine \s-1DDD\s+1 window creation and
layout as well as the interaction with the X window manager.
.TP
.B "autoRaiseTool (\fPclass\fB AutoRaiseTool)"
If `\fBon\fR' (default), \s-1DDD\s+1 will always keep the command
tool on top of other \s-1DDD\s+1 windows.  If this setting
interferes with your window manager, or if your window manager keeps
the command tool on top anyway, set this resource to `\fBoff\fR'.
.TP
.B "autoRaiseMenu (\fPclass\fB AutoRaiseMenu)"
If `\fBon\fR' (default), \s-1DDD\s+1 will always keep the pull down
menu on top of the \s-1DDD\s+1 main window.  If this setting
interferes with your window manager, or if your window manager does
not auto-raise windows, set this resource to `\fBoff\fR':
.br
.sp
  \fBDdd*autoRaiseMenu: off\fR
.sp
.br
.TP
.B "colorWMIcons (\fPclass\fB ColorWMIcons)"
If `\fBon\fR' (default), \s-1DDD\s+1 uses multi-color icons.  If
your window manager has trouble with multi-color icons, set this
resource to `\fBoff\fR' and \s-1DDD\s+1 will use black-and-white
icons instead.
.TP
.B "decorateTool (\fPclass\fB Decorate)"
This resource controls the decoration of the command tool.
.RS
.br
.IP \(bu 2
If this is `\fBoff\fR', the command tool is created as a
\fItransient window\fR.  Several window managers keep transient
windows automatically on top of their parents, which is appropriate
for the command tool.  However, your window manager may be configured
not to decorate transient windows, which means that you cannot easily
move the command tool around.
.IP \(bu 2
If this is `\fBon\fR', \s-1DDD\s+1 realizes the command tool as a
\fItop-level window\fR.  Such windows are always decorated by the
window manager.  However, top-level windows are not automatically kept
on top of other windows, such that you may wish to set the
`\fBautoRaiseTool\fR' resource, too.
.IP \(bu 2
If this is `\fBauto\fR' (default), \s-1DDD\s+1 checks whether the
window manager decorates transients.  If yes, the command tool is
realized as a transient window (as in the `\fBoff\fR' setting); if no,
the command tool is realized as a top-level window (as in the
`\fBon\fR' setting).  Hence, the command tool is always decorated
using the \*(lqbest\*(rq method, but the extra check takes some time.
.br
.RE
.PP
.TP
.B "openDataWindow (\fPclass\fB Window)"
If `\fBoff\fR' (default), the data window is closed upon start-up.
.TP
.B "openDebuggerConsole (\fPclass\fB Window)"
If `\fBoff\fR', the debugger console is closed upon start-up.
.TP
.B "openSourceWindow (\fPclass\fB Window)"
If `\fBoff\fR', the source window is closed upon start-up.
.TP
.B "separateDataWindow (\fPclass\fB Separate)"
If `\fBon\fR', the data window and the debugger console are realized
in different top-level windows.  If `\fBoff\fR' (default), the data
window is attached to the debugger console.  See also the
`\fB\-\-attach-windows\fR' and `\fB\-\-attach-data-window\fR'
options, below.
.TP
.B "separateExecWindow (\fPclass\fB Separate)"
If `\fBon\fR', the debugged program is executed in a separate
execution window.  If `\fBoff\fR' (default), the debugged program is
executed in the console window.  See also the `\fB\-\-exec\-window\fR'
and `\fB\-\-no\-exec\-window\fR' options, below.
.TP
.B "separateSourceWindow (\fPclass\fB Separate)"
If `\fBon\fR', the source window and the debugger console are
realized in different top-level windows.  If `\fBoff\fR' (default),
the source window is attached to the debugger console.  See also the
`\fB\-\-attach-windows\fR' and `\fB\-\-attach-source-window\fR'
options, below.
.TP
.B "statusAtBottom (\fPclass\fB StatusAtBottom)"
If `\fBon\fR' (default), the status line is placed at the bottom of
the \s-1DDD\s+1 source window.  If `\fBoff\fR', the status line is
placed at the top of the \s-1DDD\s+1 source window (as in \s-1DDD\s+1 1.x).
See also the `\fB\-\-status-at-bottom\fR' and
`\fB\-\-status-at-top\fR' options, below.
.TP
.B "stickyTool (\fPclass\fB StickyTool)"
If `\fBon\fR' (default), the command tool automatically follows
every movement of the source window.  Whenever the source window is
moved, the command tool is moved by the same offset such that its
position relative to the source window remains unchanged.  If
`\fBoff\fR', the command tool does not follow source window
movements.
.TP
.B "transientDialogs (\fPclass\fB TransientDialogs)"
If `\fBon\fR' (default), all dialogs are created as transient
windows\(em\&that is, they always stay on top of the main
\s-1DDD\s+1 windows, and they iconify with it.  If `\fBoff\fR', the
important selection dialogs, such as the breakpoint and display
editors, are created as top-level windows on their own, and may be
obscured by the \s-1DDD\s+1 main windows.
.PP
.\"
.\"
.\"
.SS "Debugger Settings"
.\"
The following resources determine the inferior debugger.
.TP
.B "autoCommands (\fPclass\fB AutoCommands)"
If this is `\fBon\fR' (default), each line output by the inferior
debugger beginning with the value of the `\fBautoCommandPrefix\fR'
resource (see below) will be interpreted as \s-1DDD\s+1 command and
executed.  Useful for user-defined commands; see `\fBUSER-DEFINED
COMMANDS\fR', above.
.TP
.B "autoCommandPrefix (\fPclass\fB AutoCommandPrefix)"
The prefix for auto-commands.  By default, an empty string, meaning to
generate a new prefix for each \s-1DDD\s+1 session.  If this is set
to `\fBddd: \fR', for example, each \s-1GDB\s+1 output in the form
`\fBddd: \fIcommand\fR' will cause \s-1DDD\s+1 to execute
\fIcommand\fR.
.TP
.B "autoDebugger (\fPclass\fB AutoDebugger)"
If this is `\fBon\fR' (default), \s-1DDD\s+1 will attempt to
determine the debugger type from its arguments, possibly overriding
the `\fBdebugger\fR' resource (see below).  If this is `\fBoff\fR',
\s-1DDD\s+1 will invoke the debugger specified by the
`\fBdebugger\fR' resource regardless of \s-1DDD\s+1 arguments.
.TP
.B "blockTTYInput (\fPclass\fB BlockTTYInput)"
Whether \s-1DDD\s+1 should block when reading data from the inferior
debugger via the pseudo-tty interface.  Some systems \fIrequire\fR
this, such as Linux with libc 5.4.33 and earlier; set it to
`\fBon\fR'.  Some other systems \fIprohibit\fR this, such as Linux
with GNU libc 6 and later; set it to `\fBoff\fR'.  The value
`\fBauto\fR' (default) will always select the \*(lqbest\*(rq choice
(that is, the best choice known to the \s-1DDD\s+1 developers).
.TP
.B "dbxInitCommands (\fPclass\fB InitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-1DBX\s+1.  By default, it is empty.
.br
Do not use this resource to customize \s-1DBX\s+1; instead, use a
personal `\fB$HOME/.dbxinit\fR' or `\fB$HOME/.dbxrc\fR' file.  See
your \s-1DBX\s+1 documentation for details.
.TP
.B "dbxSettings (\fPclass\fB Settings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-1DBX\s+1.  By default, it is empty.
.TP
.B "debugger (\fPclass\fB Debugger)"
The type of the inferior debugger to invoke (`\fBgdb\fR', `\fBdbx\fR',
`\fBxdb\fR', `\fBjdb\fR', `\fBpydb\fR', or `\fBperl\fR').  This
resource is usually set through the `\fB\-\-gdb\fR', `\fB\-\-dbx\fR',
`\fB\-\-xdb\fR', `\fB\-\-jdb\fR', `\fB\-\-pydb\fR', and
`\fB\-\-perl\fR', options; see below for details.
.TP
.B "debuggerCommand (\fPclass\fB DebuggerCommand)"
The name under which the inferior debugger is to be invoked.  If this
string is empty, the debugger type (`\fBdebugger\fR' resource) is
used.  This resource is usually set through the `\fB\-\-debugger\fR'
option; see below for details.
.TP
.B "debuggerHost (\fPclass\fB DebuggerHost)"
The host where the inferior debugger is to be executed; an empty
string (default) means the local host.  See the `\fB\-\-host\fR'
option, below, and `\fBREMOTE DEBUGGING\fR', above.
.TP
.B "debuggerHostLogin (\fPclass\fB DebuggerHostLogin)"
The login user name on the remote host; an empty string (default)
means using the local user name.  See the `\fB\-\-login\fR'
option, below, and `\fBREMOTE DEBUGGING\fR', above.
.TP
.B "debuggerRHost (\fPclass\fB DebuggerRHost)"
The host where the inferior debugger is to be executed; an empty
string (default) means to use the `\fBdebuggerHost\fR' resource.  In
contrast to `\fBdebuggerHost\fR', using this resource causes
\s-1DDD\s+1 to login interactively to the remote host and invoke the
inferior debugger from the remote shell.  See also the
`\fB\-\-rhost\fR' option, below, and `\fBREMOTE DEBUGGING\fR', above.
.TP
.B "fullNameMode (\fPclass\fB TTYMode)"
If this is `\fBon\fR', \s-1DDD\s+1 reports the current source
position on standard output in \s-1GDB\s+1 `\fB\-fullname\fR'
format.  As a side effect, the source window is disabled by default.
See also the `\fB\-\-fullname\fR' option, below.
.TP
.B "gdbInitCommands (\fPclass\fB InitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-1GDB\s+1.  As a side-effect, all settings
specified in this resource are considered fixed and cannot be changed
through the \s-1GDB\s+1 settings panel, unless preceded by white
space.  By default, the `\fBgdbInitCommands\fR' resource contains some
settings vital to \s-1DDD\s+1:
.sp
.br
  \fBDdd*gdbInitCommands: \\
  set height 0\\n\\
  set width 0\\n\\
   set verbose off\\n\\
  set prompt (gdb) \\n\fR
.br
.sp
While the `\fBset height\fR', `\fBset width\fR', and `\fBset
prompt\fR' settings are fixed, the `\fBset verbose\fR' settings can be
changed through the \s-1GDB\s+1 settings panel (although being reset
upon each new \s-1DDD\s+1 invocation).
.br
Do not use this resource to customize \s-1GDB\s+1; instead, use a
personal `\fB$HOME/.gdbinit\fR' file.  See your \s-1GDB\s+1
documentation for details.
.TP
.B "gdbSettings (\fPclass\fB Settings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-1GDB\s+1.  Its default value is
.sp
.br
  \fBDdd*gdbSettings: \\
  set print asm-demangle on\\n\fR
.br
.sp
This resource is used to save and restore the debugger settings.
.TP
.B "jdbInitCommands (\fPclass\fB InitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-1JDB\s+1.  This resource may be used to customize
\s-1JDB\s+1.  By default, it is empty.
.TP
.B "jdbSettings (\fPclass\fB Settings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-1JDB\s+1.  By default, it is empty.
.sp
This resource is used by \s-1DDD\s+1 to save and restore \s-1JDB\s+1
settings.
.TP
.B "openSelection (\fPclass\fB OpenSelection)"
If this is `\fBon\fR', \s-1DDD\s+1 invoked without argument checks
whether the current selection or clipboard contains the file name or
\s-1URL\s+1 of an executable program.  If this is so, \s-1DDD\s+1
will automatically open this program for debugging.  If this resource
is `\fBoff\fR' (default), \s-1DDD\s+1 invoked without arguments will
always start without a debugged program.
.TP
.B "perlInitCommands (\fPclass\fB InitCommands)"
This string contains a list of newline-separated commands that are
initially sent to the Perl debugger.  By default, it is empty.
.sp
This resource may be used to customize the Perl debugger.
.TP
.B "pydbSettings (\fPclass\fB Settings)"
This string contains a list of newline-separated commands that are
also initially sent to the Perl debugger.  By default, it is empty.
.sp
This resource is used by \s-1DDD\s+1 to save and restore Perl
debugger settings.
.TP
.B "pydbInitCommands (\fPclass\fB InitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-1PYDB\s+1.  By default, it is empty.
.br
This resource may be used to customize \s-1PYDB\s+1.
.TP
.B "pydbSettings (\fPclass\fB Settings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-1PYDB\s+1.  By default, it is empty.
.sp
This resource is used by \s-1DDD\s+1 to save and restore \s-1PYDB\s+1
settings.
.TP
.B "questionTimeout (\fPclass\fB QuestionTimeout)"
The time (in seconds) to wait for the inferior debugger to reply.
Default is \fB10\fR.
.TP
.B "rHostInitCommands (\fPclass\fB RHostInitCommands)"
These commands are initially executed in a remote interactive
session, using the `\fB\-\-rhost\fR' option.  By default, it sets up
the remote terminal such that it suits \s-1DDD\s+1:
.sp
.br
  \fBDdd*rHostInitCommands: stty \-echo \-onlcr\fR
.br
.sp
You may add other commands here\(em\&for instance, to set the
executable path or to invoke a suitable shell.
.TP
.B "sourceInitCommands (\fPclass\fB SourceInitCommands)"
If `\fBon\fR' (default), \s-1DDD\s+1 writes all \s-1GDB\s+1
initialization commands into a temporary file and makes \s-1GDB\s+1
read this file, rather than sending each initialization command
separately.  This results in faster startup (especially if you have
several user-defined commands).  If `\fBoff\fR', \s-1DDD\s+1 makes
\s-1GDB\s+1 process each command separately.
.TP
.B "synchronousDebugger (\fPclass\fB SynchronousDebugger)"
If `\fBon\fR', X events are not processed while the debugger is
busy.  This may result in slightly better performance on
single-processor systems.  See also the `\fB\-\-sync-debugger\fR'
option, below.
.TP
.B "terminateOnEOF (\fPclass\fB TerminateOnEOF)"
If `\fBon\fR', \s-1DDD\s+1 terminates the inferior debugger when
\s-1DDD\s+1 detects an EOF condition (that is, as soon as the
inferior debugger closes its output channel).  This was the default
behavior in \s-1DDD\s+1 2.x and earlier.  If `\fBoff\fR' (default),
\s-1DDD\s+1 takes no special action.
.TP
.B "ttyMode (\fPclass\fB TTYMode)"
If `\fBon\fR', enable \s-1TTY\s+1 interface, taking additional
debugger commands from standard input and forwarding debugger output
on standard output.  As a side effect, the debugger console is
disabled by default.  See also the `\fB\-\-tty\fR' and
`\fB\-\-fullname\fR' options, below.
.TP
.B "useTTYCommand (\fPclass\fB UseTTYCommand)"
If `\fBon\fR', use the \s-1GDB\s+1 `\fBtty\fR' command for
redirecting input/output to the separate execution window.  If
`\fBoff\fR', use explicit redirection through shell redirection
operators `\fB<\fR' and `\fB>\fR'.  The default is `\fBoff\fR'
(explicit redirection), since on some systems, the `\fBtty\fR' command
does not work properly on some \s-1GDB\s+1 versions.
.TP
.B "xdbInitCommands (\fPclass\fB InitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-1XDB\s+1.  By default, it is empty.
.br
Do not use this resource to customize \s-1DBX\s+1; instead, use a
personal `\fB$HOME/.xdbrc\fR' file.  See your \s-1XDB\s+1
documentation for details.
.TP
.B "xdbSettings (\fPclass\fB Settings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-1XDB\s+1.  By default, it is empty.
.PP
.\"
.\"
.\"
.SS "User-defined Buttons"
.\"
The following resources can be used to create and control tool bars and
user-defined buttons.
.TP
.B "activeButtonColorKey (\fPclass\fB ColorKey)"
The \s-1XPM\s+1 color key to use for the images of active buttons
(entered or armed).  `\fBc\fR' means color, `\fBg\fR' (default) means
grey, and `\fBm\fR' means monochrome.
.TP
.B "buttonCaptions (\fPclass\fB ButtonCaptions)"
Whether the tool bar buttons should be shown using captions
(`\fBon\fR', default) or not (`\fBoff\fR').  If neither captions nor
images are enabled, tool bar buttons are shown using ordinary labels.
See also `\fBbuttonImages\fR', below.
.TP
.B "buttonCaptionGeometry (\fPclass\fB ButtonCaptionGeometry)"
The geometry of the caption subimage within the button icons.  Default
is `\fB29\(mu7\(pl0\-0\fR'.
.TP
.B "buttonImages (\fPclass\fB ButtonImages)"
Whether the tool bar buttons should be shown using images (`\fBon\fR',
default) or not (`\fBoff\fR').  If neither captions nor images are
enabled, tool bar buttons are shown using ordinary labels.  See also
`\fBbuttonCaptions\fR', above.
.TP
.B "buttonImageGeometry (\fPclass\fB ButtonImageGeometry)"
The geometry of the image within the button icon.  Default is
`\fB25\(mu21\(pl2\(pl0\fR'.
.TP
.B "buttonColorKey (\fPclass\fB ColorKey)"
The \s-1XPM\s+1 color key to use for the images of inactive buttons
(non-entered or insensitive).  `\fBc\fR' means color, `\fBg\fR'
(default) means grey, and `\fBm\fR' means monochrome.
.TP
.B "commandToolBar (\fPclass\fB ToolBar)"
Whether the tool buttons (see the `\fBtoolButtons\fR' resource, below)
should be shown in a tool bar above the source window (`\fBon\fR') or
within the command tool (`\fBoff\fR', default).  Enabling the command
tool bar disables the command tool and vice versa.
.TP
.B "commonToolBar (\fPclass\fB ToolBar)"
Whether the tool bar buttons should be shown in one common tool bar at the
top of the common \s-1DDD\s+1 window (`\fBon\fR', default), or whether they
should be placed in two separate tool bars, one for data, and one for
source operations, as in \s-1DDD\s+1 2.x (`\fBoff\fR').
.TP
.B "consoleButtons (\fPclass\fB Buttons)"
A newline-separated list of buttons to be added under the debugger
console.  Each button issues the command given by its name.
.sp
The following characters have special meanings:
.RS
.br
.IP \(bu 2
Commands ending with '\fB...\fR' insert their name, followed by a space, in
the debugger console.
.br
.IP \(bu 2
Commands ending with a control character (that is, `\fB^\fR' followed
by a letter or `\fB?\fR') insert the given control character.
.br
.IP \(bu 2
The string `\fB()\fR' is replaced by the current contents 
of the argument field `\fB()\fR'.
.br
.IP \(bu 2
The string specified in the `\fBlabelDelimiter\fR' resource (usually
`\fB//\fR') separates the command name from the button label.  If no
button label is specified, the capitalized command will be used as
button label.
.RE
.sp
.RS
The following button names are reserved:
.TP 10
.B "Apply"
Send the given command to the debugger.
.TP 10
.B "Back"
Lookup previously selected source position.
.TP 10
.B "Clear"
Clear current command
.TP 10
.B "Complete"
Complete current command.
.TP 10
.B "Edit"
Edit current source file.
.TP 10
.B "Forward"
Lookup next selected source position.
.TP 10
.B "Make"
Invoke the `\fBmake\fR' program, using the most recently given arguments.
.TP 10
.B "Next"
Show next command
.TP 10
.B "No"
Answer current debugger prompt with `\fBno\fR'.  This button is
visible only if the debugger asks a yes/no question.
.TP 10
.B "Prev"
Show previous command
.TP 10
.B "Reload"
Reload source file.
.TP 10
.B "Yes"
Answer current debugger prompt with `\fByes\fR'.  This button is
visible only if the debugger asks a yes/no question.
.RE
.sp
.RS
.PP
The default resource value is empty\(em\&no console buttons are
created.
.PP
Here are some examples to insert into your `\fB$HOME/.ddd/init\fR' file.
These are the settings of \s-1DDD\s+1 1.x:
.sp
.br
  \fBDdd*consoleButtons: Yes\\nNo\\nbreak^C\fR
.br
.sp
This setting creates some more buttons:
.sp
.br
  \fBDdd*consoleButtons: \\
  Yes\\nNo\\nrun\\nClear\\nPrev\\nNext\\nApply\\nbreak^C\fR
.br
.sp
See also the `\fBdataButtons\fR', `\fBsourceButtons\fR' and
`\fBtoolButtons\fR' resources, below.
.RE
.sp
.TP
.B "dataButtons (\fPclass\fB Buttons)"
A newline-separated list of buttons to be added under the data display.
Each button issues the command given by its name.  See the
`\fBconsoleButtons\fR' resource, above, for details on button syntax.
.RS
.PP
The default resource value is empty\(em\&no source buttons are
created.
.RE
.TP
.B "flatToolbarButtons (\fPclass\fB FlatButtons)"
If `\fBon\fR' (default), all tool bar buttons with images or captions
are given a `flat' appearance\(em\&the 3-D border only shows up when the
pointer is over the icon.  If `\fBoff\fR', the 3-D border is shown all
the time.
.TP
.B "flatDialogButtons (\fPclass\fB FlatButtons)"
If `\fBon\fR' (default), all dialog buttons with images or captions
are given a `flat' appearance\(em\&the 3-D border only shows up when
the pointer is over the icon.  If `\fBoff\fR', the 3-D border is shown
all the time.
.TP
.B "labelDelimiter (\fPclass\fB LabelDelimiter)"
The string used to separate labels from commands and shortcuts.
Default is `\fB//\fR'.
.TP
.B "sourceButtons (\fPclass\fB Buttons)"
A newline-separated list of buttons to be added under the debugger
console.  Each button issues the command given by its name.  See the
`\fBconsoleButtons\fR' resource, above, for details on button syntax.
.RS
.PP
The default resource value is empty\(em\&no source buttons are
created.
.PP
Here are some example to insert into your `\fB$HOME/.ddd/init\fR' file.
These are the settings of \s-1DDD\s+1 1.x:
.sp
.br
  \fBDdd*sourceButtons: \\
  run\\nstep\\nnext\\nstepi\\nnexti\\ncont\\n\\
  finish\\nkill\\nup\\ndown\\n\\
  Back\\nForward\\nEdit\\ninterrupt^C\fR
.br
.sp
This setting creates some buttons which are not found on the command tool:
.sp
.br
  \fBDdd*sourceButtons: \\
  print *()\\ngraph display *()\\nprint /x ()\\n\\
  whatis ()\\nptype ()\\nwatch ()\\nuntil\\nshell\fR
.br
.sp
An even more professional setting uses customized button labels.
.sp
.br
  \fBDdd*sourceButtons: \\
  print *(()) // Print *()\\n\\
  graph display *(()) // Display *()\\n\\
  print /x ()\\n\\
  whatis () // What is ()\\n\\
  ptype ()\\n\\
  watch ()\\n\\
  until\\n\\
  shell\fR
.br
.sp
See also the `\fBconsoleButtons\fR' and `\fBdataButtons\fR' resources,
above, and the `\fBtoolButtons\fR' resource, below.
.RE
.TP
.B "toolbarsAtBottom (\fPclass\fB ToolbarsAtBottom)"
Whether source and data tool bars should be placed above source and
data, respectively (`\fBoff\fR', default), or below, as in
\s-1DDD\s+1 2.x (`\fBon\fR').  See also the
`\fB\-\-toolbars-at-bottom\fR' and `\fB\-\-toolbars-at-top\fR'
options, below.
.TP
.B "toolButtons (\fPclass\fB Buttons)"
A newline-separated list of buttons to be included in the command tool
or the command tool bar (see the `\fBcommandToolBar\fR' resource,
above).  Each button issues the command given by its name.  See the
`\fBconsoleButtons\fR' resource, above, for details on button syntax.
.RS
.PP
The default resource value is
.sp
.br
  \fBDdd*toolButtons: \\
  run\\nbreak^C\\nstep\\nstepi\\nnext\\nnexti\\n\\
  until\\nfinish\\ncont\\n\\kill\\n\\
  up\\ndown\\nBack\\nForward\\nEdit\\nMake\fR
.br
.sp
For each button, its location in the command tool must be specified
using \fBXmForm\fR constraint resources.  See the `\fBDdd\fR'
application defaults file for instructions.
.PP
If the `\fBtoolButtons\fR' resource value is empty, the command tool is
not created.
.RE
.TP
.B "toolRightOffset (\fPclass\fB Offset)"
The distance between the right border of the command tool and the
right border of the source text (in pixels).  Default is 8 pixels.
.TP
.B "toolTopOffset (\fPclass\fB Offset)"
The distance between the upper border of the command tool and the
upper border of the source text (in pixels).  Default is 8 pixels.
.TP
.B "verifyButtons (\fPclass\fB VerifyButtons)"
If `\fBon\fR' (default), verify for each button whether its command is
actually supported by the inferior debugger.  If the command is
unknown, the button is disabled.  If this resource is `\fBoff\fR', no
checking is done: all commands are accepted \*(lqas is\*(rq.
.\"
.\"
.SS "User-Defined New Display Menu"
.\"
The following resources control the user-defined `\fBNew Display\fR' menu.
.\"
.TP
.B "dbxDisplayShortcuts (\fPclass\fB DisplayShortcuts)"
A newline-separated list of display expressions to be included in the
`\fBNew Display\fR' menu for \s-1DBX\s+1.  If a line contains a label
delimiter (the string `\fB//\fR'; can be changed via the
`\fBlabelDelimiter\fR' resource), the string before the delimiter is
used as \fIexpression\fR, and the string after the delimiter is used
as label.  Otherwise, the label is `\fBDisplay \fIexpression\fR'.
Upon activation, the string `\fB()\fR' in \fIexpression\fR is replaced
by the name of the currently selected display.
.TP
.B "gdbDisplayShortcuts (\fPclass\fB DisplayShortcuts)"
A newline-separated list of display expressions to be included in the
`\fBNew Display\fR' menu for \s-1GDB\s+1.  See the description of
`\fBdbxDisplayShortcuts\fR', above.
.TP
.B "jdbDisplayShortcuts (\fPclass\fB DisplayShortcuts)"
A newline-separated list of display expressions to be included in the
`\fBNew Display\fR' menu for \s-1JDB\s+1.  See the description of
`\fBdbxDisplayShortcuts\fR', above.
.TP
.B "labelDelimiter (\fPclass\fB LabelDelimiter)"
The string used to separate labels from commands and shortcuts.
Default is `\fB//\fR'.
.TP
.B "perlDisplayShortcuts (\fPclass\fB DisplayShortcuts)"
A newline-separated list of display expressions to be included in the
`\fBNew Display\fR' menu for Perl.  See the description of
`\fBdbxDisplayShortcuts\fR', above.
.TP
.B "pydbDisplayShortcuts (\fPclass\fB DisplayShortcuts)"
A newline-separated list of display expressions to be included in the
`\fBNew Display\fR' menu for \s-1PYDB\s+1.  See the description of
`\fBdbxDisplayShortcuts\fR', above.
.TP
.B "xdbDisplayShortcuts (\fPclass\fB DisplayShortcuts)"
A newline-separated list of display expressions to be included in the
`\fBNew Display\fR' menu for \s-1XDB\s+1.  See the description of
`\fBdbxDisplayShortcuts\fR', above.
.\"
.\"
.SS "Data Display"
.\"
The following resources control the data display.
.\"
.TP
.B "align2dArrays (\fPclass\fB Align2dArrays)"
If `\fBon\fR' (default), \s-1DDD\s+1 lays out two-dimensional arrays
as tables, such that all array elements are aligned with each other.
If `\fBoff\fR', \s-1DDD\s+1 treats a two-dimensional array as an
array of one-dimensional arrays, each aligned on its own.
.TP
.B "autoCloseDataWindow (\fPclass\fB AutoClose)"
If this is `\fBon\fR' (default) and \s-1DDD\s+1 is in stacked window
mode, deleting the last display automatically closes the data window.
If this is `\fBoff\fR', the data window stays open even after deleting
the last display.
.TP
.B "bumpDisplays (\fPclass\fB BumpDisplays)"
If some display \fID\fR changes size and this resource is `\fBon\fR'
(default), \s-1DDD\s+1 assigns new positions to displays below and
on the right of \fID\fR such that the distance between displays
remains constant.  If this is `\fBoff\fR', other displays are not
rearranged.
.TP
.B "clusterDisplays (\fPclass\fB ClusterDisplays)"
If `\fBon\fR', new independent data displays will automatically be
clustered.  Default is `\fBoff\fR', meaning to leave new displays
unclustered.
.TP
.B "deleteAliasDisplays (\fPclass\fB DeleteAliasDisplays)"
If this is `\fBon\fR' (default), the `\fBUndisplay ()\fR' button also
deletes all aliases of the selected displays.  If this is `\fBoff\fR',
only the selected displays are deleted; the aliases remain, and one of
the aliases will be unsuppressed.
.TP
.B "detectAliases (\fPclass\fB DetectAliases)"
If `\fBon\fR', \s-1DDD\s+1 attempts to recognize shared data
structures.  See `\fBExamining shared data structures\fR', above, for
a discussion.  The default is `\fBoff\fR', meaning that shared data
structures are not recognized.
.TP
.B "expandRepeatedValues (\fPclass\fB ExpandRepeatedValues)"
\s-1GDB\s+1 can print repeated array elements as `\fIVALUE\fB
<repeated \fIN\fB times>\fR'.  If `\fBexpandRepeatedValues\fR' is
`\fBon\fR', \s-1DDD\s+1 will display \fIN\fR instances of
\fIVALUE\fR instead.  If `\fBexpandRepeatedValues\fR' is `\fBoff\fR'
(default), \s-1DDD\s+1 will display \fIVALUE\fR with
`\fB<\fIN\fB\(mu>' appended to indicate the repetition.
.TP
.B "hideInactiveDisplays (\fPclass\fB HideInactiveDisplays)"
If some display gets out of scope and this resource is `\fBon\fR'
(default), \s-1DDD\s+1 removes it from the data display.  If this is
`\fBoff\fR', it is simply disabled.
.TP
.B "pannedGraphEditor (\fPclass\fB PannedGraphEditor)"
The control to scroll the graph.  
.RS
.br
.IP \(bu 2
If this is `\fBon\fR', an Athena panner is used (a kind of
two-directional scrollbar).
.IP \(bu 2
If this is `\fBoff\fR' (default), two Motif scrollbars are used.
.PP
See also the `\fB\-\-scrolled-graph-editor\fR' and
`\fB\-\-panned-graph-editor\fR' options, below.
.RE
.TP
.B "paperSize (\fPclass\fB PaperSize)"
The paper size used for printing, in format \fIwidth\fR x
\fIheight\fR.  The default is A4 format, or `\fB210mm \(mu 297mm\fR'.
.TP
.B "showBaseDisplayTitles (\fPclass\fB ShowDisplayTitles)"
Whether to assign titles to base (independent) displays or not.
Default is `\fBon\fR'.
.TP
.B "showDependentDisplayTitles (\fPclass\fB ShowDisplayTitles)"
Whether to assign titles to dependent displays or not.  Default is
`\fBoff\fR'.
.TP
.B "typedAliases (\fPclass\fB TypedAliases)"
If `\fBon\fR' (default), \s-1DDD\s+1 requires structural equivalence
in order to recognize shared data structures.  If this is `\fBoff\fR',
two displays at the same address are considered aliases, regardless of
their structure.
.TP
.B "vslBaseDefs (\fPclass\fB VSLDefs)"
A string with additional \s-1VSL\s+1 definitions that are appended to
the builtin \s-1VSL\s+1 library.  This resource is prepended to the
`\fBvslDefs\fR' resource below and set in the \s-1DDD\s+1
application defaults file; don't change it.
.TP
.B "vslDefs (\fPclass\fB VSLDefs)"
A string with additional \s-1VSL\s+1 definitions that are appended to
the builtin \s-1VSL\s+1 library.  The default value is an empty
string.  This resource can be used to override specific \s-1VSL\s+1
definitions that affect the data display.
.RS
.PP
The general pattern to replace a function definition \fIfunction\fR
with a new definition \fInew_def\fR is:
.sp
.br
\fB#pragma replace \fIfunction\fR
.br
\fIfunction\fB(\fIargs\fR...\fB) = \fInew_def\fB;\fR
.br
.sp
The following \s-1VSL\s+1 functions are frequently used:
.TP 10
.B "color(\fIbox\fB, \fIforeground\fB [\|, \fIbackground\fB\|])"
Set the \fIforeground\fR and \fIbackground\fR colors of \fIbox\fR.
.TP 10
.B "display_color(\fIbox\fB)"
The color used in data displays.
Default: \fBcolor(\fIbox\fB, "black", "white")
.TP 10
.B "title_color(\fIbox\fB)"
The color used in the title bar.
Default: \fBcolor(\fIbox\fB, "black")
.TP 10
.B "disabled_color(\fIbox\fB)"
The color used for disabled boxes.
Default: \fBcolor(\fIbox\fB, "white", "grey50")
.TP 10
.B "simple_color(\fIbox\fB)"
The color used for simple values.
Default: \fBcolor(\fIbox\fB, "black")
.TP 10
.B "pointer_color(\fIbox\fB)"
The color used for pointers.
Default: \fBcolor(\fIbox\fB, "blue4")
.TP 10
.B "struct_color(\fIbox\fB)"
The color used for structures.
Default: \fBcolor(\fIbox\fB, "black")
.TP 10
.B "array_color(\fIbox\fB)"
The color used for arrays.
Default: \fBcolor(\fIbox\fB, "blue4")
.TP 10
.B "reference_color(\fIbox\fB)"
The color used for references.
Default: \fBcolor(\fIbox\fB, "blue4")
.TP 10
.B "changed_color(\fIbox\fB)"
The color used for changed values.
Default: \fBcolor(\fIbox\fB, "black", "#ffffcc")
.TP 10
.B "stdfontfamily()"
The font family used.  One of \fBfamily_times()\fR, 
\fBfamily_courier()\fR, \fBfamily_helvetica()\fR, 
\fBfamily_new_century()\fR, or \fBfamily_typewriter()\fR (default).
.TP 10
.B "stdfontsize()"
The font size used (in pixels).  \fB0\fR (default) means to use
\fBstdfontpoints()\fR instead.
.TP 10
.B "stdfontpoints()"
The font size used (in 1\(f/10 points).  \fB0\fR means to use
\fBstdfontsize()\fR instead.  Default value: \fB90\fR.
.TP 10
.B "stdfontweight()"
The font weight used.  Either \fBweight_medium()\fR (default) or
\fBweight_bold()\fR.
.PP
To set the pointer color to "red4", use
.sp
.br
  \fBDdd*vslDefs: \\
  #pragma replace pointer_color\\n\\
  pointer_color(box) = color(box, "red4");\\n\fR
.br
.sp
To set the default font size to resolution-independent 10.0 points, use
.sp
.br
  \fBDdd*vslDefs: \\
  #pragma replace stdfontsize\\n\\
  #pragma replace stdfontpoints\\n\\
  stdfontsize() = 0;\\n
  stdfontpoints() = 100;\\n\fR
.br
.sp
To set the default font to 12-pixel courier, use
.sp
.br
  \fBDdd*vslDefs: \\
  #pragma replace stdfontsize\\n\\
  #pragma replace stdfontfamily\\n\\
  stdfontsize() = 12;\\n\\
  stdfontfamily() = family_courier();\\n\fR
.br
.sp
See the file `\fBddd.vsl\fR' for further definitions to override using
the `\fBvslDefs\fR' resource.
.RE
.sp
.TP
.B "vslLibrary (\fPclass\fB VSLLibrary)"
The \s-1VSL\s+1 library to use.  `\fBbuiltin\fR' (default) means to
use the built-in library, any other value is used as file name.
.TP
.B "vslPath (\fPclass\fB VSLPath)"
A colon-separated list of directories to search for \s-1VSL\s+1
include files.  Default is `\fB.\fR', the current directory.
.RS
.PP
If your \s-1DDD\s+1 source distribution is installed in
`\fB/opt/src\fR', you can use the following settings to read the
\s-1VSL\s+1 library from `\fB/home/joe/ddd.vsl\fR':
.sp
.br
  \fBDdd*vslLibrary:  /home/joe/ddd.vsl
  Ddd*vslPath:  \\
  .:/opt/src/ddd/ddd:/opt/src/ddd/vsllib\fR
.br
.sp
\s-1VSL\s+1 include files referenced by `\fB/home/joe/ddd.vsl\fR' are
searched first in the current directory `\fB.\fR', then in
`\fB/opt/src/ddd/ddd/\fR', and then in `\fB/opt/src/ddd/vsllib/\fR'.
.PP
Instead of supplying another \s-1VSL\s+1 library, it is often easier
to specify some minor changes to the built-in library.  See the
`\fBvslDefs\fR' resource, above, for details.
.RE
.\"
.SS "Plot Window"
.\"
The following resources control the plot window.
.\"
.TP
.B "plotTermType (\fPclass\fB PlotTermType)"
The Gnuplot terminal type.  Can have one of two values:
.IP \(bu 2
If this is `\fBx11\fR', \s-1DDD\s+1 \(lqswallows\(rq the Gnuplot
output window into its own user interface.  Some window managers,
notably \s-1MWM\s+1, have trouble with swallowing techniques.
.IP \(bu 2
Setting this resource to `\fBxlib\fR' (default) makes \s-1DDD\s+1
provide a \fIbuiltin plot window\fR instead.  In this mode, plots work
well with any window manager, but are less customizable (Gnuplot
resources are not understood).
.TP
.B "plotCommand (\fPclass\fB PlotCommand)"
The name of a Gnuplot executable.  Default is `\fBgnuplot\fR',
followed by some options to set up colors and the initial geometry.
.TP
.B "plotWindowClass (\fPclass\fB PlotWindowClass)"
The class of the Gnuplot output window.  When invoking Gnuplot,
\s-1DDD\s+1 waits for a window with this class and incorporates it
into its own user interface (unless `\fBplotTermType\fR' is
`\fBxlib\fR'; see above).  Default is `\fBGnuplot\fR'.
.TP
.B "plotWindowDelay (\fPclass\fB WindowDelay)"
The time (in ms) to wait for the creation of the Gnuplot window.
Before this delay, \s-1DDD\s+1 looks at each newly created window to
see whether this is the plot window to swallow.  This is cheap, but
unfortunately, some window managers do not pass the creation event to
\s-1DDD\s+1.  If this delay has passed, and \s-1DDD\s+1 has not
found the plot window, \s-1DDD\s+1 searches \fIall\fR existing
windows, which is pretty expensive.  Default time is \fB2000\fR.
.TP
.B "plotInitCommands (\fPclass\fB PlotInitCommands)"
The initial Gnuplot commands issued by \s-1DDD\s+1.  Default is:
.sp
.br
  \fBset parametric
  set urange [0:1]
  set vrange [0:1]
  set trange [0:1]\fR
.br
.sp
The `\fBparametric\fR' setting is required to make Gnuplot understand
the data files as generated \s-1DDD\s+1.  The range commands are
used to plot scalars.
.TP
.B "plot2dSettings (\fPclass\fB PlotSettings)"
Additional initial settings for 2-D plots.  Default is `\fBset
noborder\fR'.  Feel free to customize these settings as desired.
.TP
.B "plot3dSettings (\fPclass\fB PlotSettings)"
Additional initial settings for 3-D plots.  Default is `\fBset
border\fR'.  Feel free to customize these settings as desired.
.PP
.\"
.SS "Debugger Console"
.\"
The following resources control the debugger console.
.\"
.TP
.B "lineBufferedConsole (\fPclass\fB LineBuffered)"
If this is `\fBon\fR' (default), each line from the inferior is
output on each own, such that the final line is placed at the bottom
of the debugger console.  If this is `\fBoff\fR', all lines are
output as a whole.  This is faster, but results in a random position
of the last line.
.PP
.\"
.SS "Value Histories"
.\"
The following resources control the pop-down value histories
associated with various text fields.
.\"
.TP
.B "popdownHistorySize (\fPclass\fB HistorySize)"
The maximum number of items to display in pop-down value histories.  A
value of \fB0\fR (default) means an unlimited number of values.
.TP
.B "sortPopdownHistory (\fPclass\fB SortPopdownHistory)"
If `\fBon\fR' (default), items in the pop-down value histories are
sorted alphabetically.  If `\fBoff\fR', most recently used values will
appear at the top.
.PP
.\"
.\"
.SS "Customizing Helpers"
.\"
The following resources determine external programs invoked by \s-1DDD\s+1.
.TP
.B "editCommand (\fPclass\fB EditCommand)"
A command string to invoke an editor on the specific file.
`\fB@LINE@\fR' is replaced by the current line number, `\fB@FILE@\fR'
by the file name.  The default is to invoke \fB$XEDITOR\fR first, then
\fB$EDITOR\fR, then \fBvi\fR:
.sp
.br
  \fBDdd*editCommand: \\
  ${XEDITOR-false} +@LINE@ @FILE@ \\
  || xterm \-e ${EDITOR-vi} +@LINE@ @FILE@\fR
.br
.sp
.br
This `\fB.ddd/init\fR' setting invokes an editing session
for an \fIXEmacs\fR editor running \fIgnuserv\fR:
.sp
.br
  \fBDdd*editCommand: gnuclient +@LINE@ @FILE@\fR
.br
.sp
This `\fB.ddd/init\fR' setting invokes an editing session for an
\fIEmacs\fR editor running \fIemacsserver\fR:
.sp
.br
  \fBDdd*editCommand: emacsclient +@LINE@ @FILE@\fR
.br
.sp
.TP
.B "fontSelectCommand (\fPclass\fB FontSelectCommand)"
A command to select from a list of fonts.  The string `\fB@FONT@\fR'
is replaced by the current \s-1DDD\s+1 default font; the string
`\fB@TYPE@\fR' is replaced by a symbolic name of the \s-1DDD\s+1
font to edit.  The program must either place the name of the selected
font in the \s-1PRIMARY\s+1 selection or print the selected font on
standard output.  A typical value is:
.sp
.br
  \fBDdd*fontSelectCommand: xfontsel \-print\fR
.br
.sp
.TP
.B "getCoreCommand (\fPclass\fB GetCoreCommand)"
A command to get a core dump of a running process (typically,
`\fBgcore\fR') `\fB@FILE@\fR' is replaced by the base name of the file
to create; `\fB@PID@\fR' is replaced by the process id.  The output
must be written to `\fB@FILE@.@PID@\fR'.
.br
Leave this entry empty if you have no `\fBgcore\fR' or similar command.
.TP
.B "lessTifVersion (\fPclass\fB LessTifVersion)"
Indicates the LessTif version \s-1DDD\s+1 is running against.  For
LessTif version \fIx.y\fR, the value is \fIx\fR multiplied by 1000
plus \fIy\fR\(em\&for instance, the value \fB79\fR stands for LessTif
0.79 and the value \fB1005\fR stands for LessTif 1.5.
.br
If the value of this resource is less than 1000, indicating LessTif
0.99 or earlier, \s-1DDD\s+1 enables version-specific hacks to make
\s-1DDD\s+1 work around LessTif bugs and deficiencies.
.br
If \s-1DDD\s+1 was compiled against LessTif, the default value is
the value of the `\fBLessTifVersion\fR' macro in \fB<Xm/Xm.h>\fR.  If
\s-1DDD\s+1 was compiled against OSF/Motif, the default value is
\fB1000\fR, disabling all LessTif-specific hacks.
.TP
.B "listCoreCommand (\fPclass\fB listCoreCommand)"
The command to list all core files on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listCoreCommand: \\
  file @MASK@ | grep '.*:.*core.*' \\
  | cut \-d: \-f1\fR
.br
.sp
.TP
.B "listDirCommand (\fPclass\fB listDirCommand)"
The command to list all directories on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listDirCommand: \\
  file @MASK@ | grep '.*:.*directory.*' \\
  | cut \-d: \-f1\fR
.br
.sp
.TP
.B "listExecCommand (\fPclass\fB listExecCommand)"
The command to list all executable files on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listExecCommand: \\
  file @MASK@ | grep '.*:.*exec.*' \\
  | grep \-v  '.*:.*script.*' \\
  | cut \-d: \-f1 | grep \-v '.*\\.o$'\fR
.br
.sp
.TP
.B "listSourceCommand (\fPclass\fB listSourceCommand)"
The command to list all source files on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listSourceCommand: \\
  file @MASK@ | grep '.*:.*text.*' \\
  | cut \-d: \-f1\fR
.br
.sp
.TP
.B "printCommand (\fPclass\fB PrintCommand)"
The command to print a postscript file.  Usually `\fBlp\fR' or
`\fBlpr\fR'.
.TP
.B "psCommand (\fPclass\fB PsCommand)"
The command to get a list of processes.  Usually `\fBps\fR'.
Depending on your system, useful alternate values include `\fBps
-ef\fR' and `\fBps ux\fR'.  The first line of the output must either
contain a `\fBPID\fR' title, or each line must begin with a process
ID.
.br
Note that the output of this command is filtered by \s-1DDD\s+1; a
process is only shown if it can be attached to.  The \s-1DDD\s+1
process itself as well as the process of the inferior debugger are
suppressed, too.
.TP
.B "rshCommand (\fPclass\fB RshCommand)"
The remote shell command to invoke \s-1TTY\s+1-based commands on
remote hosts.  Usually, `\fBremsh\fR', `\fBrsh\fR', `\fBssh\fR', or
`\fBon\fR'.
.TP
.B "termCommand (\fPclass\fB TermCommand)"
The command to invoke a separate \s-1TTY\s+1 for showing the
input/output of the debugged program.  A Bourne shell command to run
in the separate \s-1TTY\s+1 is appended to this string.  The string
`\fB@FONT@\fR' is replaced by the name of the fixed width font used by
\s-1DDD\s+1.  A simple value is
.sp
.br
  \fBDdd*termCommand: xterm \-fn @FONT@ \-e /bin/sh \-c\fR
.br
.TP
.B "termType (\fPclass\fB TermType)"
The terminal type provided by the `\fBtermCommand\fR'
resource\(em\&that is, the value of the \fBTERM\fR environment
variable to be passed to the debugged program.  Default:
`\fBxterm\fR'.
.TP
.B "uncompressCommand (\fPclass\fB UncompressCommand)"
The command to uncompress the built-in \s-1DDD\s+1 manual, the
\s-1DDD\s+1 license, and the \s-1DDD\s+1 news.  Takes a compressed
text from standard input and writes the uncompressed text to standard
output.  The default value is `\fBgzip -d -c\fR'; typical values
include `\fBzcat\fR' and `\fBgunzip -c\fR'.
.TP
.B "wwwCommand (\fPclass\fB WWWCommand)"
The command to invoke a \s-1WWW\s+1 browser.  The string `\fB@URL@\fR'
is replaced by the \s-1URL\s+1 to open.  Default is to try a running
Netscape first, then \fB$WWWBROWSER\fR, then to invoke a new Netscape
process, then to let a running Emacs do the job, then to invoke
Mosaic, then to invoke Lynx in an xterm.
.RS
.PP
To specify `\fBnetscape-4.0\fR' as browser, use the setting:
.sp
.br
  \fBDdd*wwwCommand: \\
     netscape-4.0 \-remote 'openURL(@URL@)' \\
  || netscape-4.0 '@URL@'\fR
.br
.sp
This command first tries to connect to a running \fBnetscape-4.0\fR browser;
if this fails, it starts a new \fBnetscape-4.0\fR process.
.RE
.TP
.B "wwwPage (\fPclass\fB WWWPage)"
The \s-1DDD\s+1 \s-1WWW\s+1 page.  Value:
.sp
.br
  \fBDdd*wwwPage: http://www.cs.tu-bs.de/softech/ddd/\fR
.br
.sp
.\"
.\"
.\"
.SS "Obtaining Diagnostics"
.\"
The following resources are used for debugging \s-1DDD\s+1 and to
obtain specific \s-1DDD\s+1 information.
.TP
.B "appDefaultsVersion (\fPclass\fB Version)"
The version of the \s-1DDD\s+1 app-defaults file.  If this string
does not match the version of the current \s-1DDD\s+1 executable,
\s-1DDD\s+1 issues a warning.
.TP
.B "checkConfiguration (\fPclass\fB CheckConfiguration)"
If `\fBon\fR', check the \s-1DDD\s+1 environment (in particular, the
X configuration), report any possible problem causes and exit.  See
also the `\fB\-\-check-configuration\fR' option, below.
.TP
.B "dddinitVersion (\fPclass\fB Version)"
The version of the \s-1DDD\s+1 executable that last wrote the
`\fB$HOME/.ddd/init\fR' file.  If this string does not match the
version of the current \s-1DDD\s+1 executable, \s-1DDD\s+1 issues
a warning.
.TP
.B "debugCoreDumps (\fPclass\fB DebugCoreDumps)"
If `\fBon\fR', \s-1DDD\s+1 invokes a debugger on itself when
receiving a fatal signal.
.TP
.B "dumpCore (\fPclass\fB DumpCore)"
If `\fBon\fR' (default), \s-1DDD\s+1 dumps core when receiving a
fatal signal.
.TP
.B "maintenance (\fPclass\fB Maintenance)"
If `\fBon\fR', enables a top-level `\fBMaintenance\fR' menu with
additional options.  See also the `\fB\-\-maintenance\fR' option,
below.
.TP
.B "showConfiguration (\fPclass\fB ShowConfiguration)"
If `\fBon\fR', show the \s-1DDD\s+1 configuration on standard
output and exit.  See also the `\fB\-\-configuration\fR' option,
below.
.TP
.B "showFonts (\fPclass\fB ShowFonts)"
If `\fBon\fR', show the \s-1DDD\s+1 font definitions on standard
output and exit.  See also the `\fB\-\-fonts\fR' option, below.
.TP
.B "showInvocation (\fPclass\fB ShowInvocation)"
If `\fBon\fR', show the \s-1DDD\s+1 invocation options on standard
output and exit.  See also the `\fB\-\-help\fR' option, below.
.TP
.B "showLicense (\fPclass\fB ShowLicense)"
If `\fBon\fR', show the \s-1DDD\s+1 license on standard output and
exit.  See also the `\fB\-\-license\fR' option, below.
.TP
.B "showManual (\fPclass\fB ShowManual)"
If `\fBon\fR', show this \s-1DDD\s+1 manual page on standard
output and exit.  If the standard output is a terminal, the manual
page is shown in a pager (\fB$PAGER\fR, `\fBless\fR' or `\fBmore\fR').
See also the `\fB\-\-manual\fR' option, below.
.TP
.B "showNews (\fPclass\fB ShowNews)"
If `\fBon\fR', show the \s-1DDD\s+1 news on standard output and
exit.  See also the `\fB\-\-news\fR' option, below.
.TP
.B "showVersion (\fPclass\fB ShowVersion)"
If `\fBon\fR', show the \s-1DDD\s+1 version on standard output and
exit.  See also the `\fB\-\-version\fR' option, below.
.TP
.B "trace (\fPclass\fB Trace)"
If `\fBon\fR', show the dialog between \s-1DDD\s+1 and the
inferior debugger on standard output.  Default is `\fBoff\fR'.
.\"
.\"
.\"
.SS "More Resources"
.\"
The `\fBDdd\fR' application defaults file contains even more
information about setting \s-1DDD\s+1 resources.  The `\fBDdd\fR'
file comes with the \s-1DDD\s+1 distribution.
.\"
.\"
.\" ---------------
.SH "OPTIONS"
.\" ---------------
.\"
You can use the following options when starting \s-1DDD\s+1.  All
options may be abbreviated, as long as they are unambiguous; single
dashes may also be used.  \s-1DDD\s+1 also understands the usual X
options such as `\fB\-display\fR' or `\fB\-geometry\fR'; see
\fBX(1)\fR for details.
.PP
All other arguments and options are passed to the inferior debugger.
To pass an option to the inferior debugger that conflicts with an X
option, or with a \s-1DDD\s+1 option listed here, use the
`\fB\-\-debugger\fR' option, below.
.PP
.\"
.TP
.B \-\-attach-windows
Attach the source and data windows to the debugger console, creating
one single big \s-1DDD\s+1 window.  This is the default setting.
.TP
.B \-\-attach-source-window
Attaches only the source window to the debugger console.
.TP
.B \-\-attach-data-window
Attaches only the source window to the debugger console.
.TP
.B \-\-automatic-debugger
Determine the inferior debugger automatically.
.TP
.B \-\-button-tips
Enable button tips.
.TP
.B \-\-configuration
Show the \s-1DDD\s+1 configuration settings and exit.
.TP
.B \-\-check-configuration
Check the \s-1DDD\s+1 environment (in particular, the X configuration),
report any possible problem causes and exit.
.TP
.B \-\-data-window
Create the data window upon start-up.
.TP
.B \-\-dbx
Run the \s-1DBX\s+1 debugger as inferior debugger.
.TP
.B \-\-debugger \fIname\fR
Invoke the inferior debugger \fIname\fR.  This is useful if you have
several debugger versions around, or if the inferior debugger cannot
be invoked as `\fBgdb\fR', `\fBdbx\fR', `\fBxdb\fR', `\fBjdb\fR',
`\fBpydb\fR', or `\fBperl\fR' respectively.
.br
This option can also be used to pass options to the inferior debugger
that would otherwise conflict with \s-1DDD\s+1 options.  For
instance, to pass the option `\fB\-d \fIdirectory\fR' to \s-1XDB\s+1,
use:
.sp
.br
  \fBddd\ \-\-debugger "xdb \-d \fIdirectory\fB"\fR
.br
.sp
If you use the `\fB\-\-debugger\fR' option, be sure that the type of
inferior debugger is specified as well.  That is, use one of the
options `\fB\-\-gdb\fR', `\fB\-\-dbx\fR', `\fB\-\-xdb\fR',
`\fB\-\-jdb\fR'\, `\fB\-\-pydb\fR', or `\fB\-\-perl\fR' (unless the
default setting works fine).
.TP
.B \-\-debugger-console
Create the debugger console upon start-up.
.TP
.B \-\-disassemble
Disassemble the source code.  See also the `\fB\-\-no-disassemble\fR'
option, below.
.TP
.B \-\-exec-window
Run the debugged program in a specially created execution window.
This is useful for programs that have special terminal requirements
not provided by the debugger window, as raw keyboard processing or
terminal control sequences.
.TP
.B \-\-fonts\fR
Show the font definitions used by \s-1DDD\s+1 on standard output.
.TP
.B \-\-fontsize \fIsize\fR
Set the default font size to \fIsize\fR 1\(f/10 points.  To use
12-point fonts, say `\fB\-\-fontsize 120\fR'.
.TP
.B \-\-fullname
Enable \s-1TTY\s+1 interface, taking additional debugger commands
from standard input and forwarding debugger output on standard output.
Current positions are issued in \s-1GDB\s+1 `\fB\-fullname\fR' format
suitable for debugger front-ends.  By default, both the debugger
console and source window are disabled.
.TP
.B \-\-gdb
Run the \s-1GDB\s+1 debugger as inferior debugger.
.TP
.B \-\-glyphs
Display the current execution position and breakpoints as glyphs.
See also the `\fB\-\-no-glyphs\fR' option, below.
.TP
.B \-\-help
Give a list of frequently used options.  Show options of the
inferior debugger as well.
.TP
.B \-\-host \fR[\|\fIusername\fB@\fR\|]\|\fIhostname\fR
Invoke the inferior debugger directly on the remote host
\fIhostname\fR.  If \fIusername\fR is given and the `\fB\-\-login\fR'
option is not used, use \fIusername\fR as remote user name.  See
`\fBREMOTE DEBUGGING\fR', above.
.TP
.B \-\-jdb
Run \s-1JDB\s+1 as inferior debugger.
.TP
.B \-\-lesstif-hacks\fR
Equivalent to `\fB\-\-lesstif-version 999\fR'.
Deprecated.
.TP
.B \-\-lesstif-version \fIversion\fR
Enable some hacks to make \s-1DDD\s+1 run properly with LessTif.
See the `\fBlessTifVersion\fR' resource and `\fBUSING DDD WITH
LESSTIF\fR', above, for a discussion.
.TP
.B \-\-license
Show the \s-1DDD\s+1 license and exit.
.TP
.B \-\-login \fIusername\fR
Use \fIusername\fR as remote user name.  See `\fBREMOTE DEBUGGING\fR',
above.
.TP
.B \-\-maintenance
Enable the top-level `\fBMaintenance\fR' menu with options for
debugging \s-1DDD\s+1.
.TP
.B \-\-manual
Show this manual page and exit.
.TP
.B \-\-news
Show the \s-1DDD\s+1 news and exit.
.TP
.B \-\-no-button-tips
Disable button tips.
.TP
.B \-\-no-data-window
Do not create the data window upon start-up.
.TP
.B \-\-no-debugger-console
Do not create the debugger console upon start-up.
.TP
.B \-\-no-disassemble
Do not disassemble the source code.
.TP
.B \-\-no-exec-window
Do not run the debugged program in a specially created execution
window; use the debugger console instead.  Useful for programs that have
little terminal input/output, or for remote debugging.
.TP
.B \-\-no-glyphs
Display the current execution position and breakpoints as text
characters.  Do not use glyphs.
.TP
.B \-\-no-lesstif-hacks
Equivalent to `\fB\-\-lesstif-version 1000\fR'.  Deprecated.
.TP
.B \-\-no-source-window
Do not create the source window upon start-up.
.TP
.B \-\-no-value-tips
Disable value tips.
.TP
.B \-\-nw
Do not use the X window interface.  Start the inferior debugger on
the local host.
.TP
.B \-\-perl
Run Perl as inferior debugger.
.TP
.B \-\-pydb
Run \s-1PYDB\s+1 as inferior debugger.
.TP
.B \-\-panned-graph-editor
Use an Athena panner to scroll the data window.  Most people prefer
panners on scroll bars, since panners allow two-dimensional scrolling.
However, the panner is off by default, since some Motif
implementations do not work well with Athena widgets.  See also
\fB\-\-scrolled-graph-editor\fR, below.
.TP
.B \-\-play \fIlog-file\fR
Recapitulate a previous \s-1DDD\s+1 session.  Invoke `ddd
\fB\-\-PLAY \fIlog-file\fR' as inferior debugger, simulating the
inferior debugger given in \fIlog-file\fR (see below).  This is useful
for debugging \s-1DDD\s+1.
.TP
.B \-\-PLAY \fIlog-file\fR
Simulate an inferior debugger.  \fIlog-file\fR is a
`\fB$HOME/.ddd/log\fR' file as generated by some previous
\s-1DDD\s+1 session.  When a command is entered, scan the
\fIlog-file\fR for this command and re-issue the logged reply; if the
command is not found, do nothing.  This is used by the
`\fB\-\-play\fR' option.
.TP
.B \-\-rhost \fR[\|\fIusername\fB@\fR\|]\|\fIhostname\fR
Run the inferior debugger interactively on the remote host
\fIhostname\fR.  If \fIusername\fR is given and the `\fB\-\-login\fR'
option is not used, use \fIusername\fR as remote user name.  See
`\fBREMOTE DEBUGGING\fR', above.
.TP 
.B \-\-separate-windows
Separate the console, source and data windows.  See also the
`\fB\-\-attach\fR' options, above.
.TP
.B \-\-scrolled-graph-editor
Use Motif scroll bars to scroll the data window.  This is the default
in most \s-1DDD\s+1 configurations.  See also
\fB\-\-panned-graph-editor\fR, above.
.TP
.B \-\-source-window
Create the source window upon start-up.
.TP
.B \-\-status-at-bottom
Place the status line at the bottom of the source window.
.TP
.B \-\-status-at-top
Place the status line at the top of the source window.
.TP
.B \-\-sync-debugger
Do not process X events while the debugger is busy.  This may result
in slightly better performance on single-processor systems.
.TP
.B \-\-toolbars-at-bottom
Place the toolbars the bottom of the window.
.TP
.B \-\-toolbars-at-top
Place the toolbars at the top of the window.
.TP
.B \-\-trace
Show the interaction between \s-1DDD\s+1 and the inferior debugger
on standard error.  This is useful for debugging \s-1DDD\s+1.  If
`\fB\-\-trace\fR' is not specified, this information is written into
`\fB$HOME/.ddd/log\fR', such that you can also do a post-mortem
debugging.
.TP
.B \-\-tty
Enable \s-1TTY\s+1 interface, taking additional debugger commands from
standard input and forwarding debugger output on standard output.
Current positions are issued in a format readable for humans.  By
default, the debugger console is disabled.
.TP
.B \-\-value-tips
Enable value tips.
.TP
.B \-\-version
Show the \s-1DDD\s+1 version and exit.
.TP
.B \-\-vsl-library \fIlibrary\fR
Load the \s-1VSL\s+1 library \fIlibrary\fR instead of using the
\s-1DDD\s+1 built-in library.  This is useful for customizing
display shapes and fonts.
.TP
.B \-\-vsl-path \fIpath\fR
Search \s-1VSL\s+1 libraries in \fIpath\fR (a colon-separated
directory list).
.TP
.B \-\-vsl-help
Show a list of further options controlling the \s-1VSL\s+1
interpreter.  These options are intended for debugging purposes and
are subject to change without further notice.
.TP
.B \-\-xdb
Run \s-1XDB\s+1 as inferior debugger.
.\"
.\"
.\" ---------------
.SH "ACTIONS"
.\" ---------------
.\"
.\"
The following \s-1DDD\s+1 actions may be used in translation tables.
.\"
.SS "General Actions"
.\"
These actions are used to assign the keyboard focus.
.TP
.B ddd-get-focus ()
Assign focus to the element that just received input.
.TP
.B ddd-next-tab-group ()
Assign focus to the next tab group.
.TP
.B ddd-prev-tab-group ()
Assign focus to the previous tab group.
.TP
.B ddd-previous-tab-group ()
Assign focus to the previous tab group.
.\"
.\"
.\"
.SS "Data Display Actions"
.\"
These actions are used in the \s-1DDD\s+1 graph editor.
.TP
.B end ()
End the action initiated by \fBselect\fR.  Bound to a button up event.
.TP
.B extend ()
Extend the current selection.  Bound to a button down event.
.TP
.B extend-or-move ()
Extend the current selection.  Bound to a button down event.
If the pointer is dragged, move the selection.
.TP
.B follow ()
Continue the action initiated by \fBselect\fR.  Bound to a pointer
motion event.
.TP
.B graph-select ()
Equivalent to \fBselect\fR, but also updates the current argument.
.TP
.B graph-select-or-move ()
Equivalent to \fBselect-or-move\fR, but also updates the current argument.
.TP
.B graph-extend ()
Equivalent to \fBextend\fR, but also updates the current argument.
.TP
.B graph-extend-or-move ()
Equivalent to \fBextend-or-move\fR, but also updates the current argument.
.TP
.B graph-toggle ()
Equivalent to \fBtoggle\fR, but also updates the current argument.
.TP
.B graph-toggle-or-move ()
Equivalent to \fBtoggle-or-move\fR, but also updates the current argument.
.TP
.B graph-popup-menu (\fR[\fBgraph\fR|\fBnode\fR|\fBshortcut\fR]\fB)
Pops up a menu.  \fBgraph\fR pops up a menu with global graph
operations, \fBnode\fR pops up a menu with node operations, and
\fBshortcut\fR pops up a menu with display shortcuts.  If no argument
is given, pops up a menu depending on the context: when pointing on a
node with the \fBShift\fR key pressed, behaves like \fBshortcut\fR;
when pointing on a without the \fBShift\fR key pressed, behaves like
\fBnode\fR; otherwise, behaves as if \fBgraph\fR was given.
.TP
.B graph-dereference ()
Dereference the selected display.
.TP
.B graph-detail ()
Show or hide detail of the selected display.
.TP
.B graph-rotate ()
Rotate the selected display.
.TP
.B graph-dependent ()
Pop up a dialog to create a dependent display.
.TP
.B hide-edges (\fR[\fBany\fR|\fBboth\fR|\fBfrom\fR|\fBto\fR]\fB)
Hide some edges.  \fBany\fR means to process all edges where either
source or target node are selected. \fBboth\fR means to process all
edges where both nodes are selected. \fBfrom\fR means to process all
edges where at least the source node is selected. \fBto\fR means to
process all edges where at least the target node is selected.  Default
is \fBany\fR.
.TP
.B layout (\fR[\fBregular\fR|\fBcompact\fR]\fB, \fR[[\fB+\fR|\fB\-\fR]\fIdegrees\fR]]\fB)
Layout the graph.  \fBregular\fR means to use the regular layout
algorithm; \fBcompact\fR uses an alternate layout algorithm, where
successors are placed next to their parents.  Default is
\fBregular\fR.  \fIdegrees\fR indicates in which direction the graph
should be layouted.  Default is the current graph direction.
.TP
.B move-selected (\fIx-offset\fB, \fIy-offset\fB)
Move all selected nodes in the direction given by \fIx-offset\fR and
\fIy-offset\fR.  \fIx-offset\fR and \fIy-offset\fR is either given as
a numeric pixel value, or as `\fB+grid\fR', or `\fB\-grid\fR', meaning
the current grid size.
.TP
.B normalize ()
Place all nodes on their positions and redraw the graph.
.TP
.B rotate (\fR[[\fB+\fR|\fB\-\fR]\fIdegrees\fR]\fB)
Rotate the graph around \fIdegrees\fR degrees.  
\fIdegrees\fR must be a multiple of 90.  Default is \fB+90\fR.
.TP
.B select ()
Select the node pointed at.  Clear all other selections.  Bound to a
button down event.
.TP
.B select-all ()
Select all nodes in the graph.
.TP
.B select-first ()
Select the first node in the graph.
.TP
.B select-next ()
Select the next node in the graph.
.TP
.B select-or-move ()
Select the node pointed at.  Clear all other selections.  Bound to a
button down event. If the pointer is dragged, move the selected node.
.TP
.B select-prev ()
Select the previous node in the graph.
.TP
.B show-edges (\fR[\fBany\fR|\fBboth\fR|\fBfrom\fR|\fBto\fR]\fB)
Show some edges.  \fBany\fR means to process all edges where either
source or target node are selected. \fBboth\fR means to process all
edges where both nodes are selected. \fBfrom\fR means to process all
edges where at least the source node is selected. \fBto\fR means to
process all edges where at least the target node is selected.  Default
is \fBany\fR.
.TP
.B snap-to-grid ()
Place all nodes on the nearest grid position.
.TP
.B toggle ()
Toggle the current selection\(em\&if the node pointed at is selected,
it will be unselected, and vice versa.  Bound to a button down event.
.TP
.B toggle-or-move ()
Toggle the current selection\(em\&if the node pointed at is selected,
it will be unselected, and vice versa.  Bound to a button down event.
If the pointer is dragged, move the selection.
.TP
.B unselect-all ()
Clear the selection.
.\"
.\"
.SS "Debugger Console Actions"
.\"
These actions are used in the debugger console and other text fields.
.TP
.B gdb-backward-character ()
Move one character to the left.  Bound to \fBLeft\fR.
.TP
.B gdb-beginning-of-line ()
Move cursor to the beginning of the current line, after the prompt.
Bound to \s-1\fBHOME\fR\s+1.
.TP
.B gdb-control (\fIcontrol-character\fB)
Send the given \fIcontrol-character\fR to the inferior debugger.
The \fIcontrol-character\fR must be specified in the form `\fB^\fIX\fR',
where \fIX\fR is an upper-case letter or `\fB?\fR'.
.TP
.B gdb-command (\fIcommand\fB)
Execute \fIcommand\fR in the debugger console.  The following
replacements are performed on \fIcommand\fR:
.RS
.br
.IP \(bu 2
If \fIcommand\fR has the form '\fIname\fB...\fR', insert \fIname\fR,
followed by a space, in the debugger console.
.IP \(bu 2
All occurrences of `\fB()\fR' are replaced by the current contents of
the argument field `\fB()\fR'.
.br
.RE
.TP
.B gdb-complete-arg (\fIcommand\fB)
Complete current argument as if \fIcommand\fR was prepended.
Bound to \fBCtrl+T\fR.
.TP
.B gdb-complete-command ()
Complete current command line in the debugger console.
Bound to \s-1\fBTAB\fR\s+1.
.TP
.B gdb-complete-tab (\fIcommand\fB)
If global \s-1\fBTAB\fR\s+1 completion is enabled, complete current
argument as if \fIcommand\fR was prepended.  Otherwise, proceed as if
the \s-1\fBTAB\fR\s+1 key was hit.  Bound to \s-1\fBTAB\fR\s+1.
.TP
.B gdb-delete-or-control (\fIcontrol-character\fB)
Like \fBgdb-control\fR, but effective only if the cursor is at the end
of a line.  Otherwise, \fIcontrol-character\fR is ignored and the
character following the cursor is deleted.  Bound to \fBCtrl+D\fR.
.TP
.B gdb-end-of-line ()
Move cursor to the end of the current line.  Bound to \fBEnd\fR.
.TP
.B gdb-forward-character ()
Move one character to the right.  Bound to \fBRight\fR.
.TP
.B gdb-insert-graph-arg ()
Insert the contents of the data display argument field `\fB()\fR'.
.TP
.B gdb-insert-source-arg ()
Insert the contents of the source argument field `\fB()\fR'.
.TP
.B gdb-interrupt ()
If \s-1DDD\s+1 is in incremental search mode, exit it; otherwise
call \fBgdb-control(^C)\fR.
.TP
.B gdb-isearch-prev ()
Enter reverse incremental search mode.  Bound to \fBCtrl+B\fR.
.TP
.B gdb-isearch-next ()
Enter incremental search mode.  Bound to \fBCtrl+F\fR.
.TP
.B gdb-isearch-exit ()
Exit incremental search mode.  Bound to \s-1\fBESC\fR\s+1.
.TP
.B gdb-next-history ()
Recall next command from history.  Bound to \fBDown\fR.
.TP
.B gdb-prev-history ()
Recall previous command from history.  Bound to \fBUp\fR.
.TP
.B gdb-previous-history ()
Recall previous command from history.  Bound to \fBUp\fR.
.TP
.B gdb-process ([\|\fIaction\fB\|[\|, \fIargs...\fB\|]\|])
Process the given event in the debugger console.  Bound to key events
in the source and data window.  If this action is bound to the source
window, and the source window is editable, perform
\fIaction\fB(\fIargs...\fB)\fR on the source window instead; if
\fIaction\fR is not given, perform `\fBself-insert()\fR'.
.TP
.B gdb-select-all ()
If the `\fBselectAllBindings\fR' resource is set to \fBMotif\fR,
perform \fIbeginning-of-line\fR.  Otherwise, perform \fIselect-all\fR.
Bound to \fBCtrl+A\fR.
.TP
.B gdb-set-line (\fIvalue\fB)
Set the current line to \fIvalue\fR.  Bound to \fBCtrl+U\fR.
.\"
.\"
.SS "Source Window Actions"
.\"
These actions are used in the source and code windows.
.TP
.B source-delete-glyph ()
Delete the breakpoint related to the glyph at cursor position.
.TP
.B source-double-click ([\fItext-action\fR [,\fIline-action\fR [,\fIfunction-action\fR]]]\fB)\fR
The double-click action in the source window.
.RS
.br
.IP \(bu 2
If this action is taken on a breakpoint glyph, edit the breakpoint
properties.
.IP \(bu 2
If this action is taken in the breakpoint area, invoke
`\fBgdb-command(\fIline-action\fB)\fR'.  If \fIline-action\fR is not
given, it defaults to `\fBbreak ()\fR'.
.IP \(bu 2
If this action is taken in the source text, and the next character
following the current selection is a `\fB(\fR', invoke
`\fBgdb-command(\fIfunction-action\fB)\fR'.  If \fIfunction-action\fR
is not given, it defaults to `\fBlist ()\fR'.
.IP \(bu 2
Otherwise, invoke `\fBgdb-command(\fItext-action\fB)\fR'.  If
\fItext-action\fR is not given, it defaults to `\fBgraph display
()\fR'.
.br
.RE
.TP
.B source-drag-glyph ()
Initiate a drag on the glyph at cursor position.
.TP
.B source-drop-glyph ([\fIaction\fR])
Drop the dragged glyph at cursor position.  \fIaction\fR is either
`\fBmove\fR', meaning to move the dragged glyph, or `\fBcopy\fR',
meaning to copy the dragged glyph.  If no \fIaction\fR is given,
`\fBmove\fR' is assumed.
.TP
.B source-end-select-word ()
End selecting a word.
.TP
.B source-follow-glyph ()
Continue a drag on the glyph at cursor position.  Usually bound to
some motion event.
.TP
.B source-popup-menu ()
Pop up a menu, depending on the location.
.TP
.B source-set-arg ()
Set the argument field to the current selection.  Typically bound to
some selection operation.
.TP
.B source-start-select-word ()
Start selecting a word.
.TP
.B source-update-glyphs ()
Update all visible glyphs.  Usually invoked after a scrolling operation.
.\"
.\"
.\" ---------------
.SH "IMAGES"
.\" ---------------
.\"
\s-1DDD\s+1 installs a number of images that may be used as pixmap
resources, simply by giving a symbolic name.  For button images,
three variants are installed as well:
.IP \(bu 2
The suffix `\fB-hi\fR' indicates a highlighted variant (Button is entered).
.IP \(bu 2
The suffix `\fB-arm\fR' indicates an armed variant (Button is pushed).
.IP \(bu 2
The suffix `\fB-xx\fR' indicates a disabled (insensitive) variant.
.TP
.B "break_at"
`\fBBreak at ()\fR' button.
.TP
.B "clear_at"
`\fBClear at ()\fR' button.
.TP
.B "ddd"
\s-1DDD\s+1 icon.
.TP
.B "delete"
`\fBDelete ()\fR' button.
.TP
.B "disable"
`\fBDisable\fR' button.
.TP
.B "dispref"
`\fBDisplay * ()\fR' button.
.TP
.B "display"
`\fBDisplay ()\fR' button.
.TP
.B "drag_arrow"
The execution pointer (being dragged).
.TP
.B "drag_cond"
A conditional breakpoint (being dragged).
.TP
.B "drag_stop"
A breakpoint (being dragged).
.TP
.B "drag_temp"
A temporary breakpoint (being dragged).
.TP
.B "enable"
`\fBEnable\fR' button.
.TP
.B "find_forward"
`\fBFind\s-2>>\s+2 ()\fR' button.
.TP
.B "find_backward"
`\fBFind\s-2<<\s+2 ()\fR' button.
.TP
.B "grey_arrow"
The execution pointer (not in lowest frame).
.TP
.B "grey_cond"
A conditional breakpoint (disabled).
.TP
.B "grey_stop"
A breakpoint (disabled).
.TP
.B "grey_temp"
A temporary breakpoint (disabled).
.TP
.B "hide"
`\fBHide ()\fR' button.
.TP
.B "lookup"
`\fBLookup ()\fR' button.
.TP
.B "maketemp"
`\fBMake Temporary\fR' button.
.TP
.B "new_break"
`\fBNew Breakpoint\fR' button.
.TP
.B "new_display"
`\fBNew Display\fR' button.
.TP
.B "new_watch"
`\fBNew Watchpoint\fR' button.
.TP
.B "plain_arrow"
The execution pointer.
.TP
.B "plain_cond"
A conditional breakpoint (enabled).
.TP
.B "plain_stop"
A breakpoint (enabled).
.TP
.B "plain_temp"
A temporary breakpoint (enabled).
.TP
.B "print"
`\fBPrint ()\fR' button.
.TP
.B "properties"
`\fBProperties\fR' button.
.TP
.B "rotate"
`\fBRotate ()\fR' button.
.TP
.B "set"
`\fBSet ()\fR' button.
.TP
.B "show"
`\fBShow ()\fR' button.
.TP
.B "signal_arrow"
The execution pointer (stopped by signal).
.TP
.B "undisplay"
`\fBUndisplay ()\fR' button.
.TP
.B "unwatch"
`\fBUnwatch ()\fR' button.
.TP
.B "watch"
`\fBWatch ()\fR' button.
.PP
.\"
.\"
.\" ---------------
.SH "ENVIRONMENT"
.\" ---------------
.\"
\s-1DDD\s+1 is controlled by the following environment variables:
.PP
.TP 20
.B DDD_NO_SIGNAL_HANDLERS
If set, \s-1DDD\s+1 does not catch fatal errors.  This is sometimes
useful when debugging \s-1DDD\s+1.
.TP
.B DDD_STATE
Root of \s-1DDD\s+1 state directory.  Default is `\fB$HOME/.ddd/\fR'.
.TP
.B DDD_SESSION
If set, indicates a session to start, overriding all options.  This is
used by \s-1DDD\s+1 when restarting itself.
.TP
.B DDD_SESSIONS
\s-1DDD\s+1 session directory.  Default is `\fB$DDD_STATE/sessions/\fR'.
.TP
.B EDITOR
The text editor to invoke for editing source code.  See the
`\fBeditCommand\fR' resource, above.
.TP
.B VSL_INCLUDE
Where to search for \s-1VSL\s+1 include files.  Default is the current 
directory.
.TP
.B WWWBROWSER
The \s-1WWW\s+1 browser to invoke for viewing the \s-1DDD\s+1
\s-1WWW\s+1 page.  See the `\fBwwwCommand\fR' resource, above.
.TP
.B XEDITOR
The X editor to invoke for editing source code.  See the
`\fBeditCommand\fR' resource, above.
.PP
The following environment variables are set by \s-1DDD\s+1:
.PP
.TP 20
.B DDD
Set to a string indicating the \s-1DDD\s+1 version.  By testing
whether \fBDDD\fR is set, a debuggee (or inferior debugger) can
determine whether it was invoked by \s-1DDD\s+1.
.TP
.B TERM
Set to `\fBdumb\fR', the \s-1DDD\s+1 terminal type.  This is set for
the inferior debugger only.  If the debuggee runs in a separate
execution window, the debuggee's \fBTERM\fR value is set according to
the `\fBtermType\fR' resource (see `\fBRESOURCES\fR', above).
.TP
.B TERMCAP
Set to `' (none), the \s-1DDD\s+1 terminal capabilities.
.TP
.B PAGER
Set to `\fBcat\fR', the preferred \s-1DDD\s+1 pager.
.\"
.\"
.\" ---------------
.SH "FILES"
.\" ---------------
.\"
.PD 0
.TP 20
.B $HOME/.ddd/
\s-1DDD\s+1 state directory.
.TP
.B $HOME/.ddd/init
Individual \s-1DDD\s+1 resource file.  \s-1DDD\s+1 options are
saved here.
.TP
.B $HOME/.ddd/history
Default \s-1DDD\s+1 command history file.
.TP
.B $HOME/.ddd/lock
\s-1DDD\s+1 lock file; indicates that a \s-1DDD\s+1 is running.
.TP
.B $HOME/.ddd/log
Trace of the current interaction between \s-1DDD\s+1 and the
inferior debugger.
.TP
.B $HOME/.ddd/sessions/
\s-1DDD\s+1 session directory.  One subdirectory per session.
.TP
.B $HOME/.ddd/sessions/\fIsession\fB/dddcore
\s-1DDD\s+1 core file for \fIsession\fR.
.TP
.B $HOME/.ddd/sessions/\fIsession\fB/init
\s-1DDD\s+1 resource file for \fIsession\fR.
.TP
.B $HOME/.ddd/sessions/\fIsession\fB/history
\s-1DDD\s+1 command history for \fIsession\fR.
.TP
.B $HOME/.ddd/sessions/.ddd/
The \s-1DDD\s+1 `restart' session.
.TP
.B $HOME/.ddd/tips
\s-1DDD\s+1 tips resource file.  Contains the number of the next tip
of the day.
.TP
.B $HOME/.gdbinit
\s-1GDB\s+1 initialization file.
.TP
.B $HOME/.dbxinit
\s-1DBX\s+1 initialization file.
.TP
.B $HOME/.dbxrc
Alternate \s-1DBX\s+1 initialization file.
.TP
.B $HOME/.xdbrc
\s-1XDB\s+1 initialization file.
.TP
.B $HOME/.gnuplot
Gnuplot initialization file.
.TP
.B $HOME/.dddinit
Old-style \s-1DDD\s+1 initialization file; used only if
\fB$HOME/.ddd/init\fR does not exist.
.PD
.\"
.\" ---------------
.SH "SEE ALSO"
.\" ---------------
.BR X (1),
.BR gdb (1),
.BR dbx (1),
.BR xdb (1),
.BR perldebug (1),
.BR remsh (1),
.BR rsh (1),
.BR gnuplot (1),
.PP
.RB "`\|" gdb "\|'"
entry in \fBinfo\fR.
.PP
.I
Using \s-1GDB\s+1: A Guide to the \s-1GNU\s+1 Source-Level Debugger\c
\&, by Richard M. Stallman and Roland H. Pesch.
.PP
.I
jdb\(em\&The Java Debugger\c
\&, at \fBhttp://java.sun.com/\fR (and its mirrors) in
\fB/products/jdk/1.1/docs/tooldocs/solaris/jdb.html\fR
.PP
.I
Java Language Debugging\c
\&, at \fBhttp://java.sun.com/\fR (and its mirrors) in 
\fB/products/jdk/1.1/debugging/\fR
.PP
.I
The Python Language\c
\&, at \fBhttp://www.python.org/\fR and its mirrors.
.PP
.I
\s-1DDD\s+1\(em\&A Free Graphical Front-End for \s-1UNIX\s+1 Debuggers\c
\&, by Andreas Zeller and Dorothea Ltkehaus, Computer Science Report
95-07, Technische Universitt Braunschweig, 1995.
.PP
.I
\s-1DDD\s+1 \(en ein Debugger mit graphischer Datendarstellung\c
\&, by Dorothea Ltkehaus, Diploma Thesis, Technische
Universitt Braunschweig, 1994.
.PP
The \s-1DDD\s+1 \fI\s-1FTP\s+1 site,\fR
.sp
.br
  \fBftp://ftp.ips.cs.tu-bs.de/pub/local/softech/ddd/\fR
.br
.sp
.PP
The \s-1DDD\s+1 \fI\s-1WWW\s+1 page,\fR
.sp
.br
  \fBhttp://www.cs.tu-bs.de/softech/ddd/\fR
.br
.sp
.PP
The \s-1DDD\s+1 \fIMailing List,\fR
.sp
.br
   \fBddd-users@ips.cs.tu-bs.de\fR
.br
.sp
For more information on this list, send a mail to
.sp
.br
   \fBddd-users-request@ips.cs.tu-bs.de\fR .
.br
.sp
.PP
.\"
.\" ---------------
.SH "LIMITATIONS"
.\" ---------------
.\"
.SS "General Limitations"
.\"
If command output is sent to the debugger console, it is impossible
for \s-1DDD\s+1 to distinguish between the output of the debugged
program and the output of the inferior debugger.  This problem can be
avoided by running the program in the separate execution window.
.PP
Output that confuses \s-1DDD\s+1 includes:
.IP \(bu 2
Primary debugger prompts (e.g. `\fB(gdb) \fR' or `\fB(dbx) \fR')
.IP \(bu 2
Secondary debugger prompts (e.g. `\fB>\fR')
.IP \(bu 2 
Confirmation prompts (e.g. `\fB(y or n) \fR')
.IP \(bu 2
Prompts for more output (e.g. `\fBPress \s-1RETURN\s+1 to continue\fR')
.IP \(bu 2
Display output (e.g. `\fB$pc = 0x1234\fR')
.PP
If your program outputs any of these strings, you should run it in the
separate execution window.
.PP
If the inferior debugger changes the default \s-1TTY\s+1 settings, for
instance through a `\fBstty\fR' command in its initialization file,
\s-1DDD\s+1 will likely become confused.  The same applies to
debugged programs which change the default \s-1TTY\s+1 settings.
.\"
.\"
.SS "Limitations using GDB"
.\"
Some \s-1GDB\s+1 settings are essential for \s-1DDD\s+1 to work correctly.
These settings with their correct values are:
.sp
.br
  \fBset height 0\fR
.br
  \fBset width 0\fR
.br
  \fBset verbose off\fR
.br
  \fBset prompt (gdb) \fR
.br
.sp
\s-1DDD\s+1 sets these values automatically when invoking
\s-1GDB\s+1; if these values are changed, there may be some
malfunctions, especially in the data display.
.PP
When debugging at the machine level with \s-1GDB\s+1 4.12 and earlier
as inferior debugger, use a `\fBdisplay /x $pc\fR' command to ensure
the program counter value is updated correctly at each stop.  You may
also enter the command in \fB$HOME/.gdbinit\fR or (better yet) upgrade
to the most recent \s-1GDB\s+1 version.
.PP
.\"
.SS "Limitations using DBX"
.\"
When used for debugging Pascal-like programs, \s-1DDD\s+1 does not
infer correct array subscripts and always starts to count with 1.
.PP
With some \s-1DBX\s+1 versions (notably Solaris \s-1DBX\s+1),
\s-1DDD\s+1 strips C-style and C++-style comments from the
\s-1DBX\s+1 output in order to interpret it properly.  This also
affects the output of the debugged program when sent to the debugger
console.  Using the separate execution window avoids these problems.
.PP
In some \s-1DBX\s+1 versions (notably \s-1DEC\s+1 \s-1DBX\s+1 and
\s-1AIX\s+1 \s-1DBX\s+1), there is no automatic data display.  As an
alternative, \s-1DDD\s+1 uses the \s-1DBX\s+1 `\fBprint\fR' command
to access data values.  This means that variable names are interpreted
according to the current frame; variables outside the current frame
cannot be displayed.
.\"
.SS "Limitations using XDB"
.\"
There is no automatic data display in \s-1XDB\s+1.  As a workaround,
\s-1DDD\s+1 uses the `\fBp\fR' command to access data values.  This
means that variable names are interpreted according to the current
frame; variables outside the current frame cannot be displayed.
.\"
.SS "Limitations using JDB"
.\"
.PP
There is no automatic data display in \s-1JDB\s+1.  As a workaround,
\s-1DDD\s+1 uses the `\fBdump\fR' command to access data values.
This means that variable names are interpreted according to the
current frame; variables outside the current frame cannot be
displayed.
.PP
The \s-1JDB\s+1 `\fBdump\fR' and `\fBprint\fR' commands do not support
expression evaluation.  Hence, you cannot display arbitrary
expressions.
.PP
Parsing of \s-1JDB\s+1 output is quite CPU-intensive, due to the
recognition of asynchronous prompts (any thread may output anything at
any time, including prompts).  Hence, a program producing much console
output is likely to slow down \s-1DDD\s+1 considerably.  In such a
case, have the program run with \fB\-debug\fR in a separate window and
attach \s-1JDB\s+1 to it using the \fB\-passwd\fR option.
.\"
.SS "Limitations using Perl"
.\"
.PP
There is no automatic data display in Perl.  As a workaround,
\s-1DDD\s+1 uses the `\fBx\fR' command to access data values.  This
means that variable names are interpreted according to the current
frame; variables outside the current frame cannot be displayed.
.\"
.\"
.\" ---------------
.SH "REPORTING BUGS"
.\" ---------------
.\"
If you find a bug in \s-1DDD\s+1, please send us a bug report.  We
will either attempt to fix the bug\(em\&or include the bug description
in the \s-1DDD\s+1 `\fBBUGS\fR' file, such that others can attempt
to fix it.  (Instead of sending bug reports, you may also send
\fIfixes\fR; \s-1DDD\s+1 is an excellent tool for debugging itself
:-)
.\"
.SS "Where to Send Bug Reports"
.\"
We recommend that you send bug reports for \s-1DDD\s+1 via electronic
mail to
.sp
.br
  \fBddd-bugs@ips.cs.tu-bs.de\fR
.br
.sp
As a last resort, send bug reports on paper to:
.sp
.br
.DS
  Technische Universitt Braunschweig 
.br
  Abteilung Softwaretechnologie 
.br
  \s-1DDD\s+1-Bugs 
.br
  Bltenweg 88
.br
  D-38092 Braunschweig
.br
  \s-1GERMANY\s+1 
.br
.DE
.\"
.SS "Is it a \s-1DDD\s+1 Bug?"
.\"
Before sending in a bug report, try to find out whether the problem
cause really lies within \s-1DDD\s+1.  A common cause of problems
are incomplete or missing X or Motif installations, for instance, or
bugs in the X server or Motif itself.  Running \s-1DDD\s+1 as
.br
.sp
  \fBddd \-\-check-configuration\fR
.sp
.br
checks for common problems and gives hints on how to repair them.
.PP
Another potential cause of problems is the inferior debugger;
occasionally, they show bugs, too.  To find out whether a bug was
caused by the inferior debugger, run \s-1DDD\s+1 as
.br
.sp
  \fBddd \-\-trace\fR
.sp
.br
This shows the interaction between \s-1DDD\s+1 and the inferior
debugger on standard error while \s-1DDD\s+1 is running.  (If
`\fB\-\-trace\fR' is not given, this interaction is logged in the file
`\fB$HOME/.ddd/log\fR'.)  Compare the debugger output to the output
of \s-1DDD\s+1 and determine which one is wrong.
.\"
.SS "How to Report Bugs"
.\"
Here are some guidelines for bug reports:
.br
.IP \(bu 2
The fundamental principle of reporting bugs usefully is this:
\fIreport all the facts\fR.  If you are not sure whether to state a fact or
leave it out, state it!
.br
.IP \(bu 2
Keep in mind that the purpose of a bug report is to enable someone to
fix the bug if it is not known.  It is not very important what happens
if the bug is already known.  Therefore, always write your bug reports
on the assumption that the bug is not known.
.br
.IP \(bu 2
Your bug report should be self-contained.  Do not refer to information
sent in previous mails; your previous mail may have been forwarded to
somebody else.
.br
.IP \(bu 2
Please report each bug in a separate message.  This makes it easier
for us to track which bugs have been fixed and to forward your bugs
reports to the appropriate maintainer.
.br
.IP \(bu 2
Please report bugs in English; this increases the chances of finding
someone who can fix the bug.  Do not assume one particular person will
receive your bug report.
.br
.PP
.\"
.SS "What to Include in a Bug Report"
.\"
To enable us to fix a \s-1DDD\s+1 bug, you \fImust\fR include the
following information:
.br
.IP \(bu 2
Your \s-1DDD\s+1 configuration.  Invoke \s-1DDD\s+1 as
.br
.sp
  \fBddd \-\-configuration\fR
.sp
.br
to get the configuration information.  If this does not work, please
include at least the \s-1DDD\s+1 version, the type of machine you
are using, and its operating system name and version number.
.br
.IP \(bu 2
The debugger you are using and its version (e.g., `\fBgdb-4.17\fR' or
`\fBdbx as shipped with Solaris 2.6\fR').
.br
.IP \(bu 2
The compiler you used to compile \s-1DDD\s+1 and its version (e.g.,
`\fBgcc-2.8.1\fR').
.br
.IP \(bu 2
A description of what behavior you observe that you believe is
incorrect.  For example, \*(lq\s-1DDD\s+1 gets a fatal signal\*(rq
or \*(lq\s-1DDD\s+1 exits immediately after attempting to create the
data window\*(lq.
.br
.IP \(bu 2
A \fIlog file\fR showing the interaction between \s-1DDD\s+1 and the
inferior debugger.  By default, this interaction is logged in the file
`\fB$HOME/.ddd/log\fR'.  Include all trace output from the
\s-1DDD\s+1 invocation up to the first bug occurrence; insert own
comments where necessary.
.br
.IP \(bu 2
If you wish to suggest changes to the \s-1DDD\s+1 source, send us context
diffs.  If you even discuss something in the \s-1DDD\s+1 source, refer to
it by context, \fInever\fR by line number.
.PP
Be sure to include this information in \fIevery\fR single bug report.
.\"
.\"
.\" ---------------
.SH "HISTORY"
.\" ---------------
.\"
The history of \s-1DDD\s+1 is a story of code recycling.  The oldest
parts of \s-1DDD\s+1 were written in 1990, when \fIAndreas Zeller\fR
designed \s-1VSL\s+1, a box-based visual structure language for
visualizing data and program structures.  The \s-1VSL\s+1 interpreter
and the \s-1BOX\s+1 library became part of Andreas' Diploma Thesis, a
graphical syntax editor based on the Programming System Generator
\s-1PSG\s+1.
.PP
In 1992, the \s-1VSL\s+1 and \s-1BOX\s+1 libraries were recycled for
the \s-1NORA\s+1 project.  For \s-1NORA\s+1, an experimental
inference-based software development tool set, Andreas wrote a graph
editor (based on \s-1VSL\s+1 and the \s-1BOX\s+1 libraries) and
facilities for inter-process knowledge exchange.  Based on these
tools, \fIDorothea Ltkehaus\fR (now \fIDorothea Krabiell\fR) realized
\s-1DDD\s+1 as her Diploma Thesis, 1994.
.PP
The original \s-1DDD\s+1 had no source window; this was added by
Dorothea during the winter of 1994\(en1995.  In the first quarter of
1995, finally, Andreas completed \s-1DDD\s+1 by adding command and
execution windows, extensions for \s-1DBX\s+1 and remote debugging as
well as configuration support for several architectures.  Since then,
Andreas has further maintained and extended \s-1DDD\s+1, based on
the comments and suggestions of several \s-1DDD\s+1 users around the
world.  See the comments in the \s-1DDD\s+1 source for details.
.PP
Major \s-1DDD\s+1 events:
.PD 0
.TP 20
April, 1995
\s-1DDD\s+1 0.9: First \s-1DDD\s+1 beta release.
.TP
May, 1995
\s-1DDD\s+1 1.0: First public \s-1DDD\s+1 release.
.TP
December, 1995
\s-1DDD\s+1 1.4: Machine-level debugging, glyphs, \s-1EMACS\s+1 integration.
.TP
October, 1996
\s-1DDD\s+1 2.0: Color displays, \s-1XDB\s+1 support, generic
\s-1DBX\s+1 support, command tool.
.TP
May, 1997
\s-1DDD\s+1 2.1: Alias detection, button tips, status displays.
.TP
November, 1997
\s-1DDD\s+1 2.2: Persistent sessions, display shortcuts.
.TP
June, 1998
\s-1DDD\s+1 3.0: Icon tool bar, Java support, \s-1JDB\s+1 support.
.TP
December, 1998
\s-1DDD\s+1 3.1: Data plotting, Perl support, Python support, Undo/Redo.
.PD
.\"
.\"
.\" ---------------
.SH "EXTENDING DDD"
.\" ---------------
.\"
If you have any contributions to be incorporated into \s-1DDD\s+1,
please send them to `\fBddd@ips.cs.tu-bs.de\fR'.  For suggestions on
what might be done, see the file `\fBTODO\fR' in the \s-1DDD\s+1
distribution.
.\"
.\"
.\" ---------------
.SH "DDD NEEDS YOUR SUPPORT!"
.\" ---------------
.\"
DDD needs your support!  If you have any success stories related to
DDD, please write them down on a picture postcard and send them to us:
.PP
.DS
  Technische Universitt Braunschweig 
.br
  Abteilung Softwaretechnologie 
.br
  Bltenweg 88
.br
  D-38092 Braunschweig 
.br
  \s-1GERMANY\s+1 
.br
.DE
.PP
You may also leave a message in the \fI\s-1DDD\s+1 Guestbook\fR. It
is accessible via the \s-1DDD\s+1 \s-1WWW\s+1 page,
.sp
.br
  \fBhttp://www.cs.tu-bs.de/softech/ddd/\fR .
.br
.sp
.PP
.\"
.\"
.\" --------------------
.SH "PRINTING THIS MANUAL"
.\" --------------------
.\"
Invoke \s-1DDD\s+1 with the `\fB\-\-manual\fR' option to show this
manual page on standard output.  This text output is suitable for
installation as formatted manual page (as
`\fB/usr/local/man/cat1/ddd.1\fR' or similar) on \s-1UNIX\s+1 systems.
.PP
A PostScript copy of this manual page, including several \s-1DDD\s+1
screen shots and diagrams, is included in the \s-1DDD\s+1 source
distribution and available separately as `\fBddd.man.ps.gz\fR' in
.sp
.br
  \fBftp://ftp.ips.cs.tu-bs.de/pub/local/softech/ddd/doc/\fR
.br
.sp
This directory also contains other documentation related to \s-1DDD\s+1.
.PP
A \s-1ROFF\s+1 copy of this manual page, suitable for installation as
manual page on \s-1UNIX\s+1 systems (as
`\fB/usr/local/man/man1/ddd.1\fR' or similar), is included in the
\s-1DDD\s+1 source distribution.
.PP
.\"
.\"
.\"
.\" ---------------
.SH "COPYRIGHT"
.\" ---------------
.\"
.\"
.SS "\s-1DDD\s+1"
.\"
\s-1DDD\s+1 is Copyright \(co 1995, 1996, 1997, 1998
Technische Universitt Braunschweig, Germany.
.PP
\s-1DDD\s+1 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
\s-1DDD\s+1 is distributed in the hope that it will be useful,
but \fIwithout any warranty\fR; without even the implied warranty of
\fImerchantability\fR or \fIfitness for a particular purpose\fR.
See the License for more details.
.PP
You should have received a copy of the License along with
\s-1DDD\s+1.  If not, invoke \s-1DDD\s+1 with the
`\fB\-\-license\fR' option; this will print a copy on standard output.
To read the License from within \s-1DDD\s+1, use `\fBHelp\(->DDD
License\fR'.
.PP
.\"
.\"
.SS "\s-1DDD\s+1 Manual"
.\"
This \s-1DDD\s+1 manual is Copyright \(co 1995, 1996, 1997, 1998
Technische Universitt Braunschweig, Germany.
.PP
Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
