/* 
 * mapruser.h
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 *
 * $Id:$
 *
*/

#ifndef MAP_RUSERS_H_
#define MAP_RUSERS_H_

typedef struct data_internal *data_internal_t;

/* try to connect to the host machine to get informations. 
   If it's impossible, flag == False 
   Else, it return the list_host updated. 
   If (list_host == NULL), it mallocs else it reallocs */
extern data_internal_t onehost(data_internal_t list_host, 
                               int *flag, char *host);

/* Free the list_host struct */
extern void delete_host_list(data_internal_t list_host);

/* Function to access to the data_internal_t struct */

extern char *get_date(data_internal_t list_host      , int n_host, int n_login);
extern char *get_idle_time(data_internal_t list_host , int n_host, int n_login);
extern char *get_local(data_internal_t list_host     , int n_host, int n_login);
extern char *get_name_host(data_internal_t list_host , int n);
extern char *get_name_login(data_internal_t list_host, int n_host, int n_log);
extern int   get_nb_login(data_internal_t list_host  , int n_host);
extern char *get_remote(data_internal_t list_host    , int n_host, int n_login);

extern void  set_nb_login(data_internal_t list_host  , int n_host, int val);


extern void  set_rusers_width(data_internal_t list_host, int width);
extern void  set_rusers_height(data_internal_t list_host, int height);
extern int   get_rusers_width(data_internal_t list_host);
extern int   get_rusers_height(data_internal_t list_host);

#endif
