/*
 * xmisc.c
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 * 
 * $Id: xmisc.c,v 1.3 1995/04/18 16:24:52 dumas Exp dumas $
 */


#include <Xm/Xm.h>

#include <xmisc.h>

Widget GetTopShell(Widget w)
{
    while (w && !XtIsWMShell(w))
        w = XtParent(w);

    return w;
}


void load_pixmap(Widget w, Display *theDisp, Window rootW,
                 int theDepth, char *bits, int width, int height)
{
    Pixmap    pixmap;

    pixmap = read_bitmap(theDisp, w,
                         rootW, bits, theDepth,
                         width, height);

    XtVaSetValues(w, XmNlabelType, XmPIXMAP, 
                  XmNlabelPixmap, pixmap, NULL);
}


Pixmap read_bitmap(Display *display, Widget w,
                   Window rootW, 
                   char *bits, int theDepth,
                   int width, int height)
{
    Pixmap    pixmap;

    GC        theGC;
    XGCValues vals;
   
    /* Create a GC for drawing the pixmap */
    XtVaGetValues(w, XmNforeground, &vals.foreground,
                     XmNbackground, &vals.background,
                     NULL);

    theGC = XCreateGC(display, rootW, GCForeground | GCBackground, &vals);

    pixmap = XCreatePixmapFromBitmapData(display, rootW, bits,
                                         width, height,
                                         vals.foreground, 
                                         vals.background, 
                                         theDepth);

    XFreeGC(display, theGC);

    return(pixmap);
}

