/*
 * cat_text.c
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 *
 *  $Id:$
 */

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>

#include <cat_text.h>
#include <xmisc.h>

void cat_text(Widget w, char *buf, char *title)
{
    Widget dialog,
           pane,
           text_w,
           bt_close,
           sep;
    
    Arg args[4];
    XmTextPosition wpr_position=0;

    dialog =XtVaCreatePopupShell("Cat_Shell",
                                 xmDialogShellWidgetClass, GetTopShell(w),
                                 XmNtitle, title, 
                                 NULL);

    pane = XmCreateForm( dialog, "Cat_Form", NULL, 0);
    XtManageChild(pane); 
    
    XtSetArg(args[0], XmNeditMode, XmMULTI_LINE_EDIT);
    XtSetArg(args[1], XmNwordWrap, False);
    XtSetArg(args[2], XmNscrollHorizontal, False);
    XtSetArg(args[3], XmNblinkRate, 0);
    text_w = XmCreateScrolledText( pane, "Cat_Text",
                                   args, 4);
    XtManageChild(text_w);

    sep = XtVaCreateManagedWidget("Cat_Separator" , 
                                  xmSeparatorWidgetClass, pane,
                                  NULL);

    bt_close = XtVaCreateManagedWidget("Cat_Ok_button", 
                                       xmPushButtonWidgetClass,
                                       pane,
                                       NULL);

    XmTextInsert(text_w, wpr_position, buf);

    XtPopup(dialog, XtGrabExclusive);
}
