/*
 *
 * about.c
 *
 * Eric Dumas
 * $Id:$
 */

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>

#include <stdio.h>
#include <stdlib.h>

#include <about.h>
#include <xmisc.h>

#include <info.xbm>

static void cb_popdown_shell(Widget , XtPointer , XtPointer);

#define CREAT_LABEL(name, father)                    \
    XtVaCreateManagedWidget(name,                           \
                            xmLabelGadgetClass, father,     \
                            NULL)

void about_prog(Widget w)
{
    int n;

    Widget dialog=NULL, 
           pane,
           bt_close,
           pixmap,
           sep; 
    
    n = 0;
    
    dialog =XtVaCreatePopupShell("About",
                                 xmDialogShellWidgetClass, GetTopShell(w),
                                 NULL);

    pane = XmCreateForm( dialog, "AboutForm", NULL, 0);
    XtManageChild(pane);

    bt_close = XtVaCreateManagedWidget("About_Ok_button", 
                                       xmPushButtonWidgetClass,
                                       pane,
                                       NULL);
    
    XtAddCallback(bt_close, XmNactivateCallback, cb_popdown_shell,
                  dialog);

    pixmap =XtVaCreateManagedWidget("Pixmap_About", 
                                     xmLabelWidgetClass, pane
                                     , NULL);

    CREAT_LABEL("Title_About", pane);
    CREAT_LABEL("Name_About", pane);
    CREAT_LABEL("Mail_About", pane);
    
    load_pixmap(pixmap, 
                XtDisplay(pixmap),
                RootWindowOfScreen(XtScreen(w)),
                DefaultDepthOfScreen(XtScreen(w)),
                info_bits, 
                info_width, 
                info_height);

    sep = XtVaCreateManagedWidget("Separator_About", 
                                  xmSeparatorWidgetClass, pane,
                                  NULL); 
    XtPopup(dialog, XtGrabExclusive);
}

static void cb_popdown_shell(Widget w, XtPointer client_data, 
                             XtPointer call_data)
{
     Widget topshell = (Widget) client_data;

     XtPopdown(topshell);
}




