/*----------------------------------------------------------------------------
--
--  Module:           xitInfoFile
--
--  Project:          xit - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xitInfoFile.c.
--
--  Filename:         xitInfoFile.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitInfoFile.h, Version: 1.1, Date: 95/02/18 15:10:37 */


/* Only include this file once. */
#ifndef define_xitInfoFile_def
#  define define_xitInfoFile_def


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "LstLinked.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Status codes. */
typedef enum {
  XIT_IF_OK,
  XIT_IF_ERROR
} XIT_IF_STATUS;

/* Read states. */
typedef enum {
  XIT_IF_RESET,
  XIT_IF_HEADER,
  XIT_IF_TEXT,
  XIT_IF_DONE
} XIT_IF_STATE;

/* Different tags. */
typedef enum {
  XIT_IF_TAG_ACTION_EXECUTE,
  XIT_IF_TAG_INCLUDE_FILE,
  XIT_IF_TAG_LINK,
  XIT_IF_TAG_ACTION_JUMP
} XIT_IF_TAG_TYPE;


/* Search profile. */
typedef struct {
  Boolean  case_sensitive;
  Boolean  headers;
  Boolean  text;
  char     *string;
} XIT_IF_SEARCH_PROFILE;

/* Item header. */
typedef struct {
  char    chapter_id[ 50 ];
  char    title[ 200 ];
  char    book[ 50 ];
  char    link[ 50 ];
  int     toc_level;
} XIT_IF_SECTION, *XIT_IF_SECTION_REF;


/* Tag information. */
typedef struct {
  XIT_IF_TAG_TYPE  tag_type;
  char             *param1;
  char             *param2;
  char             *param3;
  char             *param4;
} XIT_IF_TAG_INFO, *XIT_IF_TAG_INFO_REF;


/* Book record. */
typedef struct {
  char  name[ 50 ];
  char  description[ 100 ];
  char  first_chapter_id[ 50 ];
  char  file[ PATH_MAX + 1 ];
} XIT_IF_BOOK_REC, XIT_IF_BOOK_REC_REF;


/* Handle to the info file. */
typedef void  *XIT_IF_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

int
  xitIfCurrentSection( XIT_IF_HANDLE  info_file_handle );

void 
  xitIfDestroy( XIT_IF_HANDLE  info_file_handle );

void
  xitIfFreeMatchInfo( XIT_IF_SECTION_REF *match_info,
                      int                match_info_size );

void
  xitIfFreeTagsInfo( LST_DESC_TYPE  tag_list );

XIT_IF_STATUS 
  xitIfGetChapter( XIT_IF_HANDLE       info_file_handle,
                   char                *chapter_id,
                   int                 section_number,
                   XIT_IF_SECTION_REF  section_ref );

XIT_IF_STATUS 
  xitIfGetNextSection( XIT_IF_HANDLE       info_file_handle,
                       char                *chapter_id,
                       XIT_IF_SECTION_REF  section_ref );

XIT_IF_STATUS 
  xitIfGetNextTextLine( XIT_IF_HANDLE  info_file_handle,
                        char           *buffer,
                        int            buffer_size );

XIT_IF_STATUS 
  xitIfGetTags( XIT_IF_HANDLE  info_file_handle,
                LST_DESC_TYPE  *tag_list );

XIT_IF_STATUS
  xitIfGetToc( XIT_IF_HANDLE       info_file_handle,
               int                 max_toc_entries,
               XIT_IF_SECTION_REF  *toc_entries,
               int                 *no_toc_entries );

XIT_IF_HANDLE
  xitIfInitialize( char  *filename );

XIT_IF_STATUS
  xitIfResetFile( XIT_IF_HANDLE  info_file_handle );

XIT_IF_STATUS
  xitIfSearchString( XIT_IF_HANDLE          info_file_handle,
                     XIT_IF_SEARCH_PROFILE  *search,
                     int                    max_match_info,
                     XIT_IF_SECTION_REF     *match_info,
                     int                    *no_match_info );

#endif

