/*----------------------------------------------------------------------------
--
--  Module:           xitGetChldn
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Get the a reference to the children of this widget.
--
--  Filename:         xitGetChldn.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitGetChldn.c, Version: 1.1, Date: 95/02/18 15:10:32";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "System.h"

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xitGetChildren( Widget      widget,
                  Cardinal    *num_children,
                  WidgetList  *children )
{

  /* Code. */

  *num_children = 0;

  if( widget == NULL )
    return( False );

  if( ! XtIsComposite( widget ) )
    return( False );


  {
    Arg       args[ 5 ];
    Cardinal  n;

    n = 0;
    XtSetArg( args[ n ], XmNnumChildren, num_children ); n++;
    XtSetArg( args[ n ], XmNchildren,    children ); n++;
    XtGetValues( widget, args, n );
  }


  return( True );

} /* xitGetChildren */
