/*----------------------------------------------------------------------------
--
--  Module:           xitFieldStep
--
--  Project:          xit   - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface for module xitFieldStep.
--
--  Filename:         xitFieldStep.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-09-03
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitFieldStep.h, Version: 1.1, Date: 95/02/18 15:10:31 */


/* Only include this module once. */
#ifndef define_xitFieldStep_h
#  define define_xitFieldStep_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* New resource names. */
#define XmNarrowWidth  "arrowWidth"
#define XmCArrowWidth  "ArrowWidth"

#define FIELD_STEP_CLASS  "FieldStep"


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Definition of callback structure. */
typedef struct {
  int            reason;
  XEvent         *event;
  XmStringTable  list;
  int            elements;
  int            current;
  int            previous;
} xitFieldStepCallbackStruct;

/* The various child widgets you can get. */
typedef enum {
  xitFIELD_STEP_TEXT_FIELD,
  xitFIELD_STEP_ARROW_UP,
  xitFIELD_STEP_ARROW_DOWN
} xitFieldStepChildren;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget
  xitCreateFieldStep( Widget          parent,
                      String          name,
                      ArgList         add_args,
                      Cardinal        num_args,
                      XtCallbackProc  proc,
                      XtPointer       client_data );

Widget
  xitFieldStepGetChild( Widget               widget,
                        xitFieldStepChildren  child );

void
  xitFieldStepGetCurrent( Widget    widget,
                          int       *current_return,
                          XmString  *label_return );

void
  xitFieldStepSetCurrent( Widget   widget,
                          int      new,
                          Boolean  call );

#endif
